/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.BlockStoragePolicySpi;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.HarFileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.StorageStatistics;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Progressable;
import org.junit.Assert;
import org.junit.Test;

public class TestHarFileSystem {
    public static final Log LOG = LogFactory.getLog(TestHarFileSystem.class);

    @Test
    public void testHarUri() {
        Configuration conf = new Configuration();
        TestHarFileSystem.checkInvalidPath("har://hdfs-/foo.har", conf);
        TestHarFileSystem.checkInvalidPath("har://hdfs/foo.har", conf);
        TestHarFileSystem.checkInvalidPath("har://-hdfs/foo.har", conf);
        TestHarFileSystem.checkInvalidPath("har://-/foo.har", conf);
        TestHarFileSystem.checkInvalidPath("har://127.0.0.1-/foo.har", conf);
        TestHarFileSystem.checkInvalidPath("har://127.0.0.1/foo.har", conf);
    }

    static void checkInvalidPath(String s, Configuration conf) {
        System.out.println("\ncheckInvalidPath: " + s);
        Path p = new Path(s);
        try {
            p.getFileSystem(conf);
            Assert.fail((String)(p + " is an invalid path."));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testFileChecksum() throws Exception {
        Path p = new Path("har://file-localhost/foo.har/file1");
        try (HarFileSystem harfs = new HarFileSystem();){
            Assert.assertEquals(null, (Object)harfs.getFileChecksum(p));
        }
    }

    @Test
    public void testFixBlockLocations() {
        BlockLocation[] b = new BlockLocation[]{new BlockLocation(null, null, 10L, 10L)};
        HarFileSystem.fixBlockLocations((BlockLocation[])b, (long)0L, (long)20L, (long)5L);
        Assert.assertEquals((long)b[0].getOffset(), (long)5L);
        Assert.assertEquals((long)b[0].getLength(), (long)10L);
        b = new BlockLocation[]{new BlockLocation(null, null, 10L, 10L)};
        HarFileSystem.fixBlockLocations((BlockLocation[])b, (long)0L, (long)20L, (long)15L);
        Assert.assertEquals((long)b[0].getOffset(), (long)0L);
        Assert.assertEquals((long)b[0].getLength(), (long)5L);
        b = new BlockLocation[]{new BlockLocation(null, null, 10L, 10L)};
        HarFileSystem.fixBlockLocations((BlockLocation[])b, (long)0L, (long)10L, (long)5L);
        Assert.assertEquals((long)b[0].getOffset(), (long)5L);
        Assert.assertEquals((long)b[0].getLength(), (long)5L);
        b = new BlockLocation[]{new BlockLocation(null, null, 10L, 10L)};
        HarFileSystem.fixBlockLocations((BlockLocation[])b, (long)0L, (long)6L, (long)12L);
        Assert.assertEquals((long)b[0].getOffset(), (long)0L);
        Assert.assertEquals((long)b[0].getLength(), (long)6L);
        b = new BlockLocation[]{new BlockLocation(null, null, 10L, 10L)};
        HarFileSystem.fixBlockLocations((BlockLocation[])b, (long)3L, (long)20L, (long)5L);
        Assert.assertEquals((long)b[0].getOffset(), (long)5L);
        Assert.assertEquals((long)b[0].getLength(), (long)10L);
        b = new BlockLocation[]{new BlockLocation(null, null, 10L, 10L)};
        HarFileSystem.fixBlockLocations((BlockLocation[])b, (long)3L, (long)20L, (long)15L);
        Assert.assertEquals((long)b[0].getOffset(), (long)3L);
        Assert.assertEquals((long)b[0].getLength(), (long)2L);
        b = new BlockLocation[]{new BlockLocation(null, null, 10L, 10L)};
        HarFileSystem.fixBlockLocations((BlockLocation[])b, (long)3L, (long)7L, (long)5L);
        Assert.assertEquals((long)b[0].getOffset(), (long)5L);
        Assert.assertEquals((long)b[0].getLength(), (long)5L);
        b = new BlockLocation[]{new BlockLocation(null, null, 10L, 10L)};
        HarFileSystem.fixBlockLocations((BlockLocation[])b, (long)3L, (long)3L, (long)12L);
        Assert.assertEquals((long)b[0].getOffset(), (long)3L);
        Assert.assertEquals((long)b[0].getLength(), (long)3L);
        b = new BlockLocation[]{new BlockLocation(null, null, 512L, 512L), new BlockLocation(null, null, 1024L, 512L)};
        HarFileSystem.fixBlockLocations((BlockLocation[])b, (long)0L, (long)512L, (long)896L);
        Assert.assertEquals((long)b[0].getOffset(), (long)0L);
        Assert.assertEquals((long)b[0].getLength(), (long)128L);
        Assert.assertEquals((long)b[1].getOffset(), (long)128L);
        Assert.assertEquals((long)b[1].getLength(), (long)384L);
    }

    @Test
    public void testInheritedMethodsImplemented() throws Exception {
        int errors = 0;
        for (Method m : FileSystem.class.getDeclaredMethods()) {
            if (Modifier.isStatic(m.getModifiers()) || Modifier.isPrivate(m.getModifiers()) || Modifier.isFinal(m.getModifiers())) continue;
            try {
                MustNotImplement.class.getMethod(m.getName(), m.getParameterTypes());
                try {
                    HarFileSystem.class.getDeclaredMethod(m.getName(), m.getParameterTypes());
                    LOG.error((Object)("HarFileSystem MUST not implement " + m));
                    ++errors;
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
            catch (NoSuchMethodException exc) {
                try {
                    HarFileSystem.class.getDeclaredMethod(m.getName(), m.getParameterTypes());
                }
                catch (NoSuchMethodException exc2) {
                    LOG.error((Object)("HarFileSystem MUST implement " + m));
                    ++errors;
                }
            }
        }
        Assert.assertTrue((String)(errors + " methods were not overridden correctly - see log"), (errors <= 0 ? 1 : 0) != 0);
    }

    private static interface MustNotImplement {
        public BlockLocation[] getFileBlockLocations(Path var1, long var2, long var4);

        public long getLength(Path var1);

        public FSDataOutputStream append(Path var1, int var2);

        public void rename(Path var1, Path var2, Options.Rename ... var3);

        public boolean exists(Path var1);

        public boolean isDirectory(Path var1);

        public boolean isFile(Path var1);

        public boolean createNewFile(Path var1);

        public FSDataOutputStream createNonRecursive(Path var1, FsPermission var2, boolean var3, int var4, short var5, long var6, Progressable var8) throws IOException;

        public FSDataOutputStream createNonRecursive(Path var1, FsPermission var2, EnumSet<CreateFlag> var3, int var4, short var5, long var6, Progressable var8) throws IOException;

        public FSDataOutputStream createNonRecursive(Path var1, FsPermission var2, EnumSet<CreateFlag> var3, int var4, short var5, long var6, Progressable var8, Options.ChecksumOpt var9);

        public boolean mkdirs(Path var1);

        public FSDataInputStream open(Path var1);

        public FSDataOutputStream create(Path var1);

        public FSDataOutputStream create(Path var1, boolean var2);

        public FSDataOutputStream create(Path var1, Progressable var2);

        public FSDataOutputStream create(Path var1, short var2);

        public FSDataOutputStream create(Path var1, short var2, Progressable var3);

        public FSDataOutputStream create(Path var1, boolean var2, int var3);

        public FSDataOutputStream create(Path var1, boolean var2, int var3, Progressable var4);

        public FSDataOutputStream create(Path var1, boolean var2, int var3, short var4, long var5);

        public FSDataOutputStream create(Path var1, boolean var2, int var3, short var4, long var5, Progressable var7);

        public FSDataOutputStream create(Path var1, FsPermission var2, EnumSet<CreateFlag> var3, int var4, short var5, long var6, Progressable var8) throws IOException;

        public FSDataOutputStream create(Path var1, FsPermission var2, EnumSet<CreateFlag> var3, int var4, short var5, long var6, Progressable var8, Options.ChecksumOpt var9) throws IOException;

        public String getName();

        public boolean delete(Path var1);

        public short getReplication(Path var1);

        public void processDeleteOnExit();

        public ContentSummary getContentSummary(Path var1);

        public QuotaUsage getQuotaUsage(Path var1);

        public FsStatus getStatus();

        public FileStatus[] listStatus(Path var1, PathFilter var2);

        public FileStatus[] listStatus(Path[] var1);

        public FileStatus[] listStatus(Path[] var1, PathFilter var2);

        public FileStatus[] globStatus(Path var1);

        public FileStatus[] globStatus(Path var1, PathFilter var2);

        public Iterator<LocatedFileStatus> listFiles(Path var1, boolean var2);

        public Iterator<LocatedFileStatus> listLocatedStatus(Path var1);

        public Iterator<LocatedFileStatus> listLocatedStatus(Path var1, PathFilter var2);

        public Iterator<FileStatus> listStatusIterator(Path var1);

        public void copyFromLocalFile(Path var1, Path var2);

        public void moveFromLocalFile(Path[] var1, Path var2);

        public void moveFromLocalFile(Path var1, Path var2);

        public void copyToLocalFile(Path var1, Path var2);

        public void copyToLocalFile(boolean var1, Path var2, Path var3, boolean var4);

        public void moveToLocalFile(Path var1, Path var2);

        public long getBlockSize(Path var1);

        public FSDataOutputStream primitiveCreate(Path var1, EnumSet<CreateFlag> var2, Options.CreateOpts ... var3);

        public void primitiveMkdir(Path var1, FsPermission var2, boolean var3);

        public int getDefaultPort();

        public String getCanonicalServiceName();

        public Token<?> getDelegationToken(String var1) throws IOException;

        public FileChecksum getFileChecksum(Path var1) throws IOException;

        public boolean deleteOnExit(Path var1) throws IOException;

        public boolean cancelDeleteOnExit(Path var1) throws IOException;

        public Token<?>[] addDelegationTokens(String var1, Credentials var2) throws IOException;

        public Path fixRelativePart(Path var1);

        public void concat(Path var1, Path[] var2) throws IOException;

        public FSDataOutputStream primitiveCreate(Path var1, FsPermission var2, EnumSet<CreateFlag> var3, int var4, short var5, long var6, Progressable var8, Options.ChecksumOpt var9) throws IOException;

        public boolean primitiveMkdir(Path var1, FsPermission var2) throws IOException;

        public RemoteIterator<Path> listCorruptFileBlocks(Path var1) throws IOException;

        public void copyFromLocalFile(boolean var1, Path var2, Path var3) throws IOException;

        public void createSymlink(Path var1, Path var2, boolean var3) throws IOException;

        public FileStatus getFileLinkStatus(Path var1) throws IOException;

        public boolean supportsSymlinks();

        public Path getLinkTarget(Path var1) throws IOException;

        public Path resolveLink(Path var1) throws IOException;

        public void setVerifyChecksum(boolean var1);

        public void setWriteChecksum(boolean var1);

        public Path createSnapshot(Path var1, String var2) throws IOException;

        public void renameSnapshot(Path var1, String var2, String var3) throws IOException;

        public void deleteSnapshot(Path var1, String var2) throws IOException;

        public void modifyAclEntries(Path var1, List<AclEntry> var2) throws IOException;

        public void removeAclEntries(Path var1, List<AclEntry> var2) throws IOException;

        public void removeDefaultAcl(Path var1) throws IOException;

        public void removeAcl(Path var1) throws IOException;

        public void setAcl(Path var1, List<AclEntry> var2) throws IOException;

        public AclStatus getAclStatus(Path var1) throws IOException;

        public void setXAttr(Path var1, String var2, byte[] var3) throws IOException;

        public void setXAttr(Path var1, String var2, byte[] var3, EnumSet<XAttrSetFlag> var4) throws IOException;

        public byte[] getXAttr(Path var1, String var2) throws IOException;

        public Map<String, byte[]> getXAttrs(Path var1) throws IOException;

        public Map<String, byte[]> getXAttrs(Path var1, List<String> var2) throws IOException;

        public List<String> listXAttrs(Path var1) throws IOException;

        public void removeXAttr(Path var1, String var2) throws IOException;

        public void access(Path var1, FsAction var2) throws IOException;

        public void setStoragePolicy(Path var1, String var2) throws IOException;

        public void unsetStoragePolicy(Path var1) throws IOException;

        public BlockStoragePolicySpi getStoragePolicy(Path var1) throws IOException;

        public Collection<? extends BlockStoragePolicySpi> getAllStoragePolicies() throws IOException;

        public Path getTrashRoot(Path var1) throws IOException;

        public Collection<FileStatus> getTrashRoots(boolean var1) throws IOException;

        public StorageStatistics getStorageStatistics();

        public String getAlternativeScheme();
    }
}

