/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import org.apache.hadoop.util.ExponentialBackOff;
import org.junit.Assert;
import org.junit.Test;

public class TestExponentialBackOff {
    @Test
    public void testDefaultValues() {
        ExponentialBackOff backOff = new ExponentialBackOff();
        Assert.assertEquals((long)100L, (long)backOff.getInitialIntervalMillis());
        Assert.assertEquals((long)60000L, (long)backOff.getMaximumIntervalMillis());
        Assert.assertEquals((double)0.5, (double)backOff.getRandomizationFactor(), (double)0.01);
        Assert.assertEquals((double)1.5, (double)backOff.getMultiplier(), (double)0.01);
        Assert.assertEquals((long)10L, (long)backOff.getMaximumRetries());
    }

    @Test
    public void testBuilder() {
        long initialInterval = 150L;
        long maximumInterval = 400L;
        double randomizationFactor = 0.3;
        double multiplier = 1.2;
        int maximumRetries = 3;
        ExponentialBackOff backoff = new ExponentialBackOff.Builder().setInitialIntervalMillis(initialInterval).setMaximumIntervalMillis(maximumInterval).setRandomizationFactor(randomizationFactor).setMultiplier(multiplier).setMaximumRetries(maximumRetries).build();
        Assert.assertEquals((long)initialInterval, (long)backoff.getInitialIntervalMillis());
        Assert.assertEquals((long)maximumInterval, (long)backoff.getMaximumIntervalMillis());
        Assert.assertEquals((double)randomizationFactor, (double)backoff.getRandomizationFactor(), (double)0.01);
        Assert.assertEquals((double)multiplier, (double)backoff.getMultiplier(), (double)0.01);
        Assert.assertEquals((long)maximumRetries, (long)backoff.getMaximumRetries());
    }

    @Test
    public void testMaximumRetries() {
        int maxRetries = 3;
        ExponentialBackOff backOff = new ExponentialBackOff.Builder().setMaximumRetries(maxRetries).build();
        int retries = 0;
        while (backOff.getBackOffInMillis() != -1L) {
            ++retries;
        }
        Assert.assertEquals((long)maxRetries, (long)retries);
    }

    @Test
    public void testExponentialBackOff() {
        long[] expectedTimeouts;
        ExponentialBackOff backOff = new ExponentialBackOff.Builder().setInitialIntervalMillis(100L).setMaximumIntervalMillis(2700L).setMultiplier(3.0).setRandomizationFactor(0.0).setMaximumRetries(6).build();
        for (long timeout : expectedTimeouts = new long[]{100L, 300L, 900L, 2700L, 2700L, 2700L, -1L}) {
            Assert.assertEquals((long)timeout, (long)backOff.getBackOffInMillis());
        }
    }

    @Test
    public void testReset() {
        ExponentialBackOff backOff = new ExponentialBackOff.Builder().setRandomizationFactor(0.0).setMultiplier(1.0).build();
        backOff.getBackOffInMillis();
        backOff.getBackOffInMillis();
        backOff.reset();
        Assert.assertEquals((long)0L, (long)backOff.getNumberOfRetries());
        Assert.assertEquals((long)backOff.getInitialIntervalMillis(), (long)backOff.getBackOffInMillis());
    }
}

