/*
 * Decompiled with CFR 0.152.
 */
package io.hops.security;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.ReadOnlyJWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.text.ParseException;
import java.util.Random;

public class MockJWTIssuer {
    private final byte[] sharedSecret;
    private final JWSSigner signer;
    private final JWSVerifier verifier;
    private final Random rand;

    public MockJWTIssuer(byte[] sharedSecret) {
        this.sharedSecret = sharedSecret;
        this.signer = new MACSigner(sharedSecret);
        this.verifier = new MACVerifier(sharedSecret);
        this.rand = new Random();
    }

    public String generate(JWTClaimsSet claims) throws JOSEException {
        claims.setIssuer("MockJWTIssuer");
        claims.setCustomClaim("rand", (Object)this.rand.nextLong());
        SignedJWT signedJWT = new SignedJWT(new JWSHeader(JWSAlgorithm.HS256), (ReadOnlyJWTClaimsSet)claims);
        signedJWT.sign(this.signer);
        return signedJWT.serialize();
    }

    public boolean verify(String token) throws ParseException, JOSEException {
        SignedJWT jwt = SignedJWT.parse((String)token);
        return jwt.verify(this.verifier);
    }
}

