/*
 * Decompiled with CFR 0.152.
 */
package io.hops.security;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.PosixFilePermission;
import java.security.GeneralSecurityException;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.BackOff;
import org.apache.hadoop.util.DateUtils;
import org.apache.hadoop.util.ExponentialBackOff;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;

public class ServiceJWTManager
extends AbstractService {
    public static final String JWT_MANAGER_PREFIX = "hops.jwt-manager.";
    public static final String JWT_MANAGER_MASTER_TOKEN_KEY = "hops.jwt-manager.master-token";
    public static final String JWT_MANAGER_RENEW_TOKEN_PATTERN = "hops.jwt-manager.renew-token-%d";
    private static final Log LOG = LogFactory.getLog(ServiceJWTManager.class);
    private static final String LOCK_FILE = ".ssl-server.lock";
    private static final Set<PosixFilePermission> LOCK_FILE_PERMISSIONS = new HashSet<PosixFilePermission>();
    private final Gson jsonParser = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.IDENTITY).setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create();
    private CloseableHttpClient httpClient;
    private final ExecutorService tokenRenewer;
    private CountDownLatch waiter;
    private Configuration sslConf;
    private URL serviceJWTRenewPath;
    private URL serviceJWTInvalidatePath;
    private long serviceJWTValidityPeriodSeconds;
    private final AtomicReference<String> masterToken = new AtomicReference();
    private LocalDateTime masterTokenExpiration;
    private String[] renewalTokens;

    public ServiceJWTManager(String name) {
        super(name);
        this.tokenRenewer = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("JWT renewer thread").setDaemon(true).build());
    }

    public void setHTTPClient(CloseableHttpClient client) {
        this.httpClient = client;
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        URL host = new URL(conf.get("hops.hopsworks.host", "https://127.0.0.1"));
        this.sslConf = new Configuration(false);
        this.sslConf.addResource(conf.get("hadoop.ssl.server.conf", "ssl-server.xml"));
        this.loadMasterJWT();
        this.loadRenewalJWTs();
        this.serviceJWTValidityPeriodSeconds = conf.getTimeDuration("hops.jwt-manager.master-token-validity", 432000L, TimeUnit.SECONDS);
        if (this.serviceJWTValidityPeriodSeconds == 0L) {
            this.serviceJWTValidityPeriodSeconds = 30L;
        }
        String serviceJWTRenewPathConf = conf.get("hops.jwt-manager.service-renew-path", "/hopsworks-api/api/jwt/service");
        this.serviceJWTRenewPath = new URL(host, serviceJWTRenewPathConf);
        String serviceJWTInvalidatePathConf = conf.get("hops.jwt-manager.service-invalidate-path", "/hopsworks-api/api/jwt/service");
        if (!serviceJWTInvalidatePathConf.endsWith("/")) {
            serviceJWTInvalidatePathConf = serviceJWTRenewPathConf + "/";
        }
        this.serviceJWTInvalidatePath = new URL(host, serviceJWTInvalidatePathConf);
        super.serviceInit(conf);
    }

    private void createLockFileIfMissing() throws IOException {
        Path lockFile = this.getLockFilePath();
        if (!lockFile.toFile().exists()) {
            LOG.debug((Object)("Lock file " + lockFile.toString() + " does not exist"));
            FileChannel fc = FileChannel.open(lockFile, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
            try (FileLock fl = fc.tryLock();){
                if (fl == null) {
                    return;
                }
                Files.setPosixFilePermissions(lockFile, LOCK_FILE_PERMISSIONS);
            }
        }
    }

    private Path getLockFilePath() {
        String tmp = System.getProperty("java.io.tmpdir");
        return Paths.get(tmp, LOCK_FILE);
    }

    @Override
    protected void serviceStart() throws Exception {
        this.createLockFileIfMissing();
        this.waiter = new CountDownLatch(1);
        this.tokenRenewer.execute(new TokenRenewer());
        super.serviceStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void serviceStop() throws Exception {
        block37: {
            Path lockFile;
            LOG.info((Object)"Stopping ServiceJWTManager");
            try {
                try {
                    this.tokenRenewer.shutdown();
                    if (!this.tokenRenewer.awaitTermination(100L, TimeUnit.MILLISECONDS)) {
                        this.tokenRenewer.shutdownNow();
                    }
                }
                catch (InterruptedException ex) {
                    this.tokenRenewer.shutdownNow();
                    Thread.currentThread().interrupt();
                }
                if (this.waiter != null) {
                    this.waiter.await(100L, TimeUnit.MILLISECONDS);
                }
                super.serviceStop();
                lockFile = this.getLockFilePath();
                if (!lockFile.toFile().exists()) break block37;
            }
            catch (Throwable throwable) {
                Path lockFile2 = this.getLockFilePath();
                if (lockFile2.toFile().exists()) {
                    FileChannel fc = FileChannel.open(lockFile2, StandardOpenOption.WRITE);
                    try (FileLock fl = fc.tryLock();){
                        if (fl != null) {
                            FileUtils.deleteQuietly((File)lockFile2.toFile());
                        }
                    }
                    catch (Exception ex) {
                        Thread.currentThread().interrupt();
                    }
                }
                throw throwable;
            }
            FileChannel fc = FileChannel.open(lockFile, StandardOpenOption.WRITE);
            try (FileLock fl = fc.tryLock();){
                if (fl != null) {
                    FileUtils.deleteQuietly((File)lockFile.toFile());
                }
            }
            catch (Exception ex) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected void setMasterToken(String masterToken) {
        this.masterToken.set(masterToken);
    }

    public String getMasterToken() {
        return this.masterToken.get();
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected LocalDateTime getMasterTokenExpiration() {
        return this.masterTokenExpiration;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected void setMasterTokenExpiration(LocalDateTime masterTokenExpiration) {
        this.masterTokenExpiration = masterTokenExpiration;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected void setRenewalTokens(String[] renewalTokens) {
        this.renewalTokens = renewalTokens;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected ExecutorService getExecutorService() {
        return this.tokenRenewer;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected void loadMasterJWT() throws GeneralSecurityException {
        String masterTokenConf = this.sslConf.get(JWT_MANAGER_MASTER_TOKEN_KEY);
        if (masterTokenConf == null) {
            throw new GeneralSecurityException("Could not parse master JWT from configuration");
        }
        this.masterToken.set(masterTokenConf);
        try {
            JWT jwt = JWTParser.parse((String)this.masterToken.get());
            this.masterTokenExpiration = DateUtils.date2LocalDateTime(jwt.getJWTClaimsSet().getExpirationTime());
        }
        catch (ParseException ex) {
            throw new GeneralSecurityException("Could not parse master JWT", ex);
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected void loadRenewalJWTs() throws GeneralSecurityException {
        String renewTokenKey;
        String renewToken = null;
        ArrayList<String> renewalTokens = new ArrayList<String>();
        int idx = 0;
        while (!(renewToken = this.sslConf.get(renewTokenKey = String.format(JWT_MANAGER_RENEW_TOKEN_PATTERN, idx), "")).isEmpty()) {
            renewalTokens.add(renewToken);
            ++idx;
        }
        if (renewalTokens.isEmpty()) {
            throw new GeneralSecurityException("Could not load one-time renewal JWTs");
        }
        this.renewalTokens = renewalTokens.toArray(new String[renewalTokens.size()]);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected void reloadJWTs() throws GeneralSecurityException {
        this.sslConf.reloadConfiguration();
        this.loadMasterJWT();
        this.loadRenewalJWTs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    @VisibleForTesting
    protected ServiceTokenDTO renewServiceJWT(String token, String oneTimeToken, LocalDateTime expiresAt, LocalDateTime notBefore) throws URISyntaxException, IOException {
        try (CloseableHttpResponse httpResponse = null;){
            ServiceTokenDTO renewedTokenResponse;
            JWTDTO request = new JWTDTO();
            request.token = token;
            request.expiresAt = DateUtils.localDateTime2Date(expiresAt);
            request.nbf = DateUtils.localDateTime2Date(notBefore);
            String jsonRequest = this.jsonParser.toJson((Object)request);
            HttpPut httpRequest = new HttpPut(this.serviceJWTRenewPath.toURI());
            httpRequest.addHeader(this.createAuthenticationHeader(oneTimeToken));
            httpRequest.setEntity((HttpEntity)new StringEntity(jsonRequest));
            httpRequest.addHeader("Content-Type", "application/json");
            httpResponse = this.httpClient.execute((HttpUriRequest)httpRequest);
            this.checkHTTPResponseCode((HttpResponse)httpResponse, "Could not make HTTP request to renew service JWT");
            ServiceTokenDTO serviceTokenDTO = renewedTokenResponse = (ServiceTokenDTO)this.jsonParser.fromJson(EntityUtils.toString((HttpEntity)httpResponse.getEntity()), ServiceTokenDTO.class);
            return serviceTokenDTO;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    @VisibleForTesting
    protected void invalidateServiceJWT(String token2invalidate) throws URISyntaxException, IOException {
        try (CloseableHttpResponse httpResponse = null;){
            URL invalidateURL = new URL(this.serviceJWTInvalidatePath, token2invalidate);
            HttpDelete httpRequest = new HttpDelete(invalidateURL.toURI());
            httpRequest.addHeader(this.createAuthenticationHeader(this.masterToken.get()));
            httpRequest.addHeader("Content-Type", "application/json");
            httpResponse = this.httpClient.execute((HttpUriRequest)httpRequest);
            this.checkHTTPResponseCode((HttpResponse)httpResponse, "Could not make HTTP request to invalidate master JWT");
        }
    }

    private Header createAuthenticationHeader(String token) {
        String authHeaderContent = String.format("Bearer %s", token);
        return new BasicHeader("Authorization", authHeaderContent);
    }

    private void checkHTTPResponseCode(HttpResponse response, String extraMessage) throws IOException {
        int code = response.getStatusLine().getStatusCode();
        if (code != 200) {
            throw new IOException("HTTP error, response code " + code + " Reason: " + response.getStatusLine().getReasonPhrase() + " Message: " + extraMessage);
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected boolean isTime2Renew(LocalDateTime now, LocalDateTime tokenExpiration) {
        return now.isAfter(tokenExpiration) || now.isEqual(tokenExpiration);
    }

    protected FileLock tryAndGetLock() {
        try {
            FileChannel fc = FileChannel.open(this.getLockFilePath(), StandardOpenOption.WRITE, StandardOpenOption.CREATE);
            return fc.tryLock();
        }
        catch (Exception ex) {
            return null;
        }
    }

    static /* synthetic */ String[] access$402(ServiceJWTManager x0, String[] x1) {
        x0.renewalTokens = x1;
        return x1;
    }

    static {
        LOCK_FILE_PERMISSIONS.add(PosixFilePermission.OWNER_READ);
        LOCK_FILE_PERMISSIONS.add(PosixFilePermission.OWNER_WRITE);
        LOCK_FILE_PERMISSIONS.add(PosixFilePermission.OWNER_EXECUTE);
        LOCK_FILE_PERMISSIONS.add(PosixFilePermission.GROUP_READ);
        LOCK_FILE_PERMISSIONS.add(PosixFilePermission.GROUP_WRITE);
        LOCK_FILE_PERMISSIONS.add(PosixFilePermission.GROUP_EXECUTE);
    }

    public class ServiceTokenDTO {
        private JWTDTO jwt;
        private String[] renewTokens;

        public JWTDTO getJwt() {
            return this.jwt;
        }

        public void setJwt(JWTDTO jwt) {
            this.jwt = jwt;
        }

        public String[] getRenewTokens() {
            return this.renewTokens;
        }

        public void setRenewTokens(String[] renewTokens) {
            this.renewTokens = renewTokens;
        }
    }

    public static class JWTDTO {
        private String token;
        private String subject;
        private String keyName;
        private String audiences;
        private Boolean renewable;
        private Integer expLeeway;
        private Date expiresAt;
        private Date nbf;

        public String getToken() {
            return this.token;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public String getSubject() {
            return this.subject;
        }

        public void setSubject(String subject) {
            this.subject = subject;
        }

        public String getKeyName() {
            return this.keyName;
        }

        public void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public String getAudiences() {
            return this.audiences;
        }

        public void setAudiences(String audiences) {
            this.audiences = audiences;
        }

        public Boolean getRenewable() {
            return this.renewable;
        }

        public void setRenewable(Boolean renewable) {
            this.renewable = renewable;
        }

        public Integer getExpLeeway() {
            return this.expLeeway;
        }

        public void setExpLeeway(Integer expLeeway) {
            this.expLeeway = expLeeway;
        }

        public Date getExpiresAt() {
            return this.expiresAt;
        }

        public void setExpiresAt(Date expiresAt) {
            this.expiresAt = expiresAt;
        }

        public Date getNbf() {
            return this.nbf;
        }

        public void setNbf(Date nbf) {
            this.nbf = nbf;
        }
    }

    private class TokenRenewer
    implements Runnable {
        private final BackOff backOff;
        private final long sleepPeriodSeconds;

        private TokenRenewer() {
            int maximumRetries = Math.max(1, ServiceJWTManager.this.renewalTokens.length - 1);
            this.backOff = new ExponentialBackOff.Builder().setInitialIntervalMillis(1000L).setMaximumIntervalMillis(7000L).setMultiplier(2.0).setMaximumRetries(maximumRetries).build();
            this.sleepPeriodSeconds = ServiceJWTManager.this.serviceJWTValidityPeriodSeconds / 2L;
        }

        @Override
        public void run() {
            FileLock fileLock = null;
            while (!Thread.currentThread().isInterrupted()) {
                fileLock = ServiceJWTManager.this.tryAndGetLock();
                if (fileLock != null) {
                    LOG.debug((Object)(ServiceJWTManager.this.getName() + " Managed to get file lock to renew JWTs"));
                    break;
                }
                LOG.debug((Object)(ServiceJWTManager.this.getName() + " Did NOT manage to get file lock to renew JWTs"));
                try {
                    LOG.debug((Object)(ServiceJWTManager.this.getName() + " But refreshing JWTs from ssl-server"));
                    ServiceJWTManager.this.reloadJWTs();
                    TimeUnit.SECONDS.sleep(this.sleepPeriodSeconds);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                catch (GeneralSecurityException ex) {
                    LOG.warn((Object)"Could not refresh service JWTs when failed to acquire exclusive lock");
                }
            }
            boolean shouldTry2renew = true;
            while (!Thread.currentThread().isInterrupted() && shouldTry2renew) {
                try {
                    LocalDateTime now = DateUtils.getNow();
                    if (ServiceJWTManager.this.isTime2Renew(now, ServiceJWTManager.this.masterTokenExpiration)) {
                        this.backOff.reset();
                        LocalDateTime expiresAt = DateUtils.getNow().plus(ServiceJWTManager.this.serviceJWTValidityPeriodSeconds, ChronoUnit.SECONDS);
                        for (int renewalTokenIdx = 0; renewalTokenIdx < ServiceJWTManager.this.renewalTokens.length; ++renewalTokenIdx) {
                            try {
                                ServiceTokenDTO renewedTokens = ServiceJWTManager.this.renewServiceJWT((String)ServiceJWTManager.this.masterToken.get(), ServiceJWTManager.this.renewalTokens[renewalTokenIdx], expiresAt, now);
                                String oldMasterToken = (String)ServiceJWTManager.this.masterToken.get();
                                ServiceJWTManager.this.masterToken.set(renewedTokens.jwt.token);
                                ServiceJWTManager.this.masterTokenExpiration = DateUtils.date2LocalDateTime(renewedTokens.jwt.expiresAt);
                                ServiceJWTManager.access$402(ServiceJWTManager.this, renewedTokens.renewTokens);
                                try {
                                    ServiceJWTManager.this.invalidateServiceJWT(oldMasterToken);
                                }
                                catch (Exception ex) {
                                    LOG.warn((Object)"Failed to invalidate old service master JWT. Continue...");
                                }
                                ServiceJWTManager.this.sslConf.set(ServiceJWTManager.JWT_MANAGER_MASTER_TOKEN_KEY, (String)ServiceJWTManager.this.masterToken.get());
                                for (int i = 0; i < ServiceJWTManager.this.renewalTokens.length; ++i) {
                                    String confKey = String.format(ServiceJWTManager.JWT_MANAGER_RENEW_TOKEN_PATTERN, i);
                                    ServiceJWTManager.this.sslConf.set(confKey, ServiceJWTManager.this.renewalTokens[i]);
                                }
                                URL sslServerURL = ServiceJWTManager.this.sslConf.getResource(ServiceJWTManager.this.getConfig().get("hadoop.ssl.server.conf", "ssl-server.xml"));
                                File sslServerFile = new File(sslServerURL.getFile());
                                try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(sslServerFile));){
                                    ServiceJWTManager.this.sslConf.writeXml(bos);
                                    bos.flush();
                                }
                                LOG.info((Object)"Updated service JWT");
                            }
                            catch (URISyntaxException ex) {
                                LOG.error((Object)("There is an error in service JWT renewal URI: " + ServiceJWTManager.this.serviceJWTRenewPath.toString()), (Throwable)ex);
                                shouldTry2renew = false;
                            }
                            catch (Exception ex) {
                                long backoffTimeout = this.backOff.getBackOffInMillis();
                                if (backoffTimeout != -1L) {
                                    LOG.warn((Object)("Error while trying to renew service JWT. Retrying in " + backoffTimeout + " ms"), (Throwable)ex);
                                    TimeUnit.MILLISECONDS.sleep(backoffTimeout);
                                    continue;
                                }
                                LOG.error((Object)"Could not renew service JWT. Manual update is necessary!", (Throwable)ex);
                                shouldTry2renew = false;
                            }
                            break;
                        }
                        if (!shouldTry2renew) break;
                    }
                    TimeUnit.SECONDS.sleep(this.sleepPeriodSeconds);
                }
                catch (InterruptedException ex) {
                    LOG.warn((Object)"Service JWT renewer has been interrupted");
                    Thread.currentThread().interrupt();
                }
            }
            if (fileLock != null) {
                try {
                    fileLock.release();
                }
                catch (IOException ex) {
                    LOG.warn((Object)"Failed to release ssl-server file lock", (Throwable)ex);
                }
            }
            ServiceJWTManager.this.waiter.countDown();
            LOG.info((Object)"JWT renewal thread finishing");
        }
    }
}

