/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ha;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.net.ServerSocketUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Time;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ServerCnxnFactoryAccessor;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnLog;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClientBaseWithFixes {
    protected static final Logger LOG = LoggerFactory.getLogger(ClientBaseWithFixes.class);
    public static int CONNECTION_TIMEOUT = 30000;
    static final File BASETEST = GenericTestUtils.getTestDir();
    protected final String hostPort = this.initHostPort();
    protected int maxCnxns = 0;
    protected ServerCnxnFactory serverFactory = null;
    protected File tmpDir = null;
    long initialFdCount;
    private LinkedList<ZooKeeper> allClients;
    private boolean allClientsSetup = false;

    protected TestableZooKeeper createClient() throws IOException, InterruptedException {
        return this.createClient(this.hostPort);
    }

    protected TestableZooKeeper createClient(String hp) throws IOException, InterruptedException {
        CountdownWatcher watcher = new CountdownWatcher();
        return this.createClient(watcher, hp);
    }

    protected TestableZooKeeper createClient(CountdownWatcher watcher, String hp) throws IOException, InterruptedException {
        return this.createClient(watcher, hp, CONNECTION_TIMEOUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TestableZooKeeper createClient(CountdownWatcher watcher, String hp, int timeout) throws IOException, InterruptedException {
        watcher.reset();
        TestableZooKeeper zk = new TestableZooKeeper(hp, timeout, (Watcher)watcher);
        if (!watcher.clientConnected.await(timeout, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"Unable to connect to server");
        }
        ClientBaseWithFixes clientBaseWithFixes = this;
        synchronized (clientBaseWithFixes) {
            if (!this.allClientsSetup) {
                LOG.error("allClients never setup");
                Assert.fail((String)"allClients never setup");
            }
            if (this.allClients != null) {
                this.allClients.add((ZooKeeper)zk);
            } else {
                zk.close();
            }
        }
        watcher.initializeWatchedClient((ZooKeeper)zk);
        return zk;
    }

    public static List<HostPort> parseHostPortList(String hplist) {
        ArrayList<HostPort> alist = new ArrayList<HostPort>();
        for (String hp : hplist.split(",")) {
            int port;
            int idx = hp.lastIndexOf(58);
            String host = hp.substring(0, idx);
            try {
                port = Integer.parseInt(hp.substring(idx + 1));
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Problem parsing " + hp + e.toString());
            }
            alist.add(new HostPort(host, port));
        }
        return alist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String send4LetterWord(String host, int port, String cmd) throws IOException {
        LOG.info("connecting to " + host + " " + port);
        Socket sock = new Socket(host, port);
        BufferedReader reader = null;
        try {
            String line;
            OutputStream outstream = sock.getOutputStream();
            outstream.write(cmd.getBytes());
            outstream.flush();
            sock.shutdownOutput();
            reader = new BufferedReader(new InputStreamReader(sock.getInputStream()));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
            String string = sb.toString();
            return string;
        }
        finally {
            sock.close();
            if (reader != null) {
                reader.close();
            }
        }
    }

    public static boolean waitForServerUp(String hp, long timeout) {
        long start = Time.now();
        while (true) {
            try {
                HostPort hpobj = ClientBaseWithFixes.parseHostPortList(hp).get(0);
                String result = ClientBaseWithFixes.send4LetterWord(hpobj.host, hpobj.port, "stat");
                if (result.startsWith("Zookeeper version:") && !result.contains("READ-ONLY")) {
                    return true;
                }
            }
            catch (IOException e) {
                LOG.info("server " + hp + " not up " + e);
            }
            if (Time.now() > start + timeout) break;
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return false;
    }

    public static boolean waitForServerDown(String hp, long timeout) {
        long start = Time.now();
        while (true) {
            try {
                HostPort hpobj = ClientBaseWithFixes.parseHostPortList(hp).get(0);
                ClientBaseWithFixes.send4LetterWord(hpobj.host, hpobj.port, "stat");
            }
            catch (IOException e) {
                return true;
            }
            if (Time.now() > start + timeout) break;
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return false;
    }

    public static File createTmpDir() throws IOException {
        return ClientBaseWithFixes.createTmpDir(BASETEST);
    }

    static File createTmpDir(File parentDir) throws IOException {
        File tmpFile = File.createTempFile("test", ".junit", parentDir);
        File tmpDir = new File(tmpFile + ".dir");
        Assert.assertFalse((boolean)tmpDir.exists());
        Assert.assertTrue((boolean)tmpDir.mkdirs());
        return tmpDir;
    }

    private static int getPort(String hostPort) {
        String[] split = hostPort.split(":");
        String portstr = split[split.length - 1];
        String[] pc = portstr.split("/");
        if (pc.length > 1) {
            portstr = pc[0];
        }
        return Integer.parseInt(portstr);
    }

    static ServerCnxnFactory createNewServerInstance(File dataDir, ServerCnxnFactory factory, String hostPort, int maxCnxns) throws IOException, InterruptedException {
        ZooKeeperServer zks = new ZooKeeperServer(dataDir, dataDir, 3000);
        int PORT = ClientBaseWithFixes.getPort(hostPort);
        if (factory == null) {
            factory = ServerCnxnFactory.createFactory((int)PORT, (int)maxCnxns);
        }
        factory.startup(zks);
        Assert.assertTrue((String)"waiting for server up", (boolean)ClientBaseWithFixes.waitForServerUp("127.0.0.1:" + PORT, CONNECTION_TIMEOUT));
        return factory;
    }

    static void shutdownServerInstance(ServerCnxnFactory factory, String hostPort) {
        if (factory != null) {
            ZooKeeperServer zs = ClientBaseWithFixes.getServer(factory);
            ZKDatabase zkDb = zs.getZKDatabase();
            factory.shutdown();
            try {
                zkDb.close();
            }
            catch (IOException ie) {
                LOG.warn("Error closing logs ", (Throwable)ie);
            }
            int PORT = ClientBaseWithFixes.getPort(hostPort);
            Assert.assertTrue((String)"waiting for server down", (boolean)ClientBaseWithFixes.waitForServerDown("127.0.0.1:" + PORT, CONNECTION_TIMEOUT));
        }
    }

    public static void setupTestEnv() {
        System.setProperty("zookeeper.preAllocSize", "100");
        FileTxnLog.setPreallocSize((long)102400L);
    }

    protected void setUpAll() throws Exception {
        this.allClients = new LinkedList();
        this.allClientsSetup = true;
    }

    @Before
    public void setUp() throws Exception {
        BASETEST.mkdirs();
        ClientBaseWithFixes.setupTestEnv();
        this.setUpAll();
        this.tmpDir = ClientBaseWithFixes.createTmpDir(BASETEST);
        this.startServer();
        LOG.info("Client test setup finished");
    }

    private String initHostPort() {
        BASETEST.mkdirs();
        int port = 0;
        try {
            port = ServerSocketUtil.getPort(port, 100);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return "127.0.0.1:" + port;
    }

    protected void startServer() throws Exception {
        LOG.info("STARTING server");
        this.serverFactory = ClientBaseWithFixes.createNewServerInstance(this.tmpDir, this.serverFactory, this.hostPort, this.maxCnxns);
    }

    protected void stopServer() throws Exception {
        LOG.info("STOPPING server");
        ClientBaseWithFixes.shutdownServerInstance(this.serverFactory, this.hostPort);
        this.serverFactory = null;
    }

    protected static ZooKeeperServer getServer(ServerCnxnFactory fac) {
        ZooKeeperServer zs = ServerCnxnFactoryAccessor.getZkServer((ServerCnxnFactory)fac);
        return zs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDownAll() throws Exception {
        ClientBaseWithFixes clientBaseWithFixes = this;
        synchronized (clientBaseWithFixes) {
            if (this.allClients != null) {
                for (ZooKeeper zk : this.allClients) {
                    try {
                        if (zk == null) continue;
                        zk.close();
                    }
                    catch (InterruptedException e) {
                        LOG.warn("ignoring interrupt", (Throwable)e);
                    }
                }
            }
            this.allClients = null;
        }
    }

    @After
    public void tearDown() throws Exception {
        LOG.info("tearDown starting");
        this.tearDownAll();
        this.stopServer();
        if (this.tmpDir != null) {
            Assert.assertTrue((String)("delete " + this.tmpDir.toString()), (boolean)ClientBaseWithFixes.recursiveDelete(this.tmpDir));
        }
        this.serverFactory = null;
    }

    public static boolean recursiveDelete(File d) {
        if (d.isDirectory()) {
            File[] children;
            for (File f : children = d.listFiles()) {
                Assert.assertTrue((String)("delete " + f.toString()), (boolean)ClientBaseWithFixes.recursiveDelete(f));
            }
        }
        return d.delete();
    }

    public static class HostPort {
        String host;
        int port;

        public HostPort(String host, int port) {
            this.host = host;
            this.port = port;
        }
    }

    protected static class CountdownWatcher
    implements Watcher {
        volatile CountDownLatch clientConnected;
        volatile boolean connected;
        protected ZooKeeper client;

        public void initializeWatchedClient(ZooKeeper zk) {
            if (this.client != null) {
                throw new RuntimeException("Watched Client was already set");
            }
            this.client = zk;
        }

        public CountdownWatcher() {
            this.reset();
        }

        public synchronized void reset() {
            this.clientConnected = new CountDownLatch(1);
            this.connected = false;
        }

        public synchronized void process(WatchedEvent event) {
            if (event.getState() == Watcher.Event.KeeperState.SyncConnected || event.getState() == Watcher.Event.KeeperState.ConnectedReadOnly) {
                this.connected = true;
                this.notifyAll();
                this.clientConnected.countDown();
            } else {
                this.connected = false;
                this.notifyAll();
            }
        }

        synchronized boolean isConnected() {
            return this.connected;
        }

        @VisibleForTesting
        public synchronized void waitForConnected(long timeout) throws InterruptedException, TimeoutException {
            long expire = Time.now() + timeout;
            long left = timeout;
            while (!this.connected && left > 0L) {
                this.wait(left);
                left = expire - Time.now();
            }
            if (!this.connected) {
                throw new TimeoutException("Did not connect");
            }
        }

        @VisibleForTesting
        public synchronized void waitForDisconnected(long timeout) throws InterruptedException, TimeoutException {
            long expire = Time.now() + timeout;
            long left = timeout;
            while (this.connected && left > 0L) {
                this.wait(left);
                left = expire - Time.now();
            }
            if (this.connected) {
                throw new TimeoutException("Did not disconnect");
            }
        }
    }

    protected class NullWatcher
    implements Watcher {
        protected NullWatcher() {
        }

        public void process(WatchedEvent event) {
        }
    }
}

