/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Calendar;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.eclipse.jetty.util.URIUtil;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ServletUtil {
    public static final String HTML_TAIL = "<hr />\n<a href='http://hadoop.apache.org'>Hadoop</a>, " + Calendar.getInstance().get(1) + ".\n</body></html>";

    public static PrintWriter initHTML(ServletResponse response, String title) throws IOException {
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.println("<html>\n<link rel='stylesheet' type='text/css' href='/static/hadoop.css'>\n<title>" + title + "</title>\n<body>\n<h1>" + title + "</h1>\n");
        return out;
    }

    public static String getParameter(ServletRequest request, String name) {
        String s = request.getParameter(name);
        if (s == null) {
            return null;
        }
        return (s = s.trim()).length() == 0 ? null : s;
    }

    public static long parseLongParam(ServletRequest request, String param) throws IOException {
        String paramStr = request.getParameter(param);
        if (paramStr == null) {
            throw new IOException("Invalid request has no " + param + " parameter");
        }
        return Long.parseLong(paramStr);
    }

    public static String htmlFooter() {
        return HTML_TAIL;
    }

    public static String getDecodedPath(HttpServletRequest request, String servletName) {
        return URIUtil.decodePath((String)ServletUtil.getRawPath(request, servletName));
    }

    public static String getRawPath(HttpServletRequest request, String servletName) {
        Preconditions.checkArgument((boolean)request.getRequestURI().startsWith(servletName + "/"));
        return request.getRequestURI().substring(servletName.length());
    }
}

