/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract;

import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.fs.BBUploadHandle;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.MultipartUploader;
import org.apache.hadoop.fs.MultipartUploaderFactory;
import org.apache.hadoop.fs.PartHandle;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathHandle;
import org.apache.hadoop.fs.UploadHandle;
import org.apache.hadoop.fs.contract.AbstractFSContractTestBase;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.Test;

public abstract class AbstractContractMultipartUploaderTest
extends AbstractFSContractTestBase {
    private byte[] generatePayload(int partNumber) {
        int sizeInBytes = this.partSizeInBytes();
        ByteBuffer buffer = ByteBuffer.allocate(sizeInBytes);
        for (int i = 0; i < sizeInBytes / 4; ++i) {
            buffer.putInt(partNumber);
        }
        return buffer.array();
    }

    protected byte[] digest(Path path) throws IOException {
        FileSystem fs = this.getFileSystem();
        try (FSDataInputStream in = fs.open(path);){
            byte[] fdData = IOUtils.toByteArray((InputStream)in);
            MessageDigest newDigest = DigestUtils.getMd5Digest();
            byte[] byArray = newDigest.digest(fdData);
            return byArray;
        }
    }

    protected abstract int partSizeInBytes();

    protected int getTestPayloadCount() {
        return 10;
    }

    @Test
    public void testSingleUpload() throws Exception {
        FileSystem fs = this.getFileSystem();
        Path file = this.path("testSingleUpload");
        MultipartUploader mpu = MultipartUploaderFactory.get((FileSystem)fs, null);
        UploadHandle uploadHandle = mpu.initialize(file);
        ArrayList<Pair<Integer, PartHandle>> partHandles = new ArrayList<Pair<Integer, PartHandle>>();
        MessageDigest origDigest = DigestUtils.getMd5Digest();
        byte[] payload = this.generatePayload(1);
        origDigest.update(payload);
        ByteArrayInputStream is = new ByteArrayInputStream(payload);
        PartHandle partHandle = mpu.putPart(file, (InputStream)is, 1, uploadHandle, (long)payload.length);
        partHandles.add(Pair.of((Object)1, (Object)partHandle));
        PathHandle fd = this.completeUpload(file, mpu, uploadHandle, partHandles, origDigest, payload.length);
        PathHandle fd2 = mpu.complete(file, partHandles, uploadHandle);
        AbstractContractMultipartUploaderTest.assertArrayEquals((String)"Path handles differ", (byte[])fd.toByteArray(), (byte[])fd2.toByteArray());
    }

    private PathHandle completeUpload(Path file, MultipartUploader mpu, UploadHandle uploadHandle, List<Pair<Integer, PartHandle>> partHandles, MessageDigest origDigest, int expectedLength) throws IOException {
        PathHandle fd = mpu.complete(file, partHandles, uploadHandle);
        FileStatus status = ContractTestUtils.verifyPathExists(this.getFileSystem(), "Completed file", file);
        AbstractContractMultipartUploaderTest.assertEquals((String)("length of " + status), (long)expectedLength, (long)status.getLen());
        AbstractContractMultipartUploaderTest.assertArrayEquals((String)("digest of source and " + file + " differ"), (byte[])origDigest.digest(), (byte[])this.digest(file));
        return fd;
    }

    @Test
    public void testMultipartUpload() throws Exception {
        FileSystem fs = this.getFileSystem();
        Path file = this.path("testMultipartUpload");
        MultipartUploader mpu = MultipartUploaderFactory.get((FileSystem)fs, null);
        UploadHandle uploadHandle = mpu.initialize(file);
        ArrayList<Pair<Integer, PartHandle>> partHandles = new ArrayList<Pair<Integer, PartHandle>>();
        MessageDigest origDigest = DigestUtils.getMd5Digest();
        int payloadCount = this.getTestPayloadCount();
        for (int i = 1; i <= payloadCount; ++i) {
            byte[] payload = this.generatePayload(i);
            origDigest.update(payload);
            ByteArrayInputStream is = new ByteArrayInputStream(payload);
            PartHandle partHandle = mpu.putPart(file, (InputStream)is, i, uploadHandle, (long)payload.length);
            partHandles.add((Pair<Integer, PartHandle>)Pair.of((Object)i, (Object)partHandle));
        }
        this.completeUpload(file, mpu, uploadHandle, partHandles, origDigest, payloadCount * this.partSizeInBytes());
    }

    @Test
    public void testMultipartUploadEmptyPart() throws Exception {
        FileSystem fs = this.getFileSystem();
        Path file = this.path("testMultipartUpload");
        MultipartUploader mpu = MultipartUploaderFactory.get((FileSystem)fs, null);
        UploadHandle uploadHandle = mpu.initialize(file);
        ArrayList<Pair<Integer, PartHandle>> partHandles = new ArrayList<Pair<Integer, PartHandle>>();
        MessageDigest origDigest = DigestUtils.getMd5Digest();
        byte[] payload = new byte[]{};
        origDigest.update(payload);
        ByteArrayInputStream is = new ByteArrayInputStream(payload);
        PartHandle partHandle = mpu.putPart(file, (InputStream)is, 0, uploadHandle, (long)payload.length);
        partHandles.add(Pair.of((Object)0, (Object)partHandle));
        this.completeUpload(file, mpu, uploadHandle, partHandles, origDigest, 0);
    }

    @Test
    public void testMultipartUploadReverseOrder() throws Exception {
        byte[] payload;
        int i;
        FileSystem fs = this.getFileSystem();
        Path file = this.path("testMultipartUploadReverseOrder");
        MultipartUploader mpu = MultipartUploaderFactory.get((FileSystem)fs, null);
        UploadHandle uploadHandle = mpu.initialize(file);
        ArrayList<Pair<Integer, PartHandle>> partHandles = new ArrayList<Pair<Integer, PartHandle>>();
        MessageDigest origDigest = DigestUtils.getMd5Digest();
        int payloadCount = this.getTestPayloadCount();
        for (i = 1; i <= payloadCount; ++i) {
            payload = this.generatePayload(i);
            origDigest.update(payload);
        }
        for (i = payloadCount; i > 0; --i) {
            payload = this.generatePayload(i);
            ByteArrayInputStream is = new ByteArrayInputStream(payload);
            PartHandle partHandle = mpu.putPart(file, (InputStream)is, i, uploadHandle, (long)payload.length);
            partHandles.add((Pair<Integer, PartHandle>)Pair.of((Object)i, (Object)partHandle));
        }
        this.completeUpload(file, mpu, uploadHandle, partHandles, origDigest, payloadCount * this.partSizeInBytes());
    }

    @Test
    public void testMultipartUploadReverseOrderNonContiguousPartNumbers() throws Exception {
        byte[] payload;
        int i;
        this.describe("Upload in reverse order and the part numbers are not contiguous");
        FileSystem fs = this.getFileSystem();
        Path file = this.path("testMultipartUploadReverseOrderNonContiguousPartNumbers");
        MultipartUploader mpu = MultipartUploaderFactory.get((FileSystem)fs, null);
        UploadHandle uploadHandle = mpu.initialize(file);
        ArrayList<Pair<Integer, PartHandle>> partHandles = new ArrayList<Pair<Integer, PartHandle>>();
        MessageDigest origDigest = DigestUtils.getMd5Digest();
        int payloadCount = 2 * this.getTestPayloadCount();
        for (i = 2; i <= payloadCount; i += 2) {
            payload = this.generatePayload(i);
            origDigest.update(payload);
        }
        for (i = payloadCount; i > 0; i -= 2) {
            payload = this.generatePayload(i);
            ByteArrayInputStream is = new ByteArrayInputStream(payload);
            PartHandle partHandle = mpu.putPart(file, (InputStream)is, i, uploadHandle, (long)payload.length);
            partHandles.add((Pair<Integer, PartHandle>)Pair.of((Object)i, (Object)partHandle));
        }
        this.completeUpload(file, mpu, uploadHandle, partHandles, origDigest, this.getTestPayloadCount() * this.partSizeInBytes());
    }

    @Test
    public void testMultipartUploadAbort() throws Exception {
        InputStream is;
        this.describe("Upload and then abort it before completing");
        FileSystem fs = this.getFileSystem();
        Path file = this.path("testMultipartUploadAbort");
        MultipartUploader mpu = MultipartUploaderFactory.get((FileSystem)fs, null);
        UploadHandle uploadHandle = mpu.initialize(file);
        ArrayList<Pair> partHandles = new ArrayList<Pair>();
        for (int i = 20; i >= 10; --i) {
            byte[] payload = this.generatePayload(i);
            is = new ByteArrayInputStream(payload);
            PartHandle partHandle = mpu.putPart(file, is, i, uploadHandle, (long)payload.length);
            partHandles.add(Pair.of((Object)i, (Object)partHandle));
        }
        mpu.abort(file, uploadHandle);
        String contents = "ThisIsPart49\n";
        int len = contents.getBytes(Charsets.UTF_8).length;
        is = IOUtils.toInputStream((String)contents, (String)"UTF-8");
        LambdaTestUtils.intercept(IOException.class, () -> mpu.putPart(file, is, 49, uploadHandle, (long)len));
        LambdaTestUtils.intercept(IOException.class, () -> mpu.complete(file, partHandles, uploadHandle));
        this.assertPathDoesNotExist("Uploaded file should not exist", file);
    }

    @Test
    public void testAbortUnknownUpload() throws Exception {
        FileSystem fs = this.getFileSystem();
        Path file = this.path("testAbortUnknownUpload");
        MultipartUploader mpu = MultipartUploaderFactory.get((FileSystem)fs, null);
        ByteBuffer byteBuffer = ByteBuffer.wrap("invalid-handle".getBytes(Charsets.UTF_8));
        UploadHandle uploadHandle = BBUploadHandle.from((ByteBuffer)byteBuffer);
        LambdaTestUtils.intercept(FileNotFoundException.class, () -> mpu.abort(file, uploadHandle));
    }

    @Test
    public void testAbortEmptyUploadHandle() throws Exception {
        FileSystem fs = this.getFileSystem();
        Path file = this.path("testAbortEmptyUpload");
        MultipartUploader mpu = MultipartUploaderFactory.get((FileSystem)fs, null);
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[0]);
        UploadHandle uploadHandle = BBUploadHandle.from((ByteBuffer)byteBuffer);
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> mpu.abort(file, uploadHandle));
    }

    @Test
    public void testCompleteEmptyUpload() throws Exception {
        this.describe("Expect an empty MPU to fail, but still be abortable");
        FileSystem fs = this.getFileSystem();
        Path dest = this.path("testCompleteEmptyUpload");
        MultipartUploader mpu = MultipartUploaderFactory.get((FileSystem)fs, null);
        UploadHandle handle = mpu.initialize(dest);
        LambdaTestUtils.intercept(IOException.class, () -> mpu.complete(dest, new ArrayList(), handle));
        mpu.abort(dest, handle);
    }

    @Test
    public void testPutPartEmptyUploadID() throws Exception {
        this.describe("Expect IllegalArgumentException when putPart uploadID is empty");
        FileSystem fs = this.getFileSystem();
        Path dest = this.path("testCompleteEmptyUpload");
        MultipartUploader mpu = MultipartUploaderFactory.get((FileSystem)fs, null);
        mpu.initialize(dest);
        UploadHandle emptyHandle = BBUploadHandle.from((ByteBuffer)ByteBuffer.wrap(new byte[0]));
        byte[] payload = this.generatePayload(1);
        ByteArrayInputStream is = new ByteArrayInputStream(payload);
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> mpu.putPart(dest, is, 1, emptyHandle, (long)payload.length));
    }

    @Test
    public void testCompleteEmptyUploadID() throws Exception {
        this.describe("Expect IllegalArgumentException when complete uploadID is empty");
        FileSystem fs = this.getFileSystem();
        Path dest = this.path("testCompleteEmptyUpload");
        MultipartUploader mpu = MultipartUploaderFactory.get((FileSystem)fs, null);
        UploadHandle realHandle = mpu.initialize(dest);
        UploadHandle emptyHandle = BBUploadHandle.from((ByteBuffer)ByteBuffer.wrap(new byte[0]));
        ArrayList<Pair> partHandles = new ArrayList<Pair>();
        byte[] payload = this.generatePayload(1);
        ByteArrayInputStream is = new ByteArrayInputStream(payload);
        PartHandle partHandle = mpu.putPart(dest, (InputStream)is, 1, realHandle, (long)payload.length);
        partHandles.add(Pair.of((Object)1, (Object)partHandle));
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> mpu.complete(dest, partHandles, emptyHandle));
    }
}

