/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.ssl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.math.BigInteger;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.security.alias.CredentialProviderFactory;
import org.apache.hadoop.security.ssl.FileBasedKeyStoresFactory;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.hadoop.test.GenericTestUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.CRLNumber;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509v2CRLBuilder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CRLConverter;
import org.bouncycastle.cert.jcajce.JcaX509CRLHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class KeyStoreTestUtil {
    public static String getClasspathDir(Class klass) throws Exception {
        String file = klass.getName();
        file = file.replace('.', '/') + ".class";
        URL url = Thread.currentThread().getContextClassLoader().getResource(file);
        String baseDir = url.toURI().getPath();
        baseDir = baseDir.substring(0, baseDir.length() - file.length() - 1);
        return baseDir;
    }

    public static X509Certificate generateCertificate(String dn, KeyPair pair, int days, String algorithm) throws GeneralSecurityException {
        return KeyStoreTestUtil.generateCertificate(dn, pair, days, algorithm, false);
    }

    public static X509Certificate generateCertificate(String dn, KeyPair pair, int days, String algorithm, boolean ca) throws GeneralSecurityException {
        Date from = new Date();
        Date to = new Date(from.getTime() + (long)days * 86400000L);
        BigInteger sn = new BigInteger(64, new SecureRandom());
        KeyPair keyPair = pair;
        X500Name x500Name = new X500Name(dn);
        try {
            ContentSigner sigGen = new JcaContentSignerBuilder(algorithm).setProvider("BC").build(pair.getPrivate());
            JcaX509v3CertificateBuilder certGen = new JcaX509v3CertificateBuilder(x500Name, sn, from, to, x500Name, pair.getPublic());
            certGen.addExtension(Extension.basicConstraints, false, (ASN1Encodable)new BasicConstraints(ca));
            return new JcaX509CertificateConverter().setProvider("BC").getCertificate(certGen.build(sigGen));
        }
        catch (CertificateException | OperatorCreationException ex) {
            throw new InvalidKeyException(ex);
        }
        catch (CertIOException ex) {
            throw new GeneralSecurityException(ex);
        }
    }

    public static X509Certificate generateSignedCertificate(String dn, KeyPair pair, int days, String algorithm, PrivateKey caKey, X509Certificate caCert) throws NoSuchAlgorithmException, InvalidKeyException {
        Date from = new Date();
        Date to = new Date(from.getTime() + (long)days * 86400000L);
        BigInteger sn = new BigInteger(64, new SecureRandom());
        X500Name x500Name = new X500Name(dn);
        X500Name issuer = new X500Name(caCert.getSubjectX500Principal().getName());
        try {
            JcaX509ExtensionUtils extUtil = new JcaX509ExtensionUtils();
            ContentSigner sigGen = new JcaContentSignerBuilder(algorithm).setProvider("BC").build(caKey);
            X509v3CertificateBuilder certGen = new JcaX509v3CertificateBuilder(issuer, sn, from, to, x500Name, pair.getPublic()).addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)extUtil.createAuthorityKeyIdentifier(caCert.getPublicKey())).addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)extUtil.createSubjectKeyIdentifier(pair.getPublic()));
            return new JcaX509CertificateConverter().setProvider("BC").getCertificate(certGen.build(sigGen));
        }
        catch (CertificateException | CertIOException | OperatorCreationException ex) {
            throw new InvalidKeyException(ex);
        }
    }

    public static KeyPair generateKeyPair(String algorithm) throws NoSuchAlgorithmException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance(algorithm);
        keyGen.initialize(2048);
        return keyGen.genKeyPair();
    }

    private static KeyStore createEmptyKeyStore() throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null, null);
        return ks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveKeyStore(KeyStore ks, String filename, String password) throws GeneralSecurityException, IOException {
        try (FileOutputStream out = new FileOutputStream(filename);){
            ks.store(out, password.toCharArray());
        }
    }

    public static void createKeyStore(String filename, String password, String alias, Key privateKey, Certificate cert) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStoreTestUtil.createEmptyKeyStore();
        ks.setKeyEntry(alias, privateKey, password.toCharArray(), new Certificate[]{cert});
        KeyStoreTestUtil.saveKeyStore(ks, filename, password);
    }

    public static void createKeyStore(String filename, String password, String keyPassword, String alias, Key privateKey, Certificate cert) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStoreTestUtil.createEmptyKeyStore();
        ks.setKeyEntry(alias, privateKey, keyPassword.toCharArray(), new Certificate[]{cert});
        KeyStoreTestUtil.saveKeyStore(ks, filename, password);
    }

    public static void createTrustStore(String filename, String password, String alias, Certificate cert) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStoreTestUtil.createEmptyKeyStore();
        ks.setCertificateEntry(alias, cert);
        KeyStoreTestUtil.saveKeyStore(ks, filename, password);
    }

    public static <T extends Certificate> void createTrustStore(String filename, String password, Map<String, T> certs) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStoreTestUtil.createEmptyKeyStore();
        for (Map.Entry<String, T> cert : certs.entrySet()) {
            ks.setCertificateEntry(cert.getKey(), (Certificate)cert.getValue());
        }
        KeyStoreTestUtil.saveKeyStore(ks, filename, password);
    }

    public static X509CRL generateCRL(X509Certificate caCert, PrivateKey caPrivateKey, String signAlgorith, X509CRL existingCRL, BigInteger serialNumberToRevoke) throws GeneralSecurityException {
        LocalDate currentTime = LocalDate.now();
        Date nowDate = Date.from(currentTime.atStartOfDay(ZoneId.systemDefault()).toInstant());
        LocalDate nextUpdate = currentTime.plus(1L, ChronoUnit.WEEKS);
        Date nextUpdateDate = Date.from(nextUpdate.atStartOfDay(ZoneId.systemDefault()).toInstant());
        X509v2CRLBuilder crlBuilder = new X509v2CRLBuilder(new X500Name(caCert.getSubjectX500Principal().getName()), nowDate);
        crlBuilder.setNextUpdate(nextUpdateDate);
        if (existingCRL != null) {
            crlBuilder.addCRL((X509CRLHolder)new JcaX509CRLHolder(existingCRL));
        }
        if (serialNumberToRevoke != null) {
            crlBuilder.addCRLEntry(serialNumberToRevoke, nowDate, 9);
        }
        JcaX509ExtensionUtils extUtils = new JcaX509ExtensionUtils();
        try {
            crlBuilder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)extUtils.createAuthorityKeyIdentifier(caCert.getPublicKey()));
            crlBuilder.addExtension(Extension.cRLNumber, false, (ASN1Encodable)new CRLNumber(BigInteger.ONE));
            X509CRLHolder crlHolder = crlBuilder.build(new JcaContentSignerBuilder(signAlgorith).setProvider("BC").build(caPrivateKey));
            return new JcaX509CRLConverter().setProvider("BC").getCRL(crlHolder);
        }
        catch (CertIOException | OperatorCreationException ex) {
            throw new GeneralSecurityException(ex);
        }
    }

    public static void cleanupSSLConfig(String keystoresDir, String sslConfDir) throws Exception {
        File f = new File(keystoresDir + "/clientKS.jks");
        f.delete();
        f = new File(keystoresDir + "/serverKS.jks");
        f.delete();
        f = new File(keystoresDir + "/trustKS.jks");
        f.delete();
        f = new File(sslConfDir + "/ssl-client.xml");
        f.delete();
        f = new File(sslConfDir + "/ssl-server.xml");
        f.delete();
    }

    public static void setupSSLConfig(String keystoresDir, String sslConfDir, Configuration conf, boolean useClientCert) throws Exception {
        KeyStoreTestUtil.setupSSLConfig(keystoresDir, sslConfDir, conf, useClientCert, true);
    }

    public static void setupSSLConfig(String keystoresDir, String sslConfDir, Configuration conf, boolean useClientCert, boolean trustStore) throws Exception {
        KeyStoreTestUtil.setupSSLConfig(keystoresDir, sslConfDir, conf, useClientCert, true, "");
    }

    public static void setupSSLConfig(String keystoresDir, String sslConfDir, Configuration conf, boolean useClientCert, boolean trustStore, String excludeCiphers) throws Exception {
        String clientKS = keystoresDir + "/clientKS.jks";
        String clientPassword = "clientP";
        String serverKS = keystoresDir + "/serverKS.jks";
        String serverPassword = "serverP";
        String trustKS = null;
        String trustPassword = "trustP";
        File sslClientConfFile = new File(sslConfDir, KeyStoreTestUtil.getClientSSLConfigFileName());
        File sslServerConfFile = new File(sslConfDir, KeyStoreTestUtil.getServerSSLConfigFileName());
        HashMap<String, X509Certificate> certs = new HashMap<String, X509Certificate>();
        if (useClientCert) {
            KeyPair cKP = KeyStoreTestUtil.generateKeyPair("RSA");
            X509Certificate cCert = KeyStoreTestUtil.generateCertificate("CN=localhost, O=client", cKP, 30, "SHA1withRSA");
            KeyStoreTestUtil.createKeyStore(clientKS, clientPassword, "client", cKP.getPrivate(), cCert);
            certs.put("client", cCert);
        }
        KeyPair sKP = KeyStoreTestUtil.generateKeyPair("RSA");
        X509Certificate sCert = KeyStoreTestUtil.generateCertificate("CN=localhost, O=server", sKP, 30, "SHA1withRSA");
        KeyStoreTestUtil.createKeyStore(serverKS, serverPassword, "server", sKP.getPrivate(), sCert);
        certs.put("server", sCert);
        if (trustStore) {
            trustKS = keystoresDir + "/trustKS.jks";
            KeyStoreTestUtil.createTrustStore(trustKS, trustPassword, certs);
        }
        Configuration clientSSLConf = KeyStoreTestUtil.createClientSSLConfig(clientKS, clientPassword, clientPassword, trustKS, excludeCiphers);
        Configuration serverSSLConf = KeyStoreTestUtil.createServerSSLConfig(serverKS, serverPassword, serverPassword, trustKS, excludeCiphers);
        KeyStoreTestUtil.saveConfig(sslClientConfFile, clientSSLConf);
        KeyStoreTestUtil.saveConfig(sslServerConfFile, serverSSLConf);
        conf.set("hadoop.ssl.hostname.verifier", "ALLOW_ALL");
        conf.set("hadoop.ssl.client.conf", sslClientConfFile.getName());
        conf.set("hadoop.ssl.server.conf", sslServerConfFile.getName());
        conf.setBoolean("hadoop.ssl.require.client.cert", useClientCert);
    }

    public static Configuration createClientSSLConfig(String clientKS, String password, String keyPassword, String trustKS, String trustPassword, String excludeCiphers) {
        return KeyStoreTestUtil.createSSLConfig(SSLFactory.Mode.CLIENT, clientKS, password, keyPassword, trustKS, trustPassword, excludeCiphers);
    }

    public static Configuration createClientSSLConfig(String clientKS, String password, String keyPassword, String trustKS) {
        return KeyStoreTestUtil.createSSLConfig(SSLFactory.Mode.CLIENT, clientKS, password, keyPassword, trustKS, "trustP", "");
    }

    public static Configuration createClientSSLConfig(String clientKS, String password, String keyPassword, String trustKS, String excludeCiphers) {
        return KeyStoreTestUtil.createSSLConfig(SSLFactory.Mode.CLIENT, clientKS, password, keyPassword, trustKS, "trustP", excludeCiphers);
    }

    public static Configuration createServerSSLConfig(String serverKS, String password, String keyPassword, String trustKS) throws IOException {
        return KeyStoreTestUtil.createSSLConfig(SSLFactory.Mode.SERVER, serverKS, password, keyPassword, trustKS, "trustP", "");
    }

    public static Configuration createServerSSLConfig(String serverKS, String password, String keyPassword, String trustKS, String excludeCiphers) throws IOException {
        return KeyStoreTestUtil.createSSLConfig(SSLFactory.Mode.SERVER, serverKS, password, keyPassword, trustKS, "trustP", excludeCiphers);
    }

    public static Configuration createServerSSLConfig(String serverKS, String password, String keyPassword, String trustKS, String trustPass, String excludeCiphers) throws IOException {
        return KeyStoreTestUtil.createSSLConfig(SSLFactory.Mode.SERVER, serverKS, password, keyPassword, trustKS, trustPass, excludeCiphers);
    }

    public static String getClientSSLConfigFileName() {
        return KeyStoreTestUtil.getSSLConfigFileName("ssl-client");
    }

    public static String getServerSSLConfigFileName() {
        return KeyStoreTestUtil.getSSLConfigFileName("ssl-server");
    }

    private static String getSSLConfigFileName(String base) {
        String testUniqueForkId = System.getProperty("test.unique.fork.id");
        String fileSuffix = testUniqueForkId != null ? "-" + testUniqueForkId : "";
        return base + fileSuffix + ".xml";
    }

    private static Configuration createSSLConfig(SSLFactory.Mode mode, String keystore, String password, String keyPassword, String trustKS, String trustPass, String excludeCiphers) {
        String trustPassword = trustPass;
        Configuration sslConf = new Configuration(false);
        if (keystore != null) {
            sslConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)mode, (String)"ssl.{0}.keystore.location"), keystore);
        }
        if (password != null) {
            sslConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)mode, (String)"ssl.{0}.keystore.password"), password);
        }
        if (keyPassword != null) {
            sslConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)mode, (String)"ssl.{0}.keystore.keypassword"), keyPassword);
        }
        sslConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)mode, (String)"ssl.{0}.keystore.reload.interval"), "1000");
        sslConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)mode, (String)"ssl.{0}.keystore.reload.timeunit"), "MILLISECONDS");
        if (trustKS != null) {
            sslConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)mode, (String)"ssl.{0}.truststore.location"), trustKS);
        }
        if (trustPassword != null) {
            sslConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)mode, (String)"ssl.{0}.truststore.password"), trustPassword);
        }
        if (null != excludeCiphers && !excludeCiphers.isEmpty()) {
            sslConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)mode, (String)"ssl.{0}.exclude.cipher.list"), excludeCiphers);
        }
        sslConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)mode, (String)"ssl.{0}.truststore.reload.interval"), "1000");
        return sslConf;
    }

    public static void saveConfig(File file, Configuration conf) throws IOException {
        try (FileWriter writer = new FileWriter(file);){
            conf.writeXml((Writer)writer);
        }
    }

    public static void provisionPasswordsToCredentialProvider() throws Exception {
        File testDir = GenericTestUtils.getTestDir();
        Configuration conf = new Configuration();
        Path jksPath = new Path(testDir.toString(), "test.jks");
        String ourUrl = "jceks://file" + jksPath.toUri();
        File file = new File(testDir, "test.jks");
        file.delete();
        conf.set("hadoop.security.credential.provider.path", ourUrl);
        CredentialProvider provider = (CredentialProvider)CredentialProviderFactory.getProviders((Configuration)conf).get(0);
        char[] keypass = new char[]{'k', 'e', 'y', 'p', 'a', 's', 's'};
        char[] storepass = new char[]{'s', 't', 'o', 'r', 'e', 'p', 'a', 's', 's'};
        try {
            provider.createCredentialEntry(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)SSLFactory.Mode.SERVER, (String)"ssl.{0}.keystore.password"), storepass);
            provider.createCredentialEntry(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)SSLFactory.Mode.SERVER, (String)"ssl.{0}.keystore.keypassword"), keypass);
            provider.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static Configuration getSslConfig() {
        Configuration sslConf = new Configuration(false);
        String sslServerConfFile = KeyStoreTestUtil.getServerSSLConfigFileName();
        String sslClientConfFile = KeyStoreTestUtil.getClientSSLConfigFileName();
        sslConf.addResource(sslServerConfFile);
        sslConf.addResource(sslClientConfFile);
        sslConf.set("hadoop.ssl.server.conf", sslServerConfFile);
        sslConf.set("hadoop.ssl.client.conf", sslClientConfFile);
        return sslConf;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

