/*
 * Decompiled with CFR 0.152.
 */
package io.hops.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.hops.security.CertificateLocalizationService;
import io.hops.security.SuperuserKeystoresLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.ssl.JWTSecurityMaterial;
import org.apache.hadoop.security.ssl.SecurityMaterial;
import org.apache.hadoop.security.ssl.X509SecurityMaterial;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestCertificateLocalizationService {
    private static final String BASE_DIR = Paths.get(System.getProperty("test.build.dir", Paths.get("target", "test-dir").toString()), TestCertificateLocalizationService.class.getSimpleName()).toString();
    private static final File BASE_DIR_FILE = new File(BASE_DIR);
    private final Logger LOG = LogManager.getLogger(TestCertificateLocalizationService.class);
    private CertificateLocalizationService certLocSrv;
    private Configuration conf;
    @Parameterized.Parameter
    public CertificateLocalizationService.ServiceType service;
    @Rule
    public final ExpectedException rule = ExpectedException.none();

    @Parameterized.Parameters
    public static Collection parameters() {
        return Arrays.asList({CertificateLocalizationService.ServiceType.NM}, {CertificateLocalizationService.ServiceType.RM});
    }

    @BeforeClass
    public static void beforeAll() throws IOException {
        BASE_DIR_FILE.mkdirs();
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        SuperuserKeystoresLoader loader = new SuperuserKeystoresLoader(null);
        Path passwdFileLocation = Paths.get(BASE_DIR, loader.getSuperMaterialPasswdFilename(ugi.getUserName()));
        FileUtils.writeStringToFile((File)passwdFileLocation.toFile(), (String)"password");
    }

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.conf.set("hops.tls.superuser-material-directory", BASE_DIR);
        this.certLocSrv = new CertificateLocalizationService(this.service);
        this.certLocSrv.serviceInit(this.conf);
        this.certLocSrv.serviceStart();
    }

    @After
    public void tearDown() throws Exception {
        if (null != this.certLocSrv) {
            this.certLocSrv.serviceStop();
        }
    }

    @AfterClass
    public static void afterAll() throws IOException {
        if (BASE_DIR_FILE.exists()) {
            FileUtils.deleteDirectory((File)BASE_DIR_FILE);
        }
    }

    private void verifyMaterialExistOrNot(CertificateLocalizationService certLocSrv, String username, String userFolder, String kstorePass, String tstorePass, boolean exist) throws Exception {
        Path expectedTPath;
        Path expectedKPath;
        String certLoc = certLocSrv.getMaterializeDirectory().toString();
        if (this.service == CertificateLocalizationService.ServiceType.NM) {
            expectedKPath = Paths.get(certLoc, userFolder, username + "__kstore.jks");
            expectedTPath = Paths.get(certLoc, userFolder, username + "__tstore.jks");
        } else {
            expectedKPath = Paths.get(certLoc, username, username + "__kstore.jks");
            expectedTPath = Paths.get(certLoc, username, username + "__tstore.jks");
        }
        if (exist) {
            X509SecurityMaterial material = certLocSrv.getX509MaterialLocation(username);
            Assert.assertEquals((Object)expectedKPath, (Object)material.getKeyStoreLocation());
            Assert.assertEquals((Object)expectedTPath, (Object)material.getTrustStoreLocation());
            Assert.assertTrue((boolean)expectedKPath.toFile().exists());
            Assert.assertTrue((boolean)expectedTPath.toFile().exists());
            Assert.assertEquals((Object)kstorePass, (Object)material.getKeyStorePass());
            Assert.assertEquals((Object)tstorePass, (Object)material.getTrustStorePass());
        } else {
            X509SecurityMaterial material = null;
            try {
                material = certLocSrv.getX509MaterialLocation(username);
            }
            catch (FileNotFoundException ex) {
                this.LOG.info((Object)"Exception here is normal");
                Assert.assertNull((Object)material);
                TimeUnit.MILLISECONDS.sleep(500L);
                Assert.assertFalse((boolean)expectedKPath.toFile().exists());
                Assert.assertFalse((boolean)expectedTPath.toFile().exists());
            }
        }
    }

    private void materializeCertificateUtil(CertificateLocalizationService certLocSrv, String username, String userFolder, ByteBuffer bfk, String keyStorePass, ByteBuffer bft, String trustStorePass) throws InterruptedException {
        if (this.service == CertificateLocalizationService.ServiceType.NM) {
            certLocSrv.materializeCertificates(username, userFolder, bfk, keyStorePass, bft, trustStorePass);
        } else {
            certLocSrv.materializeCertificates(username, username, bfk, keyStorePass, bft, trustStorePass);
        }
    }

    private void materializeJWTUtil(CertificateLocalizationService certLocSrv, String username, String userFolder, String token) throws InterruptedException {
        if (this.service == CertificateLocalizationService.ServiceType.NM) {
            certLocSrv.materializeJWT(username, null, userFolder, token);
        } else {
            certLocSrv.materializeJWT(username, null, username, token);
        }
    }

    @Test
    public void testLocalizationDirectory() throws Exception {
        Path materializeDir = this.certLocSrv.getMaterializeDirectory();
        Set<PosixFilePermission> permissionSet = Files.getPosixFilePermissions(materializeDir, new LinkOption[0]);
        EnumSet<PosixFilePermission> expectedPermissionSet = null;
        expectedPermissionSet = this.service == CertificateLocalizationService.ServiceType.NM ? EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_EXECUTE) : EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE);
        Assert.assertTrue((boolean)permissionSet.containsAll(expectedPermissionSet));
    }

    @Test
    public void testMaterialization() throws Exception {
        byte[] randomK = "Some_random_keystore_stuff".getBytes();
        byte[] randomT = "Some_random_truststore_stuff".getBytes();
        ByteBuffer bfk = ByteBuffer.wrap(randomK);
        ByteBuffer bft = ByteBuffer.wrap(randomT);
        String username = "Dr.Who";
        String userFolder = "userfolder";
        String keyStorePass = "keyStorePass";
        String trustStorePass = "trustStorePass";
        this.materializeCertificateUtil(this.certLocSrv, username, userFolder, bfk, keyStorePass, bft, trustStorePass);
        this.verifyMaterialExistOrNot(this.certLocSrv, username, userFolder, keyStorePass, trustStorePass, true);
        this.certLocSrv.removeX509Material(username);
        TimeUnit.MILLISECONDS.sleep(10L);
        this.verifyMaterialExistOrNot(this.certLocSrv, username, userFolder, keyStorePass, trustStorePass, false);
    }

    @Test
    public void testJWTMaterialization() throws Exception {
        String jwt = "random_jwt";
        String username = "Dorothy";
        this.certLocSrv.materializeJWT(username, null, username, jwt);
        JWTSecurityMaterial material = this.certLocSrv.getJWTMaterialLocation(username, null);
        Assert.assertEquals((Object)jwt, (Object)material.getToken());
        Assert.assertTrue((boolean)material.getTokenLocation().toFile().exists());
    }

    @Test
    public void testJWTDeletion() throws Exception {
        String jwt = "a_token";
        String username = "Dorothy";
        this.certLocSrv.materializeJWT(username, null, username, jwt);
        JWTSecurityMaterial material = this.certLocSrv.getJWTMaterialLocation(username, null);
        Assert.assertTrue((boolean)material.getTokenLocation().toFile().exists());
        this.certLocSrv.removeJWTMaterial(username, null);
        this.rule.expect(FileNotFoundException.class);
        JWTSecurityMaterial newMaterial = this.certLocSrv.getJWTMaterialLocation(username, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateMaterialNotification() throws Exception {
        if (this.certLocSrv != null) {
            this.certLocSrv.stop();
            this.certLocSrv = null;
        }
        DelayedCertificateLocalizationService delayedCertLoc = new DelayedCertificateLocalizationService(this.service, 1000L);
        try {
            delayedCertLoc.init(this.conf);
            delayedCertLoc.start();
            ByteBuffer keyStore = ByteBuffer.wrap("keyStore0".getBytes());
            ByteBuffer trustStore = ByteBuffer.wrap("trustStore0".getBytes());
            String keyStorePassword = "kpassword0";
            String trustStorePassword = "tpassword0";
            String username = "Dolores";
            String userFolder = "userFolder";
            String jwt = "Something that's supposed to be a token";
            ByteBuffer newKeyStore = ByteBuffer.wrap("keyStore1".getBytes());
            ByteBuffer newTrustStore = ByteBuffer.wrap("trustStore1".getBytes());
            String newKeyStorePassword = "kpassword1";
            String newTrustStorePassword = "tpassword1";
            String newJWT = "Another token";
            this.materializeCertificateUtil(delayedCertLoc, username, userFolder, keyStore, keyStorePassword, trustStore, trustStorePassword);
            this.materializeJWTUtil(delayedCertLoc, username, userFolder, jwt);
            delayedCertLoc.updateX509(username, null, newKeyStore, newKeyStorePassword, newTrustStore, newTrustStorePassword);
            delayedCertLoc.updateJWT(username, null, newJWT);
            X509SecurityMaterial material = delayedCertLoc.getX509MaterialLocation(username);
            Assert.assertNotEquals((Object)keyStore, (Object)material.getKeyStoreMem());
            Assert.assertNotEquals((Object)keyStorePassword, (Object)material.getKeyStorePass());
            Assert.assertEquals((Object)newKeyStore, (Object)material.getKeyStoreMem());
            Assert.assertEquals((Object)newKeyStorePassword, (Object)material.getKeyStorePass());
            JWTSecurityMaterial jwtMaterial = delayedCertLoc.getJWTMaterialLocation(username, null);
            Assert.assertNotEquals((Object)jwt, (Object)jwtMaterial.getToken());
        }
        finally {
            delayedCertLoc.stop();
        }
    }

    @Test
    public void testUpdateMaterial() throws Exception {
        ByteBuffer keyStore = ByteBuffer.wrap("keyStore0".getBytes());
        ByteBuffer trustStore = ByteBuffer.wrap("trustStore0".getBytes());
        String keyStorePassword = "kpassword0";
        String trustStorePassword = "tpassword0";
        String username = "Dolores";
        String userFolder = "userFolder";
        String jwt = "A not very random string";
        this.materializeCertificateUtil(this.certLocSrv, username, userFolder, keyStore, keyStorePassword, trustStore, trustStorePassword);
        this.verifyMaterialExistOrNot(this.certLocSrv, username, userFolder, keyStorePassword, trustStorePassword, true);
        this.materializeJWTUtil(this.certLocSrv, username, userFolder, jwt);
        X509SecurityMaterial oldMaterial = this.certLocSrv.getX509MaterialLocation(username);
        JWTSecurityMaterial oldJWTMaterial = this.certLocSrv.getJWTMaterialLocation(username, null);
        Assert.assertNotNull((Object)oldJWTMaterial);
        ByteBuffer newKeyStore = ByteBuffer.wrap("keyStore1".getBytes());
        ByteBuffer newTrustStore = ByteBuffer.wrap("trustStore1".getBytes());
        String newKeyStorePassword = "kpassword1";
        String newTrustStorePassword = "tpassword1";
        String newJWT = "Again not a very random token";
        this.certLocSrv.updateX509(username, null, newKeyStore, newKeyStorePassword, newTrustStore, newTrustStorePassword);
        this.certLocSrv.updateJWT(username, null, newJWT);
        X509SecurityMaterial newMaterial = this.certLocSrv.getX509MaterialLocation(username);
        Assert.assertEquals((Object)newKeyStore, (Object)newMaterial.getKeyStoreMem());
        Assert.assertEquals((Object)newTrustStore, (Object)newMaterial.getTrustStoreMem());
        Assert.assertEquals((Object)newKeyStorePassword, (Object)newMaterial.getKeyStorePass());
        Assert.assertEquals((Object)newTrustStorePassword, (Object)newMaterial.getTrustStorePass());
        Assert.assertEquals((Object)oldMaterial.getCertFolder(), (Object)newMaterial.getCertFolder());
        Assert.assertEquals((Object)oldMaterial.getKeyStoreLocation().toString(), (Object)newMaterial.getKeyStoreLocation().toString());
        Assert.assertEquals((Object)oldMaterial.getTrustStoreLocation().toString(), (Object)newMaterial.getTrustStoreLocation().toString());
        Assert.assertEquals((Object)oldMaterial.getPasswdLocation().toString(), (Object)newMaterial.getPasswdLocation().toString());
        Assert.assertEquals((long)oldMaterial.getRequestedApplications(), (long)newMaterial.getRequestedApplications());
        Assert.assertEquals((Object)SecurityMaterial.STATE.FINISHED, (Object)newMaterial.getState());
        Assert.assertFalse((boolean)keyStore.equals(newMaterial.getKeyStoreMem()));
        Assert.assertFalse((boolean)trustStore.equals(newMaterial.getTrustStoreMem()));
        Assert.assertNotEquals((Object)keyStorePassword, (Object)newMaterial.getKeyStorePass());
        Assert.assertNotEquals((Object)trustStorePassword, (Object)newMaterial.getTrustStorePass());
        JWTSecurityMaterial newJWTMaterial = this.certLocSrv.getJWTMaterialLocation(username, null);
        Assert.assertEquals((Object)newJWT, (Object)newJWTMaterial.getToken());
        Assert.assertNotEquals((Object)jwt, (Object)newJWTMaterial.getToken());
        Assert.assertEquals((Object)oldJWTMaterial.getTokenLocation(), (Object)newJWTMaterial.getTokenLocation());
        this.certLocSrv.removeX509Material(username);
        this.verifyMaterialExistOrNot(this.certLocSrv, username, userFolder, newKeyStorePassword, newTrustStorePassword, false);
    }

    @Test
    public void testMaterializationRemoval() throws Exception {
        ByteBuffer store = ByteBuffer.wrap("some_bytes".getBytes());
        String username = "Dolores";
        String userFolder = "userFolder";
        String password = "password";
        this.materializeCertificateUtil(this.certLocSrv, username, userFolder, store, password, store, password);
        this.certLocSrv.removeX509Material(username);
        this.verifyMaterialExistOrNot(this.certLocSrv, username, userFolder, password, password, false);
    }

    @Test
    public void testMultipleReadsCryptoBuffers() throws Exception {
        byte[] randomK = "Some_random_keystore_stuff".getBytes();
        byte[] randomT = "Some_random_truststore_stuff".getBytes();
        ByteBuffer bfk = ByteBuffer.wrap(randomK);
        ByteBuffer bft = ByteBuffer.wrap(randomT);
        String username = "Dr.Who";
        String userFolder = "userfolder";
        String keyStorePass = "keyStorePass";
        String trustStorePass = "trustStorePass";
        this.materializeCertificateUtil(this.certLocSrv, username, userFolder, bfk, keyStorePass, bft, trustStorePass);
        X509SecurityMaterial cryptoMaterial = this.certLocSrv.getX509MaterialLocation(username);
        Assert.assertTrue((boolean)bfk.equals(cryptoMaterial.getKeyStoreMem()));
        Assert.assertTrue((boolean)bft.equals(cryptoMaterial.getTrustStoreMem()));
        Assert.assertTrue((boolean)bfk.equals(cryptoMaterial.getKeyStoreMem()));
        Assert.assertTrue((boolean)bft.equals(cryptoMaterial.getTrustStoreMem()));
        this.certLocSrv.removeX509Material(username);
    }

    @Test
    public void testMaterializationWithMultipleApplications() throws Exception {
        byte[] randomK = "Some_random_keystore_stuff".getBytes();
        byte[] randomT = "Some_random_truststore_stuff".getBytes();
        ByteBuffer bfk = ByteBuffer.wrap(randomK);
        ByteBuffer bft = ByteBuffer.wrap(randomT);
        String username = "Dr.Who";
        String userFolder = "userFolder";
        String keyStorePass0 = "keyStorePass0";
        String trustStorePass0 = "trustStorePass0";
        this.materializeCertificateUtil(this.certLocSrv, username, userFolder, bfk, keyStorePass0, bft, trustStorePass0);
        this.verifyMaterialExistOrNot(this.certLocSrv, username, userFolder, keyStorePass0, trustStorePass0, true);
        this.materializeCertificateUtil(this.certLocSrv, username, userFolder, bfk, keyStorePass0, bft, trustStorePass0);
        X509SecurityMaterial cryptoMaterial = this.certLocSrv.getX509MaterialLocation(username);
        Assert.assertEquals((long)2L, (long)cryptoMaterial.getRequestedApplications());
        this.certLocSrv.removeX509Material(username);
        TimeUnit.MILLISECONDS.sleep(10L);
        cryptoMaterial = this.certLocSrv.getX509MaterialLocation(username);
        Assert.assertEquals((long)1L, (long)cryptoMaterial.getRequestedApplications());
        Assert.assertFalse((boolean)cryptoMaterial.isSafeToRemove());
        this.verifyMaterialExistOrNot(this.certLocSrv, username, userFolder, keyStorePass0, trustStorePass0, true);
        this.certLocSrv.removeX509Material(username);
        TimeUnit.MILLISECONDS.sleep(10L);
        this.verifyMaterialExistOrNot(this.certLocSrv, username, userFolder, keyStorePass0, trustStorePass0, false);
        this.rule.expect(FileNotFoundException.class);
        this.certLocSrv.getX509MaterialLocation(username);
    }

    @Test
    public void testMaterialNotFound() throws Exception {
        this.rule.expect(FileNotFoundException.class);
        this.certLocSrv.getX509MaterialLocation("username");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDelayedMaterializationAndForceRemoval() throws Exception {
        if (this.certLocSrv != null) {
            this.certLocSrv.serviceStop();
            this.certLocSrv = null;
        }
        DelayedCertificateLocalizationService delayedCertLoc = new DelayedCertificateLocalizationService(this.service, 1000L);
        try {
            delayedCertLoc.serviceInit(this.conf);
            delayedCertLoc.serviceStart();
            String username = "username";
            String userFolder = "userFolder";
            String password = "password";
            ByteBuffer byteBuffer = ByteBuffer.wrap("some_bytes".getBytes());
            this.materializeCertificateUtil(delayedCertLoc, username, userFolder, byteBuffer, password, byteBuffer, password);
            delayedCertLoc.forceRemoveMaterial(username);
            this.verifyMaterialExistOrNot(delayedCertLoc, username, userFolder, password, password, false);
            TimeUnit.MILLISECONDS.sleep(1000L);
            Assert.assertNotNull((Object)delayedCertLoc.getHasBeenMaterialized());
            Assert.assertFalse((boolean)delayedCertLoc.getHasBeenMaterialized());
        }
        finally {
            delayedCertLoc.serviceStop();
        }
    }

    @Test
    public void testMXBeanForceRemove() throws Exception {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName mxbean = new ObjectName("Hadoop:service=" + this.service.toString() + ",name=CertificateLocalizer");
        ObjectMapper objectMapper = new ObjectMapper();
        byte[] someBytes = "some_bytes".getBytes();
        ByteBuffer keyStore = ByteBuffer.wrap(someBytes);
        ByteBuffer trustStore = ByteBuffer.wrap(someBytes);
        String userA = "userA";
        String userFolderA = "userFolderA";
        String userAStateKey = userA + "/unknown/" + CertificateLocalizationService.STORAGE_KEY_TYPE.X509;
        String userB = "userB";
        String userFolderB = "userFolderB";
        this.materializeCertificateUtil(this.certLocSrv, userA, userFolderA, keyStore, "some_pass", trustStore, "some_pass");
        TimeUnit.MILLISECONDS.sleep(300L);
        String jmxReturn = (String)mbs.getAttribute(mxbean, "State");
        Map<String, String> returnMap = this.parseCertificateLocalizerState(jmxReturn, objectMapper);
        Map<String, Integer> materializedMap = this.getMaterializedStateOutOfString(returnMap, objectMapper);
        Assert.assertEquals((long)1L, (long)materializedMap.size());
        Assert.assertTrue((boolean)materializedMap.containsKey(userAStateKey));
        Assert.assertEquals((long)1L, (long)materializedMap.get(userAStateKey).intValue());
        this.materializeCertificateUtil(this.certLocSrv, userA, userFolderA, keyStore, "some_pass", trustStore, "some_pass");
        this.invokeJMXRemoveOperation(mbs, mxbean, userA);
        jmxReturn = (String)mbs.getAttribute(mxbean, "State");
        returnMap = this.parseCertificateLocalizerState(jmxReturn, objectMapper);
        materializedMap = this.getMaterializedStateOutOfString(returnMap, objectMapper);
        Assert.assertEquals((long)0L, (long)materializedMap.size());
        this.materializeCertificateUtil(this.certLocSrv, userA, userFolderA, keyStore, "some_pass", trustStore, "some_pass");
        TimeUnit.MILLISECONDS.sleep(300L);
        this.materializeCertificateUtil(this.certLocSrv, userA, userFolderA, keyStore, "some_pass", trustStore, "some_pass");
        this.materializeCertificateUtil(this.certLocSrv, userB, userFolderB, keyStore, "another_pass", trustStore, "another_pass");
        TimeUnit.MILLISECONDS.sleep(300L);
        jmxReturn = (String)mbs.getAttribute(mxbean, "State");
        returnMap = this.parseCertificateLocalizerState(jmxReturn, objectMapper);
        materializedMap = this.getMaterializedStateOutOfString(returnMap, objectMapper);
        Assert.assertEquals((long)2L, (long)materializedMap.size());
        this.invokeJMXRemoveOperation(mbs, mxbean, userA);
        jmxReturn = (String)mbs.getAttribute(mxbean, "State");
        returnMap = this.parseCertificateLocalizerState(jmxReturn, objectMapper);
        materializedMap = this.getMaterializedStateOutOfString(returnMap, objectMapper);
        Assert.assertEquals((long)1L, (long)materializedMap.size());
        Assert.assertFalse((boolean)materializedMap.containsKey(userAStateKey));
    }

    private boolean invokeJMXRemoveOperation(MBeanServer mbs, ObjectName mxbean, String username) throws Exception {
        MBeanInfo mBeanInfo = mbs.getMBeanInfo(mxbean);
        for (MBeanOperationInfo op : mBeanInfo.getOperations()) {
            if (!op.getName().equals("forceRemoveMaterial")) continue;
            boolean returnValue = (Boolean)mbs.invoke(mxbean, "forceRemoveMaterial", new Object[]{username}, new String[]{String.class.getName()});
            return returnValue;
        }
        return false;
    }

    @Test
    public void testMXBeanState() throws Exception {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName mxbean = new ObjectName("Hadoop:service=" + this.service.toString() + ",name=CertificateLocalizer");
        ObjectMapper objectMapper = new ObjectMapper();
        String jmxReturn = (String)mbs.getAttribute(mxbean, "State");
        Map<String, String> returnMap = this.parseCertificateLocalizerState(jmxReturn, objectMapper);
        Assert.assertTrue((String)"Return Map should contain key materialized", (boolean)returnMap.containsKey("materialized"));
        Map<String, Integer> materializedMap = this.getMaterializedStateOutOfString(returnMap, objectMapper);
        Assert.assertTrue((boolean)materializedMap.isEmpty());
        byte[] someBytes = "some_bytes".getBytes();
        ByteBuffer keyStore = ByteBuffer.wrap(someBytes);
        ByteBuffer trustStore = ByteBuffer.wrap(someBytes);
        String userA = "userA";
        String userFolderA = "userFolderA";
        String userAStateKey = userA + "/unknown/" + CertificateLocalizationService.STORAGE_KEY_TYPE.X509;
        this.materializeCertificateUtil(this.certLocSrv, userA, userFolderA, keyStore, "some_pass", trustStore, "some_pass");
        TimeUnit.MILLISECONDS.sleep(300L);
        jmxReturn = (String)mbs.getAttribute(mxbean, "State");
        returnMap = this.parseCertificateLocalizerState(jmxReturn, objectMapper);
        materializedMap = this.getMaterializedStateOutOfString(returnMap, objectMapper);
        Assert.assertEquals((long)1L, (long)materializedMap.size());
        Assert.assertTrue((boolean)materializedMap.containsKey(userAStateKey));
        Assert.assertEquals((long)1L, (long)materializedMap.get(userAStateKey).intValue());
        this.materializeCertificateUtil(this.certLocSrv, userA, userFolderA, keyStore, "some_pass", trustStore, "some_pass");
        jmxReturn = (String)mbs.getAttribute(mxbean, "State");
        returnMap = this.parseCertificateLocalizerState(jmxReturn, objectMapper);
        materializedMap = this.getMaterializedStateOutOfString(returnMap, objectMapper);
        Assert.assertEquals((long)2L, (long)materializedMap.get(userAStateKey).intValue());
        String userB = "userB";
        String userFolderB = "userFolderB";
        String userBStateKey = userB + "/unknown/" + CertificateLocalizationService.STORAGE_KEY_TYPE.X509;
        this.materializeCertificateUtil(this.certLocSrv, userB, userFolderB, keyStore, "some_pass", trustStore, "some_pass");
        TimeUnit.MILLISECONDS.sleep(300L);
        jmxReturn = (String)mbs.getAttribute(mxbean, "State");
        returnMap = this.parseCertificateLocalizerState(jmxReturn, objectMapper);
        materializedMap = this.getMaterializedStateOutOfString(returnMap, objectMapper);
        Assert.assertEquals((long)2L, (long)materializedMap.size());
        Assert.assertTrue((boolean)materializedMap.containsKey(userAStateKey));
        Assert.assertTrue((boolean)materializedMap.containsKey(userBStateKey));
        Assert.assertEquals((long)2L, (long)materializedMap.get(userAStateKey).intValue());
        Assert.assertEquals((long)1L, (long)materializedMap.get(userBStateKey).intValue());
        this.certLocSrv.removeX509Material(userA);
        this.certLocSrv.removeX509Material(userA);
        TimeUnit.MILLISECONDS.sleep(300L);
        jmxReturn = (String)mbs.getAttribute(mxbean, "State");
        returnMap = this.parseCertificateLocalizerState(jmxReturn, objectMapper);
        materializedMap = this.getMaterializedStateOutOfString(returnMap, objectMapper);
        Assert.assertEquals((long)1L, (long)materializedMap.size());
        Assert.assertFalse((boolean)materializedMap.containsKey(userAStateKey));
        Assert.assertTrue((boolean)materializedMap.containsKey(userBStateKey));
        Assert.assertEquals((long)1L, (long)materializedMap.get(userBStateKey).intValue());
        this.certLocSrv.removeX509Material(userB);
        TimeUnit.MILLISECONDS.sleep(300L);
        jmxReturn = (String)mbs.getAttribute(mxbean, "State");
        returnMap = this.parseCertificateLocalizerState(jmxReturn, objectMapper);
        materializedMap = this.getMaterializedStateOutOfString(returnMap, objectMapper);
        Assert.assertTrue((boolean)materializedMap.isEmpty());
    }

    private Map<String, String> parseCertificateLocalizerState(String jmxReturn, ObjectMapper objectMapper) throws IOException {
        return (Map)objectMapper.readValue(jmxReturn, HashMap.class);
    }

    private Map<String, Integer> getMaterializedStateOutOfString(Map<String, String> state, ObjectMapper objectMapper) throws IOException {
        String materializedStr = state.get("materialized");
        return (Map)objectMapper.readValue(materializedStr, HashMap.class);
    }

    private class DelayedCertificateLocalizationService
    extends CertificateLocalizationService {
        private final long sleepInMS;
        private Boolean hasBeenMaterialized;

        public DelayedCertificateLocalizationService(CertificateLocalizationService.ServiceType service, long sleepInMS) {
            super(service);
            this.hasBeenMaterialized = null;
            this.sleepInMS = sleepInMS;
        }

        public Boolean getHasBeenMaterialized() {
            return this.hasBeenMaterialized;
        }

        protected Thread createLocalizationEventsHandler() {
            return new Thread(){

                @Override
                public void run() {
                    while (!Thread.currentThread().isInterrupted()) {
                        try {
                            CertificateLocalizationService.LocalizationEvent event = DelayedCertificateLocalizationService.this.dequeue();
                            TimeUnit.MILLISECONDS.sleep(DelayedCertificateLocalizationService.this.sleepInMS);
                            if (event instanceof CertificateLocalizationService.MaterializeEvent) {
                                DelayedCertificateLocalizationService.this.hasBeenMaterialized = DelayedCertificateLocalizationService.this.materializeInternal((CertificateLocalizationService.MaterializeEvent)event);
                                continue;
                            }
                            if (event instanceof CertificateLocalizationService.RemoveEvent) {
                                DelayedCertificateLocalizationService.this.removeInternal((CertificateLocalizationService.RemoveEvent)event);
                                continue;
                            }
                            if (!(event instanceof CertificateLocalizationService.UpdateEvent)) continue;
                            DelayedCertificateLocalizationService.this.updateInternal((CertificateLocalizationService.UpdateEvent)event);
                        }
                        catch (InterruptedException ex) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
            };
        }
    }
}

