/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.conf;

import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.Test;

public class TestConfigurationSubclass {
    private static final String EMPTY_CONFIGURATION_XML = "/org/apache/hadoop/conf/empty-configuration.xml";

    @Test
    public void testGetProps() {
        SubConf conf = new SubConf(true);
        Properties properties = conf.getProperties();
        Assert.assertNotNull((String)"hadoop.tmp.dir is not set", (Object)properties.getProperty("hadoop.tmp.dir"));
    }

    @Test
    public void testReload() throws Throwable {
        SubConf conf = new SubConf(true);
        Assert.assertFalse((boolean)conf.isReloaded());
        Configuration.addDefaultResource((String)EMPTY_CONFIGURATION_XML);
        Assert.assertTrue((boolean)conf.isReloaded());
        Properties properties = conf.getProperties();
    }

    @Test
    public void testReloadNotQuiet() throws Throwable {
        SubConf conf = new SubConf(true);
        conf.setQuietMode(false);
        Assert.assertFalse((boolean)conf.isReloaded());
        conf.addResource("not-a-valid-resource");
        Assert.assertTrue((boolean)conf.isReloaded());
        try {
            Properties properties = conf.getProperties();
            Assert.fail((String)"Should not have got here");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((String)e.toString(), (boolean)e.getMessage().contains("not found"));
        }
    }

    private static class SubConf
    extends Configuration {
        private boolean reloaded;

        private SubConf(boolean loadDefaults) {
            super(loadDefaults);
        }

        public Properties getProperties() {
            return super.getProps();
        }

        public void reloadConfiguration() {
            super.reloadConfiguration();
            this.reloaded = true;
        }

        public boolean isReloaded() {
            return this.reloaded;
        }

        public void setReloaded(boolean reloaded) {
            this.reloaded = reloaded;
        }
    }
}

