/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import org.apache.hadoop.crypto.OpensslCipher;
import org.apache.hadoop.io.compress.Lz4Codec;
import org.apache.hadoop.io.compress.zlib.ZlibFactory;
import org.apache.hadoop.util.NativeCodeLoader;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestNativeCodeLoader {
    static final Logger LOG = LoggerFactory.getLogger(TestNativeCodeLoader.class);

    private static boolean requireTestJni() {
        String rtj = System.getProperty("require.test.libhadoop");
        if (rtj == null) {
            return false;
        }
        return rtj.compareToIgnoreCase("false") != 0;
    }

    @Test
    public void testNativeCodeLoaded() {
        if (!TestNativeCodeLoader.requireTestJni()) {
            LOG.info("TestNativeCodeLoader: libhadoop.so testing is not required.");
            return;
        }
        if (!NativeCodeLoader.isNativeCodeLoaded()) {
            Assert.fail((String)"TestNativeCodeLoader: libhadoop.so testing was required, but libhadoop.so was not loaded.");
        }
        Assert.assertFalse((boolean)NativeCodeLoader.getLibraryName().isEmpty());
        Assert.assertFalse((boolean)ZlibFactory.getLibraryName().isEmpty());
        if (NativeCodeLoader.buildSupportsOpenssl()) {
            Assert.assertFalse((boolean)OpensslCipher.getLibraryName().isEmpty());
        }
        Assert.assertFalse((boolean)Lz4Codec.getLibraryName().isEmpty());
        LOG.info("TestNativeCodeLoader: libhadoop.so is loaded.");
    }
}

