/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.hops.security;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;

public final class HopsX509AuthenticatorFactory {
  private static volatile HopsX509AuthenticatorFactory _INSTANCE;
  private final HopsX509Authenticator authenticator;
  
  private HopsX509AuthenticatorFactory(Configuration conf) {
    authenticator = new HopsX509Authenticator(conf);
  }
  
  public static HopsX509AuthenticatorFactory getInstance(Configuration conf) {
    if (_INSTANCE == null) {
      synchronized (HopsX509AuthenticatorFactory.class) {
        if (_INSTANCE == null) {
          _INSTANCE = new HopsX509AuthenticatorFactory(conf);
        }
      }
    }
    return _INSTANCE;
  }
  
  public HopsX509Authenticator getAuthenticator() {
    return authenticator;
  }
  
  @VisibleForTesting
  public void clearFactory() {
    _INSTANCE = null;
  }
}
