/*
 * Decompiled with CFR 0.152.
 */
package io.hops.security;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import io.hops.security.CertificateLocalization;
import io.hops.security.CertificateLocalizationMBean;
import io.hops.security.SuperuserKeystoresLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.security.ssl.JWTSecurityMaterial;
import org.apache.hadoop.security.ssl.SecurityMaterial;
import org.apache.hadoop.security.ssl.X509SecurityMaterial;
import org.apache.hadoop.service.AbstractService;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.jetty.util.ajax.JSON;

@InterfaceAudience.LimitedPrivate(value={"Hive"})
public class CertificateLocalizationService
extends AbstractService
implements CertificateLocalization,
CertificateLocalizationMBean {
    private final Logger LOG = LogManager.getLogger(CertificateLocalizationService.class);
    private final String SYSTEM_TMP = System.getProperty("java.io.tmpdir", "/tmp");
    private final String LOCALIZATION_DIR_NAME = "certLoc";
    private Path materializeDir;
    private final Map<StorageKey, SecurityMaterial> materialLocation = new ConcurrentHashMap<StorageKey, SecurityMaterial>();
    private ObjectName mbeanObjectName;
    private final ServiceType service;
    public static final String JMX_MATERIALIZED_KEY = "materialized";
    public static final String JMX_FORCE_REMOVE_OP = "forceRemoveMaterial";
    private final ReentrantLock lock = new ReentrantLock(true);
    private final BlockingQueue<LocalizationEvent> localizationEventsQ;
    private Thread localizationEventsHandler;
    private X509SecurityMaterial superuserMaterial;
    private char[] keystoresPassword;

    public CertificateLocalizationService(ServiceType service) {
        super(CertificateLocalizationService.class.getName());
        this.service = service;
        this.localizationEventsQ = new ArrayBlockingQueue<LocalizationEvent>(100);
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        this.superuserMaterial = this.loadSuperuserMaterialInternal(conf);
        this.keystoresPassword = this.readSupersuperPassword();
        String localizationDir = this.service.toString() + "_" + "certLoc";
        this.materializeDir = Paths.get(this.SYSTEM_TMP, localizationDir);
        File fileMaterializeDir = this.materializeDir.toFile();
        if (!fileMaterializeDir.exists()) {
            fileMaterializeDir.mkdir();
            EnumSet<PosixFilePermission> materializeDirPerm = this.service == ServiceType.NM ? EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_EXECUTE) : EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE);
            Files.setPosixFilePermissions(this.materializeDir, materializeDirPerm);
        }
        this.LOG.debug((Object)("Initialized at dir: " + this.materializeDir.toString()));
        super.serviceInit(conf);
    }

    private X509SecurityMaterial loadSuperuserMaterialInternal(Configuration conf) throws IOException {
        SuperuserKeystoresLoader superuserKeystoresLoader = new SuperuserKeystoresLoader(conf);
        return superuserKeystoresLoader.loadSuperUserMaterial();
    }

    public char[] readSupersuperPassword() throws IOException {
        return FileUtils.readFileToString((File)this.superuserMaterial.getPasswdLocation().toFile()).toCharArray();
    }

    @Override
    protected void serviceStart() throws Exception {
        this.localizationEventsHandler = this.createLocalizationEventsHandler();
        this.localizationEventsHandler.setDaemon(true);
        this.localizationEventsHandler.setName("CertificateLocalizationEvents handler");
        this.localizationEventsHandler.start();
        StandardMBean mbean = new StandardMBean(this, CertificateLocalizationMBean.class);
        this.mbeanObjectName = MBeans.register(this.service.toString(), "CertificateLocalizer", mbean);
        super.serviceStart();
    }

    @Override
    public String getSuperKeystoreLocation() {
        return this.superuserMaterial.getKeyStoreLocation().toString();
    }

    @Override
    public String getSuperKeystorePass() {
        return String.valueOf(this.keystoresPassword);
    }

    @Override
    public String getSuperKeyPassword() {
        return String.valueOf(this.keystoresPassword);
    }

    @Override
    public String getSuperTruststoreLocation() {
        return this.superuserMaterial.getTrustStoreLocation().toString();
    }

    @Override
    public String getSuperTruststorePass() {
        return String.valueOf(this.keystoresPassword);
    }

    @Override
    public String getSuperMaterialPasswordFile() {
        return this.superuserMaterial.getPasswdLocation().toString();
    }

    @Override
    protected void serviceStop() throws Exception {
        if (this.mbeanObjectName != null) {
            MBeans.unregister(this.mbeanObjectName);
        }
        if (this.localizationEventsHandler != null) {
            this.localizationEventsHandler.interrupt();
        }
        if (null != this.materializeDir) {
            FileUtils.deleteQuietly((File)this.materializeDir.toFile());
        }
        for (int i = 0; i < this.keystoresPassword.length; ++i) {
            this.keystoresPassword[i] = 120;
        }
        this.LOG.debug((Object)"Stopped CertificateLocalization service");
        super.serviceStop();
    }

    @VisibleForTesting
    public Path getMaterializeDirectory() {
        return this.materializeDir;
    }

    @Override
    public void materializeCertificates(String username, String user, ByteBuffer keyStore, String keyStorePassword, ByteBuffer trustStore, String trustStorePassword) throws InterruptedException {
        this.materializeCertificates(username, null, user, keyStore, keyStorePassword, trustStore, trustStorePassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void materializeCertificates(String username, String applicationId, String user, ByteBuffer keyStore, String keyStorePassword, ByteBuffer trustStore, String trustStorePassword) throws InterruptedException {
        StorageKey key = StorageKey.newX509Instance(username, applicationId);
        try {
            this.lock.lock();
            SecurityMaterial material = this.materialLocation.get(key);
            if (material != null) {
                material.incrementRequestedApplications();
                this.LOG.debug((Object)("Incrementing requested application to " + material.getRequestedApplications() + " for key " + key));
            } else {
                Path appDirPath = applicationId != null ? Paths.get(this.materializeDir.toString(), user, applicationId) : Paths.get(this.materializeDir.toString(), user);
                Path keyStorePath = Paths.get(appDirPath.toFile().getAbsolutePath(), username + "__kstore.jks");
                Path trustStorePath = Paths.get(appDirPath.toFile().getAbsolutePath(), username + "__tstore.jks");
                Path passwdPath = Paths.get(appDirPath.toFile().getAbsolutePath(), username + "__cert.key");
                X509SecurityMaterial cryptoMaterial = new X509SecurityMaterial(appDirPath, keyStorePath, trustStorePath, passwdPath, keyStore, keyStorePassword, trustStore, trustStorePassword);
                this.materialLocation.put(key, cryptoMaterial);
                MaterializeEvent event = new MaterializeEvent(key, cryptoMaterial);
                this.dispatchEvent(event);
                this.LOG.debug((Object)("Dispatch materialize event for key " + key));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecurityMaterial prepareMaterialForChange(StorageKey key) throws MaterialNotFoundException, InterruptedException {
        try {
            this.lock.lock();
            SecurityMaterial material = this.materialLocation.get(key);
            if (material == null) {
                throw new MaterialNotFoundException("Material for key " + key + " is missing");
            }
            SecurityMaterial securityMaterial = material;
            synchronized (securityMaterial) {
                while (!material.getState().equals((Object)SecurityMaterial.STATE.FINISHED)) {
                    material.wait();
                }
                material.changeState(SecurityMaterial.STATE.ONGOING);
            }
            securityMaterial = material;
            return securityMaterial;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void updateX509(String username, String applicationId, ByteBuffer keyStore, String keyStorePassword, ByteBuffer trustStore, String trustStorePassword) throws InterruptedException {
        StorageKey key = StorageKey.newX509Instance(username, applicationId);
        try {
            X509SecurityMaterial x509Material = (X509SecurityMaterial)this.prepareMaterialForChange(key);
            x509Material.updateKeyStoreMem(keyStore);
            x509Material.updateKeyStorePass(keyStorePassword);
            x509Material.updateTrustStoreMem(trustStore);
            x509Material.updateTrustStorePass(trustStorePassword);
            UpdateEvent updateEvent = new UpdateEvent(key, x509Material);
            this.dispatchEvent(updateEvent);
            this.LOG.debug((Object)("Dispatched update event for key " + key));
        }
        catch (MaterialNotFoundException ex) {
            this.LOG.warn((Object)"Requested X.509 update but got an exception", (Throwable)ex);
        }
    }

    @Override
    public void updateJWT(String username, String applicationId, String jwt) throws InterruptedException {
        StorageKey key = StorageKey.newJWTInstance(username, applicationId);
        try {
            JWTSecurityMaterial jwtMaterial = (JWTSecurityMaterial)this.prepareMaterialForChange(key);
            jwtMaterial.updateToken(jwt);
            UpdateEvent updateEvent = new UpdateEvent(key, jwtMaterial);
            this.dispatchEvent(updateEvent);
            this.LOG.debug((Object)("Dispatched JWT update event for key " + key));
        }
        catch (MaterialNotFoundException ex) {
            this.LOG.warn((Object)"Requested JWT update but got an exception", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    @VisibleForTesting
    protected void updateInternal(UpdateEvent event) {
        String errorMsg = "";
        try {
            SecurityMaterial storedMaterial = this.materialLocation.get(event.key);
            if (storedMaterial == null) {
                this.LOG.warn((Object)("Requested X.509 update for key " + event.key + " but material is missing or has been removed"));
                return;
            }
            if (event.cryptoMaterial instanceof X509SecurityMaterial) {
                errorMsg = "Could not update X.509 security material for key " + event.key;
                this.updateInternalX509((X509SecurityMaterial)event.cryptoMaterial);
            } else if (event.cryptoMaterial instanceof JWTSecurityMaterial) {
                errorMsg = "Could not update JWT security material for key " + event.key;
                this.updateInternalJWT((JWTSecurityMaterial)event.cryptoMaterial);
            } else {
                errorMsg = "Unknown security material type " + event.cryptoMaterial.getClass().getCanonicalName();
            }
        }
        catch (IOException ex) {
            this.LOG.error((Object)("Error updating security material: " + errorMsg), (Throwable)ex);
        }
        finally {
            if (event.cryptoMaterial != null) {
                SecurityMaterial securityMaterial = event.cryptoMaterial;
                synchronized (securityMaterial) {
                    event.cryptoMaterial.changeState(SecurityMaterial.STATE.FINISHED);
                    event.cryptoMaterial.notifyAll();
                }
            }
        }
    }

    private void updateInternalX509(X509SecurityMaterial securityMaterial) throws IOException {
        this.writeX509ToLocalFS(securityMaterial.getKeyStoreMem(), securityMaterial.getKeyStoreLocation().toFile(), securityMaterial.getTrustStoreMem(), securityMaterial.getTrustStoreLocation().toFile(), securityMaterial.getKeyStorePass(), securityMaterial.getPasswdLocation().toFile());
    }

    private void updateInternalJWT(JWTSecurityMaterial securityMaterial) throws IOException {
        FileUtils.writeStringToFile((File)securityMaterial.getTokenLocation().toFile(), (String)securityMaterial.getToken());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void materializeJWT(String username, String applicationId, String userFolder, String jwt) throws InterruptedException {
        StorageKey key = StorageKey.newJWTInstance(username, applicationId);
        try {
            this.lock.lock();
            SecurityMaterial material = this.materialLocation.get(key);
            if (material != null) {
                material.incrementRequestedApplications();
                this.LOG.debug((Object)("Incrementing requested application to " + material.getRequestedApplications() + " for key " + key));
            } else {
                Path appDirPath = applicationId != null ? Paths.get(this.materializeDir.toString(), userFolder, applicationId) : Paths.get(this.materializeDir.toString(), userFolder);
                Path jwtPath = Paths.get(appDirPath.toFile().getAbsolutePath(), username + "_token.jwt");
                material = new JWTSecurityMaterial(appDirPath, jwtPath, jwt);
                this.materialLocation.put(key, material);
                MaterializeEvent event = new MaterializeEvent(key, material);
                this.dispatchEvent(event);
                this.LOG.debug((Object)("Dispatch materialize event for key " + key));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void writeX509ToLocalFS(ByteBuffer keyStore, File keyStoreLocation, ByteBuffer trustStore, File trustStoreLocation, String password, File passwordFileLocation) throws IOException {
        FileChannel keyStoreChannel = new FileOutputStream(keyStoreLocation, false).getChannel();
        keyStoreChannel.write(keyStore);
        keyStoreChannel.close();
        FileChannel trustStoreChannel = new FileOutputStream(trustStoreLocation, false).getChannel();
        trustStoreChannel.write(trustStore);
        trustStoreChannel.close();
        FileUtils.writeStringToFile((File)passwordFileLocation, (String)password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    @VisibleForTesting
    protected boolean materializeInternal(MaterializeEvent event) {
        SecurityMaterial securityMaterial = event.cryptoMaterial;
        synchronized (securityMaterial) {
            if (event.cryptoMaterial.hasBeenCanceled()) {
                this.LOG.debug((Object)("Tried to materialize " + event.key + " but it has already been canceled, ignoring..."));
                event.cryptoMaterial.changeState(SecurityMaterial.STATE.FINISHED);
                event.cryptoMaterial.notifyAll();
                return false;
            }
            event.cryptoMaterial.changeState(SecurityMaterial.STATE.ONGOING);
        }
        this.LOG.debug((Object)("Materializing internal for " + event.key));
        File appDirFile = event.cryptoMaterial.getCertFolder().toFile();
        if (!appDirFile.exists()) {
            appDirFile.mkdirs();
        }
        try {
            if (event.cryptoMaterial instanceof X509SecurityMaterial) {
                this.materializeInternalX509((X509SecurityMaterial)event.cryptoMaterial);
            } else if (event.cryptoMaterial instanceof JWTSecurityMaterial) {
                this.materializeInternalJWT((JWTSecurityMaterial)event.cryptoMaterial);
            }
            SecurityMaterial securityMaterial2 = event.cryptoMaterial;
            synchronized (securityMaterial2) {
                event.cryptoMaterial.changeState(SecurityMaterial.STATE.FINISHED);
                event.cryptoMaterial.notifyAll();
            }
            this.LOG.debug((Object)("Finished materialization for " + event.key));
            return true;
        }
        catch (IOException ex) {
            this.LOG.error((Object)ex, (Throwable)ex);
            try {
                this.lock.lock();
                this.materialLocation.remove(event.key);
                FileUtils.deleteQuietly((File)event.cryptoMaterial.getCertFolder().toFile());
                SecurityMaterial securityMaterial3 = event.cryptoMaterial;
                synchronized (securityMaterial3) {
                    event.cryptoMaterial.changeState(SecurityMaterial.STATE.FINISHED);
                    event.cryptoMaterial.notifyAll();
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private void materializeInternalX509(X509SecurityMaterial material) throws IOException {
        this.writeX509ToLocalFS(material.getKeyStoreMem(), material.getKeyStoreLocation().toFile(), material.getTrustStoreMem(), material.getTrustStoreLocation().toFile(), material.getKeyStorePass(), material.getPasswdLocation().toFile());
        if (this.service == ServiceType.NM) {
            EnumSet<PosixFilePermission> materialPermissions = EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_EXECUTE);
            Files.setPosixFilePermissions(material.getCertFolder(), materialPermissions);
            Files.setPosixFilePermissions(material.getKeyStoreLocation(), materialPermissions);
            Files.setPosixFilePermissions(material.getTrustStoreLocation(), materialPermissions);
            Files.setPosixFilePermissions(material.getPasswdLocation(), materialPermissions);
        }
    }

    private void materializeInternalJWT(JWTSecurityMaterial material) throws IOException {
        FileUtils.writeStringToFile((File)material.getTokenLocation().toFile(), (String)material.getToken());
        if (this.service == ServiceType.NM) {
            EnumSet<PosixFilePermission> materialPermissions = EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_EXECUTE);
            Files.setPosixFilePermissions(material.getCertFolder(), materialPermissions);
            Files.setPosixFilePermissions(material.getTokenLocation(), materialPermissions);
        }
    }

    private void dispatchEvent(LocalizationEvent event) throws InterruptedException {
        this.localizationEventsQ.put(event);
    }

    @Override
    public void removeX509Material(String username) throws InterruptedException {
        this.removeX509Material(username, null);
    }

    @Override
    public void removeX509Material(String username, String applicationId) throws InterruptedException {
        StorageKey key = StorageKey.newX509Instance(username, applicationId);
        this.checkAndRemoveAsync(key);
    }

    @Override
    public void removeJWTMaterial(String username, String applicationId) throws InterruptedException {
        StorageKey key = StorageKey.newJWTInstance(username, applicationId);
        this.checkAndRemoveAsync(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndRemoveAsync(StorageKey key) throws InterruptedException {
        try {
            this.lock.lock();
            SecurityMaterial material = this.materialLocation.get(key);
            if (material != null) {
                material.decrementRequestedApplications();
                this.LOG.debug((Object)("Decrementing requested applications to " + material.getRequestedApplications() + " for key " + key));
                if (material.isSafeToRemove()) {
                    material.changeState(SecurityMaterial.STATE.ONGOING);
                    RemoveEvent event = new RemoveEvent(material);
                    this.materialLocation.remove(key);
                    this.dispatchEvent(event);
                    this.LOG.debug((Object)("Dispatching remove event for key " + key));
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected void removeInternal(RemoveEvent event) {
        if (event.cryptoMaterial instanceof X509SecurityMaterial) {
            this.removeInternalX509((X509SecurityMaterial)event.cryptoMaterial);
        } else if (event.cryptoMaterial instanceof JWTSecurityMaterial) {
            this.removeInternalJWT((JWTSecurityMaterial)event.cryptoMaterial);
        }
    }

    private void removeInternalX509(X509SecurityMaterial material) {
        FileUtils.deleteQuietly((File)material.getKeyStoreLocation().toFile());
        this.LOG.debug((Object)("Deleted " + material.getKeyStoreLocation()));
        FileUtils.deleteQuietly((File)material.getTrustStoreLocation().toFile());
        this.LOG.debug((Object)("Deleted " + material.getTrustStoreLocation()));
        FileUtils.deleteQuietly((File)material.getPasswdLocation().toFile());
        this.LOG.debug((Object)("Deleted " + material.getPasswdLocation()));
        this.deleteAppDirectoryIfEmpty(material.getCertFolder().toFile());
    }

    private void removeInternalJWT(JWTSecurityMaterial material) {
        FileUtils.deleteQuietly((File)material.getTokenLocation().toFile());
        this.LOG.debug((Object)("Deleted " + material.getTokenLocation()));
        this.deleteAppDirectoryIfEmpty(material.getCertFolder().toFile());
    }

    private void deleteAppDirectoryIfEmpty(File appDirectory) {
        String[] content = appDirectory.list();
        if (content != null && content.length == 0) {
            FileUtils.deleteQuietly((File)appDirectory);
            this.LOG.debug((Object)("Deleted app directory " + appDirectory));
        }
    }

    @Override
    public X509SecurityMaterial getX509MaterialLocation(String username) throws FileNotFoundException, InterruptedException {
        return this.getX509MaterialLocation(username, null);
    }

    @Override
    public X509SecurityMaterial getX509MaterialLocation(String username, String applicationId) throws FileNotFoundException, InterruptedException {
        StorageKey key = StorageKey.newX509Instance(username, applicationId);
        return (X509SecurityMaterial)this.getSecurityMaterialInternal(key);
    }

    @Override
    public JWTSecurityMaterial getJWTMaterialLocation(String username, String applicationId) throws FileNotFoundException, InterruptedException {
        StorageKey key = StorageKey.newJWTInstance(username, applicationId);
        return (JWTSecurityMaterial)this.getSecurityMaterialInternal(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecurityMaterial getSecurityMaterialInternal(StorageKey key) throws FileNotFoundException, InterruptedException {
        SecurityMaterial material = this.materialLocation.get(key);
        this.LOG.debug((Object)("Trying to get material for key " + key));
        if (material == null) {
            throw new FileNotFoundException("Materialized crypto material could not be found for user " + key);
        }
        SecurityMaterial securityMaterial = material;
        synchronized (securityMaterial) {
            while (!material.getState().equals((Object)SecurityMaterial.STATE.FINISHED)) {
                this.LOG.debug((Object)("Waiting to get notified for key " + key));
                material.wait();
            }
            this.LOG.debug((Object)("Notified for key " + key));
            material = this.materialLocation.get(key);
            if (material == null) {
                throw new FileNotFoundException("Materializer could not materialize certificate for " + key);
            }
            return material;
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected LocalizationEvent dequeue() throws InterruptedException {
        return this.localizationEventsQ.take();
    }

    @Override
    public String getState() {
        ImmutableMap state;
        try {
            this.lock.lock();
            state = ImmutableMap.copyOf(this.materialLocation);
        }
        finally {
            this.lock.unlock();
        }
        ReturnState returnState = new ReturnState();
        ReturnState internalState = new ReturnState();
        for (Map.Entry entry : state.entrySet()) {
            internalState.put(((StorageKey)entry.getKey()).compactToString(), ((SecurityMaterial)entry.getValue()).getRequestedApplications());
        }
        returnState.put(JMX_MATERIALIZED_KEY, JSON.toString(internalState));
        return JSON.toString(returnState);
    }

    @Override
    public boolean forceRemoveMaterial(String username) throws InterruptedException, ExecutionException {
        return this.forceRemoveMaterial(username, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean forceRemoveMaterial(String username, String applicationId) throws InterruptedException, ExecutionException {
        StorageKey key = StorageKey.newX509Instance(username, applicationId);
        SecurityMaterial material = this.materialLocation.remove(key);
        if (material != null) {
            boolean managedToCancel;
            SecurityMaterial securityMaterial = material;
            synchronized (securityMaterial) {
                managedToCancel = material.tryToCancel();
            }
            if (managedToCancel) {
                FileUtils.deleteQuietly((File)material.getCertFolder().toFile());
            } else {
                securityMaterial = material;
                synchronized (securityMaterial) {
                    while (!material.getState().equals((Object)SecurityMaterial.STATE.FINISHED)) {
                        material.wait();
                    }
                    FileUtils.deleteQuietly((File)material.getCertFolder().toFile());
                }
            }
            return true;
        }
        return false;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected Thread createLocalizationEventsHandler() {
        return new LocalizationEventsHandler();
    }

    private class MaterialNotFoundException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public MaterialNotFoundException(String reason) {
            super(reason);
        }

        public MaterialNotFoundException(String reason, Throwable throwable) {
            super(reason, throwable);
        }

        public MaterialNotFoundException(Throwable throwable) {
            super(throwable);
        }
    }

    private class LocalizationEventsHandler
    extends Thread {
        private LocalizationEventsHandler() {
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    LocalizationEvent event = (LocalizationEvent)CertificateLocalizationService.this.localizationEventsQ.take();
                    if (event instanceof MaterializeEvent) {
                        CertificateLocalizationService.this.materializeInternal((MaterializeEvent)event);
                        continue;
                    }
                    if (event instanceof RemoveEvent) {
                        CertificateLocalizationService.this.removeInternal((RemoveEvent)event);
                        continue;
                    }
                    if (event instanceof UpdateEvent) {
                        CertificateLocalizationService.this.updateInternal((UpdateEvent)event);
                        continue;
                    }
                    CertificateLocalizationService.this.LOG.warn((Object)"Unknown event type");
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
            CertificateLocalizationService.this.LOG.info((Object)"Stopping localization events handler thread");
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected class RemoveEvent
    implements LocalizationEvent {
        private final SecurityMaterial cryptoMaterial;

        private RemoveEvent(SecurityMaterial cryptoMaterial) {
            this.cryptoMaterial = cryptoMaterial;
        }
    }

    protected class UpdateEvent
    implements LocalizationEvent {
        private final StorageKey key;
        private final SecurityMaterial cryptoMaterial;

        private UpdateEvent(StorageKey key, SecurityMaterial cryptoMaterial) {
            this.key = key;
            this.cryptoMaterial = cryptoMaterial;
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected class MaterializeEvent
    implements LocalizationEvent {
        private final StorageKey key;
        private final SecurityMaterial cryptoMaterial;

        private MaterializeEvent(StorageKey key, SecurityMaterial cryptoMaterial) {
            this.key = key;
            this.cryptoMaterial = cryptoMaterial;
        }
    }

    private static class StorageKey {
        private final String username;
        private final String applicationId;
        private final STORAGE_KEY_TYPE type;

        private static StorageKey newX509Instance(String username, String applicationId) {
            return new StorageKey(username, applicationId, STORAGE_KEY_TYPE.X509);
        }

        private static StorageKey newJWTInstance(String username, String applicationId) {
            return new StorageKey(username, applicationId, STORAGE_KEY_TYPE.JWT);
        }

        public StorageKey(String username, String applicationId, STORAGE_KEY_TYPE type) {
            this.username = username;
            this.applicationId = applicationId;
            this.type = type;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof StorageKey)) {
                return false;
            }
            if (this.applicationId != null) {
                return this.username.equals(((StorageKey)other).username) && this.applicationId.equals(((StorageKey)other).applicationId) && this.type.equals((Object)((StorageKey)other).type);
            }
            return this.username.equals(((StorageKey)other).username);
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.username.hashCode();
            if (this.applicationId != null) {
                result = 31 * result + this.applicationId.hashCode();
            }
            result = 31 * result + this.type.ordinal();
            return result;
        }

        public String toString() {
            String appId = this.applicationId != null ? this.applicationId : "unknown";
            return "CryptoKey <" + this.username + ", " + appId + ", " + (Object)((Object)this.type) + ">";
        }

        public String compactToString() {
            String appId = this.applicationId != null ? this.applicationId : "unknown";
            return this.username + "/" + appId + "/" + (Object)((Object)this.type);
        }
    }

    static enum STORAGE_KEY_TYPE {
        X509,
        JWT;

    }

    private class ReturnState<S, T>
    extends HashMap<S, T> {
        private static final long serialVersionUID = 1L;

        private ReturnState() {
        }
    }

    public static enum ServiceType {
        RM("RM"),
        NM("NM"),
        HS2("HS2"),
        HM("HM"),
        LLAP("LLAP"),
        DN("DN"),
        LIVY("LIVY");

        private final String service;

        private ServiceType(String service) {
            this.service = service;
        }

        public String toString() {
            return this.service;
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected static interface LocalizationEvent {
    }
}

