/*
 * Decompiled with CFR 0.152.
 */
package io.hops.security;

import io.hops.security.HopsX509AuthenticationException;
import io.hops.security.HopsX509Authenticator;
import io.hops.security.HopsX509AuthenticatorFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;

public class TestHopsX509Authenticator {
    private Configuration conf;
    private HopsX509AuthenticatorFactory authFactory;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void before() {
        this.conf = new Configuration();
        this.conf.setBoolean("ipc.server.ssl.enabled", true);
        this.authFactory = HopsX509AuthenticatorFactory.getInstance((Configuration)this.conf);
    }

    @After
    public void after() {
        if (this.authFactory != null) {
            this.authFactory.clearFactory();
        }
    }

    @Test
    public void TestAuthenticatedNormalUser() throws Exception {
        String o = "application_id";
        X509Certificate clientCertificate = this.generateX509Certificate("CN=bob, O=" + o);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"bob");
        InetAddress remoteAddress = InetAddress.getLocalHost();
        HopsX509Authenticator authenticator = this.authFactory.getAuthenticator();
        authenticator.authenticateConnection(ugi, clientCertificate, remoteAddress);
        Assert.assertEquals((Object)o, (Object)ugi.getApplicationId());
    }

    @Test
    public void TestAuthenticatedNormalUserWebHDFS() throws Exception {
        String o = "application_id";
        X509Certificate clientCertificate = this.generateX509Certificate("CN=bob, O=" + o);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"bob");
        InetAddress remoteAddress = InetAddress.getLocalHost();
        HopsX509Authenticator authenticator = this.authFactory.getAuthenticator();
        authenticator.authenticateConnection(ugi, clientCertificate, remoteAddress, "WebHDFS");
        Assert.assertNull((Object)ugi.getApplicationId());
    }

    @Test
    public void TestNotAuthenticatedNormalUser() throws Exception {
        X509Certificate clientCertificate = this.generateX509Certificate("CN=bob");
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"trudy");
        InetAddress remoteAddress = InetAddress.getLocalHost();
        HopsX509Authenticator authenticator = this.authFactory.getAuthenticator();
        this.expectedException.expect(HopsX509AuthenticationException.class);
        authenticator.authenticateConnection(ugi, clientCertificate, remoteAddress);
    }

    @Test
    public void TestAuthenticatedSuperUser() throws Exception {
        InetAddress remoteAddress = InetAddress.getLocalHost();
        String o = "application_id";
        X509Certificate clientCertificate = this.generateX509Certificate("CN=" + remoteAddress.getCanonicalHostName() + ", O=" + o + ", L=alice");
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"alice");
        HopsX509Authenticator authenticator = this.authFactory.getAuthenticator();
        authenticator.authenticateConnection(ugi, clientCertificate, remoteAddress);
        Assert.assertEquals((Object)o, (Object)ugi.getApplicationId());
    }

    @Test
    public void TestNotAuthenticatedSuperUser() throws Exception {
        InetAddress remoteAddress = InetAddress.getLocalHost();
        X509Certificate clientCertificate = this.generateX509Certificate("CN=i_hope_this_is_not_routable,L=real_super");
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"chuck");
        HopsX509Authenticator authenticator = this.authFactory.getAuthenticator();
        this.expectedException.expect(HopsX509AuthenticationException.class);
        authenticator.authenticateConnection(ugi, clientCertificate, remoteAddress);
    }

    @Test
    public void TestNotAuthenticatedSuperUserWithResolvableCN() throws Exception {
        InetAddress remoteAddress = InetAddress.getLocalHost();
        X509Certificate clientCertificate = this.generateX509Certificate("CN=" + remoteAddress.getCanonicalHostName() + ", L=real_super");
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"chuck");
        HopsX509Authenticator authenticator = this.authFactory.getAuthenticator();
        this.expectedException.expect(HopsX509AuthenticationException.class);
        authenticator.authenticateConnection(ugi, clientCertificate, remoteAddress);
    }

    @Test
    public void TestFQDNCache() throws Exception {
        InetAddress remoteAddress = InetAddress.getLocalHost();
        X509Certificate clientCertificate = this.generateX509Certificate("CN=" + remoteAddress.getCanonicalHostName() + ",L=alice");
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"alice");
        CustomHopsX509Authenticator authenticator = new CustomHopsX509Authenticator(this.conf);
        authenticator.authenticateConnection(ugi, clientCertificate, remoteAddress);
        Assert.assertFalse((boolean)authenticator.iscached);
        authenticator.authenticateConnection(ugi, clientCertificate, remoteAddress);
        Assert.assertTrue((boolean)authenticator.iscached);
    }

    @Test
    public void TestMultipleResolvedAddresses() throws UnknownHostException, HopsX509AuthenticationException {
        HopsX509Authenticator realAuth = new HopsX509Authenticator(this.conf);
        HopsX509Authenticator auth = (HopsX509Authenticator)Mockito.spy((Object)realAuth);
        String cn = "example.hopsworks.ai";
        HashSet<InetAddress> mockAddresses = new HashSet<InetAddress>();
        byte[] ipAddr1 = new byte[]{10, 0, 1, 1};
        InetAddress addr1 = InetAddress.getByAddress(ipAddr1);
        mockAddresses.add(addr1);
        byte[] ipAddr2 = new byte[]{10, 0, 1, 2};
        InetAddress addr2 = InetAddress.getByAddress(ipAddr2);
        mockAddresses.add(addr2);
        byte[] ipAddr3 = new byte[]{10, 0, 1, 3};
        InetAddress addr3 = InetAddress.getByAddress(ipAddr3);
        mockAddresses.add(addr3);
        ((HopsX509Authenticator)Mockito.doReturn(mockAddresses).when((Object)auth)).getAllInetAddressesAsSet(Mockito.matches((String)cn));
        boolean authResult = auth.isTrustedConnection(addr2, cn, "alice", "alice");
        Assert.assertTrue((boolean)authResult);
        byte[] wrongIpAddr = new byte[]{10, 0, 2, 1};
        InetAddress wrongAddr = InetAddress.getByAddress(wrongIpAddr);
        authResult = auth.isTrustedConnection(wrongAddr, cn, "alice", "alice");
        Assert.assertFalse((boolean)authResult);
    }

    @Test
    public void TestSimpleAuthentication() throws UnknownHostException, HopsX509AuthenticationException {
        Configuration conf = new Configuration(true);
        conf.set("hops.tls.rpc-acl-auth-mode", "SIMPLE");
        HopsX509Authenticator realAuth = new HopsX509Authenticator(conf);
        HopsX509Authenticator auth = (HopsX509Authenticator)Mockito.spy((Object)realAuth);
        String cn = "example.hopsworks.ai";
        String unresolvableDomainName = "unresolvable.domain.name";
        HashSet<InetAddress> mockAddresses = new HashSet<InetAddress>();
        byte[] ipAddr1 = new byte[]{10, 0, 1, 1};
        InetAddress addr1 = InetAddress.getByAddress(ipAddr1);
        mockAddresses.add(addr1);
        ((HopsX509Authenticator)Mockito.doReturn(mockAddresses).when((Object)auth)).getAllInetAddressesAsSet(Mockito.matches((String)cn));
        ((HopsX509Authenticator)Mockito.doThrow((Throwable)new UnknownHostException(cn)).when((Object)auth)).getAllInetAddressesAsSet(unresolvableDomainName);
        byte[] clientIP = new byte[]{10, 1, 0, 1};
        boolean authResult = auth.isTrustedConnection(InetAddress.getByAddress(clientIP), cn, "alice", "alice");
        Assert.assertTrue((boolean)authResult);
        this.expectedException.expect(HopsX509AuthenticationException.class);
        auth.isTrustedConnection(InetAddress.getByAddress(clientIP), unresolvableDomainName, "alice", "alice");
    }

    private X509Certificate generateX509Certificate(String subjectDN) throws Exception {
        KeyPair keyPair = KeyStoreTestUtil.generateKeyPair("RSA");
        return KeyStoreTestUtil.generateCertificate(subjectDN, keyPair, 30, "SHA1withRSA");
    }

    private class CustomHopsX509Authenticator
    extends HopsX509Authenticator {
        private boolean iscached;

        CustomHopsX509Authenticator(Configuration conf) {
            super(conf);
            this.iscached = false;
        }

        protected Set<InetAddress> isTrustedFQDN(String fqdn) {
            Set addresses = super.isTrustedFQDN(fqdn);
            this.iscached = addresses != null;
            return addresses;
        }
    }
}

