/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.ssl;

import io.hops.security.HopsFileBasedKeyStoresFactory;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.TestRpcBase;
import org.apache.hadoop.ipc.protobuf.TestProtos;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.util.envVars.EnvironmentVariables;

class RpcTLSUtils {
    RpcTLSUtils() {
    }

    protected static TestProtos.EchoResponseProto makeEchoRequest(UserGroupInformation ugi, InetSocketAddress serverAddress, Configuration conf, String message) throws Exception {
        return (TestProtos.EchoResponseProto)ugi.doAs((PrivilegedExceptionAction)new ParameterizedPrivilegedExceptionAction<TestProtos.EchoResponseProto>(serverAddress, conf, message){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public TestProtos.EchoResponseProto run() throws Exception {
                TestRpcBase.TestRpcService proxy = TestRpcBase.getClient(this.serverAddress, this.conf);
                try {
                    TestProtos.EchoResponseProto response;
                    TestProtos.EchoRequestProto request = TestProtos.EchoRequestProto.newBuilder().setMessage(this.message).build();
                    TestProtos.EchoResponseProto echoResponseProto = response = proxy.echo(null, request);
                    return echoResponseProto;
                }
                finally {
                    if (proxy != null) {
                        RPC.stopProxy((Object)proxy);
                    }
                }
            }
        });
    }

    public static TestCryptoMaterial setupTLSMaterial(Configuration conf, TLSSetup tlsSetup, Class callingClass) throws GeneralSecurityException, IOException {
        KeyPair serverKeyPair = KeyStoreTestUtil.generateKeyPair(tlsSetup.keyAlgorithm);
        X509Certificate serverCert = KeyStoreTestUtil.generateCertificate("CN=Server", serverKeyPair, 60, tlsSetup.signatureAlgorithm);
        KeyStoreTestUtil.createKeyStore(tlsSetup.serverKstore.toString(), tlsSetup.serverStorePassword, "server", serverKeyPair.getPrivate(), serverCert);
        KeyStoreTestUtil.createTrustStore(tlsSetup.serverTstore.toString(), tlsSetup.serverStorePassword, "server", serverCert);
        FileUtils.writeStringToFile((File)tlsSetup.serverStorePasswordLocation.toFile(), (String)tlsSetup.serverStorePassword);
        KeyPair clientKeyPair = KeyStoreTestUtil.generateKeyPair(tlsSetup.keyAlgorithm);
        X509Certificate clientCert = KeyStoreTestUtil.generateSignedCertificate("CN=" + tlsSetup.clientUserName, clientKeyPair, 30, tlsSetup.signatureAlgorithm, serverKeyPair.getPrivate(), serverCert);
        KeyStoreTestUtil.createKeyStore(tlsSetup.clientKstore.toString(), tlsSetup.clientStorePassword, "client", clientKeyPair.getPrivate(), clientCert);
        HashMap<String, X509Certificate> clientTrustedCerts = new HashMap<String, X509Certificate>(2);
        clientTrustedCerts.put("client", clientCert);
        clientTrustedCerts.put("server", serverCert);
        KeyStoreTestUtil.createTrustStore(tlsSetup.clientTstore.toString(), tlsSetup.clientStorePassword, clientTrustedCerts);
        FileUtils.writeStringToFile((File)tlsSetup.clientPasswordLocation.toFile(), (String)tlsSetup.clientStorePassword);
        conf.set("hadoop.rpc.socket.factory.class.default", "org.apache.hadoop.net.HopsSSLSocketFactory");
        conf.setBoolean("ipc.server.ssl.enabled", true);
        conf.set("hadoop.ssl.hostname.verifier", "ALLOW_ALL");
        String superUser = UserGroupInformation.getCurrentUser().getUserName();
        conf.set("hadoop.proxyuser." + superUser, "*");
        conf.set("hadoop.ssl.keystores.factory.class", HopsFileBasedKeyStoresFactory.class.getCanonicalName());
        conf.set("hops.tls.superuser-material-directory", tlsSetup.serverKstore.getParent().toString());
        return new TestCryptoMaterial(serverKeyPair, serverCert, clientKeyPair, clientCert);
    }

    protected static class MockEnvironmentVariables
    implements EnvironmentVariables {
        private final Map<String, String> envs = new HashMap<String, String>();

        protected MockEnvironmentVariables() {
        }

        protected void setEnv(String name, String value) {
            this.envs.put(name, value);
        }

        public String getEnv(String variableName) {
            return this.envs.get(variableName);
        }
    }

    static class TestCryptoMaterial {
        private final KeyPair serverKeyPair;
        private final X509Certificate serverCertificate;
        private final KeyPair clientKeyPair;
        private final X509Certificate clientCertificate;

        public TestCryptoMaterial(KeyPair serverKeyPair, X509Certificate serverCertificate, KeyPair clientKeyPair, X509Certificate clientCertificate) {
            this.serverKeyPair = serverKeyPair;
            this.serverCertificate = serverCertificate;
            this.clientKeyPair = clientKeyPair;
            this.clientCertificate = clientCertificate;
        }

        public KeyPair getServerKeyPair() {
            return this.serverKeyPair;
        }

        public X509Certificate getServerCertificate() {
            return this.serverCertificate;
        }

        public KeyPair getClientKeyPair() {
            return this.clientKeyPair;
        }

        public X509Certificate getClientCertificate() {
            return this.clientCertificate;
        }
    }

    private static abstract class ParameterizedPrivilegedExceptionAction<T>
    implements PrivilegedExceptionAction<T> {
        public final InetSocketAddress serverAddress;
        public final Configuration conf;
        public final String message;

        private ParameterizedPrivilegedExceptionAction(InetSocketAddress serverAddress, Configuration conf, String message) {
            this.serverAddress = serverAddress;
            this.conf = conf;
            this.message = message;
        }
    }

    public static class TLSSetup {
        private final String keyAlgorithm;
        private final String signatureAlgorithm;
        private final Path serverKstore;
        private final Path serverTstore;
        private final Path serverStorePasswordLocation;
        private final String serverStorePassword;
        private final Path clientKstore;
        private final Path clientTstore;
        private final Path clientPasswordLocation;
        private final String clientStorePassword;
        private final String clientUserName;

        private TLSSetup(Builder builder) {
            this.serverKstore = builder.serverKstore;
            this.serverTstore = builder.serverTstore;
            this.serverStorePassword = builder.serverStorePassword;
            this.serverStorePasswordLocation = builder.serverStorePasswordLocation;
            this.clientKstore = builder.clientKstore;
            this.clientTstore = builder.clientTstore;
            this.clientPasswordLocation = builder.clientPasswordLocation;
            this.clientStorePassword = builder.clientStorePassword;
            this.clientUserName = builder.clientUserName;
            this.keyAlgorithm = builder.keyAlgorithm;
            this.signatureAlgorithm = builder.signatureAlgorithm;
        }

        public Path getServerKstore() {
            return this.serverKstore;
        }

        public Path getServerTstore() {
            return this.serverTstore;
        }

        public Path getClientKstore() {
            return this.clientKstore;
        }

        public Path getClientTstore() {
            return this.clientTstore;
        }

        public String getClientUserName() {
            return this.clientUserName;
        }

        public static class Builder {
            private String keyAlgorithm;
            private String signatureAlgorithm;
            private Path serverKstore;
            private Path serverTstore;
            private Path serverStorePasswordLocation;
            private String serverStorePassword;
            private Path clientKstore;
            private Path clientTstore;
            private Path clientPasswordLocation;
            private String clientStorePassword;
            private String clientUserName;

            public Builder setKeyAlgorithm(String keyAlgorithm) {
                this.keyAlgorithm = keyAlgorithm;
                return this;
            }

            public Builder setSignatureAlgorithm(String signatureAlgorithm) {
                this.signatureAlgorithm = signatureAlgorithm;
                return this;
            }

            public Builder setServerKstore(Path serverKstore) {
                this.serverKstore = serverKstore;
                return this;
            }

            public Builder setServerTstore(Path serverTstore) {
                this.serverTstore = serverTstore;
                return this;
            }

            public Builder setServerStorePasswordLocation(Path serverStorePasswordLocation) {
                this.serverStorePasswordLocation = serverStorePasswordLocation;
                return this;
            }

            public Builder setClientKstore(Path clientKstore) {
                this.clientKstore = clientKstore;
                return this;
            }

            public Builder setClientTstore(Path clientTstore) {
                this.clientTstore = clientTstore;
                return this;
            }

            public Builder setClientUserName(String clientUserName) {
                this.clientUserName = clientUserName;
                return this;
            }

            public Builder setServerStorePassword(String serverStorePassword) {
                this.serverStorePassword = serverStorePassword;
                return this;
            }

            public Builder setClientPasswordLocation(Path clientPasswordLocation) {
                this.clientPasswordLocation = clientPasswordLocation;
                return this;
            }

            public Builder setClientStorePassword(String clientStorePassword) {
                this.clientStorePassword = clientStorePassword;
                return this;
            }

            public TLSSetup build() {
                return new TLSSetup(this);
            }
        }
    }
}

