/*
 * Decompiled with CFR 0.152.
 */
package io.hops.leader_election.watchdog;

import io.hops.leader_election.watchdog.JsonPoller;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.Test;

public class TestJsonPoller {
    @Test
    public void testEmptyEndpoint() {
        Configuration conf = new Configuration(true);
        JsonPoller poller = new JsonPoller();
        poller.setConf(conf);
        Exception exception = (Exception)Assert.assertThrows(IllegalArgumentException.class, () -> ((JsonPoller)poller).init());
        Assert.assertTrue((boolean)exception.getMessage().startsWith("Alive watchdog HTTP poller url is empty"));
    }

    @Test
    public void testEmptyDataCenterIdentifier() {
        Configuration conf = new Configuration(true);
        JsonPoller poller = new JsonPoller();
        conf.set("hops.alive-watchdog.http-poll.url", "http://localhost");
        poller.setConf(conf);
        Exception exception = (Exception)Assert.assertThrows(IllegalArgumentException.class, () -> ((JsonPoller)poller).init());
        Assert.assertTrue((boolean)exception.getMessage().startsWith("Alive watchdog HTTP JSON poller DC identifier"));
    }

    @Test
    public void testAlive() throws Exception {
        try (MockWebServer server = new MockWebServer();){
            MockResponse response = new MockResponse().setResponseCode(200).setBody("{\"active\": \"dc1\"}");
            server.enqueue(response);
            JsonPoller poller = new JsonPoller();
            Configuration conf = new Configuration(true);
            conf.set("hops.alive-watchdog.http-poll.url", "http://" + server.getHostName() + ":" + server.getPort());
            conf.set(JsonPoller.DC_IDENTIFIER, "dC1");
            poller.setConf(conf);
            poller.init();
            Assert.assertTrue((boolean)poller.shouldIBeAlive());
            poller.destroy();
        }
    }

    @Test
    public void testDeadJSON() throws Exception {
        try (MockWebServer server = new MockWebServer();){
            MockResponse response = new MockResponse().setResponseCode(200).setBody("{\"active\": \"Dc2\"}");
            server.enqueue(response);
            JsonPoller poller = new JsonPoller();
            Configuration conf = new Configuration(true);
            conf.set("hops.alive-watchdog.http-poll.url", "http://" + server.getHostName() + ":" + server.getPort());
            conf.set(JsonPoller.DC_IDENTIFIER, "dC1");
            poller.setConf(conf);
            poller.init();
            Assert.assertFalse((boolean)poller.shouldIBeAlive());
            poller.destroy();
        }
    }

    @Test
    public void testDeadStatus() throws Exception {
        try (MockWebServer server = new MockWebServer();){
            MockResponse response = new MockResponse().setResponseCode(404);
            server.enqueue(response);
            JsonPoller poller = new JsonPoller();
            Configuration conf = new Configuration(true);
            conf.set("hops.alive-watchdog.http-poll.url", "http://" + server.getHostName() + ":" + server.getPort());
            conf.set(JsonPoller.DC_IDENTIFIER, "dC1");
            poller.setConf(conf);
            poller.init();
            Assert.assertFalse((boolean)poller.shouldIBeAlive());
            poller.destroy();
        }
    }
}

