/*
 * Decompiled with CFR 0.152.
 */
package io.hops.leader_election.watchdog;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.hops.leader_election.watchdog.AliveWatchdogPoller;
import io.hops.leader_election.watchdog.HttpUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;

public class JsonPoller
implements AliveWatchdogPoller {
    private static final Log LOG = LogFactory.getLog(JsonPoller.class);
    protected static final String DC_IDENTIFIER = "hops.alive-watchdog." + JsonPoller.class.getCanonicalName() + ".dc-id";
    private final Gson gson = new GsonBuilder().create();
    private Configuration conf;
    private HttpGet request;
    private PoolingHttpClientConnectionManager httpConnectionManager;
    private CloseableHttpClient httpClient;
    private String dcId;

    @Override
    public Boolean shouldIBeAlive() throws Exception {
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)this.request);){
            if (response.getStatusLine().getStatusCode() < 200 || response.getStatusLine().getStatusCode() >= 400) {
                Boolean bl = false;
                return bl;
            }
            String body = EntityUtils.toString((HttpEntity)response.getEntity());
            Verdict verdict = (Verdict)this.gson.fromJson(body, Verdict.class);
            Boolean bl = this.dcId.equalsIgnoreCase(verdict.active);
            return bl;
        }
    }

    @Override
    public void init() throws Exception {
        String url = this.conf.get("hops.alive-watchdog.http-poll.url");
        if (url == null) {
            String msg = "Alive watchdog HTTP poller url is empty. Make sure you have set hops.alive-watchdog.http-poll.url";
            LOG.error((Object)msg);
            throw new IllegalArgumentException(msg);
        }
        this.dcId = this.conf.get(DC_IDENTIFIER);
        if (Strings.isNullOrEmpty((String)this.dcId)) {
            String msg = "Alive watchdog HTTP JSON poller DC identifier is empty. Make sure you have set " + DC_IDENTIFIER;
            LOG.error((Object)msg);
            throw new IllegalArgumentException(msg);
        }
        URI endpoint = new URI(url);
        this.request = new HttpGet(endpoint);
        this.httpConnectionManager = HttpUtils.createHTTPConnectionManager(this.conf, 20);
        this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.httpConnectionManager).build();
    }

    @Override
    public void destroy() throws Exception {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
        if (this.httpConnectionManager != null) {
            this.httpConnectionManager.close();
        }
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    private static class Verdict {
        String active;

        private Verdict() {
        }
    }
}

