/*
 * Decompiled with CFR 0.152.
 */
package io.hops.leader_election.watchdog;

import io.hops.leader_election.watchdog.HttpPageNotFoundPoller;
import java.net.URISyntaxException;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.Test;

public class TestHttpPageNotFoundPoller {
    @Test
    public void testEmptyEndpoint() {
        Configuration conf = new Configuration(true);
        HttpPageNotFoundPoller poller = new HttpPageNotFoundPoller();
        poller.setConf(conf);
        Exception exception = (Exception)Assert.assertThrows(IllegalArgumentException.class, () -> ((HttpPageNotFoundPoller)poller).init());
        Assert.assertTrue((boolean)exception.getMessage().startsWith("Alive watchdog HTTP poller url is empty"));
    }

    @Test
    public void testNonValidUrl() {
        Configuration conf = new Configuration(true);
        conf.set("hops.alive-watchdog.http-poll.url", "http://");
        HttpPageNotFoundPoller poller = new HttpPageNotFoundPoller();
        poller.setConf(conf);
        Assert.assertThrows(URISyntaxException.class, () -> ((HttpPageNotFoundPoller)poller).init());
    }

    @Test
    public void testAlive() throws Exception {
        try (MockWebServer server = new MockWebServer();){
            MockResponse response = new MockResponse().setResponseCode(200);
            server.enqueue(response);
            HttpPageNotFoundPoller poller = new HttpPageNotFoundPoller();
            Configuration conf = new Configuration(true);
            conf.set("hops.alive-watchdog.http-poll.url", "http://" + server.getHostName() + ":" + server.getPort());
            poller.setConf(conf);
            poller.init();
            Assert.assertTrue((boolean)poller.shouldIBeAlive());
            poller.destroy();
        }
    }

    @Test
    public void testNotAlive() throws Exception {
        try (MockWebServer server = new MockWebServer();){
            MockResponse response = new MockResponse().setResponseCode(404);
            server.enqueue(response);
            HttpPageNotFoundPoller poller = new HttpPageNotFoundPoller();
            Configuration conf = new Configuration(true);
            conf.set("hops.alive-watchdog.http-poll.url", "http://" + server.getHostName() + ":" + server.getPort());
            poller.setConf(conf);
            poller.init();
            Assert.assertFalse((boolean)poller.shouldIBeAlive());
            poller.destroy();
        }
    }
}

