/*
 * Decompiled with CFR 0.152.
 */
package io.hops.leader_election.watchdog;

import io.hops.leader_election.watchdog.AliveWatchdogPoller;
import io.hops.leader_election.watchdog.AliveWatchdogService;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestWatchdogService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAliveAtStartUp() throws Exception {
        Configuration conf = new Configuration(true);
        AliveWatchdogService realWatchdog = new AliveWatchdogService();
        AliveWatchdogService watchdogService = (AliveWatchdogService)Mockito.spy((Object)realWatchdog);
        ((AliveWatchdogService)Mockito.doNothing().when((Object)watchdogService)).exit();
        try {
            watchdogService.serviceInit(conf);
            AlwaysAlivePoller poller = new AlwaysAlivePoller();
            watchdogService.setPoller((AliveWatchdogPoller)poller);
            watchdogService.serviceStart();
            Assert.assertTrue((poller.calledCounter > 0 ? 1 : 0) != 0);
            ((AliveWatchdogService)Mockito.verify((Object)watchdogService, (VerificationMode)Mockito.never())).exit();
        }
        finally {
            watchdogService.serviceStop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNotAliveAtStartUp() throws Exception {
        Configuration conf = new Configuration(true);
        AliveWatchdogService realWatchdog = new AliveWatchdogService();
        AliveWatchdogService watchdogService = (AliveWatchdogService)Mockito.spy((Object)realWatchdog);
        ((AliveWatchdogService)Mockito.doNothing().when((Object)watchdogService)).exit();
        try {
            watchdogService.serviceInit(conf);
            AlwaysDeadPoller poller = new AlwaysDeadPoller();
            watchdogService.setPoller((AliveWatchdogPoller)poller);
            watchdogService.serviceStart();
            ((AliveWatchdogService)Mockito.verify((Object)watchdogService, (VerificationMode)Mockito.times((int)1))).exit();
            Assert.assertNull((Object)watchdogService.getExecutorService());
        }
        finally {
            watchdogService.serviceStop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWatchdogSwitch() throws Exception {
        Configuration conf = new Configuration(true);
        conf.set("hops.alive-watchdog.interval", "20ms");
        AliveWatchdogService watchdogService = (AliveWatchdogService)Mockito.spy((Object)new AliveWatchdogService());
        ((AliveWatchdogService)Mockito.doNothing().when((Object)watchdogService)).exit();
        CountDownLatch tipped = new CountDownLatch(1);
        try {
            watchdogService.serviceInit(conf);
            SwitchPoller poller = new SwitchPoller(5, tipped);
            watchdogService.setPoller((AliveWatchdogPoller)poller);
            watchdogService.serviceStart();
            tipped.await(5L, TimeUnit.SECONDS);
            ((AliveWatchdogService)Mockito.verify((Object)watchdogService, (VerificationMode)Mockito.atLeastOnce())).exit();
        }
        finally {
            watchdogService.serviceStop();
        }
        Assert.assertTrue((boolean)watchdogService.getExecutorService().isTerminated());
        Assert.assertTrue((boolean)watchdogService.getExecutorService().isShutdown());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPollerRetry() throws Exception {
        Configuration conf = new Configuration(true);
        AliveWatchdogService watchdogService = (AliveWatchdogService)Mockito.spy((Object)new AliveWatchdogService());
        ((AliveWatchdogService)Mockito.doNothing().when((Object)watchdogService)).exit();
        CountDownLatch wentThrough = new CountDownLatch(1);
        try {
            watchdogService.serviceInit(conf);
            RetryPoller poller = new RetryPoller(wentThrough);
            watchdogService.setPoller((AliveWatchdogPoller)poller);
            watchdogService.serviceStart();
            wentThrough.await(5L, TimeUnit.SECONDS);
            ((AliveWatchdogService)Mockito.verify((Object)watchdogService, (VerificationMode)Mockito.never())).exit();
        }
        finally {
            watchdogService.serviceStop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPollerRetryGiveUp() throws Exception {
        Configuration conf = new Configuration(true);
        conf.set("hops.alive-watchdog.interval", "50ms");
        AliveWatchdogService watchdogService = (AliveWatchdogService)Mockito.spy((Object)new AliveWatchdogService());
        ((AliveWatchdogService)Mockito.doNothing().when((Object)watchdogService)).exit();
        try {
            watchdogService.serviceInit(conf);
            RetryPoller poller = new RetryPoller(null, Integer.MAX_VALUE);
            watchdogService.setPoller((AliveWatchdogPoller)poller);
            watchdogService.serviceStart();
            TimeUnit.SECONDS.sleep(3L);
            ((AliveWatchdogService)Mockito.verify((Object)watchdogService, (VerificationMode)Mockito.atLeastOnce())).exit();
        }
        finally {
            watchdogService.serviceStop();
        }
    }

    private static class RetryPoller
    implements AliveWatchdogPoller {
        int calls = 0;
        boolean startJitter = false;
        CountDownLatch wentThrough;
        final int tippingPoint;

        private RetryPoller(CountDownLatch wentThrough) {
            this(wentThrough, 3);
        }

        private RetryPoller(CountDownLatch wentThrough, int tippingPoint) {
            this.wentThrough = wentThrough;
            this.tippingPoint = tippingPoint;
        }

        public Boolean shouldIBeAlive() throws Exception {
            if (this.startJitter && this.calls++ < this.tippingPoint) {
                throw new IOException("oops");
            }
            if (!this.startJitter) {
                this.startJitter = true;
            } else {
                this.wentThrough.countDown();
            }
            return true;
        }

        public void init() throws Exception {
        }

        public void destroy() throws Exception {
        }

        public void setConf(Configuration conf) {
        }

        public Configuration getConf() {
            return null;
        }
    }

    private static class SwitchPoller
    implements AliveWatchdogPoller {
        private final int tippingPoint;
        private int calls = 0;
        private CountDownLatch tipped;

        private SwitchPoller(int tippingPoint, CountDownLatch tipped) {
            this.tippingPoint = tippingPoint;
            this.tipped = tipped;
        }

        public Boolean shouldIBeAlive() throws Exception {
            if (this.calls > this.tippingPoint) {
                this.tipped.countDown();
            }
            return this.calls++ < this.tippingPoint;
        }

        public void init() throws Exception {
        }

        public void destroy() throws Exception {
        }

        public void setConf(Configuration conf) {
        }

        public Configuration getConf() {
            return null;
        }
    }

    private static class AlwaysDeadPoller
    implements AliveWatchdogPoller {
        private AlwaysDeadPoller() {
        }

        public Boolean shouldIBeAlive() throws Exception {
            return false;
        }

        public void init() throws Exception {
        }

        public void destroy() throws Exception {
        }

        public void setConf(Configuration conf) {
        }

        public Configuration getConf() {
            return null;
        }
    }

    private static class AlwaysAlivePoller
    implements AliveWatchdogPoller {
        int calledCounter = 0;

        private AlwaysAlivePoller() {
        }

        public Boolean shouldIBeAlive() throws Exception {
            ++this.calledCounter;
            return true;
        }

        public void init() throws Exception {
        }

        public void destroy() throws Exception {
        }

        public void setConf(Configuration conf) {
        }

        public Configuration getConf() {
            return null;
        }
    }
}

