/*
 * Decompiled with CFR 0.152.
 */
package io.hops.security;

import io.hops.security.SuperuserKeystoresLoader;
import java.nio.file.Paths;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.ssl.X509SecurityMaterial;
import org.apache.hadoop.util.envVars.EnvironmentVariables;
import org.apache.hadoop.util.envVars.EnvironmentVariablesFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSuperuserKeystoresLoader {
    private static String USER;
    private final String IMPERSONATE_USER = "alice";

    @BeforeClass
    public static void beforeClass() throws Exception {
        USER = UserGroupInformation.getLoginUser().getUserName();
    }

    @After
    public void afterEach() {
        EnvironmentVariablesFactory.setInstance(null);
    }

    @Test
    public void testLoadEnvironmentVariable() throws Exception {
        String materialDirectory = "/tmp/secrets";
        MockEnvironmentVariables envVars = new MockEnvironmentVariables();
        envVars.setEnv("SUPERUSER_MATERIAL_DIRECTORY", "/tmp/secrets");
        EnvironmentVariablesFactory.setInstance((EnvironmentVariables)envVars);
        Configuration conf = new Configuration(false);
        final SuperuserKeystoresLoader loader = new SuperuserKeystoresLoader(conf);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"alice");
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                X509SecurityMaterial material = loader.loadSuperUserMaterial();
                TestSuperuserKeystoresLoader.this.assertMaterialEquals("/tmp/secrets", loader, material);
                return null;
            }
        });
    }

    @Test
    public void testLoadConfiguration() throws Exception {
        String materialDirectory = "/tmp/secure/bin";
        Configuration conf = new Configuration(false);
        conf.set("hops.tls.superuser-material-directory", "/tmp/secure/bin");
        final SuperuserKeystoresLoader loader = new SuperuserKeystoresLoader(conf);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"alice");
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                X509SecurityMaterial material = loader.loadSuperUserMaterial();
                TestSuperuserKeystoresLoader.this.assertMaterialEquals("/tmp/secure/bin", loader, material);
                return null;
            }
        });
    }

    @Test
    public void testLoadFromHome() throws Exception {
        final String materialDirectory = Paths.get(System.getProperty("user.home"), ".hops_tls").toString();
        Configuration conf = new Configuration(false);
        final SuperuserKeystoresLoader loader = new SuperuserKeystoresLoader(conf);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"alice");
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                X509SecurityMaterial material = loader.loadSuperUserMaterial();
                TestSuperuserKeystoresLoader.this.assertMaterialEquals(materialDirectory, loader, material);
                return null;
            }
        });
    }

    @Test
    public void testLoadFromHomeWithVariable() throws Exception {
        String materialDirectory = "${HOME}/.hops_tls";
        final String expectedDirectory = Paths.get(System.getProperty("user.home"), ".hops_tls").toString();
        Configuration conf = new Configuration(false);
        conf.set("hops.tls.superuser-material-directory", "${HOME}/.hops_tls");
        final SuperuserKeystoresLoader loader = new SuperuserKeystoresLoader(conf);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"alice");
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                X509SecurityMaterial material = loader.loadSuperUserMaterial();
                TestSuperuserKeystoresLoader.this.assertMaterialEquals(expectedDirectory, loader, material);
                return null;
            }
        });
    }

    @Test
    public void testLoadFromDirectoryWithUserVariable() throws Exception {
        String materialDirectory = "/some/directory/${USER}";
        final String expectedDirectory = Paths.get("/some/directory", USER).toString();
        Configuration conf = new Configuration(false);
        conf.set("hops.tls.superuser-material-directory", "/some/directory/${USER}");
        final SuperuserKeystoresLoader loader = new SuperuserKeystoresLoader(conf);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"alice");
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                X509SecurityMaterial material = loader.loadSuperUserMaterial();
                TestSuperuserKeystoresLoader.this.assertMaterialEquals(expectedDirectory, loader, material);
                return null;
            }
        });
    }

    private void assertMaterialEquals(String materialDirectory, SuperuserKeystoresLoader loader, X509SecurityMaterial material) {
        Assert.assertEquals((Object)Paths.get(materialDirectory, new String[0]).resolve(loader.getSuperKeystoreFilename(USER)), (Object)material.getKeyStoreLocation());
        Assert.assertEquals((Object)Paths.get(materialDirectory, new String[0]).resolve(loader.getSuperTruststoreFilename(USER)), (Object)material.getTrustStoreLocation());
        Assert.assertEquals((Object)Paths.get(materialDirectory, new String[0]).resolve(loader.getSuperMaterialPasswdFilename(USER)), (Object)material.getPasswdLocation());
    }

    private class MockEnvironmentVariables
    implements EnvironmentVariables {
        private final Map<String, String> envs = new HashMap<String, String>();

        private MockEnvironmentVariables() {
        }

        public String getEnv(String variableName) {
            return this.envs.get(variableName);
        }

        public void setEnv(String name, String value) {
            this.envs.put(name, value);
        }
    }
}

