/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.ssl;

import io.hops.security.MockEnvironmentVariablesService;
import io.hops.security.SuperuserKeystoresLoader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.TestRpcBase;
import org.apache.hadoop.ipc.protobuf.TestProtos;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.ssl.CRLFetcherFactory;
import org.apache.hadoop.security.ssl.CRLValidator;
import org.apache.hadoop.security.ssl.CRLValidatorFactory;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.security.ssl.RevocationListFetcherService;
import org.apache.hadoop.security.ssl.RpcTLSUtils;
import org.apache.hadoop.util.envVars.EnvironmentVariables;
import org.apache.hadoop.util.envVars.EnvironmentVariablesFactory;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMWriter;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestCRLValidator {
    private static final Logger LOG = LogManager.getLogger(TestCRLValidator.class);
    private static final String BASE_DIR = Paths.get(System.getProperty("test.build.dir", Paths.get("target", "test-dir").toString()), TestCRLValidator.class.getSimpleName()).toString();
    private static final File BASE_DIR_FILE = new File(BASE_DIR);
    private Configuration conf;
    private final String keyAlgorithm = "RSA";
    private final String signatureAlgorithm = "SHA256withRSA";
    private final String password = "password";
    private static String confDir = null;
    @Rule
    public final ExpectedException rule = ExpectedException.none();

    @BeforeClass
    public static void setup() throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        BASE_DIR_FILE.mkdirs();
        confDir = KeyStoreTestUtil.getClasspathDir(TestCRLValidator.class);
    }

    @Before
    public void setupTest() throws Exception {
        this.conf = new Configuration();
        CRLValidatorFactory.getInstance().clearCache();
        CRLFetcherFactory.getInstance().clearFetcherCache();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        File sslServerFile;
        if (BASE_DIR_FILE.exists()) {
            FileUtils.deleteDirectory((File)BASE_DIR_FILE);
        }
        if ((sslServerFile = Paths.get(confDir, TestCRLValidator.class.getSimpleName() + ".ssl-server.xml").toFile()).exists()) {
            sslServerFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServerWithCRLValid() throws Exception {
        UserGroupInformation currentUGI = UserGroupInformation.getCurrentUser();
        SuperuserKeystoresLoader loader = new SuperuserKeystoresLoader(this.conf);
        Path serverKeystore = Paths.get(BASE_DIR, loader.getSuperKeystoreFilename(currentUGI.getUserName()));
        Path serverTruststore = Paths.get(BASE_DIR, loader.getSuperTruststoreFilename(currentUGI.getUserName()));
        Path serverPasswd = Paths.get(BASE_DIR, loader.getSuperMaterialPasswdFilename(currentUGI.getUserName()));
        Path crlPath = Paths.get(BASE_DIR, "input.server.crl.pem");
        Path fetchedCrlPath = Paths.get(BASE_DIR, "server.crl.pem");
        String clientUsername = "Client_username";
        Path clientKeystore = Paths.get(BASE_DIR, clientUsername + "__kstore.jks");
        Path clientTruststore = Paths.get(BASE_DIR, clientUsername + "__tstore.jks");
        Path clientPasswordLocation = Paths.get(BASE_DIR, clientUsername + "__cert.key");
        RPC.Server server = null;
        Object proxy = null;
        RpcTLSUtils.TLSSetup tlsSetup = new RpcTLSUtils.TLSSetup.Builder().setKeyAlgorithm("RSA").setSignatureAlgorithm("SHA256withRSA").setServerKstore(serverKeystore).setServerTstore(serverTruststore).setServerStorePassword("password").setServerStorePasswordLocation(serverPasswd).setClientKstore(clientKeystore).setClientTstore(clientTruststore).setClientStorePassword("password").setClientPasswordLocation(clientPasswordLocation).setClientUserName(clientUsername).build();
        RpcTLSUtils.TestCryptoMaterial testCryptoMaterial = RpcTLSUtils.setupTLSMaterial(this.conf, tlsSetup, TestCRLValidator.class);
        X509CRL crl = KeyStoreTestUtil.generateCRL(testCryptoMaterial.getServerCertificate(), testCryptoMaterial.getServerKeyPair().getPrivate(), "SHA256withRSA", null, null);
        this.writeCRLToFile(crl, crlPath);
        this.configureCRL(this.conf, crlPath, fetchedCrlPath);
        RPC.setProtocolEngine((Configuration)this.conf, TestRpcBase.TestRpcService.class, ProtobufRpcEngine.class);
        RevocationListFetcherService crlFetcherService = this.startCRLFetcherService(this.conf);
        CRLValidator testingValidator = new CRLValidator(this.conf);
        testingValidator.setReloadTimeunit(TimeUnit.SECONDS);
        testingValidator.setReloadInterval(1L);
        CRLValidatorFactory.getInstance().registerValidator(CRLValidatorFactory.TYPE.NORMAL, testingValidator);
        RpcTLSUtils.MockEnvironmentVariables envs = new RpcTLSUtils.MockEnvironmentVariables();
        envs.setEnv("MATERIAL_DIRECTORY", BASE_DIR);
        EnvironmentVariablesFactory.setInstance((EnvironmentVariables)envs);
        RPC.Builder serverBuilder = TestRpcBase.newServerBuilder(this.conf).setNumHandlers(1).setSecretManager(null).setnumReaders(2);
        try {
            String message = "Hello, is it me you're looking for?";
            server = TestRpcBase.setupTestServer(serverBuilder);
            UserGroupInformation clientUGI = UserGroupInformation.createRemoteUser((String)clientUsername);
            TestProtos.EchoResponseProto response = RpcTLSUtils.makeEchoRequest(clientUGI, server.getListenerAddress(), this.conf, "Hello, is it me you're looking for?");
            Assert.assertEquals((Object)response.getMessage(), (Object)"Hello, is it me you're looking for?");
        }
        finally {
            if (server != null) {
                server.stop();
            }
            if (crlFetcherService != null) {
                crlFetcherService.serviceStop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServerWithEnabledButMissingCRL() throws Exception {
        UserGroupInformation currentUGI = UserGroupInformation.getCurrentUser();
        SuperuserKeystoresLoader loader = new SuperuserKeystoresLoader(this.conf);
        Path serverKeystore = Paths.get(BASE_DIR, loader.getSuperKeystoreFilename(currentUGI.getUserName()));
        Path serverTruststore = Paths.get(BASE_DIR, loader.getSuperTruststoreFilename(currentUGI.getUserName()));
        Path serverPasswd = Paths.get(BASE_DIR, loader.getSuperMaterialPasswdFilename(currentUGI.getUserName()));
        Path crlPath = Paths.get(BASE_DIR, "input.server.crl.pem");
        Path fetchedCrlPath = Paths.get(BASE_DIR, "server.crl.pem");
        String clientUsername = "Client_username";
        Path clientKeystore = Paths.get(BASE_DIR, clientUsername + "__kstore.jks");
        Path clientTruststore = Paths.get(BASE_DIR, clientUsername + "__tstore.jks");
        Path clientPasswordLocation = Paths.get(BASE_DIR, clientUsername + "__cert.key");
        RPC.Server server = null;
        Object proxy = null;
        RpcTLSUtils.TLSSetup tlsSetup = new RpcTLSUtils.TLSSetup.Builder().setKeyAlgorithm("RSA").setSignatureAlgorithm("SHA256withRSA").setServerKstore(serverKeystore).setServerTstore(serverTruststore).setServerStorePassword("password").setServerStorePasswordLocation(serverPasswd).setClientKstore(clientKeystore).setClientTstore(clientTruststore).setClientStorePassword("password").setClientPasswordLocation(clientPasswordLocation).setClientUserName(clientUsername).build();
        RpcTLSUtils.TestCryptoMaterial testCryptoMaterial = RpcTLSUtils.setupTLSMaterial(this.conf, tlsSetup, TestCRLValidator.class);
        X509CRL crl = KeyStoreTestUtil.generateCRL(testCryptoMaterial.getServerCertificate(), testCryptoMaterial.getServerKeyPair().getPrivate(), "SHA256withRSA", null, testCryptoMaterial.getClientCertificate().getSerialNumber());
        this.writeCRLToFile(crl, crlPath);
        this.configureCRL(this.conf, crlPath, fetchedCrlPath);
        RPC.setProtocolEngine((Configuration)this.conf, TestRpcBase.TestRpcService.class, ProtobufRpcEngine.class);
        RpcTLSUtils.MockEnvironmentVariables envs = new RpcTLSUtils.MockEnvironmentVariables();
        envs.setEnv("MATERIAL_DIRECTORY", BASE_DIR);
        EnvironmentVariablesFactory.setInstance((EnvironmentVariables)envs);
        RPC.Builder serverBuilder = TestRpcBase.newServerBuilder(this.conf).setNumHandlers(1).setSecretManager(null).setnumReaders(2);
        try {
            this.rule.expect(NoSuchFileException.class);
            server = TestRpcBase.setupTestServer(serverBuilder);
        }
        finally {
            if (server != null) {
                server.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServerWithCRLInvalid() throws Exception {
        UserGroupInformation currentUGI = UserGroupInformation.getCurrentUser();
        SuperuserKeystoresLoader loader = new SuperuserKeystoresLoader(this.conf);
        Path serverKeystore = Paths.get(BASE_DIR, loader.getSuperKeystoreFilename(currentUGI.getUserName()));
        Path serverTruststore = Paths.get(BASE_DIR, loader.getSuperTruststoreFilename(currentUGI.getUserName()));
        Path serverPasswd = Paths.get(BASE_DIR, loader.getSuperMaterialPasswdFilename(currentUGI.getUserName()));
        Path crlPath = Paths.get(BASE_DIR, "input.server.crl.pem");
        Path fetchedCrlPath = Paths.get(BASE_DIR, "server.crl.pem");
        String clientUsername = "Client_username";
        Path clientKeystore = Paths.get(BASE_DIR, clientUsername + "__kstore.jks");
        Path clientTruststore = Paths.get(BASE_DIR, clientUsername + "__tstore.jks");
        Path clientPasswordLocation = Paths.get(BASE_DIR, clientUsername + "__cert.key");
        RPC.Server server = null;
        RpcTLSUtils.TLSSetup tlsSetup = new RpcTLSUtils.TLSSetup.Builder().setKeyAlgorithm("RSA").setSignatureAlgorithm("SHA256withRSA").setServerKstore(serverKeystore).setServerTstore(serverTruststore).setServerStorePassword("password").setServerStorePasswordLocation(serverPasswd).setClientKstore(clientKeystore).setClientTstore(clientTruststore).setClientStorePassword("password").setClientPasswordLocation(clientPasswordLocation).setClientUserName(clientUsername).build();
        RpcTLSUtils.TestCryptoMaterial testCryptoMaterial = RpcTLSUtils.setupTLSMaterial(this.conf, tlsSetup, TestCRLValidator.class);
        X509CRL crl = KeyStoreTestUtil.generateCRL(testCryptoMaterial.getServerCertificate(), testCryptoMaterial.getServerKeyPair().getPrivate(), "SHA256withRSA", null, testCryptoMaterial.getClientCertificate().getSerialNumber());
        this.writeCRLToFile(crl, crlPath);
        this.configureCRL(this.conf, crlPath, fetchedCrlPath);
        RPC.setProtocolEngine((Configuration)this.conf, TestRpcBase.TestRpcService.class, ProtobufRpcEngine.class);
        RevocationListFetcherService crlFetcherService = this.startCRLFetcherService(this.conf);
        CRLValidator testingValidator = new CRLValidator(this.conf);
        testingValidator.setReloadTimeunit(TimeUnit.SECONDS);
        testingValidator.setReloadInterval(1L);
        testingValidator.startReloadingThread();
        CRLValidatorFactory.getInstance().registerValidator(CRLValidatorFactory.TYPE.NORMAL, testingValidator);
        RpcTLSUtils.MockEnvironmentVariables envs = new RpcTLSUtils.MockEnvironmentVariables();
        envs.setEnv("MATERIAL_DIRECTORY", BASE_DIR);
        EnvironmentVariablesFactory.setInstance((EnvironmentVariables)envs);
        RPC.Builder serverBuilder = TestRpcBase.newServerBuilder(this.conf).setNumHandlers(1).setSecretManager(null).setnumReaders(2);
        try {
            boolean exceptionRaised;
            UserGroupInformation clientUGI;
            block8: {
                String message = "Hello, is it me you're looking for?";
                server = TestRpcBase.setupTestServer(serverBuilder);
                clientUGI = UserGroupInformation.createRemoteUser((String)clientUsername);
                exceptionRaised = false;
                try {
                    RpcTLSUtils.makeEchoRequest(clientUGI, server.getListenerAddress(), this.conf, "Hello, is it me you're looking for?");
                }
                catch (Exception ex) {
                    if (!(ex.getCause().getCause() instanceof RemoteException)) break block8;
                    if (ex.getCause().getCause().getMessage().contains("HopsCRLValidator: Certificate " + testCryptoMaterial.getClientCertificate().getSubjectDN() + " has been revoked by " + crl.getIssuerX500Principal())) {
                        exceptionRaised = true;
                    }
                    throw ex;
                }
            }
            Assert.assertTrue((boolean)exceptionRaised);
            LOG.info((Object)"Removing client certificate from CRL and wait for the CRL fetcher to pick it up");
            crl = KeyStoreTestUtil.generateCRL(testCryptoMaterial.getServerCertificate(), testCryptoMaterial.getServerKeyPair().getPrivate(), "SHA256withRSA", null, null);
            this.writeCRLToFile(crl, crlPath);
            TimeUnit.SECONDS.sleep(crlFetcherService.getFetcherInterval() * 2L + testingValidator.getReloadInterval() * 2L);
            TestProtos.EchoResponseProto response = RpcTLSUtils.makeEchoRequest(clientUGI, server.getListenerAddress(), this.conf, "Hello, is it me you're looking for?");
            Assert.assertEquals((Object)response.getMessage(), (Object)"Hello, is it me you're looking for?");
        }
        finally {
            if (server != null) {
                server.stop();
            }
            if (crlFetcherService != null) {
                crlFetcherService.serviceStop();
            }
        }
    }

    @Test
    public void testValidator() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        SuperuserKeystoresLoader loader = new SuperuserKeystoresLoader(this.conf);
        Path caTruststore = Paths.get(BASE_DIR, loader.getSuperTruststoreFilename(ugi.getUserName()));
        Path passwdLocation = Paths.get(BASE_DIR, loader.getSuperMaterialPasswdFilename(ugi.getUserName()));
        FileUtils.writeStringToFile((File)passwdLocation.toFile(), (String)"password");
        Path crlPath = Paths.get(BASE_DIR, "crl.pem");
        KeyPair cakeyPair = KeyStoreTestUtil.generateKeyPair("RSA");
        X509Certificate caCert = KeyStoreTestUtil.generateCertificate("CN=rootCA", cakeyPair, 60, "SHA256withRSA", true);
        KeyStoreTestUtil.createTrustStore(caTruststore.toString(), "password", "rootca", caCert);
        KeyPair clientKeyPair = KeyStoreTestUtil.generateKeyPair("RSA");
        X509Certificate clientCert = KeyStoreTestUtil.generateSignedCertificate("CN=client", clientKeyPair, 30, "SHA256withRSA", cakeyPair.getPrivate(), caCert);
        clientCert.verify(cakeyPair.getPublic());
        X509CRL crl = KeyStoreTestUtil.generateCRL(caCert, cakeyPair.getPrivate(), "SHA256withRSA", null, null);
        this.writeCRLToFile(crl, crlPath);
        this.conf.set("hops.tls.superuser-material-directory", BASE_DIR);
        this.conf.set("hops.crl.output.file", crlPath.toString());
        CRLValidator validator = CRLValidatorFactory.getInstance().getValidator(CRLValidatorFactory.TYPE.TESTING, this.conf, this.conf);
        Certificate[] chain = new Certificate[]{clientCert, caCert};
        validator.validate(chain);
        crl = KeyStoreTestUtil.generateCRL(caCert, cakeyPair.getPrivate(), "SHA256withRSA", crl, clientCert.getSerialNumber());
        TimeUnit.SECONDS.sleep(1L);
        this.writeCRLToFile(crl, crlPath);
        TimeUnit.SECONDS.sleep(validator.getReloadInterval() * 2L);
        this.rule.expect(CertificateException.class);
        validator.validate(chain);
    }

    @Test
    public void testCRLValidatorFactory() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        SuperuserKeystoresLoader loader = new SuperuserKeystoresLoader(this.conf);
        Path truststore = Paths.get(BASE_DIR, loader.getSuperTruststoreFilename(ugi.getUserName()));
        Path passwdLocation = Paths.get(BASE_DIR, loader.getSuperMaterialPasswdFilename(ugi.getUserName()));
        FileUtils.writeStringToFile((File)passwdLocation.toFile(), (String)"password");
        Path crlPath = Paths.get(BASE_DIR, "crl.pem");
        KeyPair keyPair = KeyStoreTestUtil.generateKeyPair("RSA");
        X509Certificate cert = KeyStoreTestUtil.generateCertificate("CN=root", keyPair, 60, "SHA256withRSA", true);
        KeyStoreTestUtil.createTrustStore(truststore.toString(), "password", "root", cert);
        X509CRL crl = KeyStoreTestUtil.generateCRL(cert, keyPair.getPrivate(), "SHA256withRSA", null, null);
        this.writeCRLToFile(crl, crlPath);
        this.conf.set("hops.tls.superuser-material-directory", BASE_DIR);
        this.conf.set("hops.crl.output.file", crlPath.toString());
        CRLValidator normalValidator1 = CRLValidatorFactory.getInstance().getValidator(CRLValidatorFactory.TYPE.NORMAL, this.conf, this.conf);
        CRLValidator normalValidator2 = CRLValidatorFactory.getInstance().getValidator(CRLValidatorFactory.TYPE.NORMAL, this.conf, this.conf);
        Assert.assertEquals((Object)normalValidator1, (Object)normalValidator2);
        CRLValidator testingValidator1 = CRLValidatorFactory.getInstance().getValidator(CRLValidatorFactory.TYPE.TESTING, this.conf, this.conf);
        CRLValidator testingValidator2 = CRLValidatorFactory.getInstance().getValidator(CRLValidatorFactory.TYPE.TESTING, this.conf, this.conf);
        Assert.assertEquals((Object)testingValidator1, (Object)testingValidator2);
        Assert.assertNotEquals((Object)normalValidator1, (Object)testingValidator1);
    }

    @Test
    public void testCRLValidatioFactoryNonSuperuser() throws Exception {
        String username = "application__user";
        Path keystore = Paths.get(BASE_DIR, "k_certificate");
        Path truststore = Paths.get(BASE_DIR, "t_certificate");
        Path passwdLocation = Paths.get(BASE_DIR, "material_passwd");
        FileUtils.writeStringToFile((File)passwdLocation.toFile(), (String)"password");
        Path crlPath = Paths.get(BASE_DIR, "crl.pem");
        KeyPair keyPair = KeyStoreTestUtil.generateKeyPair("RSA");
        X509Certificate cert = KeyStoreTestUtil.generateCertificate("CN=root", keyPair, 60, "SHA256withRSA", true);
        KeyStoreTestUtil.createKeyStore(keystore.toString(), "password", "password", "root", keyPair.getPrivate(), cert);
        KeyStoreTestUtil.createTrustStore(truststore.toString(), "password", "root", cert);
        X509CRL crl = KeyStoreTestUtil.generateCRL(cert, keyPair.getPrivate(), "SHA256withRSA", null, null);
        this.writeCRLToFile(crl, crlPath);
        this.conf.set("hops.tls.superuser-material-directory", BASE_DIR);
        this.conf.set("hops.crl.output.file", crlPath.toString());
        MockEnvironmentVariablesService mockEnvService = new MockEnvironmentVariablesService();
        mockEnvService.setEnv("PWD", BASE_DIR);
        EnvironmentVariablesFactory.setInstance((EnvironmentVariables)mockEnvService);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)username);
        CRLValidator validator = (CRLValidator)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<CRLValidator>(){

            @Override
            public CRLValidator run() throws Exception {
                return CRLValidatorFactory.getInstance().getValidator(CRLValidatorFactory.TYPE.NORMAL, TestCRLValidator.this.conf, TestCRLValidator.this.conf);
            }
        });
        Assert.assertNotNull((Object)validator);
    }

    @Test
    public void testRetryActions() throws Exception {
        boolean exceptionThrown = false;
        try {
            new CRLValidator(this.conf);
        }
        catch (NoSuchFileException ex) {
            exceptionThrown = true;
        }
        Assert.assertTrue((boolean)exceptionThrown);
    }

    private void writeCRLToFile(X509CRL crl, Path crlPath) throws IOException {
        try (FileWriter fw = new FileWriter(crlPath.toFile(), false);){
            PEMWriter pw = new PEMWriter((Writer)fw);
            pw.writeObject((Object)crl);
            pw.flush();
            fw.flush();
            pw.close();
        }
    }

    private void configureCRL(Configuration conf, Path crlPath, Path fetchedCrlPath) {
        conf.setBoolean("hops.crl.validation.enabled", true);
        conf.set("hops.crl.fetcher.class", "org.apache.hadoop.security.ssl.RemoteCRLFetcher");
        conf.set("hops.crl.fetcher.interval", "1s");
        conf.set("hops.crl.input.uri", "file://" + crlPath.toString());
        conf.set("hops.crl.output.file", fetchedCrlPath.toString());
    }

    private RevocationListFetcherService startCRLFetcherService(Configuration conf) throws Exception {
        RevocationListFetcherService crlFetcherService = new RevocationListFetcherService();
        crlFetcherService.setIntervalTimeUnit(TimeUnit.SECONDS);
        crlFetcherService.serviceInit(conf);
        crlFetcherService.serviceStart();
        return crlFetcherService;
    }
}

