/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import io.hops.security.HopsUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.ssl.FileBasedKeyStoresFactory;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestHopsUtil {
    private static final Log LOG = LogFactory.getLog(TestHopsUtil.class);
    private static final String BASE_DIR = Paths.get(System.getProperty("test.build.dir", Paths.get("target", "test-dir").toString()), TestHopsUtil.class.getSimpleName()).toString();
    private static final File BASE_DIR_FILE = new File(BASE_DIR);
    private static String CLASSPATH;
    private File sslClientFile;

    @BeforeClass
    public static void beforeClass() throws Exception {
        BASE_DIR_FILE.mkdirs();
        CLASSPATH = KeyStoreTestUtil.getClasspathDir(TestHopsUtil.class);
    }

    @After
    public void afterTest() throws Exception {
        if (this.sslClientFile != null) {
            this.sslClientFile.delete();
        }
    }

    @AfterClass
    public static void afterClass() throws Exception {
        if (BASE_DIR_FILE.exists()) {
            FileUtils.deleteDirectory((File)BASE_DIR_FILE);
        }
    }

    @Test
    public void testGenerateContainerSSLServer() throws Exception {
        Configuration systemConf = new Configuration(false);
        HashMap<String, String> expected = new HashMap<String, String>();
        Path passwdFilePath = Paths.get(BASE_DIR_FILE.getAbsolutePath(), systemConf.get("hops.ssl.keystores.passwd.name", "material_passwd"));
        File passwdFile = passwdFilePath.toFile();
        String password = "password";
        FileUtils.writeStringToFile((File)passwdFile, (String)password);
        this.sslClientFile = Paths.get(CLASSPATH, "ssl-client.xml").toFile();
        Configuration sslClientConf = new Configuration(false);
        String keyStoreReloadIntevalKey = FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)SSLFactory.Mode.CLIENT, (String)"ssl.{0}.keystore.reload.interval");
        String keyStoreReloadIntervalValue = "400";
        expected.put(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)SSLFactory.Mode.SERVER, (String)"ssl.{0}.keystore.reload.interval"), keyStoreReloadIntervalValue);
        sslClientConf.set(keyStoreReloadIntevalKey, keyStoreReloadIntervalValue);
        String keyStoreReloadUnitKey = FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)SSLFactory.Mode.CLIENT, (String)"ssl.{0}.keystore.reload.timeunit");
        String keyStoreReloadUnitValue = "d";
        expected.put(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)SSLFactory.Mode.SERVER, (String)"ssl.{0}.keystore.reload.timeunit"), keyStoreReloadUnitValue);
        sslClientConf.set(keyStoreReloadUnitKey, keyStoreReloadUnitValue);
        String trustStoreReloadIntervalKey = FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)SSLFactory.Mode.CLIENT, (String)"ssl.{0}.truststore.reload.interval");
        String trustStoreReloadIntervalValue = "3000";
        expected.put(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)SSLFactory.Mode.SERVER, (String)"ssl.{0}.truststore.reload.interval"), trustStoreReloadIntervalValue);
        sslClientConf.set(trustStoreReloadIntervalKey, trustStoreReloadIntervalValue);
        try (FileWriter fw = new FileWriter(this.sslClientFile, false);){
            sslClientConf.writeXml((Writer)fw);
        }
        HopsUtil.generateContainerSSLServerConfiguration((File)passwdFile, (Configuration)systemConf);
        File sslServerConf = Paths.get(BASE_DIR_FILE.getAbsolutePath(), "ssl-server.xml").toFile();
        Configuration sslConf = new Configuration(false);
        sslConf.addResource((InputStream)new FileInputStream(sslServerConf));
        this.assertSSLConfValues(expected, sslConf);
    }

    @Test
    public void testGenerateContainerSSLServerConfDefaults() throws IOException {
        Configuration systemConf = new Configuration(false);
        Path passwdFilePath = Paths.get(BASE_DIR_FILE.getAbsolutePath(), systemConf.get("hops.ssl.keystores.passwd.name", "material_passwd"));
        File passwdFile = passwdFilePath.toFile();
        String password = "password";
        FileUtils.writeStringToFile((File)passwdFile, (String)password);
        HopsUtil.generateContainerSSLServerConfiguration((File)passwdFile, (Configuration)systemConf);
        File sslServerConf = Paths.get(BASE_DIR_FILE.getAbsolutePath(), "ssl-server.xml").toFile();
        Assert.assertTrue((boolean)sslServerConf.exists());
        Configuration sslConf = new Configuration(false);
        sslConf.addResource((InputStream)new FileInputStream(sslServerConf));
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)SSLFactory.Mode.SERVER, (String)"ssl.{0}.keystore.reload.interval"), String.valueOf(10000L));
        expected.put(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)SSLFactory.Mode.SERVER, (String)"ssl.{0}.keystore.reload.timeunit"), "MILLISECONDS");
        expected.put(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)SSLFactory.Mode.SERVER, (String)"ssl.{0}.truststore.reload.interval"), String.valueOf(10000));
        this.assertSSLConfValues(expected, sslConf);
    }

    @Test
    public void testGenerateContainerSSLServerConfWithDifferentName() throws IOException {
        Configuration systemConf = new Configuration(false);
        File passwdFile = Paths.get(BASE_DIR_FILE.getAbsolutePath(), systemConf.get("hops.ssl.keystores.passwd.name", "material_passwd")).toFile();
        FileUtils.writeStringToFile((File)passwdFile, (String)"password");
        systemConf.set("hadoop.ssl.server.conf", "client-ssl-server.xml");
        systemConf.set("hadoop.ssl.client.conf", "client-ssl-client.xml");
        this.sslClientFile = Paths.get(CLASSPATH, "client-ssl-client.xml").toFile();
        Configuration sslClientSSLConf = new Configuration(false);
        sslClientSSLConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)SSLFactory.Mode.CLIENT, (String)"ssl.{0}.keystore.reload.interval"), "500");
        try (FileWriter fw = new FileWriter(this.sslClientFile, false);){
            sslClientSSLConf.writeXml((Writer)fw);
        }
        HopsUtil.generateContainerSSLServerConfiguration((File)passwdFile, (Configuration)systemConf);
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)SSLFactory.Mode.SERVER, (String)"ssl.{0}.keystore.reload.interval"), "500");
        File sslServerConf = Paths.get(BASE_DIR_FILE.getAbsolutePath(), "client-ssl-server.xml").toFile();
        Assert.assertTrue((boolean)sslServerConf.exists());
        Configuration sslConf = new Configuration(false);
        sslConf.addResource((InputStream)new FileInputStream(sslServerConf));
        this.assertSSLConfValues(expected, sslConf);
    }

    private void assertSSLConfValues(Map<String, String> expected, Configuration conf) {
        for (Map.Entry<String, String> entry : expected.entrySet()) {
            String key = entry.getKey();
            LOG.info((Object)("Asserting key: " + key));
            Assert.assertEquals((Object)entry.getValue(), (Object)conf.get(key));
        }
    }
}

