/*
 * Decompiled with CFR 0.152.
 */
package io.hops.leader_election.node;

import io.hops.leader_election.node.ActiveNode;
import io.hops.leader_election.node.ActiveNodePBImpl;
import io.hops.leader_election.node.SortedActiveNodeList;
import io.hops.leader_election.proto.ActiveNodeProtos;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class SortedActiveNodeListPBImpl
implements SortedActiveNodeList {
    ActiveNodeProtos.SortedActiveNodeListProto proto = ActiveNodeProtos.SortedActiveNodeListProto.getDefaultInstance();
    ActiveNodeProtos.SortedActiveNodeListProto.Builder builder = null;
    boolean viaProto = false;
    Random random = new Random();

    public SortedActiveNodeListPBImpl(ActiveNodeProtos.SortedActiveNodeListProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public SortedActiveNodeListPBImpl(List<ActiveNode> listActiveNodes) {
        if (listActiveNodes == null) {
            throw new NullPointerException("List of active namenodes was null");
        }
        this.maybeInitBuilder();
        for (ActiveNode node : listActiveNodes) {
            this.builder.addActiveNode(((ActiveNodePBImpl)node).getProto());
        }
    }

    public ActiveNodeProtos.SortedActiveNodeListProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = ActiveNodeProtos.SortedActiveNodeListProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    @Override
    public int size() {
        ActiveNodeProtos.SortedActiveNodeListProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getActiveNodeCount();
    }

    @Override
    public boolean isEmpty() {
        ActiveNodeProtos.SortedActiveNodeListProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getActiveNodeCount() == 0;
    }

    @Override
    public List<ActiveNode> getSortedActiveNodes() {
        ActiveNodeProtos.SortedActiveNodeListProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        ArrayList<ActiveNode> activeNodes = new ArrayList<ActiveNode>();
        for (ActiveNodeProtos.ActiveNodeProto nodeProto : p.getActiveNodeList()) {
            activeNodes.add(new ActiveNodePBImpl(nodeProto));
        }
        Collections.sort(activeNodes);
        return activeNodes;
    }

    @Override
    public List<ActiveNode> getActiveNodes() {
        ActiveNodeProtos.SortedActiveNodeListProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        ArrayList<ActiveNode> activeNodes = new ArrayList<ActiveNode>();
        for (ActiveNodeProtos.ActiveNodeProto nodeProto : p.getActiveNodeList()) {
            activeNodes.add(new ActiveNodePBImpl(nodeProto));
        }
        return activeNodes;
    }

    @Override
    public ActiveNode getActiveNode(InetSocketAddress address) {
        ActiveNodeProtos.SortedActiveNodeListProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        for (ActiveNodeProtos.ActiveNodeProto namenodeProto : p.getActiveNodeList()) {
            ActiveNodePBImpl namenode = new ActiveNodePBImpl(namenodeProto);
            if (!namenode.getRpcServerAddressForClients().equals(address) && !namenode.getRpcServerAddressForDatanodes().equals(address)) continue;
            return namenode;
        }
        return null;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "No Active NameNodes";
        }
        return Arrays.toString(this.getSortedActiveNodes().toArray());
    }

    @Override
    public ActiveNode getLeader() {
        if (this.isEmpty()) {
            return null;
        }
        return this.getSortedActiveNodes().get(0);
    }
}

