/*
 * Decompiled with CFR 0.152.
 */
package io.hops.security;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.Lists;
import io.hops.StorageConnector;
import io.hops.exception.ForeignKeyConstraintViolationException;
import io.hops.exception.StorageException;
import io.hops.exception.UniqueKeyConstraintViolationException;
import io.hops.metadata.hdfs.dal.GroupDataAccess;
import io.hops.metadata.hdfs.dal.UserDataAccess;
import io.hops.metadata.hdfs.dal.UserGroupDataAccess;
import io.hops.metadata.hdfs.entity.Group;
import io.hops.metadata.hdfs.entity.User;
import io.hops.security.GroupAlreadyExistsException;
import io.hops.security.GroupNotFoundException;
import io.hops.security.GroupsNotFoundForUserException;
import io.hops.security.UserAlreadyExistsException;
import io.hops.security.UserAlreadyInGroupException;
import io.hops.security.UserNotFoundException;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.handler.RequestHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
class UsersGroupsCache {
    private final Log LOG = LogFactory.getLog(UsersGroupsCache.class);
    private final UserGroupDataAccess userGroupDataAccess;
    private final GroupDataAccess<Group> groupDataAccess;
    private final UserDataAccess<User> userDataAccess;
    private LoadingCache<String, List<String>> userToGroupsCache;
    private LoadingCache<Integer, String> idToUserCache;
    private LoadingCache<String, Integer> userToIdCache;
    private LoadingCache<Integer, Integer> deletedUsersCache;
    private LoadingCache<Integer, String> idToGroupCache;
    private LoadingCache<String, Integer> groupToIdCache;
    private LoadingCache<Integer, Integer> deletedGroupsCache;
    private static final String lockRowName = "#HopsSyncUser#";
    private static User lockUser;
    private CacheLoader<String, List<String>> userToGroupsLoader = new CacheLoader<String, List<String>>(){

        public List<String> load(String userName) throws Exception {
            UsersGroupsCache.this.LOG.debug((Object)("Get groups from DB for user: " + userName));
            List groups = UsersGroupsCache.this.getUserGroupsFromDB(userName, UsersGroupsCache.this.getUserId(userName));
            if (groups == null || groups.isEmpty()) {
                throw new GroupsNotFoundForUserException("No groups found for user (" + userName + ")");
            }
            ArrayList groupNames = Lists.newArrayListWithExpectedSize((int)groups.size());
            for (Group group : groups) {
                groupNames.add(group.getName());
                UsersGroupsCache.this.updateGroupCache(group.getId(), group.getName());
            }
            return groupNames;
        }
    };
    private RemovalListener<String, List<String>> userToGroupsRemoval = new RemovalListener<String, List<String>>(){

        public void onRemoval(RemovalNotification<String, List<String>> rn) {
            UsersGroupsCache.this.LOG.debug((Object)("User's groups removal notification for " + rn.toString() + "(" + rn.getCause() + ")"));
        }
    };
    private CacheLoader<Integer, String> idToUserLoader = new CacheLoader<Integer, String>(){

        public String load(Integer userId) throws Exception {
            UsersGroupsCache.this.LOG.debug((Object)("Get user from DB by ID. UserID: " + userId));
            User user = UsersGroupsCache.this.getUserFromDB(null, userId);
            if (user != null) {
                UsersGroupsCache.this.userToIdCache.put((Object)user.getName(), (Object)userId);
                return user.getName();
            }
            UsersGroupsCache.this.deletedUsersCache.put((Object)userId, (Object)userId);
            throw new UserNotFoundException("User ID: " + userId + " not found.");
        }
    };
    private RemovalListener<Integer, String> idToUserRemoval = new RemovalListener<Integer, String>(){

        public void onRemoval(RemovalNotification<Integer, String> rn) {
            UsersGroupsCache.this.LOG.debug((Object)("User removal notification for " + rn.toString() + "(" + rn.getCause() + ")"));
        }
    };
    private CacheLoader<String, Integer> userToIdLoader = new CacheLoader<String, Integer>(){

        public Integer load(String userName) throws Exception {
            UsersGroupsCache.this.LOG.debug((Object)("Get user from DB by name: " + userName));
            User user = UsersGroupsCache.this.getUserFromDB(userName, null);
            if (user != null) {
                UsersGroupsCache.this.idToUserCache.put((Object)user.getId(), (Object)userName);
                return user.getId();
            }
            throw new UserNotFoundException("User name: " + userName + " not found.");
        }
    };
    private RemovalListener<String, Integer> userToIdsNameRemoval = new RemovalListener<String, Integer>(){

        public void onRemoval(RemovalNotification<String, Integer> rn) {
            UsersGroupsCache.this.LOG.debug((Object)("User removal notification for " + rn.toString() + "(" + rn.getCause() + ")"));
        }
    };
    private CacheLoader<Integer, String> idToGroupLoader = new CacheLoader<Integer, String>(){

        public String load(Integer groupId) throws Exception {
            UsersGroupsCache.this.LOG.debug((Object)("Get group from DB by id: " + groupId));
            Group group = UsersGroupsCache.this.getGroupFromDB(null, groupId);
            if (group != null) {
                UsersGroupsCache.this.groupToIdCache.put((Object)group.getName(), (Object)groupId);
                return group.getName();
            }
            UsersGroupsCache.this.deletedGroupsCache.put((Object)groupId, (Object)groupId);
            throw new GroupNotFoundException("Group ID: " + groupId + " not found.");
        }
    };
    private RemovalListener<Integer, String> idToGroupsRemoval = new RemovalListener<Integer, String>(){

        public void onRemoval(RemovalNotification<Integer, String> rn) {
            UsersGroupsCache.this.LOG.debug((Object)("Group removal notification for " + rn.toString() + "(" + rn.getCause() + ")"));
        }
    };
    private CacheLoader<String, Integer> groupToIdsLoader = new CacheLoader<String, Integer>(){

        public Integer load(String groupName) throws Exception {
            UsersGroupsCache.this.LOG.debug((Object)("Get group from DB by name: " + groupName));
            Group group = UsersGroupsCache.this.getGroupFromDB(groupName, null);
            if (group != null) {
                UsersGroupsCache.this.idToGroupCache.put((Object)group.getId(), (Object)groupName);
                return group.getId();
            }
            throw new GroupNotFoundException("Group name: " + groupName + " not found.");
        }
    };
    private RemovalListener<String, Integer> groupToIdsRemoval = new RemovalListener<String, Integer>(){

        public void onRemoval(RemovalNotification<String, Integer> rn) {
            UsersGroupsCache.this.LOG.debug((Object)("Group removal notification for " + rn.toString() + "(" + rn.getCause() + ")"));
        }
    };
    private RemovalListener<Integer, Integer> deletedUsersRemoval = new RemovalListener<Integer, Integer>(){

        public void onRemoval(RemovalNotification<Integer, Integer> rn) {
        }
    };
    private CacheLoader<Integer, Integer> deletedUsersLoader = new CacheLoader<Integer, Integer>(){

        public Integer load(Integer groupId) throws Exception {
            throw new UnsupportedOperationException("Deleted user can not be loaded from DB.");
        }
    };
    private RemovalListener<Integer, Integer> deletedGroupRemoval = new RemovalListener<Integer, Integer>(){

        public void onRemoval(RemovalNotification<Integer, Integer> rn) {
        }
    };
    private CacheLoader<Integer, Integer> deletedGroupLoader = new CacheLoader<Integer, Integer>(){

        public Integer load(Integer groupId) throws Exception {
            throw new UnsupportedOperationException("Deleted group can not be loaded from DB.");
        }
    };

    public UsersGroupsCache(UserDataAccess uda, UserGroupDataAccess ugda, GroupDataAccess gda, int evectionTime, int lrumax) throws IOException {
        this.userDataAccess = uda;
        this.userGroupDataAccess = ugda;
        this.groupDataAccess = gda;
        this.userToGroupsCache = CacheBuilder.newBuilder().maximumSize((long)lrumax).expireAfterWrite((long)evectionTime, TimeUnit.SECONDS).removalListener(this.userToGroupsRemoval).build(this.userToGroupsLoader);
        this.idToUserCache = CacheBuilder.newBuilder().maximumSize((long)lrumax).expireAfterWrite((long)evectionTime, TimeUnit.SECONDS).removalListener(this.idToUserRemoval).build(this.idToUserLoader);
        this.userToIdCache = CacheBuilder.newBuilder().maximumSize((long)lrumax).expireAfterWrite((long)evectionTime, TimeUnit.SECONDS).removalListener(this.userToIdsNameRemoval).build(this.userToIdLoader);
        this.idToGroupCache = CacheBuilder.newBuilder().maximumSize((long)lrumax).expireAfterWrite((long)evectionTime, TimeUnit.SECONDS).removalListener(this.idToGroupsRemoval).build(this.idToGroupLoader);
        this.groupToIdCache = CacheBuilder.newBuilder().maximumSize((long)lrumax).expireAfterWrite((long)evectionTime, TimeUnit.SECONDS).removalListener(this.groupToIdsRemoval).build(this.groupToIdsLoader);
        this.deletedUsersCache = CacheBuilder.newBuilder().maximumSize((long)lrumax).expireAfterWrite((long)evectionTime, TimeUnit.SECONDS).removalListener(this.deletedUsersRemoval).build(this.deletedUsersLoader);
        this.deletedGroupsCache = CacheBuilder.newBuilder().maximumSize((long)lrumax).expireAfterWrite((long)evectionTime, TimeUnit.SECONDS).removalListener(this.deletedGroupRemoval).build(this.deletedGroupLoader);
    }

    public void createSyncRow() throws IOException {
        new LightWeightRequestHandler(UsersOperationsType.CREATE_LOCK_ROWS){

            public Object performTask() throws IOException {
                User user;
                boolean localTx;
                UsersGroupsCache.this.LOG.debug((Object)"Creating UsersGroups Lock Row");
                boolean fail = false;
                boolean bl = localTx = !connector.isTransactionActive();
                if (localTx) {
                    connector.beginTransaction();
                }
                try {
                    user = (User)UsersGroupsCache.this.userDataAccess.getUser(UsersGroupsCache.lockRowName);
                    if (user == null) {
                        user = (User)UsersGroupsCache.this.userDataAccess.addUser(UsersGroupsCache.lockRowName);
                    }
                    if (localTx) {
                        connector.commit();
                    }
                }
                catch (UniqueKeyConstraintViolationException ue) {
                    user = (User)UsersGroupsCache.this.userDataAccess.getUser(UsersGroupsCache.lockRowName);
                    if (localTx) {
                        connector.commit();
                    }
                }
                catch (IOException e) {
                    fail = true;
                    throw e;
                }
                finally {
                    if (fail && localTx) {
                        connector.rollback();
                    }
                }
                lockUser = user;
                return null;
            }
        }.handle();
    }

    private void ugExclusiveLock(StorageConnector connector) throws IOException {
        connector.writeLock();
        User user = null;
        if (lockUser != null) {
            user = (User)this.userDataAccess.getUser(lockUser.getId());
        }
        connector.readCommitted();
        if (user == null) {
            throw new RuntimeException("Hard Error. Users/Groups synchronization row is missing.");
        }
    }

    private void ugSharedLock(StorageConnector connector) throws StorageException {
    }

    public void clear() {
        this.userToGroupsCache.invalidateAll();
        this.idToUserCache.invalidateAll();
        this.userToIdCache.invalidateAll();
        this.idToGroupCache.invalidateAll();
        this.groupToIdCache.invalidateAll();
        this.deletedGroupsCache.invalidateAll();
        this.deletedUsersCache.invalidateAll();
    }

    private User getUserFromDB(final String userName, final Integer userId) throws IOException {
        return (User)new LightWeightRequestHandler(UsersOperationsType.GET_USER){

            public Object performTask() throws IOException {
                boolean localTx;
                UsersGroupsCache.this.LOG.debug((Object)("Get User: " + userName + " from DB."));
                boolean fail = false;
                boolean bl = localTx = !connector.isTransactionActive();
                if (localTx) {
                    connector.beginTransaction();
                }
                try {
                    User user;
                    UsersGroupsCache.this.ugSharedLock(16.connector);
                    User user2 = user = userName == null ? (User)UsersGroupsCache.this.userDataAccess.getUser(userId.intValue()) : (User)UsersGroupsCache.this.userDataAccess.getUser(userName);
                    if (localTx) {
                        connector.commit();
                    }
                    User user3 = user;
                    return user3;
                }
                catch (IOException e) {
                    fail = true;
                    throw e;
                }
                finally {
                    if (fail && localTx) {
                        connector.rollback();
                    }
                }
            }
        }.handle();
    }

    private User addUserToDB(final String userName) throws IOException {
        return (User)new LightWeightRequestHandler(UsersOperationsType.ADD_USER){

            public Object performTask() throws IOException {
                boolean localTx;
                UsersGroupsCache.this.LOG.debug((Object)("Add User: " + userName + " to DB."));
                boolean fail = false;
                boolean bl = localTx = !connector.isTransactionActive();
                if (localTx) {
                    connector.beginTransaction();
                }
                try {
                    UsersGroupsCache.this.ugExclusiveLock(17.connector);
                    User user = (User)UsersGroupsCache.this.userDataAccess.addUser(userName);
                    if (localTx) {
                        connector.commit();
                    }
                    User user2 = user;
                    return user2;
                }
                catch (IOException e) {
                    fail = true;
                    throw e;
                }
                finally {
                    if (fail && localTx) {
                        connector.rollback();
                    }
                }
            }
        }.handle();
    }

    @VisibleForTesting
    protected void removeUserFromDB(final Integer userId) throws IOException {
        new LightWeightRequestHandler(UsersOperationsType.REMOVE_USER){

            public Object performTask() throws IOException {
                boolean localTx;
                UsersGroupsCache.this.LOG.debug((Object)("Remove UserID: " + userId + " from DB."));
                boolean fail = false;
                boolean bl = localTx = !connector.isTransactionActive();
                if (localTx) {
                    connector.beginTransaction();
                }
                try {
                    UsersGroupsCache.this.ugExclusiveLock(18.connector);
                    UsersGroupsCache.this.userDataAccess.removeUser(userId.intValue());
                    if (localTx) {
                        connector.commit();
                    }
                    Object var3_3 = null;
                    return var3_3;
                }
                catch (IOException e) {
                    fail = true;
                    throw e;
                }
                finally {
                    if (fail && localTx) {
                        connector.rollback();
                    }
                }
            }
        }.handle();
    }

    private Group getGroupFromDB(final String groupName, final Integer groupId) throws IOException {
        return (Group)new LightWeightRequestHandler(UsersOperationsType.GET_GROUP){

            public Object performTask() throws IOException {
                boolean localTx;
                UsersGroupsCache.this.LOG.debug((Object)("Get GroupName: " + groupName + " GroupID: " + groupId + " from DB."));
                boolean fail = false;
                boolean bl = localTx = !connector.isTransactionActive();
                if (localTx) {
                    connector.beginTransaction();
                }
                try {
                    Group group;
                    UsersGroupsCache.this.ugSharedLock(19.connector);
                    Group group2 = group = groupName == null ? (Group)UsersGroupsCache.this.groupDataAccess.getGroup(groupId.intValue()) : (Group)UsersGroupsCache.this.groupDataAccess.getGroup(groupName);
                    if (localTx) {
                        connector.commit();
                    }
                    Group group3 = group;
                    return group3;
                }
                catch (IOException e) {
                    fail = true;
                    throw e;
                }
                finally {
                    if (fail && localTx) {
                        connector.rollback();
                    }
                }
            }
        }.handle();
    }

    private Group addGroupToDB(final String groupName) throws IOException {
        return (Group)new LightWeightRequestHandler(UsersOperationsType.ADD_GROUP){

            public Object performTask() throws IOException {
                boolean localTx;
                UsersGroupsCache.this.LOG.debug((Object)("Add Group: " + groupName + " to DB."));
                boolean fail = false;
                boolean bl = localTx = !connector.isTransactionActive();
                if (localTx) {
                    connector.beginTransaction();
                }
                try {
                    UsersGroupsCache.this.ugExclusiveLock(20.connector);
                    Group group = (Group)UsersGroupsCache.this.groupDataAccess.addGroup(groupName);
                    if (localTx) {
                        connector.commit();
                    }
                    Group group2 = group;
                    return group2;
                }
                catch (IOException e) {
                    fail = true;
                    throw e;
                }
                finally {
                    if (fail && localTx) {
                        connector.rollback();
                    }
                }
            }
        }.handle();
    }

    @VisibleForTesting
    protected void removeGroupFromDB(final Integer groupId) throws IOException {
        new LightWeightRequestHandler(UsersOperationsType.REMOVE_GROUP){

            public Object performTask() throws IOException {
                boolean localTx;
                UsersGroupsCache.this.LOG.debug((Object)("Remove GroupID: " + groupId + " from DB."));
                boolean fail = false;
                boolean bl = localTx = !connector.isTransactionActive();
                if (localTx) {
                    connector.beginTransaction();
                }
                try {
                    UsersGroupsCache.this.ugExclusiveLock(21.connector);
                    UsersGroupsCache.this.groupDataAccess.removeGroup(groupId.intValue());
                    if (localTx) {
                        connector.commit();
                    }
                    Object var3_3 = null;
                    return var3_3;
                }
                catch (IOException e) {
                    fail = true;
                    throw e;
                }
                finally {
                    if (fail && localTx) {
                        connector.rollback();
                    }
                }
            }
        }.handle();
    }

    private void removeUserFromGroupDB(final Integer userId, final Integer groupId) throws IOException {
        new LightWeightRequestHandler(UsersOperationsType.REMOVE_USER_FROM_GROUPS){

            public Object performTask() throws IOException {
                boolean localTx;
                UsersGroupsCache.this.LOG.debug((Object)("Removing user from group. UserID: " + userId + " GropuID: " + groupId + "."));
                boolean fail = false;
                boolean bl = localTx = !connector.isTransactionActive();
                if (localTx) {
                    connector.beginTransaction();
                }
                try {
                    UsersGroupsCache.this.ugExclusiveLock(22.connector);
                    UsersGroupsCache.this.userGroupDataAccess.removeUserFromGroup(userId.intValue(), groupId.intValue());
                    if (localTx) {
                        connector.commit();
                    }
                    Object var3_3 = null;
                    return var3_3;
                }
                catch (IOException e) {
                    fail = true;
                    throw e;
                }
                finally {
                    if (fail && localTx) {
                        connector.rollback();
                    }
                }
            }
        }.handle();
    }

    @VisibleForTesting
    public void addUserToGroupDB(final int userId, final int groupId) throws IOException {
        new LightWeightRequestHandler(UsersOperationsType.ADD_USER_TO_GROUPS){

            public Object performTask() throws IOException {
                boolean localTx;
                UsersGroupsCache.this.LOG.debug((Object)("Add user to group. UserID: " + userId + " GroupID: " + groupId + "."));
                boolean fail = false;
                boolean bl = localTx = !connector.isTransactionActive();
                if (localTx) {
                    connector.beginTransaction();
                }
                try {
                    UsersGroupsCache.this.ugExclusiveLock(23.connector);
                    UsersGroupsCache.this.userGroupDataAccess.addUserToGroup(userId, groupId);
                    if (localTx) {
                        connector.commit();
                    }
                    Object var3_3 = null;
                    return var3_3;
                }
                catch (IOException e) {
                    fail = true;
                    if (e instanceof ForeignKeyConstraintViolationException) {
                        User user = UsersGroupsCache.this.getUserFromDB(null, userId);
                        if (user == null) {
                            UsersGroupsCache.this.invCachesUserRemoved(userId);
                            throw new UserNotFoundException("Unable to add UserGroup mapping because user with ID: " + userId + " does not exist.");
                        }
                        Group group = UsersGroupsCache.this.getGroupFromDB(null, groupId);
                        if (group == null) {
                            UsersGroupsCache.this.invCachesGroupRemoved(groupId);
                            throw new GroupNotFoundException("Unable to add UserGroup mapping because group with  ID: " + groupId + " does not exist.");
                        }
                    }
                    throw e;
                }
                finally {
                    if (fail && localTx) {
                        connector.rollback();
                    }
                }
            }
        }.handle();
    }

    private List<Group> getUserGroupsFromDB(final String userName, final Integer userId) throws IOException {
        return (List)new LightWeightRequestHandler(UsersOperationsType.GET_USER_GROUPS){

            public Object performTask() throws IOException {
                boolean localTx;
                List result = null;
                boolean fail = false;
                boolean bl = localTx = !connector.isTransactionActive();
                if (localTx) {
                    connector.beginTransaction();
                }
                try {
                    User user;
                    UsersGroupsCache.this.ugSharedLock(24.connector);
                    User user2 = user = userId == null ? (User)UsersGroupsCache.this.userDataAccess.getUser(userName) : (User)UsersGroupsCache.this.userDataAccess.getUser(userId.intValue());
                    if (user != null) {
                        result = UsersGroupsCache.this.userGroupDataAccess.getGroupsForUser(user.getId());
                    }
                    if (localTx) {
                        connector.commit();
                    }
                    List list = result;
                    return list;
                }
                catch (IOException e) {
                    fail = true;
                    throw e;
                }
                finally {
                    if (fail && localTx) {
                        connector.rollback();
                    }
                }
            }
        }.handle();
    }

    public String getUserName(int userId) throws IOException {
        if (userId == 0) {
            return null;
        }
        try {
            if (this.deletedUsersCache.getIfPresent((Object)userId) != null) {
                throw new UserNotFoundException("User ID: " + userId + " not found.");
            }
            return (String)this.idToUserCache.get((Object)userId);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e);
        }
    }

    public int getUserId(String userName) throws IOException {
        if (userName == null) {
            return 0;
        }
        try {
            return (Integer)this.userToIdCache.get((Object)userName);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e);
        }
    }

    public List<String> getGroups(String user) throws IOException {
        assert (user != null);
        try {
            return (List)this.userToGroupsCache.get((Object)user);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e);
        }
    }

    public int getGroupId(String groupName) throws IOException {
        if (groupName == null) {
            return 0;
        }
        try {
            return (Integer)this.groupToIdCache.get((Object)groupName);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e);
        }
    }

    public String getGroupName(int groupId) throws IOException {
        if (groupId == 0) {
            return null;
        }
        try {
            if (this.deletedGroupsCache.getIfPresent((Object)groupId) != null) {
                throw new GroupNotFoundException("Group ID: " + groupId + " not found.");
            }
            return (String)this.idToGroupCache.get((Object)groupId);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e);
        }
    }

    public Integer addUser(String userName) throws IOException {
        if (userName == null) {
            return null;
        }
        try {
            int id = (Integer)this.userToIdCache.get((Object)userName);
            throw new UserAlreadyExistsException("User: " + userName + " already exists with ID: " + id);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof UserNotFoundException) {
                try {
                    User user = this.addUserToDB(userName);
                    this.updateUserCache(user.getId(), user.getName());
                }
                catch (UniqueKeyConstraintViolationException ue) {
                    throw new UserAlreadyExistsException("User: " + userName + " already exists.");
                }
            } else {
                throw new IOException(e);
            }
            return this.getUserId(userName);
        }
    }

    public Integer addGroup(String groupName) throws IOException {
        if (groupName == null) {
            return null;
        }
        try {
            this.groupToIdCache.get((Object)groupName);
            throw new GroupAlreadyExistsException("Group: " + groupName + " already exists");
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof GroupNotFoundException) {
                try {
                    Group group = this.addGroupToDB(groupName);
                    this.updateGroupCache(group.getId(), group.getName());
                }
                catch (UniqueKeyConstraintViolationException ue) {
                    throw new GroupAlreadyExistsException("Group: " + groupName + " already exists");
                }
            } else {
                throw new IOException(e);
            }
            return this.getGroupId(groupName);
        }
    }

    public void removeUser(String userName) throws IOException {
        if (userName == null) {
            return;
        }
        try {
            int userID = (Integer)this.userToIdCache.get((Object)userName);
            this.LOG.debug((Object)("Remove user from DB name: " + userName));
            this.removeUserFromDB(userID);
            this.invCacheUserRemoved(userID, userName);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof UserNotFoundException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e);
        }
    }

    public void removeGroup(String group) throws IOException {
        assert (group != null);
        this.LOG.debug((Object)("Remove group from DB name: " + group));
        try {
            int groupID = (Integer)this.groupToIdCache.get((Object)group);
            this.removeGroupFromDB(groupID);
            this.invCachesGroupRemoved(groupID, group);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof GroupNotFoundException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e);
        }
    }

    public void addUserToGroups(String user, String[] groups) throws IOException {
        assert (user != null);
        assert (groups != null);
        for (String group : groups) {
            this.addUserToGroup(user, group);
        }
    }

    public void addUserToGroup(String user, String group) throws IOException {
        List availableGroups;
        block7: {
            assert (user != null && group != null);
            this.LOG.debug((Object)("Adding user: " + user + " to Group: " + group));
            availableGroups = Collections.EMPTY_LIST;
            try {
                availableGroups = (List)this.userToGroupsCache.get((Object)user);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof GroupsNotFoundForUserException) break block7;
                throw new IOException(e);
            }
        }
        if (availableGroups.contains(group)) {
            throw new UserAlreadyInGroupException("User: " + user + " is already part of Group: " + group + ".");
        }
        try {
            int userID = (Integer)this.userToIdCache.get((Object)user);
            int groupID = (Integer)this.groupToIdCache.get((Object)group);
            this.addUserToGroupDB(userID, groupID);
            this.invCacheUserAddedToGroup(user, group);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof UserNotFoundException || e.getCause() instanceof GroupNotFoundException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e);
        }
    }

    public void removeUserFromGroup(String user, String group) throws IOException {
        if (user == null || group == null) {
            return;
        }
        this.LOG.debug((Object)("Remove user-group from DB user: " + user + ", group: " + group));
        try {
            int userId = (Integer)this.userToIdCache.get((Object)user);
            int groupId = (Integer)this.groupToIdCache.get((Object)group);
            this.removeUserFromGroupDB(userId, groupId);
            this.invCachesUserRemovedFromGroup(user, group);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof UserNotFoundException || e.getCause() instanceof GroupNotFoundException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e);
        }
    }

    private void invCachesGroupRemoved(int groupID) {
        String groupName = null;
        try {
            groupName = (String)this.idToGroupCache.get((Object)groupID);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        this.invCachesGroupRemoved(groupID, groupName);
    }

    protected void invCachesGroupRemoved(String group) throws IOException {
        int groupID = 0;
        try {
            groupID = this.getGroupId(group);
        }
        catch (GroupNotFoundException groupNotFoundException) {
            // empty catch block
        }
        this.invCachesGroupRemoved(groupID, group);
    }

    private void invCachesGroupRemoved(int groupId, String groupName) {
        if (groupId != 0) {
            this.idToGroupCache.invalidate((Object)groupId);
        }
        if (groupName != null) {
            this.groupToIdCache.invalidate((Object)groupName);
            ConcurrentMap u2gMap = this.userToGroupsCache.asMap();
            for (String user : u2gMap.keySet()) {
                if (!((List)u2gMap.get(user)).contains(groupName)) continue;
                this.userToGroupsCache.invalidate((Object)user);
            }
        }
    }

    private void invCachesUserRemoved(int userID) {
        String userName = null;
        try {
            userName = (String)this.idToUserCache.get((Object)userID);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        this.invCacheUserRemoved(userID, userName);
    }

    protected void invCacheUserRemoved(String user) throws IOException {
        assert (user != null);
        int userID = 0;
        try {
            userID = this.getUserId(user);
        }
        catch (UserNotFoundException userNotFoundException) {
            // empty catch block
        }
        this.invCacheUserRemoved(userID, user);
    }

    private void invCacheUserRemoved(int userId, String userName) {
        if (userId != 0) {
            this.idToUserCache.invalidate((Object)userId);
        }
        if (userName != null) {
            this.userToIdCache.invalidate((Object)userName);
            this.userToGroupsCache.invalidate((Object)userName);
        }
    }

    protected void invCachesUserRemovedFromGroup(String user, String group) {
        this.userToGroupsCache.invalidate((Object)user);
    }

    protected void invCacheUserAddedToGroup(String user, String group) {
        this.userToGroupsCache.invalidate((Object)user);
    }

    private void updateGroupCache(Integer groupID, String groupName) {
        this.idToGroupCache.put((Object)groupID, (Object)groupName);
        this.groupToIdCache.put((Object)groupName, (Object)groupID);
    }

    private void updateUserCache(Integer userID, String userName) {
        this.idToUserCache.put((Object)userID, (Object)userName);
        this.userToIdCache.put((Object)userName, (Object)userID);
    }

    private static enum UsersOperationsType implements RequestHandler.OperationType
    {
        ADD_USER,
        REMOVE_USER,
        ADD_GROUP,
        REMOVE_GROUP,
        GET_USER_GROUPS,
        GET_USER,
        GET_GROUP,
        ADD_USER_TO_GROUPS,
        REMOVE_USER_FROM_GROUPS,
        CREATE_LOCK_ROWS;

    }
}

