/*
 * Decompiled with CFR 0.152.
 */
package io.hops.security;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.hops.security.AbstractSecurityActions;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.regex.Matcher;
import javax.net.ssl.HostnameVerifier;
import org.apache.commons.math3.util.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;

public abstract class BaseTestHopsworksSecurityActions {
    protected String HOPSWORKS_ENDPOINT = "https://HOST:PORT";
    private String HOPSWORKS_USER = "USERNAME";
    private String HOPSWORKS_PASSWORD = "PASSWORD";
    private String HOPSWORKS_LOGIN_PATH = "/hopsworks-api/api/auth/service";

    protected void setupJWT(Configuration conf, String classpath) throws Exception {
        String sslConfFilename = super.getClass().getSimpleName() + ".ssl-server.xml";
        Path sslServerPath = Paths.get(classpath, sslConfFilename);
        Pair<String, String[]> jwtResponse = this.loginAndGetJWT();
        Configuration sslServer = new Configuration(false);
        sslServer.set("hops.jwt-manager.master-token", (String)jwtResponse.getFirst());
        for (int i = 0; i < ((String[])jwtResponse.getSecond()).length; ++i) {
            String renewalConfKey = String.format("hops.jwt-manager.renew-token-%d", i);
            sslServer.set(renewalConfKey, ((String[])jwtResponse.getSecond())[i]);
        }
        KeyStoreTestUtil.saveConfig(sslServerPath.toFile(), sslServer);
        conf.set("hadoop.ssl.server.conf", sslConfFilename);
        conf.set("hops.hopsworks.host", this.HOPSWORKS_ENDPOINT);
    }

    protected Pair<String, String[]> loginAndGetJWT() throws Exception {
        try (CloseableHttpClient client = null;){
            SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
            sslContextBuilder.loadTrustMaterial(new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    return true;
                }
            });
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContextBuilder.build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            client = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).build();
            URL loginURL = new URL(new URL(this.HOPSWORKS_ENDPOINT), this.HOPSWORKS_LOGIN_PATH);
            HttpUriRequest login = RequestBuilder.post().setUri(loginURL.toURI()).addParameter("email", this.HOPSWORKS_USER).addParameter("password", this.HOPSWORKS_PASSWORD).build();
            CloseableHttpResponse response = client.execute(login);
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
            Header[] authHeaders = response.getHeaders("Authorization");
            String masterJWT = null;
            for (Header h : authHeaders) {
                Matcher matcher = AbstractSecurityActions.JWT_PATTERN.matcher(h.getValue());
                if (!matcher.matches()) continue;
                masterJWT = matcher.group(1);
            }
            JsonParser jsonParser = new JsonParser();
            JsonObject json = jsonParser.parse(EntityUtils.toString((HttpEntity)response.getEntity())).getAsJsonObject();
            JsonArray array = json.getAsJsonArray("renewTokens");
            String[] renewTokens = new String[array.size()];
            boolean renewalTokensFound = false;
            for (int i = 0; i < renewTokens.length; ++i) {
                renewTokens[i] = array.get(i).getAsString();
                renewalTokensFound = true;
            }
            if (masterJWT != null && renewalTokensFound) {
                Pair pair = new Pair((Object)masterJWT, (Object)renewTokens);
                return pair;
            }
            throw new IOException("Could not get JWT from Hopsworks");
        }
    }
}

