/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Random;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.tools.CopyListingFileStatus;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.util.DistCpUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestDistCpUtils {
    private static final Log LOG = LogFactory.getLog(TestDistCpUtils.class);
    private static final Configuration config = new Configuration();
    private static MiniDFSCluster cluster;
    private static final FsPermission fullPerm;
    private static final FsPermission almostFullPerm;
    private static final FsPermission noPerm;
    private static Random rand;

    @BeforeClass
    public static void create() throws IOException {
        cluster = new MiniDFSCluster.Builder(config).numDataNodes(1).format(true).build();
    }

    @AfterClass
    public static void destroy() {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Test
    public void testGetRelativePathRoot() {
        Path root = new Path("/");
        Path child = new Path("/a");
        Assert.assertEquals((Object)DistCpUtils.getRelativePath((Path)root, (Path)child), (Object)"/a");
    }

    @Test
    public void testGetRelativePath() {
        Path root = new Path("/tmp/abc");
        Path child = new Path("/tmp/abc/xyz/file");
        Assert.assertEquals((Object)DistCpUtils.getRelativePath((Path)root, (Path)child), (Object)"/xyz/file");
    }

    @Test
    public void testPackAttributes() {
        EnumSet<DistCpOptions.FileAttribute> attributes = EnumSet.noneOf(DistCpOptions.FileAttribute.class);
        Assert.assertEquals((Object)DistCpUtils.packAttributes(attributes), (Object)"");
        attributes.add(DistCpOptions.FileAttribute.REPLICATION);
        Assert.assertEquals((Object)DistCpUtils.packAttributes(attributes), (Object)"R");
        attributes.add(DistCpOptions.FileAttribute.BLOCKSIZE);
        Assert.assertEquals((Object)DistCpUtils.packAttributes(attributes), (Object)"RB");
        attributes.add(DistCpOptions.FileAttribute.USER);
        attributes.add(DistCpOptions.FileAttribute.CHECKSUMTYPE);
        Assert.assertEquals((Object)DistCpUtils.packAttributes(attributes), (Object)"RBUC");
        attributes.add(DistCpOptions.FileAttribute.GROUP);
        Assert.assertEquals((Object)DistCpUtils.packAttributes(attributes), (Object)"RBUGC");
        attributes.add(DistCpOptions.FileAttribute.PERMISSION);
        Assert.assertEquals((Object)DistCpUtils.packAttributes(attributes), (Object)"RBUGPC");
        attributes.add(DistCpOptions.FileAttribute.TIMES);
        Assert.assertEquals((Object)DistCpUtils.packAttributes(attributes), (Object)"RBUGPCT");
    }

    public void testUnpackAttributes() {
        EnumSet<DistCpOptions.FileAttribute> attributes = EnumSet.allOf(DistCpOptions.FileAttribute.class);
        Assert.assertEquals(attributes, (Object)DistCpUtils.unpackAttributes((String)"RCBUGPAXT"));
        attributes.remove(DistCpOptions.FileAttribute.REPLICATION);
        attributes.remove(DistCpOptions.FileAttribute.CHECKSUMTYPE);
        attributes.remove(DistCpOptions.FileAttribute.ACL);
        attributes.remove(DistCpOptions.FileAttribute.XATTR);
        Assert.assertEquals(attributes, (Object)DistCpUtils.unpackAttributes((String)"BUGPT"));
        attributes.remove(DistCpOptions.FileAttribute.TIMES);
        Assert.assertEquals(attributes, (Object)DistCpUtils.unpackAttributes((String)"BUGP"));
        attributes.remove(DistCpOptions.FileAttribute.BLOCKSIZE);
        Assert.assertEquals(attributes, (Object)DistCpUtils.unpackAttributes((String)"UGP"));
        attributes.remove(DistCpOptions.FileAttribute.GROUP);
        Assert.assertEquals(attributes, (Object)DistCpUtils.unpackAttributes((String)"UP"));
        attributes.remove(DistCpOptions.FileAttribute.USER);
        Assert.assertEquals(attributes, (Object)DistCpUtils.unpackAttributes((String)"P"));
        attributes.remove(DistCpOptions.FileAttribute.PERMISSION);
        Assert.assertEquals(attributes, (Object)DistCpUtils.unpackAttributes((String)""));
    }

    @Test
    public void testPreserveDefaults() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)config);
        EnumSet attributes = DistCpUtils.unpackAttributes((String)"-prbugpct".substring(1));
        Path dst = new Path("/tmp/dest2");
        Path src = new Path("/tmp/src2");
        TestDistCpUtils.createFile(fs, src);
        TestDistCpUtils.createFile(fs, dst);
        fs.setPermission(src, fullPerm);
        fs.setOwner(src, "somebody", "somebody-group");
        fs.setTimes(src, 0L, 0L);
        fs.setReplication(src, (short)1);
        fs.setPermission(dst, noPerm);
        fs.setOwner(dst, "nobody", "nobody-group");
        fs.setTimes(dst, 100L, 100L);
        fs.setReplication(dst, (short)2);
        CopyListingFileStatus srcStatus = new CopyListingFileStatus(fs.getFileStatus(src));
        DistCpUtils.preserve((FileSystem)fs, (Path)dst, (CopyListingFileStatus)srcStatus, (EnumSet)attributes, (boolean)false);
        CopyListingFileStatus dstStatus = new CopyListingFileStatus(fs.getFileStatus(dst));
        Assert.assertTrue((boolean)srcStatus.getPermission().equals((Object)dstStatus.getPermission()));
        Assert.assertTrue((boolean)srcStatus.getOwner().equals(dstStatus.getOwner()));
        Assert.assertTrue((boolean)srcStatus.getGroup().equals(dstStatus.getGroup()));
        Assert.assertTrue((srcStatus.getAccessTime() == dstStatus.getAccessTime() ? 1 : 0) != 0);
        Assert.assertTrue((srcStatus.getModificationTime() == dstStatus.getModificationTime() ? 1 : 0) != 0);
        Assert.assertTrue((srcStatus.getReplication() == dstStatus.getReplication() ? 1 : 0) != 0);
    }

    @Test
    public void testPreserveNothingOnDirectory() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)config);
        EnumSet<DistCpOptions.FileAttribute> attributes = EnumSet.noneOf(DistCpOptions.FileAttribute.class);
        Path dst = new Path("/tmp/abc");
        Path src = new Path("/tmp/src");
        TestDistCpUtils.createDirectory(fs, src);
        TestDistCpUtils.createDirectory(fs, dst);
        fs.setPermission(src, fullPerm);
        fs.setOwner(src, "somebody", "somebody-group");
        fs.setTimes(src, 0L, 0L);
        fs.setPermission(dst, noPerm);
        fs.setOwner(dst, "nobody", "nobody-group");
        fs.setTimes(dst, 100L, 100L);
        CopyListingFileStatus srcStatus = new CopyListingFileStatus(fs.getFileStatus(src));
        DistCpUtils.preserve((FileSystem)fs, (Path)dst, (CopyListingFileStatus)srcStatus, attributes, (boolean)false);
        CopyListingFileStatus dstStatus = new CopyListingFileStatus(fs.getFileStatus(dst));
        Assert.assertFalse((boolean)srcStatus.getPermission().equals((Object)dstStatus.getPermission()));
        Assert.assertFalse((boolean)srcStatus.getOwner().equals(dstStatus.getOwner()));
        Assert.assertFalse((boolean)srcStatus.getGroup().equals(dstStatus.getGroup()));
        Assert.assertTrue((dstStatus.getAccessTime() == 100L ? 1 : 0) != 0);
        Assert.assertTrue((dstStatus.getModificationTime() == 100L ? 1 : 0) != 0);
        Assert.assertTrue((dstStatus.getReplication() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPreservePermissionOnDirectory() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)config);
        EnumSet<DistCpOptions.FileAttribute> attributes = EnumSet.of(DistCpOptions.FileAttribute.PERMISSION);
        Path dst = new Path("/tmp/abc");
        Path src = new Path("/tmp/src");
        TestDistCpUtils.createDirectory(fs, src);
        TestDistCpUtils.createDirectory(fs, dst);
        fs.setPermission(src, fullPerm);
        fs.setOwner(src, "somebody", "somebody-group");
        fs.setPermission(dst, noPerm);
        fs.setOwner(dst, "nobody", "nobody-group");
        CopyListingFileStatus srcStatus = new CopyListingFileStatus(fs.getFileStatus(src));
        DistCpUtils.preserve((FileSystem)fs, (Path)dst, (CopyListingFileStatus)srcStatus, attributes, (boolean)false);
        CopyListingFileStatus dstStatus = new CopyListingFileStatus(fs.getFileStatus(dst));
        Assert.assertTrue((boolean)srcStatus.getPermission().equals((Object)dstStatus.getPermission()));
        Assert.assertFalse((boolean)srcStatus.getOwner().equals(dstStatus.getOwner()));
        Assert.assertFalse((boolean)srcStatus.getGroup().equals(dstStatus.getGroup()));
    }

    @Test
    public void testPreserveGroupOnDirectory() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)config);
        EnumSet<DistCpOptions.FileAttribute> attributes = EnumSet.of(DistCpOptions.FileAttribute.GROUP);
        Path dst = new Path("/tmp/abc");
        Path src = new Path("/tmp/src");
        TestDistCpUtils.createDirectory(fs, src);
        TestDistCpUtils.createDirectory(fs, dst);
        fs.setPermission(src, fullPerm);
        fs.setOwner(src, "somebody", "somebody-group");
        fs.setPermission(dst, noPerm);
        fs.setOwner(dst, "nobody", "nobody-group");
        CopyListingFileStatus srcStatus = new CopyListingFileStatus(fs.getFileStatus(src));
        DistCpUtils.preserve((FileSystem)fs, (Path)dst, (CopyListingFileStatus)srcStatus, attributes, (boolean)false);
        CopyListingFileStatus dstStatus = new CopyListingFileStatus(fs.getFileStatus(dst));
        Assert.assertFalse((boolean)srcStatus.getPermission().equals((Object)dstStatus.getPermission()));
        Assert.assertFalse((boolean)srcStatus.getOwner().equals(dstStatus.getOwner()));
        Assert.assertTrue((boolean)srcStatus.getGroup().equals(dstStatus.getGroup()));
    }

    @Test
    public void testPreserveUserOnDirectory() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)config);
        EnumSet<DistCpOptions.FileAttribute> attributes = EnumSet.of(DistCpOptions.FileAttribute.USER);
        Path dst = new Path("/tmp/abc");
        Path src = new Path("/tmp/src");
        TestDistCpUtils.createDirectory(fs, src);
        TestDistCpUtils.createDirectory(fs, dst);
        fs.setPermission(src, fullPerm);
        fs.setOwner(src, "somebody", "somebody-group");
        fs.setPermission(dst, noPerm);
        fs.setOwner(dst, "nobody", "nobody-group");
        CopyListingFileStatus srcStatus = new CopyListingFileStatus(fs.getFileStatus(src));
        DistCpUtils.preserve((FileSystem)fs, (Path)dst, (CopyListingFileStatus)srcStatus, attributes, (boolean)false);
        CopyListingFileStatus dstStatus = new CopyListingFileStatus(fs.getFileStatus(dst));
        Assert.assertFalse((boolean)srcStatus.getPermission().equals((Object)dstStatus.getPermission()));
        Assert.assertTrue((boolean)srcStatus.getOwner().equals(dstStatus.getOwner()));
        Assert.assertFalse((boolean)srcStatus.getGroup().equals(dstStatus.getGroup()));
    }

    @Test
    public void testPreserveReplicationOnDirectory() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)config);
        EnumSet<DistCpOptions.FileAttribute> attributes = EnumSet.of(DistCpOptions.FileAttribute.REPLICATION);
        Path dst = new Path("/tmp/abc");
        Path src = new Path("/tmp/src");
        TestDistCpUtils.createDirectory(fs, src);
        TestDistCpUtils.createDirectory(fs, dst);
        fs.setPermission(src, fullPerm);
        fs.setOwner(src, "somebody", "somebody-group");
        fs.setReplication(src, (short)1);
        fs.setPermission(dst, noPerm);
        fs.setOwner(dst, "nobody", "nobody-group");
        fs.setReplication(dst, (short)2);
        CopyListingFileStatus srcStatus = new CopyListingFileStatus(fs.getFileStatus(src));
        DistCpUtils.preserve((FileSystem)fs, (Path)dst, (CopyListingFileStatus)srcStatus, attributes, (boolean)false);
        CopyListingFileStatus dstStatus = new CopyListingFileStatus(fs.getFileStatus(dst));
        Assert.assertFalse((boolean)srcStatus.getPermission().equals((Object)dstStatus.getPermission()));
        Assert.assertFalse((boolean)srcStatus.getOwner().equals(dstStatus.getOwner()));
        Assert.assertFalse((boolean)srcStatus.getGroup().equals(dstStatus.getGroup()));
        Assert.assertTrue((srcStatus.getReplication() == dstStatus.getReplication() ? 1 : 0) != 0);
    }

    @Test
    public void testPreserveTimestampOnDirectory() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)config);
        EnumSet<DistCpOptions.FileAttribute> attributes = EnumSet.of(DistCpOptions.FileAttribute.TIMES);
        Path dst = new Path("/tmp/abc");
        Path src = new Path("/tmp/src");
        TestDistCpUtils.createDirectory(fs, src);
        TestDistCpUtils.createDirectory(fs, dst);
        fs.setPermission(src, fullPerm);
        fs.setOwner(src, "somebody", "somebody-group");
        fs.setTimes(src, 0L, 0L);
        fs.setPermission(dst, noPerm);
        fs.setOwner(dst, "nobody", "nobody-group");
        fs.setTimes(dst, 100L, 100L);
        CopyListingFileStatus srcStatus = new CopyListingFileStatus(fs.getFileStatus(src));
        DistCpUtils.preserve((FileSystem)fs, (Path)dst, (CopyListingFileStatus)srcStatus, attributes, (boolean)false);
        CopyListingFileStatus dstStatus = new CopyListingFileStatus(fs.getFileStatus(dst));
        Assert.assertFalse((boolean)srcStatus.getPermission().equals((Object)dstStatus.getPermission()));
        Assert.assertFalse((boolean)srcStatus.getOwner().equals(dstStatus.getOwner()));
        Assert.assertFalse((boolean)srcStatus.getGroup().equals(dstStatus.getGroup()));
        Assert.assertTrue((srcStatus.getAccessTime() == dstStatus.getAccessTime() ? 1 : 0) != 0);
        Assert.assertTrue((srcStatus.getModificationTime() == dstStatus.getModificationTime() ? 1 : 0) != 0);
    }

    @Test
    public void testPreserveNothingOnFile() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)config);
        EnumSet<DistCpOptions.FileAttribute> attributes = EnumSet.noneOf(DistCpOptions.FileAttribute.class);
        Path dst = new Path("/tmp/dest2");
        Path src = new Path("/tmp/src2");
        TestDistCpUtils.createFile(fs, src);
        TestDistCpUtils.createFile(fs, dst);
        fs.setPermission(src, fullPerm);
        fs.setOwner(src, "somebody", "somebody-group");
        fs.setTimes(src, 0L, 0L);
        fs.setReplication(src, (short)1);
        fs.setPermission(dst, noPerm);
        fs.setOwner(dst, "nobody", "nobody-group");
        fs.setTimes(dst, 100L, 100L);
        fs.setReplication(dst, (short)2);
        CopyListingFileStatus srcStatus = new CopyListingFileStatus(fs.getFileStatus(src));
        DistCpUtils.preserve((FileSystem)fs, (Path)dst, (CopyListingFileStatus)srcStatus, attributes, (boolean)false);
        CopyListingFileStatus dstStatus = new CopyListingFileStatus(fs.getFileStatus(dst));
        Assert.assertFalse((boolean)srcStatus.getPermission().equals((Object)dstStatus.getPermission()));
        Assert.assertFalse((boolean)srcStatus.getOwner().equals(dstStatus.getOwner()));
        Assert.assertFalse((boolean)srcStatus.getGroup().equals(dstStatus.getGroup()));
        Assert.assertFalse((srcStatus.getAccessTime() == dstStatus.getAccessTime() ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getModificationTime() == dstStatus.getModificationTime() ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getReplication() == dstStatus.getReplication() ? 1 : 0) != 0);
    }

    @Test
    public void testPreservePermissionOnFile() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)config);
        EnumSet<DistCpOptions.FileAttribute> attributes = EnumSet.of(DistCpOptions.FileAttribute.PERMISSION);
        Path dst = new Path("/tmp/dest2");
        Path src = new Path("/tmp/src2");
        TestDistCpUtils.createFile(fs, src);
        TestDistCpUtils.createFile(fs, dst);
        fs.setPermission(src, fullPerm);
        fs.setOwner(src, "somebody", "somebody-group");
        fs.setTimes(src, 0L, 0L);
        fs.setReplication(src, (short)1);
        fs.setPermission(dst, noPerm);
        fs.setOwner(dst, "nobody", "nobody-group");
        fs.setTimes(dst, 100L, 100L);
        fs.setReplication(dst, (short)2);
        CopyListingFileStatus srcStatus = new CopyListingFileStatus(fs.getFileStatus(src));
        DistCpUtils.preserve((FileSystem)fs, (Path)dst, (CopyListingFileStatus)srcStatus, attributes, (boolean)false);
        CopyListingFileStatus dstStatus = new CopyListingFileStatus(fs.getFileStatus(dst));
        Assert.assertTrue((boolean)srcStatus.getPermission().equals((Object)dstStatus.getPermission()));
        Assert.assertFalse((boolean)srcStatus.getOwner().equals(dstStatus.getOwner()));
        Assert.assertFalse((boolean)srcStatus.getGroup().equals(dstStatus.getGroup()));
        Assert.assertFalse((srcStatus.getAccessTime() == dstStatus.getAccessTime() ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getModificationTime() == dstStatus.getModificationTime() ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getReplication() == dstStatus.getReplication() ? 1 : 0) != 0);
    }

    @Test
    public void testPreserveGroupOnFile() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)config);
        EnumSet<DistCpOptions.FileAttribute> attributes = EnumSet.of(DistCpOptions.FileAttribute.GROUP);
        Path dst = new Path("/tmp/dest2");
        Path src = new Path("/tmp/src2");
        TestDistCpUtils.createFile(fs, src);
        TestDistCpUtils.createFile(fs, dst);
        fs.setPermission(src, fullPerm);
        fs.setOwner(src, "somebody", "somebody-group");
        fs.setTimes(src, 0L, 0L);
        fs.setReplication(src, (short)1);
        fs.setPermission(dst, noPerm);
        fs.setOwner(dst, "nobody", "nobody-group");
        fs.setTimes(dst, 100L, 100L);
        fs.setReplication(dst, (short)2);
        CopyListingFileStatus srcStatus = new CopyListingFileStatus(fs.getFileStatus(src));
        DistCpUtils.preserve((FileSystem)fs, (Path)dst, (CopyListingFileStatus)srcStatus, attributes, (boolean)false);
        CopyListingFileStatus dstStatus = new CopyListingFileStatus(fs.getFileStatus(dst));
        Assert.assertFalse((boolean)srcStatus.getPermission().equals((Object)dstStatus.getPermission()));
        Assert.assertFalse((boolean)srcStatus.getOwner().equals(dstStatus.getOwner()));
        Assert.assertTrue((boolean)srcStatus.getGroup().equals(dstStatus.getGroup()));
        Assert.assertFalse((srcStatus.getAccessTime() == dstStatus.getAccessTime() ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getModificationTime() == dstStatus.getModificationTime() ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getReplication() == dstStatus.getReplication() ? 1 : 0) != 0);
    }

    @Test
    public void testPreserveUserOnFile() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)config);
        EnumSet<DistCpOptions.FileAttribute> attributes = EnumSet.of(DistCpOptions.FileAttribute.USER);
        Path dst = new Path("/tmp/dest2");
        Path src = new Path("/tmp/src2");
        TestDistCpUtils.createFile(fs, src);
        TestDistCpUtils.createFile(fs, dst);
        fs.setPermission(src, fullPerm);
        fs.setOwner(src, "somebody", "somebody-group");
        fs.setTimes(src, 0L, 0L);
        fs.setReplication(src, (short)1);
        fs.setPermission(dst, noPerm);
        fs.setOwner(dst, "nobody", "nobody-group");
        fs.setTimes(dst, 100L, 100L);
        fs.setReplication(dst, (short)2);
        CopyListingFileStatus srcStatus = new CopyListingFileStatus(fs.getFileStatus(src));
        DistCpUtils.preserve((FileSystem)fs, (Path)dst, (CopyListingFileStatus)srcStatus, attributes, (boolean)false);
        CopyListingFileStatus dstStatus = new CopyListingFileStatus(fs.getFileStatus(dst));
        Assert.assertFalse((boolean)srcStatus.getPermission().equals((Object)dstStatus.getPermission()));
        Assert.assertTrue((boolean)srcStatus.getOwner().equals(dstStatus.getOwner()));
        Assert.assertFalse((boolean)srcStatus.getGroup().equals(dstStatus.getGroup()));
        Assert.assertFalse((srcStatus.getAccessTime() == dstStatus.getAccessTime() ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getModificationTime() == dstStatus.getModificationTime() ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getReplication() == dstStatus.getReplication() ? 1 : 0) != 0);
    }

    @Test
    public void testPreserveReplicationOnFile() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)config);
        EnumSet<DistCpOptions.FileAttribute> attributes = EnumSet.of(DistCpOptions.FileAttribute.REPLICATION);
        Path dst = new Path("/tmp/dest2");
        Path src = new Path("/tmp/src2");
        TestDistCpUtils.createFile(fs, src);
        TestDistCpUtils.createFile(fs, dst);
        fs.setPermission(src, fullPerm);
        fs.setOwner(src, "somebody", "somebody-group");
        fs.setTimes(src, 0L, 0L);
        fs.setReplication(src, (short)1);
        fs.setPermission(dst, noPerm);
        fs.setOwner(dst, "nobody", "nobody-group");
        fs.setTimes(dst, 100L, 100L);
        fs.setReplication(dst, (short)2);
        CopyListingFileStatus srcStatus = new CopyListingFileStatus(fs.getFileStatus(src));
        DistCpUtils.preserve((FileSystem)fs, (Path)dst, (CopyListingFileStatus)srcStatus, attributes, (boolean)false);
        CopyListingFileStatus dstStatus = new CopyListingFileStatus(fs.getFileStatus(dst));
        Assert.assertFalse((boolean)srcStatus.getPermission().equals((Object)dstStatus.getPermission()));
        Assert.assertFalse((boolean)srcStatus.getOwner().equals(dstStatus.getOwner()));
        Assert.assertFalse((boolean)srcStatus.getGroup().equals(dstStatus.getGroup()));
        Assert.assertFalse((srcStatus.getAccessTime() == dstStatus.getAccessTime() ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getModificationTime() == dstStatus.getModificationTime() ? 1 : 0) != 0);
        Assert.assertTrue((srcStatus.getReplication() == dstStatus.getReplication() ? 1 : 0) != 0);
    }

    @Test
    public void testPreserveTimestampOnFile() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)config);
        EnumSet<DistCpOptions.FileAttribute> attributes = EnumSet.of(DistCpOptions.FileAttribute.TIMES);
        Path dst = new Path("/tmp/dest2");
        Path src = new Path("/tmp/src2");
        TestDistCpUtils.createFile(fs, src);
        TestDistCpUtils.createFile(fs, dst);
        fs.setPermission(src, fullPerm);
        fs.setOwner(src, "somebody", "somebody-group");
        fs.setTimes(src, 0L, 0L);
        fs.setReplication(src, (short)1);
        fs.setPermission(dst, noPerm);
        fs.setOwner(dst, "nobody", "nobody-group");
        fs.setTimes(dst, 100L, 100L);
        fs.setReplication(dst, (short)2);
        CopyListingFileStatus srcStatus = new CopyListingFileStatus(fs.getFileStatus(src));
        DistCpUtils.preserve((FileSystem)fs, (Path)dst, (CopyListingFileStatus)srcStatus, attributes, (boolean)false);
        CopyListingFileStatus dstStatus = new CopyListingFileStatus(fs.getFileStatus(dst));
        Assert.assertFalse((boolean)srcStatus.getPermission().equals((Object)dstStatus.getPermission()));
        Assert.assertFalse((boolean)srcStatus.getOwner().equals(dstStatus.getOwner()));
        Assert.assertFalse((boolean)srcStatus.getGroup().equals(dstStatus.getGroup()));
        Assert.assertTrue((srcStatus.getAccessTime() == dstStatus.getAccessTime() ? 1 : 0) != 0);
        Assert.assertTrue((srcStatus.getModificationTime() == dstStatus.getModificationTime() ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getReplication() == dstStatus.getReplication() ? 1 : 0) != 0);
    }

    public static String createTestSetup(FileSystem fs) throws IOException {
        return TestDistCpUtils.createTestSetup("/tmp1", fs, FsPermission.getDefault());
    }

    public static String createTestSetup(FileSystem fs, FsPermission perm) throws IOException {
        return TestDistCpUtils.createTestSetup("/tmp1", fs, perm);
    }

    public static String createTestSetup(String baseDir, FileSystem fs, FsPermission perm) throws IOException {
        String base = TestDistCpUtils.getBase(baseDir);
        fs.mkdirs(new Path(base + "/newTest/hello/world1"));
        fs.mkdirs(new Path(base + "/newTest/hello/world2/newworld"));
        fs.mkdirs(new Path(base + "/newTest/hello/world3/oldworld"));
        fs.setPermission(new Path(base + "/newTest"), perm);
        fs.setPermission(new Path(base + "/newTest/hello"), perm);
        fs.setPermission(new Path(base + "/newTest/hello/world1"), perm);
        fs.setPermission(new Path(base + "/newTest/hello/world2"), perm);
        fs.setPermission(new Path(base + "/newTest/hello/world2/newworld"), perm);
        fs.setPermission(new Path(base + "/newTest/hello/world3"), perm);
        fs.setPermission(new Path(base + "/newTest/hello/world3/oldworld"), perm);
        TestDistCpUtils.createFile(fs, new Path(base, "/newTest/1"));
        TestDistCpUtils.createFile(fs, new Path(base, "/newTest/hello/2"));
        TestDistCpUtils.createFile(fs, new Path(base, "/newTest/hello/world3/oldworld/3"));
        TestDistCpUtils.createFile(fs, new Path(base, "/newTest/hello/world2/4"));
        return base;
    }

    private static String getBase(String base) {
        String location = String.valueOf(rand.nextLong());
        return base + "/" + location;
    }

    public static void delete(FileSystem fs, String path) {
        try {
            if (fs != null && path != null) {
                fs.delete(new Path(path), true);
            }
        }
        catch (IOException e) {
            LOG.warn((Object)"Exception encountered ", (Throwable)e);
        }
    }

    public static void createFile(FileSystem fs, String filePath) throws IOException {
        Path path = new Path(filePath);
        TestDistCpUtils.createFile(fs, path);
    }

    public static void createFile(FileSystem fs, Path filePath) throws IOException {
        FSDataOutputStream out = fs.create(filePath, true);
        IOUtils.closeStream((Closeable)out);
    }

    public static void createDirectory(FileSystem fs, Path dirPath) throws IOException {
        fs.delete(dirPath, true);
        boolean created = fs.mkdirs(dirPath);
        if (!created) {
            LOG.warn((Object)("Could not create directory " + dirPath + " this might cause test failures."));
        }
    }

    public static boolean checkIfFoldersAreInSync(FileSystem fs, String targetBase, String sourceBase) throws IOException {
        Path base = new Path(targetBase);
        Stack<Path> stack = new Stack<Path>();
        stack.push(base);
        while (!stack.isEmpty()) {
            FileStatus[] fStatus;
            Path file = (Path)stack.pop();
            if (!fs.exists(file) || (fStatus = fs.listStatus(file)) == null || fStatus.length == 0) continue;
            for (FileStatus status : fStatus) {
                if (status.isDirectory()) {
                    stack.push(status.getPath());
                }
                Assert.assertTrue((boolean)fs.exists(new Path(sourceBase + "/" + DistCpUtils.getRelativePath((Path)new Path(targetBase), (Path)status.getPath()))));
            }
        }
        return true;
    }

    static {
        fullPerm = new FsPermission(777);
        almostFullPerm = new FsPermission(666);
        noPerm = new FsPermission(0);
        rand = new Random();
    }
}

