/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.tools.DistCp;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class TestDistCpSystem {
    @Rule
    public Timeout globalTimeout = new Timeout(30000);
    private static final String SRCDAT = "srcdat";
    private static final String DSTDAT = "dstdat";
    private static MiniDFSCluster cluster;
    private static Configuration conf;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFiles(FileSystem fs, String topdir, FileEntry[] entries) throws IOException {
        for (FileEntry entry : entries) {
            Path newpath = new Path(topdir + "/" + entry.getPath());
            if (entry.isDirectory()) {
                fs.mkdirs(newpath);
                continue;
            }
            try (FSDataOutputStream out = fs.create(newpath);){
                out.write((topdir + "/" + entry).getBytes());
                out.write("\n".getBytes());
            }
        }
    }

    private static FileStatus[] getFileStatus(FileSystem fs, String topdir, FileEntry[] files) throws IOException {
        Path root = new Path(topdir);
        ArrayList<FileStatus> statuses = new ArrayList<FileStatus>();
        for (int idx = 0; idx < files.length; ++idx) {
            Path newpath = new Path(root, files[idx].getPath());
            statuses.add(fs.getFileStatus(newpath));
        }
        return statuses.toArray(new FileStatus[statuses.size()]);
    }

    private static void deldir(FileSystem fs, String topdir) throws IOException {
        fs.delete(new Path(topdir), true);
    }

    private void testPreserveUserHelper(String testRoot, FileEntry[] srcEntries, FileEntry[] dstEntries, boolean createSrcDir, boolean createTgtDir, boolean update) throws Exception {
        String[] stringArray;
        String testSrcRel = SRCDAT;
        String testSrc = testRoot + "/" + SRCDAT;
        String testDstRel = DSTDAT;
        String testDst = testRoot + "/" + DSTDAT;
        String nnUri = FileSystem.getDefaultUri((Configuration)conf).toString();
        FileSystem fs = FileSystem.get((URI)URI.create(nnUri), (Configuration)conf);
        fs.mkdirs(new Path(testRoot));
        if (createSrcDir) {
            fs.mkdirs(new Path(testSrc));
        }
        if (createTgtDir) {
            fs.mkdirs(new Path(testDst));
        }
        this.createFiles(fs, testRoot, srcEntries);
        FileStatus[] srcstats = TestDistCpSystem.getFileStatus(fs, testRoot, srcEntries);
        for (int i = 0; i < srcEntries.length; ++i) {
            fs.setOwner(srcstats[i].getPath(), "u" + i, null);
        }
        if (update) {
            String[] stringArray2 = new String[4];
            stringArray2[0] = "-pu";
            stringArray2[1] = "-update";
            stringArray2[2] = nnUri + testSrc;
            stringArray = stringArray2;
            stringArray2[3] = nnUri + testDst;
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "-pu";
            stringArray3[1] = nnUri + testSrc;
            stringArray = stringArray3;
            stringArray3[2] = nnUri + testDst;
        }
        String[] args = stringArray;
        ToolRunner.run((Configuration)conf, (Tool)new DistCp(), (String[])args);
        String realTgtPath = testDst;
        if (!createTgtDir) {
            realTgtPath = testRoot;
        }
        FileStatus[] dststat = TestDistCpSystem.getFileStatus(fs, realTgtPath, dstEntries);
        for (int i = 0; i < dststat.length; ++i) {
            Assert.assertEquals((String)("i=" + i), (Object)("u" + i), (Object)dststat[i].getOwner());
        }
        TestDistCpSystem.deldir(fs, testRoot);
    }

    @BeforeClass
    public static void beforeClass() throws IOException {
        conf = new Configuration();
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
        cluster.waitActive();
    }

    @AfterClass
    public static void afterClass() throws IOException {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Test
    public void testPreserveUseNonEmptyDir() throws Exception {
        String testRoot = "/testdir." + GenericTestUtils.getMethodName();
        FileEntry[] srcfiles = new FileEntry[]{new FileEntry(SRCDAT, true), new FileEntry("srcdat/a", false), new FileEntry("srcdat/b", true), new FileEntry("srcdat/b/c", false)};
        FileEntry[] dstfiles = new FileEntry[]{new FileEntry(DSTDAT, true), new FileEntry("dstdat/a", false), new FileEntry("dstdat/b", true), new FileEntry("dstdat/b/c", false)};
        this.testPreserveUserHelper(testRoot, srcfiles, srcfiles, false, true, false);
        this.testPreserveUserHelper(testRoot, srcfiles, dstfiles, false, false, false);
    }

    @Test
    public void testPreserveUserEmptyDir() throws Exception {
        String testRoot = "/testdir." + GenericTestUtils.getMethodName();
        FileEntry[] srcfiles = new FileEntry[]{new FileEntry(SRCDAT, true)};
        FileEntry[] dstfiles = new FileEntry[]{new FileEntry(DSTDAT, true)};
        this.testPreserveUserHelper(testRoot, srcfiles, srcfiles, false, true, false);
        this.testPreserveUserHelper(testRoot, srcfiles, dstfiles, false, false, false);
    }

    @Test
    public void testPreserveUserSingleFile() throws Exception {
        String testRoot = "/testdir." + GenericTestUtils.getMethodName();
        FileEntry[] srcfiles = new FileEntry[]{new FileEntry(SRCDAT, false)};
        FileEntry[] dstfiles = new FileEntry[]{new FileEntry(DSTDAT, false)};
        this.testPreserveUserHelper(testRoot, srcfiles, srcfiles, false, true, false);
        this.testPreserveUserHelper(testRoot, srcfiles, dstfiles, false, false, false);
    }

    @Test
    public void testPreserveUserNonEmptyDirWithUpdate() throws Exception {
        String testRoot = "/testdir." + GenericTestUtils.getMethodName();
        FileEntry[] srcfiles = new FileEntry[]{new FileEntry("srcdat/a", false), new FileEntry("srcdat/b", true), new FileEntry("srcdat/b/c", false)};
        FileEntry[] dstfiles = new FileEntry[]{new FileEntry("a", false), new FileEntry("b", true), new FileEntry("b/c", false)};
        this.testPreserveUserHelper(testRoot, srcfiles, dstfiles, true, true, true);
    }

    @Test
    public void testSourceRoot() throws Exception {
        DistributedFileSystem fs = cluster.getFileSystem();
        String rootStr = fs.makeQualified(new Path("/")).toString();
        String testRoot = "/testdir." + GenericTestUtils.getMethodName();
        Path tgtPath = new Path(testRoot + "/nodir");
        String tgtStr = fs.makeQualified(tgtPath).toString();
        String[] args = new String[]{rootStr, tgtStr};
        Assert.assertThat((Object)ToolRunner.run((Configuration)conf, (Tool)new DistCp(), (String[])args), (Matcher)Is.is((Object)0));
        Path tgtPath2 = new Path(testRoot + "/dir");
        Assert.assertTrue((boolean)fs.mkdirs(tgtPath2));
        String tgtStr2 = fs.makeQualified(tgtPath2).toString();
        String[] args2 = new String[]{rootStr, tgtStr2};
        Assert.assertThat((Object)ToolRunner.run((Configuration)conf, (Tool)new DistCp(), (String[])args2), (Matcher)Is.is((Object)0));
    }

    private class FileEntry {
        String path;
        boolean isDir;

        public FileEntry(String path, boolean isDir) {
            this.path = path;
            this.isDir = isDir;
        }

        String getPath() {
            return this.path;
        }

        boolean isDirectory() {
            return this.isDir;
        }
    }
}

