/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.Closeable;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.tools.CopyListingFileStatus;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.GlobbedCopyListing;
import org.apache.hadoop.tools.util.DistCpUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestGlobbedCopyListing {
    private static MiniDFSCluster cluster;
    private static final Credentials CREDENTIALS;
    public static Map<String, String> expectedValues;

    @BeforeClass
    public static void setup() throws Exception {
        cluster = new MiniDFSCluster.Builder(new Configuration()).build();
        TestGlobbedCopyListing.createSourceData();
    }

    private static void createSourceData() throws Exception {
        TestGlobbedCopyListing.mkdirs("/tmp/source/1");
        TestGlobbedCopyListing.mkdirs("/tmp/source/2");
        TestGlobbedCopyListing.mkdirs("/tmp/source/2/3");
        TestGlobbedCopyListing.mkdirs("/tmp/source/2/3/4");
        TestGlobbedCopyListing.mkdirs("/tmp/source/5");
        TestGlobbedCopyListing.touchFile("/tmp/source/5/6");
        TestGlobbedCopyListing.mkdirs("/tmp/source/7");
        TestGlobbedCopyListing.mkdirs("/tmp/source/7/8");
        TestGlobbedCopyListing.touchFile("/tmp/source/7/8/9");
    }

    private static void mkdirs(String path) throws Exception {
        DistributedFileSystem fileSystem = null;
        try {
            fileSystem = cluster.getFileSystem();
            fileSystem.mkdirs(new Path(path));
            TestGlobbedCopyListing.recordInExpectedValues(path);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{fileSystem});
            throw throwable;
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{fileSystem});
    }

    private static void touchFile(String path) throws Exception {
        DistributedFileSystem fileSystem = null;
        FSDataOutputStream outputStream = null;
        try {
            fileSystem = cluster.getFileSystem();
            outputStream = fileSystem.create(new Path(path), true, 0);
            TestGlobbedCopyListing.recordInExpectedValues(path);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{fileSystem, outputStream});
            throw throwable;
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{fileSystem, outputStream});
    }

    private static void recordInExpectedValues(String path) throws Exception {
        DistributedFileSystem fileSystem = cluster.getFileSystem();
        Path sourcePath = new Path(fileSystem.getUri().toString() + path);
        expectedValues.put(sourcePath.toString(), DistCpUtils.getRelativePath((Path)new Path("/tmp/source"), (Path)sourcePath));
    }

    @AfterClass
    public static void tearDown() {
        cluster.shutdown();
    }

    @Test
    public void testRun() throws Exception {
        URI uri = cluster.getFileSystem().getUri();
        String pathString = uri.toString();
        Path fileSystemPath = new Path(pathString);
        Path source = new Path(fileSystemPath.toString() + "/tmp/source");
        Path target = new Path(fileSystemPath.toString() + "/tmp/target");
        Path listingPath = new Path(fileSystemPath.toString() + "/tmp/META/fileList.seq");
        DistCpOptions options = new DistCpOptions(Arrays.asList(source), target);
        options.setTargetPathExists(false);
        new GlobbedCopyListing(new Configuration(), CREDENTIALS).buildListing(listingPath, options);
        this.verifyContents(listingPath);
    }

    private void verifyContents(Path listingPath) throws Exception {
        SequenceFile.Reader reader = new SequenceFile.Reader((FileSystem)cluster.getFileSystem(), listingPath, new Configuration());
        Text key = new Text();
        CopyListingFileStatus value = new CopyListingFileStatus();
        HashMap<String, String> actualValues = new HashMap<String, String>();
        while (reader.next((Writable)key, (Writable)value)) {
            if (value.isDirectory() && key.toString().equals("")) continue;
            actualValues.put(value.getPath().toString(), key.toString());
        }
        Assert.assertEquals((long)expectedValues.size(), (long)actualValues.size());
        for (Map.Entry entry : actualValues.entrySet()) {
            Assert.assertEquals(entry.getValue(), (Object)expectedValues.get(entry.getKey()));
        }
    }

    static {
        CREDENTIALS = new Credentials();
        expectedValues = new HashMap<String, String>();
    }
}

