/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.contract;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.contract.AbstractFSContractTestBase;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.tools.CopyListingFileStatus;
import org.apache.hadoop.tools.DistCp;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.mapred.CopyMapper;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractContractDistCpTest
extends AbstractFSContractTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractContractDistCpTest.class);
    public static final String SCALE_TEST_DISTCP_FILE_SIZE_KB = "scale.test.distcp.file.size.kb";
    public static final int DEFAULT_DISTCP_SIZE_KB = 1024;
    protected static final int MB = 0x100000;
    @Rule
    public TestName testName = new TestName();
    private Configuration conf;
    private FileSystem localFS;
    private FileSystem remoteFS;
    private Path localDir;
    private Path remoteDir;
    private Path inputDir;
    private Path inputSubDir1;
    private Path inputSubDir2;
    private Path inputSubDir4;
    private Path inputFile1;
    private Path inputFile2;
    private Path inputFile3;
    private Path inputFile4;
    private Path inputFile5;
    private Path outputDir;
    private Path outputSubDir1;
    private Path outputSubDir2;
    private Path outputSubDir4;
    private Path outputFile1;
    private Path outputFile2;
    private Path outputFile3;
    private Path outputFile4;
    private Path outputFile5;
    private Path inputDirUnderOutputDir;

    protected int getTestTimeoutMillis() {
        return 900000;
    }

    protected Configuration createConfiguration() {
        Configuration newConf = new Configuration();
        newConf.set("mapred.job.tracker", "local");
        return newConf;
    }

    @Before
    public void setup() throws Exception {
        super.setup();
        this.conf = this.getContract().getConf();
        this.localFS = FileSystem.getLocal((Configuration)this.conf);
        this.remoteFS = this.getFileSystem();
        String className = ((Object)((Object)this)).getClass().getSimpleName();
        String testSubDir = className + "/" + this.testName.getMethodName();
        this.localDir = this.localFS.makeQualified(new Path(new Path(GenericTestUtils.getTestDir().toURI()), testSubDir + "/local"));
        AbstractContractDistCpTest.mkdirs(this.localFS, this.localDir);
        this.remoteDir = this.path(testSubDir + "/remote");
        AbstractContractDistCpTest.mkdirs(this.remoteFS, this.remoteDir);
        this.remoteFS.delete(this.remoteDir, true);
        this.localFS.delete(this.localDir, true);
    }

    protected void initPathFields(Path src, Path dest) {
        this.initInputFields(src);
        this.initOutputFields(dest);
    }

    protected void initOutputFields(Path path) {
        this.outputDir = new Path(path, "outputDir");
        this.inputDirUnderOutputDir = new Path(this.outputDir, "inputDir");
        this.outputFile1 = new Path(this.inputDirUnderOutputDir, "file1");
        this.outputSubDir1 = new Path(this.inputDirUnderOutputDir, "subDir1");
        this.outputFile2 = new Path(this.outputSubDir1, "file2");
        this.outputSubDir2 = new Path(this.inputDirUnderOutputDir, "subDir2/subDir2");
        this.outputFile3 = new Path(this.outputSubDir2, "file3");
        this.outputSubDir4 = new Path(this.inputDirUnderOutputDir, "subDir4/subDir4");
        this.outputFile4 = new Path(this.outputSubDir4, "file4");
        this.outputFile5 = new Path(this.outputSubDir4, "file5");
    }

    protected void initInputFields(Path srcDir) {
        this.inputDir = new Path(srcDir, "inputDir");
        this.inputFile1 = new Path(this.inputDir, "file1");
        this.inputSubDir1 = new Path(this.inputDir, "subDir1");
        this.inputFile2 = new Path(this.inputSubDir1, "file2");
        this.inputSubDir2 = new Path(this.inputDir, "subDir2/subDir2");
        this.inputFile3 = new Path(this.inputSubDir2, "file3");
        this.inputSubDir4 = new Path(this.inputDir, "subDir4/subDir4");
        this.inputFile4 = new Path(this.inputSubDir4, "file4");
        this.inputFile5 = new Path(this.inputSubDir4, "file5");
    }

    protected FileSystem getLocalFS() {
        return this.localFS;
    }

    protected FileSystem getRemoteFS() {
        return this.remoteFS;
    }

    protected Path getLocalDir() {
        return this.localDir;
    }

    protected Path getRemoteDir() {
        return this.remoteDir;
    }

    @Test
    public void testUpdateDeepDirectoryStructureToRemote() throws Exception {
        this.describe("update a deep directory structure from local to remote");
        this.distCpDeepDirectoryStructure(this.localFS, this.localDir, this.remoteFS, this.remoteDir);
        this.distCpUpdateDeepDirectoryStructure(this.inputDirUnderOutputDir);
    }

    @Test
    public void testUpdateDeepDirectoryStructureNoChange() throws Exception {
        this.describe("update an unchanged directory structure from local to remote; expect no copy");
        Path target = this.distCpDeepDirectoryStructure(this.localFS, this.localDir, this.remoteFS, this.remoteDir);
        this.describe("\nExecuting Update\n");
        Job job = this.distCpUpdate(this.localDir, target);
        this.assertCounterInRange(job, (Enum<?>)CopyMapper.Counter.SKIP, 1L, -1L);
        this.assertCounterInRange(job, (Enum<?>)CopyMapper.Counter.BYTESCOPIED, 0L, 0L);
    }

    void assertCounterInRange(Job job, Enum<?> counter, long min, long max) throws IOException {
        Counter c = job.getCounters().findCounter(counter);
        long value = c.getValue();
        String description = String.format("%s value %s", c.getDisplayName(), value, false);
        if (min >= 0L) {
            AbstractContractDistCpTest.assertTrue((String)(description + " too below minimum " + min), (value >= min ? 1 : 0) != 0);
        }
        if (max >= 0L) {
            AbstractContractDistCpTest.assertTrue((String)(description + " above maximum " + max), (value <= max ? 1 : 0) != 0);
        }
    }

    protected Job distCpUpdateDeepDirectoryStructure(Path destDir) throws Exception {
        this.describe("Now do an incremental update with deletion of missing files");
        Path srcDir = this.inputDir;
        LOG.info("Source directory = {}, dest={}", (Object)srcDir, (Object)destDir);
        ContractTestUtils.assertPathsExist((FileSystem)this.localFS, (String)"Paths for test are wrong", (Path[])new Path[]{this.inputFile1, this.inputFile2, this.inputFile3, this.inputFile4, this.inputFile5});
        this.modifySourceDirectories();
        Job job = this.distCpUpdate(srcDir, destDir);
        Path outputFileNew1 = new Path(this.outputSubDir2, "newfile1");
        this.lsR("Updated Remote", this.remoteFS, destDir);
        ContractTestUtils.assertPathDoesNotExist((FileSystem)this.remoteFS, (String)(" deleted from " + this.inputFile1), (Path)this.outputFile1);
        ContractTestUtils.assertIsFile((FileSystem)this.remoteFS, (Path)outputFileNew1);
        ContractTestUtils.assertPathsDoNotExist((FileSystem)this.remoteFS, (String)"DistCP should have deleted", (Path[])new Path[]{this.outputFile3, this.outputFile4, this.outputSubDir4});
        this.assertCounterInRange(job, (Enum<?>)CopyMapper.Counter.COPY, 1L, 1L);
        this.assertCounterInRange(job, (Enum<?>)CopyMapper.Counter.SKIP, 1L, -1L);
        return job;
    }

    private Job distCpUpdate(Path srcDir, Path destDir) throws Exception {
        this.describe("\nDistcp -update from " + srcDir + " to " + destDir);
        this.lsR("Local to update", this.localFS, srcDir);
        this.lsR("Remote before update", this.remoteFS, destDir);
        return this.runDistCp(this.buildWithStandardOptions(new DistCpOptions.Builder(Collections.singletonList(srcDir), destDir).withDeleteMissing(true).withSyncFolder(true).withCRC(true).withOverwrite(false)));
    }

    private Path modifySourceDirectories() throws IOException {
        this.localFS.delete(this.inputFile1, false);
        this.localFS.delete(this.inputFile3, false);
        this.localFS.delete(this.inputSubDir4, true);
        Path inputFileNew1 = new Path(this.inputSubDir2, "newfile1");
        ContractTestUtils.touch((FileSystem)this.localFS, (Path)inputFileNew1);
        return inputFileNew1;
    }

    @Test
    public void testTrackDeepDirectoryStructureToRemote() throws Exception {
        this.describe("copy a deep directory structure from local to remote");
        Path destDir = this.distCpDeepDirectoryStructure(this.localFS, this.localDir, this.remoteFS, this.remoteDir);
        ContractTestUtils.assertIsDirectory((FileSystem)this.remoteFS, (Path)destDir);
        this.describe("Now do an incremental update and save of missing files");
        Path srcDir = this.inputDir;
        Path trackDir = new Path(this.localDir, "trackDir");
        this.describe("\nDirectories\n");
        this.lsR("Local to update", this.localFS, srcDir);
        this.lsR("Remote before update", this.remoteFS, destDir);
        ContractTestUtils.assertPathsExist((FileSystem)this.localFS, (String)"Paths for test are wrong", (Path[])new Path[]{this.inputFile2, this.inputFile3, this.inputFile4, this.inputFile5});
        Path inputFileNew1 = this.modifySourceDirectories();
        this.runDistCp(this.buildWithStandardOptions(new DistCpOptions.Builder(Collections.singletonList(srcDir), this.inputDirUnderOutputDir).withTrackMissing(trackDir).withSyncFolder(true).withOverwrite(false)));
        this.lsR("tracked udpate", this.remoteFS, destDir);
        Path outputFileNew1 = new Path(this.outputSubDir2, "newfile1");
        ContractTestUtils.assertIsFile((FileSystem)this.remoteFS, (Path)outputFileNew1);
        ContractTestUtils.assertPathExists((FileSystem)this.localFS, (String)"tracking directory", (Path)trackDir);
        Path sortedSourceListing = new Path(trackDir, "source_sorted.seq");
        ContractTestUtils.assertIsFile((FileSystem)this.localFS, (Path)sortedSourceListing);
        Path sortedTargetListing = new Path(trackDir, "target_sorted.seq");
        ContractTestUtils.assertIsFile((FileSystem)this.localFS, (Path)sortedTargetListing);
        ContractTestUtils.assertPathsExist((FileSystem)this.remoteFS, (String)"DistCP should have retained", (Path[])new Path[]{this.outputFile2, this.outputFile3, this.outputFile4, this.outputSubDir4});
        HashMap<String, Path> sourceFiles = new HashMap<String, Path>(10);
        HashMap<String, Path> targetFiles = new HashMap<String, Path>(10);
        try (SequenceFile.Reader sourceReader = new SequenceFile.Reader(this.conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)sortedSourceListing)});
             SequenceFile.Reader targetReader = new SequenceFile.Reader(this.conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)sortedTargetListing)});){
            Path path;
            String key;
            CopyListingFileStatus copyStatus = new CopyListingFileStatus();
            Text name = new Text();
            while (sourceReader.next((Writable)name, (Writable)copyStatus)) {
                key = name.toString();
                path = copyStatus.getPath();
                LOG.info("{}: {}", (Object)key, (Object)path);
                sourceFiles.put(key, path);
            }
            while (targetReader.next((Writable)name, (Writable)copyStatus)) {
                key = name.toString();
                path = copyStatus.getPath();
                LOG.info("{}: {}", (Object)key, (Object)path);
                targetFiles.put(name.toString(), copyStatus.getPath());
            }
        }
        AbstractContractDistCpTest.assertTrue((String)("No " + outputFileNew1 + " in source listing"), (boolean)sourceFiles.containsValue(inputFileNew1));
        AbstractContractDistCpTest.assertTrue((String)("No " + outputFileNew1 + " in target listing"), (boolean)targetFiles.containsValue(outputFileNew1));
        AbstractContractDistCpTest.assertTrue((String)("No " + this.outputSubDir4 + " in target listing"), (boolean)targetFiles.containsValue(this.outputSubDir4));
        AbstractContractDistCpTest.assertFalse((String)("Found " + this.inputSubDir4 + " in source listing"), (boolean)sourceFiles.containsValue(this.inputSubDir4));
    }

    public void lsR(String description, FileSystem fs, Path dir) throws IOException {
        RemoteIterator files = fs.listFiles(dir, true);
        LOG.info("{}: {}:", (Object)description, (Object)dir);
        StringBuilder sb = new StringBuilder();
        while (files.hasNext()) {
            LocatedFileStatus status = (LocatedFileStatus)files.next();
            sb.append(String.format("  %s; type=%s; length=%d", status.getPath(), status.isDirectory() ? "dir" : "file", status.getLen()));
        }
        LOG.info("{}", (Object)sb);
    }

    @Test
    public void largeFilesToRemote() throws Exception {
        this.describe("copy multiple large files from local to remote");
        this.largeFiles(this.localFS, this.localDir, this.remoteFS, this.remoteDir);
    }

    @Test
    public void testDeepDirectoryStructureFromRemote() throws Exception {
        this.describe("copy a deep directory structure from remote to local");
        this.distCpDeepDirectoryStructure(this.remoteFS, this.remoteDir, this.localFS, this.localDir);
    }

    @Test
    public void testLargeFilesFromRemote() throws Exception {
        this.describe("copy multiple large files from remote to local");
        this.largeFiles(this.remoteFS, this.remoteDir, this.localFS, this.localDir);
    }

    private Path distCpDeepDirectoryStructure(FileSystem srcFS, Path srcDir, FileSystem dstFS, Path dstDir) throws Exception {
        this.initPathFields(srcDir, dstDir);
        AbstractContractDistCpTest.mkdirs(srcFS, this.inputSubDir1);
        AbstractContractDistCpTest.mkdirs(srcFS, this.inputSubDir2);
        byte[] data1 = ContractTestUtils.dataset((int)100, (int)33, (int)43);
        ContractTestUtils.createFile((FileSystem)srcFS, (Path)this.inputFile1, (boolean)true, (byte[])data1);
        byte[] data2 = ContractTestUtils.dataset((int)200, (int)43, (int)53);
        ContractTestUtils.createFile((FileSystem)srcFS, (Path)this.inputFile2, (boolean)true, (byte[])data2);
        byte[] data3 = ContractTestUtils.dataset((int)300, (int)53, (int)63);
        ContractTestUtils.createFile((FileSystem)srcFS, (Path)this.inputFile3, (boolean)true, (byte[])data3);
        ContractTestUtils.createFile((FileSystem)srcFS, (Path)this.inputFile4, (boolean)true, (byte[])ContractTestUtils.dataset((int)400, (int)53, (int)63));
        ContractTestUtils.createFile((FileSystem)srcFS, (Path)this.inputFile5, (boolean)true, (byte[])ContractTestUtils.dataset((int)500, (int)53, (int)63));
        Path target = new Path(dstDir, "outputDir");
        this.runDistCp(this.inputDir, target);
        ContractTestUtils.assertIsDirectory((FileSystem)dstFS, (Path)target);
        this.lsR("Destination tree after distcp", dstFS, target);
        ContractTestUtils.verifyFileContents((FileSystem)dstFS, (Path)new Path(target, "inputDir/file1"), (byte[])data1);
        ContractTestUtils.verifyFileContents((FileSystem)dstFS, (Path)new Path(target, "inputDir/subDir1/file2"), (byte[])data2);
        ContractTestUtils.verifyFileContents((FileSystem)dstFS, (Path)new Path(target, "inputDir/subDir2/subDir2/file3"), (byte[])data3);
        return target;
    }

    private void largeFiles(FileSystem srcFS, Path srcDir, FileSystem dstFS, Path dstDir) throws Exception {
        this.initPathFields(srcDir, dstDir);
        Path largeFile1 = new Path(this.inputDir, "file1");
        Path largeFile2 = new Path(this.inputDir, "file2");
        Path largeFile3 = new Path(this.inputDir, "file3");
        AbstractContractDistCpTest.mkdirs(srcFS, this.inputDir);
        int fileSizeKb = this.conf.getInt(SCALE_TEST_DISTCP_FILE_SIZE_KB, 1024);
        int fileSizeMb = fileSizeKb / 1024;
        AbstractContractDistCpTest.getLogger().info("{} with file size {}", (Object)this.testName.getMethodName(), (Object)fileSizeMb);
        byte[] data1 = ContractTestUtils.dataset((int)((fileSizeMb + 1) * 0x100000), (int)33, (int)43);
        ContractTestUtils.createFile((FileSystem)srcFS, (Path)largeFile1, (boolean)true, (byte[])data1);
        byte[] data2 = ContractTestUtils.dataset((int)((fileSizeMb + 2) * 0x100000), (int)43, (int)53);
        ContractTestUtils.createFile((FileSystem)srcFS, (Path)largeFile2, (boolean)true, (byte[])data2);
        byte[] data3 = ContractTestUtils.dataset((int)((fileSizeMb + 3) * 0x100000), (int)53, (int)63);
        ContractTestUtils.createFile((FileSystem)srcFS, (Path)largeFile3, (boolean)true, (byte[])data3);
        Path target = new Path(dstDir, "outputDir");
        this.runDistCp(this.inputDir, target);
        ContractTestUtils.assertIsDirectory((FileSystem)dstFS, (Path)target);
        ContractTestUtils.verifyFileContents((FileSystem)dstFS, (Path)new Path(target, "inputDir/file1"), (byte[])data1);
        ContractTestUtils.verifyFileContents((FileSystem)dstFS, (Path)new Path(target, "inputDir/file2"), (byte[])data2);
        ContractTestUtils.verifyFileContents((FileSystem)dstFS, (Path)new Path(target, "inputDir/file3"), (byte[])data3);
    }

    private void runDistCp(Path src, Path dst) throws Exception {
        this.runDistCp(this.buildWithStandardOptions(new DistCpOptions.Builder(Collections.singletonList(src), dst)));
    }

    private Job runDistCp(DistCpOptions options) throws Exception {
        Job job = new DistCp(this.conf, options).execute();
        AbstractContractDistCpTest.assertNotNull((String)"Unexpected null job returned from DistCp execution.", (Object)job);
        AbstractContractDistCpTest.assertTrue((String)"DistCp job did not complete.", (boolean)job.isComplete());
        AbstractContractDistCpTest.assertTrue((String)"DistCp job did not complete successfully.", (boolean)job.isSuccessful());
        return job;
    }

    private DistCpOptions buildWithStandardOptions(DistCpOptions.Builder builder) {
        return builder.withNumListstatusThreads(40).build();
    }

    private static void mkdirs(FileSystem fs, Path dir) throws Exception {
        AbstractContractDistCpTest.assertTrue((String)("Failed to mkdir " + dir), (boolean)fs.mkdirs(dir));
    }

    @Test
    public void testDirectWrite() throws Exception {
        this.describe("copy file from local to remote using direct write option");
        this.directWrite(this.localFS, this.localDir, this.remoteFS, this.remoteDir, true);
    }

    @Test
    public void testNonDirectWrite() throws Exception {
        this.describe("copy file from local to remote without using direct write option");
        this.directWrite(this.localFS, this.localDir, this.remoteFS, this.remoteDir, false);
    }

    private void directWrite(FileSystem srcFS, Path srcDir, FileSystem dstFS, Path dstDir, boolean directWrite) throws Exception {
        this.initPathFields(srcDir, dstDir);
        AbstractContractDistCpTest.mkdirs(srcFS, this.inputSubDir1);
        byte[] data1 = ContractTestUtils.dataset((int)64, (int)33, (int)43);
        ContractTestUtils.createFile((FileSystem)srcFS, (Path)this.inputFile1, (boolean)true, (byte[])data1);
        byte[] data2 = ContractTestUtils.dataset((int)200, (int)43, (int)53);
        ContractTestUtils.createFile((FileSystem)srcFS, (Path)this.inputFile2, (boolean)true, (byte[])data2);
        Path target = new Path(dstDir, "outputDir");
        if (directWrite) {
            this.runDistCpDirectWrite(this.inputDir, target);
        } else {
            this.runDistCp(this.inputDir, target);
        }
        ContractTestUtils.assertIsDirectory((FileSystem)dstFS, (Path)target);
        this.lsR("Destination tree after distcp", dstFS, target);
        ContractTestUtils.verifyFileContents((FileSystem)dstFS, (Path)new Path(target, "inputDir/file1"), (byte[])data1);
        ContractTestUtils.verifyFileContents((FileSystem)dstFS, (Path)new Path(target, "inputDir/subDir1/file2"), (byte[])data2);
    }

    private Job runDistCpDirectWrite(Path srcDir, Path destDir) throws Exception {
        this.describe("\nDistcp -direct from " + srcDir + " to " + destDir);
        return this.runDistCp(this.buildWithStandardOptions(new DistCpOptions.Builder(Collections.singletonList(srcDir), destDir).withDirectWrite(true)));
    }
}

