/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.mapred;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.tools.CopyListingFileStatus;
import org.apache.hadoop.tools.DistCpOptionSwitch;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.mapred.CopyMapper;
import org.apache.hadoop.tools.util.DistCpUtils;
import org.apache.hadoop.tools.util.RetriableCommand;
import org.apache.hadoop.tools.util.ThrottledInputStream;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetriableFileCopyCommand
extends RetriableCommand {
    private static Logger LOG = LoggerFactory.getLogger(RetriableFileCopyCommand.class);
    private boolean skipCrc = false;
    private boolean directWrite = false;
    private CopyMapper.FileAction action;

    public RetriableFileCopyCommand(String description, CopyMapper.FileAction action) {
        super(description);
        this.action = action;
    }

    public RetriableFileCopyCommand(boolean skipCrc, String description, CopyMapper.FileAction action) {
        this(description, action);
        this.skipCrc = skipCrc;
    }

    public RetriableFileCopyCommand(boolean skipCrc, String description, CopyMapper.FileAction action, boolean directWrite) {
        this(skipCrc, description, action);
        this.directWrite = directWrite;
    }

    @Override
    protected Object doExecute(Object ... arguments) throws Exception {
        assert (arguments.length == 4) : "Unexpected argument list.";
        CopyListingFileStatus source = (CopyListingFileStatus)arguments[0];
        assert (!source.isDirectory()) : "Unexpected file-status. Expected file.";
        Path target = (Path)arguments[1];
        Mapper.Context context = (Mapper.Context)arguments[2];
        EnumSet fileAttributes = (EnumSet)arguments[3];
        return this.doCopy(source, target, context, fileAttributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long doCopy(CopyListingFileStatus source, Path target, Mapper.Context context, EnumSet<DistCpOptions.FileAttribute> fileAttributes) throws IOException {
        LOG.info("Copying {} to {}", (Object)source.getPath(), (Object)target);
        boolean toAppend = this.action == CopyMapper.FileAction.APPEND;
        boolean useTempTarget = !toAppend && !this.directWrite;
        Path targetPath = useTempTarget ? this.getTempFile(target, context) : target;
        LOG.info("Writing to {} target file path {}", (Object)(useTempTarget ? "temporary" : "direct"), (Object)targetPath);
        Configuration configuration = context.getConfiguration();
        FileSystem targetFS = target.getFileSystem(configuration);
        try {
            Path sourcePath = source.getPath();
            FileSystem sourceFS = sourcePath.getFileSystem(configuration);
            FileChecksum sourceChecksum = fileAttributes.contains((Object)DistCpOptions.FileAttribute.CHECKSUMTYPE) ? sourceFS.getFileChecksum(sourcePath) : null;
            long offset = this.action == CopyMapper.FileAction.APPEND ? targetFS.getFileStatus(target).getLen() : source.getChunkOffset();
            long bytesRead = this.copyToFile(targetPath, targetFS, source, offset, context, fileAttributes, sourceChecksum);
            if (!source.isSplit()) {
                this.compareFileLengths(source, targetPath, configuration, bytesRead + offset);
            }
            if (bytesRead != 0L && !this.skipCrc && !source.isSplit()) {
                this.compareCheckSums(sourceFS, source.getPath(), sourceChecksum, targetFS, targetPath);
            }
            if (useTempTarget) {
                LOG.info("Renaming temporary target file path {} to {}", (Object)targetPath, (Object)target);
                this.promoteTmpToTarget(targetPath, target, targetFS);
            }
            LOG.info("Completed writing {} ({} bytes)", (Object)target, (Object)bytesRead);
            long l = bytesRead;
            return l;
        }
        finally {
            if (useTempTarget) {
                targetFS.delete(targetPath, false);
            }
        }
    }

    private Options.ChecksumOpt getChecksumOpt(EnumSet<DistCpOptions.FileAttribute> fileAttributes, FileChecksum sourceChecksum) {
        if (fileAttributes.contains((Object)DistCpOptions.FileAttribute.CHECKSUMTYPE) && sourceChecksum != null) {
            return sourceChecksum.getChecksumOpt();
        }
        return null;
    }

    private long copyToFile(Path targetPath, FileSystem targetFS, CopyListingFileStatus source, long sourceOffset, Mapper.Context context, EnumSet<DistCpOptions.FileAttribute> fileAttributes, FileChecksum sourceChecksum) throws IOException {
        BufferedOutputStream outStream;
        FsPermission permission = FsPermission.getFileDefault().applyUMask(FsPermission.getUMask((Configuration)targetFS.getConf()));
        int copyBufferSize = context.getConfiguration().getInt(DistCpOptionSwitch.COPY_BUFFER_SIZE.getConfigLabel(), 8192);
        if (this.action == CopyMapper.FileAction.OVERWRITE) {
            short repl = RetriableFileCopyCommand.getReplicationFactor(fileAttributes, source, targetFS, targetPath);
            long blockSize = RetriableFileCopyCommand.getBlockSize(fileAttributes, source, targetFS, targetPath);
            FSDataOutputStream out = targetFS.create(targetPath, permission, EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), copyBufferSize, repl, blockSize, (Progressable)context, this.getChecksumOpt(fileAttributes, sourceChecksum));
            outStream = new BufferedOutputStream((OutputStream)out);
        } else {
            outStream = new BufferedOutputStream((OutputStream)targetFS.append(targetPath, copyBufferSize));
        }
        return this.copyBytes(source, sourceOffset, outStream, copyBufferSize, context);
    }

    private void compareFileLengths(CopyListingFileStatus source, Path target, Configuration configuration, long targetLen) throws IOException {
        Path sourcePath = source.getPath();
        FileSystem fs = sourcePath.getFileSystem(configuration);
        long srcLen = fs.getFileStatus(sourcePath).getLen();
        if (srcLen != targetLen) {
            throw new IOException("Mismatch in length of source:" + sourcePath + " (" + srcLen + ") and target:" + target + " (" + targetLen + ")");
        }
    }

    private void compareCheckSums(FileSystem sourceFS, Path source, FileChecksum sourceChecksum, FileSystem targetFS, Path target) throws IOException {
        if (!DistCpUtils.checksumsAreEqual(sourceFS, source, sourceChecksum, targetFS, target)) {
            String targetScheme;
            StringBuilder errorMessage = new StringBuilder("Checksum mismatch between ").append(source).append(" and ").append(target).append(".");
            boolean addSkipHint = false;
            String srcScheme = sourceFS.getScheme();
            if (!(srcScheme.equals(targetScheme = targetFS.getScheme()) || srcScheme.contains("hdfs") && targetScheme.contains("hdfs"))) {
                errorMessage.append("Source and destination filesystems are of different types\n").append("Their checksum algorithms may be incompatible");
                addSkipHint = true;
            } else if (sourceFS.getFileStatus(source).getBlockSize() != targetFS.getFileStatus(target).getBlockSize()) {
                errorMessage.append(" Source and target differ in block-size.\n").append(" Use -pb to preserve block-sizes during copy.");
                addSkipHint = true;
            }
            if (addSkipHint) {
                errorMessage.append(" You can skip checksum-checks altogether  with -skipcrccheck.\n").append(" (NOTE: By skipping checksums, one runs the risk of masking data-corruption during file-transfer.)\n");
            }
            throw new IOException(errorMessage.toString());
        }
    }

    private void promoteTmpToTarget(Path tmpTarget, Path target, FileSystem fs) throws IOException {
        if (fs.exists(target) && !fs.delete(target, false) || !fs.exists(target.getParent()) && !fs.mkdirs(target.getParent()) || !fs.rename(tmpTarget, target)) {
            throw new IOException("Failed to promote tmp-file:" + tmpTarget + " to: " + target);
        }
    }

    private Path getTempFile(Path target, Mapper.Context context) {
        Path targetWorkPath = new Path(context.getConfiguration().get("distcp.target.work.path"));
        Path root = target.equals((Object)targetWorkPath) ? targetWorkPath.getParent() : targetWorkPath;
        Path tempFile = new Path(root, ".distcp.tmp." + context.getTaskAttemptID().toString());
        LOG.info("Creating temp file: {}", (Object)tempFile);
        return tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    long copyBytes(CopyListingFileStatus source2, long sourceOffset, OutputStream outStream, int bufferSize, Mapper.Context context) throws IOException {
        Path source = source2.getPath();
        byte[] buf = new byte[bufferSize];
        ThrottledInputStream inStream = null;
        long totalBytesRead = 0L;
        long chunkLength = source2.getChunkLength();
        boolean finished = false;
        try {
            inStream = RetriableFileCopyCommand.getInputStream(source, context.getConfiguration());
            RetriableFileCopyCommand.seekIfRequired(inStream, sourceOffset);
            int bytesRead = RetriableFileCopyCommand.readBytes(inStream, buf);
            while (bytesRead >= 0) {
                if (chunkLength > 0L && totalBytesRead + (long)bytesRead >= chunkLength) {
                    bytesRead = (int)(chunkLength - totalBytesRead);
                    finished = true;
                }
                totalBytesRead += (long)bytesRead;
                if (this.action == CopyMapper.FileAction.APPEND) {
                    sourceOffset += (long)bytesRead;
                }
                outStream.write(buf, 0, bytesRead);
                this.updateContextStatus(totalBytesRead, context, source2);
                if (finished) break;
                bytesRead = RetriableFileCopyCommand.readBytes(inStream, buf);
            }
            outStream.close();
            outStream = null;
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{outStream, inStream});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{outStream, inStream});
        return totalBytesRead;
    }

    private void updateContextStatus(long totalBytesRead, Mapper.Context context, CopyListingFileStatus source2) {
        StringBuilder message = new StringBuilder(DistCpUtils.getFormatter().format((float)totalBytesRead * 100.0f / (float)source2.getLen()));
        message.append("% ").append(this.description).append(" [").append(DistCpUtils.getStringDescriptionFor(totalBytesRead)).append('/').append(DistCpUtils.getStringDescriptionFor(source2.getLen())).append(']');
        context.setStatus(message.toString());
    }

    private static int readBytes(ThrottledInputStream inStream, byte[] buf) throws IOException {
        try {
            return inStream.read(buf);
        }
        catch (IOException e) {
            throw new CopyReadException(e);
        }
    }

    private static void seekIfRequired(ThrottledInputStream inStream, long sourceOffset) throws IOException {
        try {
            if (sourceOffset != inStream.getPos()) {
                inStream.seek(sourceOffset);
            }
        }
        catch (IOException e) {
            throw new CopyReadException(e);
        }
    }

    private static ThrottledInputStream getInputStream(Path path, Configuration conf) throws IOException {
        try {
            FileSystem fs = path.getFileSystem(conf);
            float bandwidthMB = conf.getFloat("distcp.map.bandwidth.mb", 100.0f);
            FSDataInputStream in = fs.open(path);
            return new ThrottledInputStream((InputStream)in, bandwidthMB * 1024.0f * 1024.0f);
        }
        catch (IOException e) {
            throw new CopyReadException(e);
        }
    }

    private static short getReplicationFactor(EnumSet<DistCpOptions.FileAttribute> fileAttributes, CopyListingFileStatus source, FileSystem targetFS, Path tmpTargetPath) {
        return fileAttributes.contains((Object)DistCpOptions.FileAttribute.REPLICATION) ? source.getReplication() : targetFS.getDefaultReplication(tmpTargetPath);
    }

    private static long getBlockSize(EnumSet<DistCpOptions.FileAttribute> fileAttributes, CopyListingFileStatus source, FileSystem targetFS, Path tmpTargetPath) {
        boolean preserve = fileAttributes.contains((Object)DistCpOptions.FileAttribute.BLOCKSIZE) || fileAttributes.contains((Object)DistCpOptions.FileAttribute.CHECKSUMTYPE);
        return preserve ? source.getBlockSize() : targetFS.getDefaultBlockSize(tmpTargetPath);
    }

    public static class CopyReadException
    extends IOException {
        public CopyReadException(Throwable rootCause) {
            super(rootCause);
        }
    }
}

