/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.tools.DistCpOptionSwitch;
import org.apache.hadoop.tools.DistCpOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptionsParser {
    static final Logger LOG = LoggerFactory.getLogger(OptionsParser.class);
    private static final Options cliOptions = new Options();

    private static void checkSnapshotsArgs(String[] snapshots) {
        Preconditions.checkArgument((snapshots != null && snapshots.length == 2 && !StringUtils.isBlank((CharSequence)snapshots[0]) && !StringUtils.isBlank((CharSequence)snapshots[1]) ? 1 : 0) != 0, (Object)"Must provide both the starting and ending snapshot names");
    }

    public static DistCpOptions parse(String[] args) throws IllegalArgumentException {
        String workPath;
        String[] snapshots;
        CommandLine command;
        CustomParser parser = new CustomParser();
        try {
            command = parser.parse(cliOptions, args, true);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Unable to parse arguments. " + Arrays.toString(args), e);
        }
        DistCpOptions.Builder builder = OptionsParser.parseSourceAndTargetPaths(command);
        builder.withAtomicCommit(command.hasOption(DistCpOptionSwitch.ATOMIC_COMMIT.getSwitch())).withSyncFolder(command.hasOption(DistCpOptionSwitch.SYNC_FOLDERS.getSwitch())).withDeleteMissing(command.hasOption(DistCpOptionSwitch.DELETE_MISSING.getSwitch())).withIgnoreFailures(command.hasOption(DistCpOptionSwitch.IGNORE_FAILURES.getSwitch())).withOverwrite(command.hasOption(DistCpOptionSwitch.OVERWRITE.getSwitch())).withAppend(command.hasOption(DistCpOptionSwitch.APPEND.getSwitch())).withCRC(command.hasOption(DistCpOptionSwitch.SKIP_CRC.getSwitch())).withBlocking(!command.hasOption(DistCpOptionSwitch.BLOCKING.getSwitch())).withVerboseLog(command.hasOption(DistCpOptionSwitch.VERBOSE_LOG.getSwitch())).withDirectWrite(command.hasOption(DistCpOptionSwitch.DIRECT_WRITE.getSwitch()));
        if (command.hasOption(DistCpOptionSwitch.DIFF.getSwitch())) {
            snapshots = OptionsParser.getVals(command, DistCpOptionSwitch.DIFF.getSwitch());
            OptionsParser.checkSnapshotsArgs(snapshots);
            builder.withUseDiff(snapshots[0], snapshots[1]);
        }
        if (command.hasOption(DistCpOptionSwitch.RDIFF.getSwitch())) {
            snapshots = OptionsParser.getVals(command, DistCpOptionSwitch.RDIFF.getSwitch());
            OptionsParser.checkSnapshotsArgs(snapshots);
            builder.withUseRdiff(snapshots[0], snapshots[1]);
        }
        if (command.hasOption(DistCpOptionSwitch.FILTERS.getSwitch())) {
            builder.withFiltersFile(OptionsParser.getVal(command, DistCpOptionSwitch.FILTERS.getSwitch()));
        }
        if (command.hasOption(DistCpOptionSwitch.LOG_PATH.getSwitch())) {
            builder.withLogPath(new Path(OptionsParser.getVal(command, DistCpOptionSwitch.LOG_PATH.getSwitch())));
        }
        if (command.hasOption(DistCpOptionSwitch.WORK_PATH.getSwitch()) && (workPath = OptionsParser.getVal(command, DistCpOptionSwitch.WORK_PATH.getSwitch())) != null && !workPath.isEmpty()) {
            builder.withAtomicWorkPath(new Path(workPath));
        }
        if (command.hasOption(DistCpOptionSwitch.TRACK_MISSING.getSwitch())) {
            builder.withTrackMissing(new Path(OptionsParser.getVal(command, DistCpOptionSwitch.TRACK_MISSING.getSwitch())));
        }
        if (command.hasOption(DistCpOptionSwitch.BANDWIDTH.getSwitch())) {
            try {
                Float mapBandwidth = Float.valueOf(Float.parseFloat(OptionsParser.getVal(command, DistCpOptionSwitch.BANDWIDTH.getSwitch())));
                builder.withMapBandwidth(mapBandwidth.floatValue());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Bandwidth specified is invalid: " + OptionsParser.getVal(command, DistCpOptionSwitch.BANDWIDTH.getSwitch()), e);
            }
        }
        if (command.hasOption(DistCpOptionSwitch.NUM_LISTSTATUS_THREADS.getSwitch())) {
            try {
                Integer numThreads = Integer.parseInt(OptionsParser.getVal(command, DistCpOptionSwitch.NUM_LISTSTATUS_THREADS.getSwitch()));
                builder.withNumListstatusThreads(numThreads);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Number of liststatus threads is invalid: " + OptionsParser.getVal(command, DistCpOptionSwitch.NUM_LISTSTATUS_THREADS.getSwitch()), e);
            }
        }
        if (command.hasOption(DistCpOptionSwitch.MAX_MAPS.getSwitch())) {
            try {
                Integer maps = Integer.parseInt(OptionsParser.getVal(command, DistCpOptionSwitch.MAX_MAPS.getSwitch()));
                builder.maxMaps(maps);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Number of maps is invalid: " + OptionsParser.getVal(command, DistCpOptionSwitch.MAX_MAPS.getSwitch()), e);
            }
        }
        if (command.hasOption(DistCpOptionSwitch.COPY_STRATEGY.getSwitch())) {
            builder.withCopyStrategy(OptionsParser.getVal(command, DistCpOptionSwitch.COPY_STRATEGY.getSwitch()));
        }
        if (command.hasOption(DistCpOptionSwitch.PRESERVE_STATUS.getSwitch())) {
            builder.preserve(OptionsParser.getVal(command, DistCpOptionSwitch.PRESERVE_STATUS.getSwitch()));
        } else {
            builder.preserve(DistCpOptions.FileAttribute.BLOCKSIZE);
        }
        if (command.hasOption(DistCpOptionSwitch.FILE_LIMIT.getSwitch())) {
            LOG.warn(DistCpOptionSwitch.FILE_LIMIT.getSwitch() + " is a deprecated option. Ignoring.");
        }
        if (command.hasOption(DistCpOptionSwitch.SIZE_LIMIT.getSwitch())) {
            LOG.warn(DistCpOptionSwitch.SIZE_LIMIT.getSwitch() + " is a deprecated option. Ignoring.");
        }
        if (command.hasOption(DistCpOptionSwitch.BLOCKS_PER_CHUNK.getSwitch())) {
            String chunkSizeStr = OptionsParser.getVal(command, DistCpOptionSwitch.BLOCKS_PER_CHUNK.getSwitch().trim());
            try {
                int csize = Integer.parseInt(chunkSizeStr);
                csize = csize > 0 ? csize : 0;
                LOG.info("Set distcp blocksPerChunk to " + csize);
                builder.withBlocksPerChunk(csize);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("blocksPerChunk is invalid: " + chunkSizeStr, e);
            }
        }
        if (command.hasOption(DistCpOptionSwitch.COPY_BUFFER_SIZE.getSwitch())) {
            String copyBufferSizeStr = OptionsParser.getVal(command, DistCpOptionSwitch.COPY_BUFFER_SIZE.getSwitch().trim());
            try {
                int copyBufferSize = Integer.parseInt(copyBufferSizeStr);
                builder.withCopyBufferSize(copyBufferSize);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("copyBufferSize is invalid: " + copyBufferSizeStr, e);
            }
        }
        return builder.build();
    }

    private static DistCpOptions.Builder parseSourceAndTargetPaths(CommandLine command) {
        ArrayList<Path> sourcePaths = new ArrayList<Path>();
        String[] leftOverArgs = command.getArgs();
        if (leftOverArgs == null || leftOverArgs.length < 1) {
            throw new IllegalArgumentException("Target path not specified");
        }
        Path targetPath = new Path(leftOverArgs[leftOverArgs.length - 1].trim());
        for (int index = 0; index < leftOverArgs.length - 1; ++index) {
            sourcePaths.add(new Path(leftOverArgs[index].trim()));
        }
        if (command.hasOption(DistCpOptionSwitch.SOURCE_FILE_LISTING.getSwitch())) {
            if (!sourcePaths.isEmpty()) {
                throw new IllegalArgumentException("Both source file listing and source paths present");
            }
            return new DistCpOptions.Builder(new Path(OptionsParser.getVal(command, DistCpOptionSwitch.SOURCE_FILE_LISTING.getSwitch())), targetPath);
        }
        if (sourcePaths.isEmpty()) {
            throw new IllegalArgumentException("Neither source file listing nor source paths present");
        }
        return new DistCpOptions.Builder(sourcePaths, targetPath);
    }

    private static String getVal(CommandLine command, String swtch) {
        if (swtch == null) {
            return null;
        }
        String optionValue = command.getOptionValue(swtch.trim());
        if (optionValue == null) {
            return null;
        }
        return optionValue.trim();
    }

    private static String[] getVals(CommandLine command, String option) {
        return command.getOptionValues(option);
    }

    public static void usage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("distcp OPTIONS [source_path...] <target_path>\n\nOPTIONS", cliOptions);
    }

    static {
        for (DistCpOptionSwitch option : DistCpOptionSwitch.values()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding option " + option.getOption());
            }
            cliOptions.addOption(option.getOption());
        }
    }

    private static class CustomParser
    extends GnuParser {
        private CustomParser() {
        }

        protected String[] flatten(Options options, String[] arguments, boolean stopAtNonOption) {
            for (int index = 0; index < arguments.length; ++index) {
                if (!arguments[index].equals("-" + DistCpOptionSwitch.PRESERVE_STATUS.getSwitch())) continue;
                arguments[index] = "-prbugpct";
            }
            return super.flatten(options, arguments, stopAtNonOption);
        }
    }
}

