/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.InvalidInputException;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileRecordReader;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.JobSubmissionFiles;
import org.apache.hadoop.tools.DistTool;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class DistCh
extends DistTool {
    static final String NAME = "distch";
    static final String JOB_DIR_LABEL = "distch.job.dir";
    static final String OP_LIST_LABEL = "distch.op.list";
    static final String OP_COUNT_LABEL = "distch.op.count";
    static final String USAGE = "java " + DistCh.class.getName() + " [OPTIONS] <path:owner:group:permission>+ \n\nThe values of owner, group and permission can be empty.\nPermission is a octal number.\n\nOPTIONS:\n-f <urilist_uri>       Use list at <urilist_uri> as src list\n-i                     Ignore failures\n-log <logdir>          Write logs to <logdir>";
    private static final long OP_PER_MAP = 1000L;
    private static final int MAX_MAPS_PER_NODE = 20;
    private static final int SYNC_FILE_MAX = 10;

    DistCh(Configuration conf) {
        super((Configuration)DistCh.createJobConf(conf));
    }

    private static JobConf createJobConf(Configuration conf) {
        JobConf jobconf = new JobConf(conf, DistCh.class);
        jobconf.setJobName(NAME);
        jobconf.setMapSpeculativeExecution(false);
        jobconf.setInputFormat(ChangeInputFormat.class);
        jobconf.setOutputKeyClass(Text.class);
        jobconf.setOutputValueClass(Text.class);
        jobconf.setMapperClass(ChangeFilesMapper.class);
        jobconf.setNumReduceTasks(0);
        return jobconf;
    }

    private static void check(Configuration conf, List<FileOperation> ops) throws InvalidInputException {
        ArrayList<Path> srcs = new ArrayList<Path>();
        for (FileOperation op : ops) {
            srcs.add(op.src);
        }
        DistTool.checkSource(conf, srcs);
    }

    private static List<FileOperation> fetchList(Configuration conf, Path inputfile) throws IOException {
        ArrayList<FileOperation> result = new ArrayList<FileOperation>();
        for (String line : DistCh.readFile(conf, inputfile)) {
            result.add(new FileOperation(line));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        ArrayList<FileOperation> ops = new ArrayList<FileOperation>();
        Path logpath = null;
        boolean isIgnoreFailures = false;
        try {
            for (int idx = 0; idx < args.length; ++idx) {
                if ("-f".equals(args[idx])) {
                    if (++idx == args.length) {
                        System.out.println("urilist_uri not specified");
                        System.out.println(USAGE);
                        return -1;
                    }
                    ops.addAll(DistCh.fetchList((Configuration)this.jobconf, new Path(args[idx])));
                    continue;
                }
                if (Option.IGNORE_FAILURES.cmd.equals(args[idx])) {
                    isIgnoreFailures = true;
                    continue;
                }
                if ("-log".equals(args[idx])) {
                    if (++idx == args.length) {
                        System.out.println("logdir not specified");
                        System.out.println(USAGE);
                        return -1;
                    }
                    logpath = new Path(args[idx]);
                    continue;
                }
                if (45 == args[idx].codePointAt(0)) {
                    System.out.println("Invalid switch " + args[idx]);
                    System.out.println(USAGE);
                    ToolRunner.printGenericCommandUsage((PrintStream)System.out);
                    return -1;
                }
                ops.add(new FileOperation(args[idx]));
            }
            if (ops.isEmpty()) {
                throw new IllegalStateException("Operation is empty");
            }
            LOG.info((Object)("ops=" + ops));
            LOG.info((Object)("isIgnoreFailures=" + isIgnoreFailures));
            this.jobconf.setBoolean(Option.IGNORE_FAILURES.propertyname, isIgnoreFailures);
            DistCh.check((Configuration)this.jobconf, ops);
            try {
                if (this.setup(ops, logpath)) {
                    JobClient.runJob((JobConf)this.jobconf);
                }
            }
            finally {
                try {
                    Path logdir;
                    if (logpath == null && (logdir = FileOutputFormat.getOutputPath((JobConf)this.jobconf)) != null) {
                        logdir.getFileSystem((Configuration)this.jobconf).delete(logdir, true);
                    }
                }
                finally {
                    String jobdir = this.jobconf.get(JOB_DIR_LABEL);
                    if (jobdir != null) {
                        Path jobpath = new Path(jobdir);
                        jobpath.getFileSystem((Configuration)this.jobconf).delete(jobpath, true);
                    }
                }
            }
        }
        catch (DistTool.DuplicationException e) {
            LOG.error((Object)"Input error:", (Throwable)e);
            return -2;
        }
        catch (Exception e) {
            LOG.error((Object)"distch failed: ", (Throwable)e);
            System.out.println(USAGE);
            ToolRunner.printGenericCommandUsage((PrintStream)System.out);
            return -1;
        }
        return 0;
    }

    private static int getMapCount(int srcCount, int numNodes) {
        int numMaps = (int)((long)srcCount / 1000L);
        numMaps = Math.min(numMaps, numNodes * 20);
        return Math.max(numMaps, 1);
    }

    private boolean setup(List<FileOperation> ops, Path log) throws IOException {
        Path stagingArea;
        String randomId = DistCh.getRandomId();
        JobClient jClient = new JobClient(this.jobconf);
        try {
            stagingArea = JobSubmissionFiles.getStagingDir((Cluster)jClient.getClusterHandle(), (Configuration)this.jobconf);
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
        Path jobdir = new Path(stagingArea + NAME + "_" + randomId);
        FsPermission mapredSysPerms = new FsPermission(JobSubmissionFiles.JOB_DIR_PERMISSION);
        FileSystem.mkdirs((FileSystem)jClient.getFs(), (Path)jobdir, (FsPermission)mapredSysPerms);
        LOG.info((Object)("distch.job.dir=" + jobdir));
        if (log == null) {
            log = new Path(jobdir, "_logs");
        }
        FileOutputFormat.setOutputPath((JobConf)this.jobconf, (Path)log);
        LOG.info((Object)("log=" + log));
        FileSystem fs = jobdir.getFileSystem((Configuration)this.jobconf);
        Path opList = new Path(jobdir, "_distch.op.list");
        this.jobconf.set(OP_LIST_LABEL, opList.toString());
        int opCount = 0;
        int synCount = 0;
        try (SequenceFile.Writer opWriter = SequenceFile.createWriter((FileSystem)fs, (Configuration)this.jobconf, (Path)opList, Text.class, FileOperation.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);){
            for (FileOperation op : ops) {
                FileStatus srcstat = fs.getFileStatus(op.src);
                if (srcstat.isDirectory() && op.isDifferent(srcstat)) {
                    ++opCount;
                    opWriter.append((Writable)new Text(op.src.toString()), (Writable)op);
                }
                Stack<Path> pathstack = new Stack<Path>();
                pathstack.push(op.src);
                while (!pathstack.empty()) {
                    for (FileStatus stat : fs.listStatus((Path)pathstack.pop())) {
                        if (stat.isDirectory()) {
                            pathstack.push(stat.getPath());
                        }
                        if (!op.isDifferent(stat)) continue;
                        ++opCount;
                        if (++synCount > 10) {
                            opWriter.sync();
                            synCount = 0;
                        }
                        Path f = stat.getPath();
                        opWriter.append((Writable)new Text(f.toString()), (Writable)new FileOperation(f, op));
                    }
                }
            }
        }
        DistCh.checkDuplication(fs, opList, new Path(jobdir, "_sorted"), (Configuration)this.jobconf);
        this.jobconf.setInt(OP_COUNT_LABEL, opCount);
        LOG.info((Object)("distch.op.count=" + opCount));
        this.jobconf.setNumMapTasks(DistCh.getMapCount(opCount, new JobClient(this.jobconf).getClusterStatus().getTaskTrackers()));
        return opCount != 0;
    }

    private static void checkDuplication(FileSystem fs, Path file, Path sorted, Configuration conf) throws IOException {
        SequenceFile.Sorter sorter = new SequenceFile.Sorter(fs, (RawComparator)new Text.Comparator(), Text.class, FileOperation.class, conf);
        sorter.sort(file, sorted);
        try (SequenceFile.Reader in = new SequenceFile.Reader(fs, sorted, conf);){
            FileOperation curop = new FileOperation();
            Text prevsrc = null;
            Text cursrc = new Text();
            while (in.next((Writable)cursrc, (Writable)curop)) {
                if (prevsrc != null && cursrc.equals((Object)prevsrc)) {
                    throw new DistTool.DuplicationException("Invalid input, there are duplicated files in the sources: " + prevsrc + ", " + cursrc);
                }
                prevsrc = cursrc;
                cursrc = new Text();
                curop = new FileOperation();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        System.exit(ToolRunner.run((Tool)new DistCh(new Configuration()), (String[])args));
    }

    static class ChangeFilesMapper
    implements Mapper<Text, FileOperation, WritableComparable<?>, Text> {
        private JobConf jobconf;
        private boolean ignoreFailures;
        private int failcount = 0;
        private int succeedcount = 0;

        ChangeFilesMapper() {
        }

        private String getCountString() {
            return "Succeeded: " + this.succeedcount + " Failed: " + this.failcount;
        }

        public void configure(JobConf job) {
            this.jobconf = job;
            this.ignoreFailures = job.getBoolean(Option.IGNORE_FAILURES.propertyname, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void map(Text key, FileOperation value, OutputCollector<WritableComparable<?>, Text> out, Reporter reporter) throws IOException {
            try {
                value.run((Configuration)this.jobconf);
                ++this.succeedcount;
                reporter.incrCounter((Enum)Counter.SUCCEED, 1L);
            }
            catch (IOException e) {
                ++this.failcount;
                reporter.incrCounter((Enum)Counter.FAIL, 1L);
                String s = "FAIL: " + value + ", " + StringUtils.stringifyException((Throwable)e);
                out.collect(null, (Object)new Text(s));
                DistTool.LOG.info((Object)s);
            }
            finally {
                reporter.setStatus(this.getCountString());
            }
        }

        public void close() throws IOException {
            if (this.failcount == 0 || this.ignoreFailures) {
                return;
            }
            throw new IOException(this.getCountString());
        }
    }

    static class ChangeInputFormat
    implements InputFormat<Text, FileOperation> {
        ChangeInputFormat() {
        }

        public void validateInput(JobConf job) {
        }

        public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
            int srcCount = job.getInt(DistCh.OP_COUNT_LABEL, -1);
            int targetcount = srcCount / numSplits;
            String srclist = job.get(DistCh.OP_LIST_LABEL, "");
            if (srcCount < 0 || "".equals(srclist)) {
                throw new RuntimeException("Invalid metadata: #files(" + srcCount + ") listuri(" + srclist + ")");
            }
            Path srcs = new Path(srclist);
            FileSystem fs = srcs.getFileSystem((Configuration)job);
            ArrayList<FileSplit> splits = new ArrayList<FileSplit>(numSplits);
            Text key = new Text();
            FileOperation value = new FileOperation();
            long prev = 0L;
            int count = 0;
            try (SequenceFile.Reader in = new SequenceFile.Reader(fs, srcs, (Configuration)job);){
                while (in.next((Writable)key, (Writable)value)) {
                    long curr = in.getPosition();
                    long delta = curr - prev;
                    if (++count <= targetcount) continue;
                    count = 0;
                    splits.add(new FileSplit(srcs, prev, delta, (String[])null));
                    prev = curr;
                }
            }
            long remaining = fs.getFileStatus(srcs).getLen() - prev;
            if (remaining != 0L) {
                splits.add(new FileSplit(srcs, prev, remaining, (String[])null));
            }
            DistTool.LOG.info((Object)("numSplits=" + numSplits + ", splits.size()=" + splits.size()));
            return (InputSplit[])splits.toArray(new FileSplit[splits.size()]);
        }

        public RecordReader<Text, FileOperation> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
            return new SequenceFileRecordReader((Configuration)job, (FileSplit)split);
        }
    }

    static class FileOperation
    implements Writable {
        private Path src;
        private String owner;
        private String group;
        private FsPermission permission;
        static final FsPermission FILE_UMASK = FsPermission.createImmutable((short)73);

        FileOperation() {
        }

        FileOperation(Path src, FileOperation that) {
            this.src = src;
            this.owner = that.owner;
            this.group = that.group;
            this.permission = that.permission;
            this.checkState();
        }

        FileOperation(String line) {
            try {
                String[] t = line.split(":", 4);
                for (int i = 0; i < t.length; ++i) {
                    if (!"".equals(t[i])) continue;
                    t[i] = null;
                }
                this.src = new Path(t[0]);
                this.owner = t[1];
                this.group = t[2];
                this.permission = t[3] == null ? null : new FsPermission(Short.parseShort(t[3], 8));
                this.checkState();
            }
            catch (Exception e) {
                throw (IllegalArgumentException)new IllegalArgumentException("line=" + line).initCause(e);
            }
        }

        private void checkState() throws IllegalStateException {
            if (this.owner == null && this.group == null && this.permission == null) {
                throw new IllegalStateException("owner == null && group == null && permission == null");
            }
        }

        private boolean isDifferent(FileStatus original) {
            if (this.owner != null && !this.owner.equals(original.getOwner())) {
                return true;
            }
            if (this.group != null && !this.group.equals(original.getGroup())) {
                return true;
            }
            if (this.permission != null) {
                FsPermission orig = original.getPermission();
                return original.isDirectory() ? !this.permission.equals((Object)orig) : !this.permission.applyUMask(FILE_UMASK).equals((Object)orig);
            }
            return false;
        }

        void run(Configuration conf) throws IOException {
            FileSystem fs = this.src.getFileSystem(conf);
            if (this.permission != null) {
                fs.setPermission(this.src, this.permission);
            }
            if (this.owner != null || this.group != null) {
                fs.setOwner(this.src, this.owner, this.group);
            }
        }

        public void readFields(DataInput in) throws IOException {
            this.src = new Path(Text.readString((DataInput)in));
            this.owner = DistTool.readString(in);
            this.group = DistTool.readString(in);
            this.permission = in.readBoolean() ? FsPermission.read((DataInput)in) : null;
        }

        public void write(DataOutput out) throws IOException {
            Text.writeString((DataOutput)out, (String)this.src.toString());
            DistTool.writeString(out, this.owner);
            DistTool.writeString(out, this.group);
            boolean b = this.permission != null;
            out.writeBoolean(b);
            if (b) {
                this.permission.write(out);
            }
        }

        public String toString() {
            return this.src + ":" + this.owner + ":" + this.group + ":" + this.permission;
        }
    }

    static enum Option {
        IGNORE_FAILURES("-i", "distch.ignore.failures");

        final String cmd;
        final String propertyname;

        private Option(String cmd, String propertyname) {
            this.cmd = cmd;
            this.propertyname = propertyname;
        }
    }

    static enum Counter {
        SUCCEED,
        FAIL;

    }
}

