/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.client;

public interface HdfsClientConfigKeys {
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final String DFS_BLOCK_SIZE_KEY = "dfs.blocksize";
    public static final long DFS_BLOCK_SIZE_DEFAULT = 0x8000000L;
    public static final String DFS_REPLICATION_KEY = "dfs.replication";
    public static final short DFS_REPLICATION_DEFAULT = 3;
    public static final String DFS_WEBHDFS_USER_PATTERN_KEY = "dfs.webhdfs.user.provider.user.pattern";
    public static final String DFS_WEBHDFS_USER_PATTERN_DEFAULT = "^[A-Za-z_][A-Za-z0-9._-]*[$]?$";
    public static final String DFS_WEBHDFS_ACL_PERMISSION_PATTERN_DEFAULT = "^(default:)?(user|group|mask|other):[[A-Za-z_][A-Za-z0-9._-]]*:([rwx-]{3})?(,(default:)?(user|group|mask|other):[[A-Za-z_][A-Za-z0-9._-]]*:([rwx-]{3})?)*$";
    public static final String PREFIX = "dfs.client.";
    public static final String DFS_NAMESERVICES = "dfs.nameservices";
    public static final String DFS_NAMENODE_HTTP_PORT_KEY = "dfs.http.port";
    public static final int DFS_NAMENODE_HTTP_PORT_DEFAULT = 50070;
    public static final String DFS_NAMENODE_HTTP_ADDRESS_KEY = "dfs.namenode.http-address";
    public static final String DFS_NAMENODE_HTTPS_PORT_KEY = "dfs.https.port";
    public static final int DFS_NAMENODE_HTTPS_PORT_DEFAULT = 50470;
    public static final String DFS_NAMENODE_HTTPS_ADDRESS_KEY = "dfs.namenode.https-address";
    public static final String DFS_HA_NAMENODES_KEY_PREFIX = "dfs.ha.namenodes";

    public static interface HttpClient {
        public static final String PREFIX = "dfs.http.client.";
        public static final String RETRY_POLICY_ENABLED_KEY = "dfs.http.client.retry.policy.enabled";
        public static final boolean RETRY_POLICY_ENABLED_DEFAULT = false;
        public static final String RETRY_POLICY_SPEC_KEY = "dfs.http.client.retry.policy.spec";
        public static final String RETRY_POLICY_SPEC_DEFAULT = "10000,6,60000,10";
        public static final String RETRY_MAX_ATTEMPTS_KEY = "dfs.http.client.retry.max.attempts";
        public static final int RETRY_MAX_ATTEMPTS_DEFAULT = 10;
        public static final String FAILOVER_MAX_ATTEMPTS_KEY = "dfs.http.client.failover.max.attempts";
        public static final int FAILOVER_MAX_ATTEMPTS_DEFAULT = 15;
        public static final String FAILOVER_SLEEPTIME_BASE_KEY = "dfs.http.client.failover.sleep.base.millis";
        public static final int FAILOVER_SLEEPTIME_BASE_DEFAULT = 500;
        public static final String FAILOVER_SLEEPTIME_MAX_KEY = "dfs.http.client.failover.sleep.max.millis";
        public static final int FAILOVER_SLEEPTIME_MAX_DEFAULT = 15000;
    }

    public static interface HedgedRead {
        public static final String THRESHOLD_MILLIS_KEY = "dfs.client.threshold.millis";
        public static final long THRESHOLD_MILLIS_DEFAULT = 500L;
        public static final String THREADPOOL_SIZE_KEY = "dfs.client.threadpool.size";
        public static final int THREADPOOL_SIZE_DEFAULT = 0;
    }

    public static interface Mmap {
        public static final String PREFIX = "dfs.client.mmap.";
        public static final String ENABLED_KEY = "dfs.client.mmap.enabled";
        public static final boolean ENABLED_DEFAULT = true;
        public static final String CACHE_SIZE_KEY = "dfs.client.mmap.cache.size";
        public static final int CACHE_SIZE_DEFAULT = 256;
        public static final String CACHE_TIMEOUT_MS_KEY = "dfs.client.mmap.cache.timeout.ms";
        public static final long CACHE_TIMEOUT_MS_DEFAULT = 3600000L;
        public static final String RETRY_TIMEOUT_MS_KEY = "dfs.client.mmap.retry.timeout.ms";
        public static final long RETRY_TIMEOUT_MS_DEFAULT = 300000L;
    }

    public static interface ShortCircuit {
        public static final String PREFIX = "dfs.client.read.short.circuit.";
        public static final String REPLICA_STALE_THRESHOLD_MS_KEY = "dfs.client.read.short.circuit.replica.stale.threshold.ms";
        public static final long REPLICA_STALE_THRESHOLD_MS_DEFAULT = 1800000L;
    }

    public static interface Read {
        public static final String PREFIX = "dfs.client.read.";
        public static final String PREFETCH_SIZE_KEY = "dfs.client.read.prefetch.size";

        public static interface ShortCircuit {
            public static final String PREFIX = "dfs.client.read.shortcircuit.";
            public static final String KEY = "dfs.client.read.shortcircuit.".substring(0, "dfs.client.read.shortcircuit.".length() - 1);
            public static final boolean DEFAULT = false;
            public static final String SKIP_CHECKSUM_KEY = "dfs.client.read.shortcircuit.skip.checksum";
            public static final boolean SKIP_CHECKSUM_DEFAULT = false;
            public static final String BUFFER_SIZE_KEY = "dfs.client.read.shortcircuit.buffer.size";
            public static final int BUFFER_SIZE_DEFAULT = 0x100000;
            public static final String STREAMS_CACHE_SIZE_KEY = "dfs.client.read.shortcircuit.streams.cache.size";
            public static final int STREAMS_CACHE_SIZE_DEFAULT = 256;
            public static final String STREAMS_CACHE_EXPIRY_MS_KEY = "dfs.client.read.shortcircuit.streams.cache.expiry.ms";
            public static final long STREAMS_CACHE_EXPIRY_MS_DEFAULT = 300000L;
        }
    }

    public static interface BlockWrite {
        public static final String PREFIX = "dfs.client.block.write.";
        public static final String RETRIES_KEY = "dfs.client.block.write.retries";
        public static final int RETRIES_DEFAULT = 3;
        public static final String LOCATEFOLLOWINGBLOCK_RETRIES_KEY = "dfs.client.block.write.locateFollowingBlock.retries";
        public static final int LOCATEFOLLOWINGBLOCK_RETRIES_DEFAULT = 5;
        public static final String LOCATEFOLLOWINGBLOCK_INITIAL_DELAY_MS_KEY = "dfs.client.block.write.locateFollowingBlock.initial.delay.ms";
        public static final int LOCATEFOLLOWINGBLOCK_INITIAL_DELAY_MS_DEFAULT = 400;

        public static interface ReplaceDatanodeOnFailure {
            public static final String PREFIX = "dfs.client.block.write.replace-datanode-on-failure.";
            public static final String ENABLE_KEY = "dfs.client.block.write.replace-datanode-on-failure.enable";
            public static final boolean ENABLE_DEFAULT = true;
            public static final String POLICY_KEY = "dfs.client.block.write.replace-datanode-on-failure.policy";
            public static final String POLICY_DEFAULT = "DEFAULT";
            public static final String BEST_EFFORT_KEY = "dfs.client.block.write.replace-datanode-on-failure.best-effort";
            public static final boolean BEST_EFFORT_DEFAULT = false;
        }
    }

    public static interface Write {
        public static final String PREFIX = "dfs.client.write.";
        public static final String MAX_PACKETS_IN_FLIGHT_KEY = "dfs.client.write.max-packets-in-flight";
        public static final int MAX_PACKETS_IN_FLIGHT_DEFAULT = 80;
        public static final String EXCLUDE_NODES_CACHE_EXPIRY_INTERVAL_KEY = "dfs.client.write.exclude.nodes.cache.expiry.interval.millis";
        public static final long EXCLUDE_NODES_CACHE_EXPIRY_INTERVAL_DEFAULT = 600000L;

        public static interface ByteArrayManager {
            public static final String PREFIX = "dfs.client.write.byte-array-manager.";
            public static final String ENABLED_KEY = "dfs.client.write.byte-array-manager.enabled";
            public static final boolean ENABLED_DEFAULT = false;
            public static final String COUNT_THRESHOLD_KEY = "dfs.client.write.byte-array-manager.count-threshold";
            public static final int COUNT_THRESHOLD_DEFAULT = 128;
            public static final String COUNT_LIMIT_KEY = "dfs.client.write.byte-array-manager.count-limit";
            public static final int COUNT_LIMIT_DEFAULT = 2048;
            public static final String COUNT_RESET_TIME_PERIOD_MS_KEY = "dfs.client.write.byte-array-manager.count-reset-time-period-ms";
            public static final long COUNT_RESET_TIME_PERIOD_MS_DEFAULT = 10000L;
        }
    }

    public static interface Failover {
        public static final String PREFIX = "dfs.client.failover.";
        public static final String PROXY_PROVIDER_KEY_PREFIX = "dfs.client.failover.proxy.provider";
        public static final String MAX_ATTEMPTS_KEY = "dfs.client.failover.max.attempts";
        public static final int MAX_ATTEMPTS_DEFAULT = 15;
        public static final String SLEEPTIME_BASE_KEY = "dfs.client.failover.sleep.base.millis";
        public static final int SLEEPTIME_BASE_DEFAULT = 500;
        public static final String SLEEPTIME_MAX_KEY = "dfs.client.failover.sleep.max.millis";
        public static final int SLEEPTIME_MAX_DEFAULT = 15000;
        public static final String CONNECTION_RETRIES_KEY = "dfs.client.failover.connection.retries";
        public static final int CONNECTION_RETRIES_DEFAULT = 0;
        public static final String CONNECTION_RETRIES_ON_SOCKET_TIMEOUTS_KEY = "dfs.client.failover.connection.retries.on.timeouts";
        public static final int CONNECTION_RETRIES_ON_SOCKET_TIMEOUTS_DEFAULT = 0;
    }

    public static interface Retry {
        public static final String PREFIX = "dfs.client.retry.";
        public static final String POLICY_ENABLED_KEY = "dfs.client.retry.policy.enabled";
        public static final boolean POLICY_ENABLED_DEFAULT = false;
        public static final String POLICY_SPEC_KEY = "dfs.client.retry.policy.spec";
        public static final String POLICY_SPEC_DEFAULT = "10000,6,60000,10";
        public static final String TIMES_GET_LAST_BLOCK_LENGTH_KEY = "dfs.client.retry.times.get-last-block-length";
        public static final int TIMES_GET_LAST_BLOCK_LENGTH_DEFAULT = 3;
        public static final String INTERVAL_GET_LAST_BLOCK_LENGTH_KEY = "dfs.client.retry.interval-ms.get-last-block-length";
        public static final int INTERVAL_GET_LAST_BLOCK_LENGTH_DEFAULT = 4000;
        public static final String MAX_ATTEMPTS_KEY = "dfs.client.retry.max.attempts";
        public static final int MAX_ATTEMPTS_DEFAULT = 10;
        public static final String WINDOW_BASE_KEY = "dfs.client.retry.window.base";
        public static final int WINDOW_BASE_DEFAULT = 3000;
    }
}

