/*
 * Decompiled with CFR 0.152.
 */
package io.hops.security;

import io.hops.common.security.HopsworksFsSecurityActions;
import io.hops.security.HopsSecurityActionsFactory;
import io.hops.security.HopsX509AuthenticationException;
import io.hops.security.TestingFsSecurityActions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math3.util.Pair;
import org.apache.commons.net.util.Base64;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.WebHdfsTestUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.ssl.HopsSSLTestUtils;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestWebHDFSHopsTLS
extends HopsSSLTestUtils {
    private static final Log LOG = LogFactory.getLog(TestWebHDFSHopsTLS.class);
    private static String classpathDir;
    private static Random rand;
    private Configuration conf;
    private MiniDFSCluster cluster;
    private UserGroupInformation ugi;
    private Pair<KeyPair, X509Certificate> caMaterial;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    public TestWebHDFSHopsTLS() {
        this.error_mode = HopsSSLTestUtils.CERT_ERR.NO_ERROR;
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        classpathDir = KeyStoreTestUtil.getClasspathDir(TestWebHDFSHopsTLS.class);
        rand = new Random();
    }

    @Before
    public void before() throws Exception {
        this.conf = WebHdfsTestUtil.createConf();
        this.conf.set("dfs.http.policy", "HTTPS_ONLY");
        this.conf.setBoolean("dfs.client.https.need-auth", true);
        this.ugi = UserGroupInformation.createRemoteUser((String)"project__user");
        this.caMaterial = this.generateCAMaterial("CN=CARoot");
        this.filesToPurge = this.prepareCryptoMaterial(classpathDir, this.caMaterial);
        this.setCryptoConfig(this.conf, classpathDir);
        this.conf.set("dfs.https.server.keystore.resource", this.conf.get("hadoop.ssl.server.conf", "ssl-server.xml"));
        this.conf.setBoolean("hadoop.ssl.require.client.cert", true);
        this.conf.set("dfs.security-actions.actor-class", "io.hops.security.TestingFsSecurityActions");
        HopsSecurityActionsFactory.getInstance().clear(this.conf.get("dfs.security-actions.actor-class", "io.hops.common.security.HopsworksFsSecurityActions"));
        String testDataPath = System.getProperty("test.build.data", "build/test/data");
        File testDataCluster = new File(testDataPath, "dfs_cluster");
        this.conf.set("hdfs.minidfs.basedir", testDataCluster.getAbsolutePath());
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).build();
        this.cluster.waitActive();
    }

    @After
    public void after() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
        HopsSecurityActionsFactory.getInstance().clear(this.conf.get("dfs.security-actions.actor-class", "io.hops.common.security.HopsworksFsSecurityActions"));
    }

    @Test
    public void testOps() throws Exception {
        this.prepareFS();
        this.testOpsPrivate("CN=" + this.ugi.getUserName(), null);
    }

    @Test
    public void testOpsWithAppId() throws Exception {
        this.prepareFS();
        this.testOpsPrivate("CN=" + this.ugi.getUserName(), "application_1573690044319_1560");
    }

    @Test
    public void testWithMissingClientMaterial() throws Exception {
        this.prepareFS();
        Pair<KeyPair, X509Certificate> clientMaterial = this.createClientCertificate("CN=" + this.ugi.getUserName());
        java.nio.file.Path c_keystore = Paths.get(classpathDir, this.ugi.getUserName() + "_kstore.jks");
        java.nio.file.Path c_truststore = Paths.get(classpathDir, this.ugi.getUserName() + "_tstore.jks");
        this.filesToPurge.add(c_keystore);
        this.filesToPurge.add(c_truststore);
        KeyStoreTestUtil.createKeyStore((String)c_keystore.toString(), (String)this.passwd, (String)this.passwd, (String)this.ugi.getUserName(), (Key)((KeyPair)clientMaterial.getFirst()).getPrivate(), (Certificate)((Certificate)clientMaterial.getSecond()));
        KeyStoreTestUtil.createTrustStore((String)c_truststore.toString(), (String)this.passwd, (String)"CARoot", (Certificate)((Certificate)this.caMaterial.getSecond()));
        final Configuration clientConfiguration = new Configuration(this.conf);
        this.createClientSSLConf(c_keystore, c_truststore, clientConfiguration);
        final byte[] data = new byte[64];
        rand.nextBytes(data);
        this.expectedException.expect(IOException.class);
        this.expectedException.expectMessage("Could not find X.509 credentials for " + this.ugi.getUserName());
        this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                WebHdfsFileSystem fs = WebHdfsTestUtil.getWebHdfsFileSystem(clientConfiguration, "swebhdfs");
                FSDataOutputStream out = fs.create(new Path("/testfile"));
                out.write(data, 0, data.length);
                out.hflush();
                out.close();
                return null;
            }
        });
    }

    @Test
    public void testWrongCN() throws Exception {
        this.prepareFS();
        Pair<KeyPair, X509Certificate> clientMaterial = this.createClientCertificate("CN=WRONG" + this.ugi.getUserName());
        java.nio.file.Path c_keystore = Paths.get(classpathDir, "WRONG" + this.ugi.getUserName() + "_kstore.jks");
        java.nio.file.Path c_truststore = Paths.get(classpathDir, "WRONG" + this.ugi.getUserName() + "_tstore.jks");
        this.filesToPurge.add(c_keystore);
        this.filesToPurge.add(c_truststore);
        KeyStoreTestUtil.createKeyStore((String)c_keystore.toString(), (String)this.passwd, (String)this.passwd, (String)this.ugi.getUserName(), (Key)((KeyPair)clientMaterial.getFirst()).getPrivate(), (Certificate)((Certificate)clientMaterial.getSecond()));
        KeyStoreTestUtil.createTrustStore((String)c_truststore.toString(), (String)this.passwd, (String)"CARoot", (Certificate)((Certificate)this.caMaterial.getSecond()));
        final Configuration clientConfiguration = new Configuration(this.conf);
        this.createClientSSLConf(c_keystore, c_truststore, clientConfiguration);
        final byte[] data = new byte[64];
        rand.nextBytes(data);
        this.expectedException.expect(HopsX509AuthenticationException.class);
        this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                WebHdfsFileSystem fs = WebHdfsTestUtil.getWebHdfsFileSystem(clientConfiguration, "swebhdfs");
                FSDataOutputStream out = fs.create(new Path("/testfile"));
                out.write(data, 0, data.length);
                out.hflush();
                out.close();
                return null;
            }
        });
    }

    private void prepareFS() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        Path rootPath = new Path("/");
        fs.setPermission(rootPath, FsPermission.valueOf((String)"-rwxrwxrwx"));
        DistributedFileSystem dfs = (DistributedFileSystem)fs;
        dfs.addUser(this.ugi.getUserName());
        dfs.addGroup(this.ugi.getUserName());
        dfs.addUserToGroup(this.ugi.getUserName(), this.ugi.getUserName());
    }

    private void testOpsPrivate(String cn, String ou) throws Exception {
        Pair<KeyPair, X509Certificate> clientMaterial = this.createClientCertificate(cn, ou);
        java.nio.file.Path c_keystore = Paths.get(classpathDir, this.ugi.getUserName() + "_kstore.jks");
        java.nio.file.Path c_truststore = Paths.get(classpathDir, this.ugi.getUserName() + "_tstore.jks");
        this.filesToPurge.add(c_keystore);
        this.filesToPurge.add(c_truststore);
        KeyStoreTestUtil.createKeyStore((String)c_keystore.toString(), (String)this.passwd, (String)this.passwd, (String)this.ugi.getUserName(), (Key)((KeyPair)clientMaterial.getFirst()).getPrivate(), (Certificate)((Certificate)clientMaterial.getSecond()));
        KeyStoreTestUtil.createTrustStore((String)c_truststore.toString(), (String)this.passwd, (String)"CARoot", (Certificate)((Certificate)this.caMaterial.getSecond()));
        Pair<String, String> keystoresBase64 = this.readStoresBase64(c_keystore, c_truststore);
        TestingFsSecurityActions actor = (TestingFsSecurityActions)HopsSecurityActionsFactory.getInstance().getActor(this.conf, this.conf.get("dfs.security-actions.actor-class"));
        HopsworksFsSecurityActions.X509CredentialsDTO credentialsDTO = new HopsworksFsSecurityActions.X509CredentialsDTO();
        credentialsDTO.setFileExtension("jks");
        credentialsDTO.setkStore((String)keystoresBase64.getFirst());
        credentialsDTO.settStore((String)keystoresBase64.getSecond());
        credentialsDTO.setPassword(this.passwd);
        actor.setX509Credentials(this.ugi.getUserName(), credentialsDTO);
        final Configuration clientConfiguration = new Configuration(this.conf);
        this.createClientSSLConf(c_keystore, c_truststore, clientConfiguration);
        final Path testPath = new Path("/testfile");
        final byte[] data = new byte[65536];
        rand.nextBytes(data);
        this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                WebHdfsFileSystem fs = WebHdfsTestUtil.getWebHdfsFileSystem(clientConfiguration, "swebhdfs");
                FSDataOutputStream out = fs.create(testPath);
                out.write(data, 0, data.length);
                out.hflush();
                out.close();
                TimeUnit.SECONDS.sleep(1L);
                Assert.assertTrue((boolean)fs.exists(testPath));
                fs.setPermission(testPath, FsPermission.valueOf((String)"-rwxrwxrwx"));
                return null;
            }
        });
        this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                WebHdfsFileSystem fs = WebHdfsTestUtil.getWebHdfsFileSystem(clientConfiguration, "swebhdfs");
                byte[] buffer = new byte[data.length];
                FSDataInputStream in = fs.open(testPath);
                in.readFully(buffer);
                return null;
            }
        });
        this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                WebHdfsFileSystem fs = WebHdfsTestUtil.getWebHdfsFileSystem(clientConfiguration, "swebhdfs");
                FSDataOutputStream out = fs.append(testPath);
                out.write(data, 0, data.length);
                out.hflush();
                out.close();
                TimeUnit.MILLISECONDS.sleep(500L);
                return null;
            }
        });
    }

    private Pair<KeyPair, X509Certificate> createClientCertificate(String cn) throws Exception {
        return this.createClientCertificate(cn, null);
    }

    private Pair<KeyPair, X509Certificate> createClientCertificate(String cn, String ou) throws Exception {
        KeyPair keyPair = KeyStoreTestUtil.generateKeyPair((String)"RSA");
        X509Certificate x509 = KeyStoreTestUtil.generateSignedCertificate((String)cn, (String)ou, (KeyPair)keyPair, (int)42, (String)"SHA256withRSA", (PrivateKey)((KeyPair)this.caMaterial.getFirst()).getPrivate(), (X509Certificate)((X509Certificate)this.caMaterial.getSecond()));
        return new Pair((Object)keyPair, (Object)x509);
    }

    private Pair<String, String> readStoresBase64(java.nio.file.Path keystore, java.nio.file.Path truststore) throws IOException {
        byte[] keystoreBytes = Files.readAllBytes(keystore);
        byte[] truststoreBytes = Files.readAllBytes(truststore);
        return new Pair((Object)Base64.encodeBase64String((byte[])keystoreBytes), (Object)Base64.encodeBase64String((byte[])truststoreBytes));
    }

    private void createClientSSLConf(java.nio.file.Path keystore, java.nio.file.Path truststore, Configuration clientConf) throws IOException {
        Configuration sslClientConf = KeyStoreTestUtil.createClientSSLConfig((String)keystore.toString(), (String)this.passwd, (String)this.passwd, (String)truststore.toString(), (String)this.passwd, (String)"");
        sslClientConf.set("hadoop.ssl.enabled.protocols", "TLSv1.2,TLSv1.1");
        java.nio.file.Path sslClientPath = Paths.get(classpathDir, TestWebHDFSHopsTLS.class.getSimpleName() + ".ssl-client.xml");
        this.filesToPurge.add(sslClientPath);
        File sslClientFile = new File(sslClientPath.toUri());
        KeyStoreTestUtil.saveConfig((File)sslClientFile, (Configuration)sslClientConf);
        clientConf.set("hadoop.ssl.client.conf", TestWebHDFSHopsTLS.class.getSimpleName() + ".ssl-client.xml");
        clientConf.set("hadoop.ssl.hostname.verifier", "ALLOW_ALL");
    }
}

