/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.hdfs.dal.BlockInfoDataAccess;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.handler.RequestHandler;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.junit.Assert;
import org.junit.Test;

public class TestDFSRename {
    final Path dir = new Path("/test/rename/");

    static int countLease(MiniDFSCluster cluster) throws IOException {
        return NameNodeAdapter.getLeaseManager(cluster.getNamesystem()).countLease();
    }

    void list(FileSystem fs, String name) throws IOException {
        FileSystem.LOG.info((Object)("\n\n" + name));
        for (FileStatus s : fs.listStatus(this.dir)) {
            FileSystem.LOG.info((Object)("" + s.getPath()));
        }
    }

    static void createFile(FileSystem fs, Path f) throws IOException {
        FSDataOutputStream a_out = fs.create(f);
        a_out.writeBytes("something");
        a_out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRename() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            Assert.assertTrue((boolean)fs.mkdirs(this.dir));
            Path a = new Path(this.dir, "a");
            Path aa = new Path(this.dir, "aa");
            Path b = new Path(this.dir, "b");
            TestDFSRename.createFile((FileSystem)fs, a);
            Assert.assertEquals((long)0L, (long)TestDFSRename.countLease(cluster));
            FSDataOutputStream aa_out = fs.create(aa);
            aa_out.writeBytes("something");
            Assert.assertEquals((long)1L, (long)TestDFSRename.countLease(cluster));
            this.list((FileSystem)fs, "rename0");
            fs.rename(a, b);
            this.list((FileSystem)fs, "rename1");
            aa_out.writeBytes(" more");
            aa_out.close();
            this.list((FileSystem)fs, "rename2");
            Assert.assertEquals((long)0L, (long)TestDFSRename.countLease(cluster));
            Path dstPath = new Path("/c/d");
            Assert.assertFalse((boolean)fs.exists(dstPath));
            Assert.assertFalse((boolean)fs.rename(this.dir, dstPath));
            Path src = new Path("/a/b");
            Path dst = new Path("/a/b/c");
            TestDFSRename.createFile((FileSystem)fs, new Path(src, "foo"));
            Assert.assertFalse((boolean)fs.rename(src, dst));
            Assert.assertFalse((boolean)fs.rename(src.getParent(), dst.getParent()));
            src = new Path("/testPrefix");
            dst = new Path("/testPrefixfile");
            TestDFSRename.createFile((FileSystem)fs, src);
            Assert.assertTrue((boolean)fs.rename(src, dst));
            src = new Path("/a/b/c");
            TestDFSRename.createFile((FileSystem)fs, src);
            Assert.assertTrue((boolean)fs.rename(src, src));
            Assert.assertFalse((boolean)fs.rename(new Path("/a/b"), new Path("/a/b/")));
            Assert.assertTrue((boolean)fs.rename(src, new Path("/a/b/c/")));
            fs.delete(this.dir, true);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testRenameWithOverwrite() throws Exception {
        int replFactor = 2;
        long blockSize = 512L;
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
        DistributedFileSystem dfs = cluster.getFileSystem();
        try {
            long fileLen = 1536L;
            String src = "/foo/src";
            String dst = "/foo/dst";
            Path srcPath = new Path(src);
            Path dstPath = new Path(dst);
            DFSTestUtil.createFile((FileSystem)dfs, srcPath, fileLen, (short)2, 1L);
            DFSTestUtil.createFile((FileSystem)dfs, dstPath, fileLen, (short)2, 1L);
            LocatedBlocks lbs = NameNodeAdapter.getBlockLocations(cluster.getNameNode(), dst, 0L, fileLen);
            BlockManager bm = NameNodeAdapter.getNamesystem(cluster.getNameNode()).getBlockManager();
            Assert.assertTrue((bm.getStoredBlock(((LocatedBlock)lbs.getLocatedBlocks().get(0)).getBlock().getLocalBlock()) != null ? 1 : 0) != 0);
            BlockInfoContiguous block = bm.getStoredBlock(((LocatedBlock)lbs.getLocatedBlocks().get(0)).getBlock().getLocalBlock());
            dfs.rename(srcPath, dstPath, new Options.Rename[]{Options.Rename.OVERWRITE});
            BlockInfoContiguous b = this.getBlock(block.getBlockId(), block.getInodeId());
            Assert.assertTrue((b == null ? 1 : 0) != 0);
        }
        finally {
            if (dfs != null) {
                dfs.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private BlockInfoContiguous getBlock(final long blockId, final long inodeId) throws IOException {
        return (BlockInfoContiguous)new LightWeightRequestHandler((RequestHandler.OperationType)HDFSOperationType.TEST){

            public Object performTask() throws IOException {
                BlockInfoDataAccess da = (BlockInfoDataAccess)HdfsStorageFactory.getDataAccess(BlockInfoDataAccess.class);
                return da.findById(blockId, inodeId);
            }
        }.handle();
    }
}

