/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.Permission;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSInputChecker;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.AclTestHelpers;
import org.apache.hadoop.hdfs.server.protocol.BlockReport;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.BZip2Codec;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.PathUtils;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class TestDFSShell {
    private static final Log LOG = LogFactory.getLog(TestDFSShell.class);
    private static AtomicInteger counter = new AtomicInteger();
    private final int SUCCESS = 0;
    private final int ERROR = 1;
    static final String TEST_ROOT_DIR = PathUtils.getTestDirName(TestDFSShell.class);
    private static final String RAW_A1 = "raw.a1";
    private static final String TRUSTED_A1 = "trusted.a1";
    private static final String USER_A1 = "user.a1";
    private static final byte[] RAW_A1_VALUE = new byte[]{50, 50, 50};
    private static final byte[] TRUSTED_A1_VALUE = new byte[]{49, 49, 49};
    private static final byte[] USER_A1_VALUE = new byte[]{49, 50, 51};

    static Path writeFile(FileSystem fs, Path f) throws IOException {
        FSDataOutputStream out = fs.create(f);
        out.writeBytes("dhruba: " + f);
        out.close();
        Assert.assertTrue((boolean)fs.exists(f));
        return f;
    }

    static Path mkdir(FileSystem fs, Path p) throws IOException {
        Assert.assertTrue((boolean)fs.mkdirs(p));
        Assert.assertTrue((boolean)fs.exists(p));
        Assert.assertTrue((boolean)fs.getFileStatus(p).isDirectory());
        return p;
    }

    static File createLocalFile(File f) throws IOException {
        Assert.assertTrue((!f.exists() ? 1 : 0) != 0);
        PrintWriter out = new PrintWriter(f);
        out.print("createLocalFile: " + f.getAbsolutePath());
        out.flush();
        out.close();
        Assert.assertTrue((boolean)f.exists());
        Assert.assertTrue((boolean)f.isFile());
        return f;
    }

    static File createLocalFileWithRandomData(int fileLength, File f) throws IOException {
        Assert.assertTrue((!f.exists() ? 1 : 0) != 0);
        f.createNewFile();
        FileOutputStream out = new FileOutputStream(f.toString());
        byte[] buffer = new byte[fileLength];
        out.write(buffer);
        out.flush();
        out.close();
        return f;
    }

    static void show(String s) {
        System.out.println(Thread.currentThread().getStackTrace()[2] + " " + s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testZeroSizeFile() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        Assert.assertTrue((String)("Not a HDFS: " + fs.getUri()), (boolean)(fs instanceof DistributedFileSystem));
        DistributedFileSystem dfs = fs;
        try {
            File f1 = new File(TEST_ROOT_DIR, "f1");
            Assert.assertTrue((!f1.exists() ? 1 : 0) != 0);
            Assert.assertTrue((boolean)f1.createNewFile());
            Assert.assertTrue((boolean)f1.exists());
            Assert.assertTrue((boolean)f1.isFile());
            Assert.assertEquals((long)0L, (long)f1.length());
            Path root = TestDFSShell.mkdir((FileSystem)dfs, new Path("/test/zeroSizeFile"));
            Path remotef = new Path(root, "dst");
            TestDFSShell.show("copy local " + f1 + " to remote " + remotef);
            dfs.copyFromLocalFile(false, false, new Path(f1.getPath()), remotef);
            TestDFSShell.show("Block size = " + dfs.getFileStatus(remotef).getBlockSize());
            File f2 = new File(TEST_ROOT_DIR, "f2");
            Assert.assertTrue((!f2.exists() ? 1 : 0) != 0);
            dfs.copyToLocalFile(remotef, new Path(f2.getPath()));
            Assert.assertTrue((boolean)f2.exists());
            Assert.assertTrue((boolean)f2.isFile());
            Assert.assertEquals((long)0L, (long)f2.length());
            f1.delete();
            f2.delete();
        }
        finally {
            try {
                dfs.close();
            }
            catch (Exception exception) {}
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRecrusiveRm() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        Assert.assertTrue((String)("Not a HDFS: " + fs.getUri()), (boolean)(fs instanceof DistributedFileSystem));
        try {
            fs.mkdirs(new Path(new Path("parent"), "child"));
            try {
                fs.delete(new Path("parent"), false);
                assert (false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                fs.delete(new Path("parent"), true);
            }
            catch (IOException e) {
                assert (false);
            }
        }
        finally {
            try {
                fs.close();
            }
            catch (IOException iOException) {}
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDu() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        PrintStream psBackup = System.out;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream psOut = new PrintStream(out);
        System.setOut(psOut);
        FsShell shell = new FsShell();
        shell.setConf((Configuration)conf);
        try {
            Path myPath = new Path("/test/dir");
            Assert.assertTrue((boolean)fs.mkdirs(myPath));
            Assert.assertTrue((boolean)fs.exists(myPath));
            Path myFile = new Path("/test/dir/file");
            TestDFSShell.writeFile((FileSystem)fs, myFile);
            Assert.assertTrue((boolean)fs.exists(myFile));
            Path myFile2 = new Path("/test/dir/file2");
            TestDFSShell.writeFile((FileSystem)fs, myFile2);
            Assert.assertTrue((boolean)fs.exists(myFile2));
            String[] args = new String[]{"-du", "/test/dir"};
            int val = -1;
            try {
                val = shell.run(args);
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            Assert.assertTrue((val == 0 ? 1 : 0) != 0);
            String returnString = out.toString();
            out.reset();
            Assert.assertTrue((boolean)returnString.contains("22"));
            Assert.assertTrue((boolean)returnString.contains("23"));
        }
        finally {
            System.setOut(psBackup);
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPut() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        Assert.assertTrue((String)("Not a HDFS: " + fs.getUri()), (boolean)(fs instanceof DistributedFileSystem));
        final DistributedFileSystem dfs = fs;
        try {
            new File(TEST_ROOT_DIR, ".f1.crc").delete();
            new File(TEST_ROOT_DIR, ".f2.crc").delete();
            File f1 = TestDFSShell.createLocalFile(new File(TEST_ROOT_DIR, "f1"));
            final File f2 = TestDFSShell.createLocalFile(new File(TEST_ROOT_DIR, "f2"));
            Path root = TestDFSShell.mkdir((FileSystem)dfs, new Path("/test/put"));
            final Path dst = new Path(root, "dst");
            TestDFSShell.show("begin");
            final Thread copy2ndFileThread = new Thread(){

                @Override
                public void run() {
                    try {
                        TestDFSShell.show("copy local " + f2 + " to remote " + dst);
                        dfs.copyFromLocalFile(false, false, new Path(f2.getPath()), dst);
                    }
                    catch (IOException ioe) {
                        TestDFSShell.show("good " + StringUtils.stringifyException((Throwable)ioe));
                        return;
                    }
                    Assert.assertTrue((boolean)false);
                }
            };
            SecurityManager sm = System.getSecurityManager();
            System.out.println("SecurityManager = " + sm);
            System.setSecurityManager(new SecurityManager(){
                private boolean firstTime = true;

                @Override
                public void checkPermission(Permission perm) {
                    String s;
                    Thread t;
                    if (this.firstTime && !(t = Thread.currentThread()).toString().contains("DataNode") && (s = "" + Arrays.asList(t.getStackTrace())).contains("FileUtil.copyContent")) {
                        this.firstTime = false;
                        copy2ndFileThread.start();
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            });
            TestDFSShell.show("copy local " + f1 + " to remote " + dst);
            dfs.copyFromLocalFile(false, false, new Path(f1.getPath()), dst);
            TestDFSShell.show("done");
            try {
                copy2ndFileThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.setSecurityManager(sm);
            Path destmultiple = TestDFSShell.mkdir((FileSystem)dfs, new Path("/test/putmultiple"));
            Path[] srcs = new Path[]{new Path(f1.getPath()), new Path(f2.getPath())};
            dfs.copyFromLocalFile(false, false, srcs, destmultiple);
            srcs[0] = new Path(destmultiple, "f1");
            srcs[1] = new Path(destmultiple, "f2");
            Assert.assertTrue((boolean)dfs.exists(srcs[0]));
            Assert.assertTrue((boolean)dfs.exists(srcs[1]));
            Path destmultiple2 = TestDFSShell.mkdir((FileSystem)dfs, new Path("/test/movemultiple"));
            srcs[0] = new Path(f1.getPath());
            srcs[1] = new Path(f2.getPath());
            dfs.moveFromLocalFile(srcs, destmultiple2);
            Assert.assertFalse((boolean)f1.exists());
            Assert.assertFalse((boolean)f2.exists());
            srcs[0] = new Path(destmultiple2, "f1");
            srcs[1] = new Path(destmultiple2, "f2");
            Assert.assertTrue((boolean)dfs.exists(srcs[0]));
            Assert.assertTrue((boolean)dfs.exists(srcs[1]));
            f1.delete();
            f2.delete();
        }
        finally {
            try {
                dfs.close();
            }
            catch (Exception exception) {}
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testErrOutPut() throws Exception {
        MiniDFSCluster cluster;
        block5: {
            HdfsConfiguration conf = new HdfsConfiguration();
            cluster = null;
            PrintStream bak = null;
            try {
                cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
                DistributedFileSystem srcFs = cluster.getFileSystem();
                Path root = new Path("/nonexistentfile");
                bak = System.err;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                PrintStream tmp = new PrintStream(out);
                System.setErr(tmp);
                String[] argv = new String[]{"-cat", root.toUri().getPath()};
                int ret = ToolRunner.run((Tool)new FsShell(), (String[])argv);
                Assert.assertEquals((String)" -cat returned 1 ", (long)1L, (long)ret);
                String returned = out.toString();
                Assert.assertTrue((String)"cat does not print exceptions ", (returned.lastIndexOf("Exception") == -1 ? 1 : 0) != 0);
                out.reset();
                argv[0] = "-rm";
                argv[1] = root.toString();
                FsShell shell = new FsShell();
                shell.setConf((Configuration)conf);
                ret = ToolRunner.run((Tool)shell, (String[])argv);
                Assert.assertEquals((String)" -rm returned 1 ", (long)1L, (long)ret);
                returned = out.toString();
                out.reset();
                Assert.assertTrue((String)"rm prints reasonable error ", (returned.lastIndexOf("No such file or directory") != -1 ? 1 : 0) != 0);
                argv[0] = "-rmr";
                argv[1] = root.toString();
                ret = ToolRunner.run((Tool)shell, (String[])argv);
                Assert.assertEquals((String)" -rmr returned 1", (long)1L, (long)ret);
                returned = out.toString();
                Assert.assertTrue((String)"rmr prints reasonable error ", (returned.lastIndexOf("No such file or directory") != -1 ? 1 : 0) != 0);
                out.reset();
                argv[0] = "-du";
                argv[1] = "/nonexistentfile";
                ret = ToolRunner.run((Tool)shell, (String[])argv);
                returned = out.toString();
                Assert.assertTrue((String)" -du prints reasonable error ", (returned.lastIndexOf("No such file or directory") != -1 ? 1 : 0) != 0);
                out.reset();
                argv[0] = "-dus";
                argv[1] = "/nonexistentfile";
                ret = ToolRunner.run((Tool)shell, (String[])argv);
                returned = out.toString();
                Assert.assertTrue((String)" -dus prints reasonable error", (returned.lastIndexOf("No such file or directory") != -1 ? 1 : 0) != 0);
                out.reset();
                argv[0] = "-ls";
                argv[1] = "/nonexistenfile";
                ret = ToolRunner.run((Tool)shell, (String[])argv);
                returned = out.toString();
                Assert.assertTrue((String)" -ls does not return Found 0 items", (returned.lastIndexOf("Found 0") == -1 ? 1 : 0) != 0);
                out.reset();
                argv[0] = "-ls";
                argv[1] = "/nonexistentfile";
                ret = ToolRunner.run((Tool)shell, (String[])argv);
                Assert.assertEquals((String)" -lsr should fail ", (long)1L, (long)ret);
                out.reset();
                srcFs.mkdirs(new Path("/testdir"));
                argv[0] = "-ls";
                argv[1] = "/testdir";
                ret = ToolRunner.run((Tool)shell, (String[])argv);
                returned = out.toString();
                Assert.assertTrue((String)" -ls does not print out anything ", (returned.lastIndexOf("Found 0") == -1 ? 1 : 0) != 0);
                out.reset();
                argv[0] = "-ls";
                argv[1] = "/user/nonxistant/*";
                ret = ToolRunner.run((Tool)shell, (String[])argv);
                Assert.assertEquals((String)" -ls on nonexistent glob returns 1", (long)1L, (long)ret);
                out.reset();
                argv[0] = "-mkdir";
                argv[1] = "/testdir";
                ret = ToolRunner.run((Tool)shell, (String[])argv);
                returned = out.toString();
                Assert.assertEquals((String)" -mkdir returned 1 ", (long)1L, (long)ret);
                Assert.assertTrue((String)" -mkdir returned File exists", (returned.lastIndexOf("File exists") != -1 ? 1 : 0) != 0);
                Path testFile = new Path("/testfile");
                FSDataOutputStream outtmp = srcFs.create(testFile);
                outtmp.write(testFile.toString().getBytes());
                outtmp.close();
                out.reset();
                argv[0] = "-mkdir";
                argv[1] = "/testfile";
                ret = ToolRunner.run((Tool)shell, (String[])argv);
                returned = out.toString();
                Assert.assertEquals((String)" -mkdir returned 1", (long)1L, (long)ret);
                Assert.assertTrue((String)" -mkdir returned this is a file ", (returned.lastIndexOf("not a directory") != -1 ? 1 : 0) != 0);
                out.reset();
                argv = new String[]{"-mv", "/testfile", "file"};
                ret = ToolRunner.run((Tool)shell, (String[])argv);
                Assert.assertEquals((String)"mv failed to rename", (long)1L, (long)ret);
                out.reset();
                argv = new String[]{"-mv", "/testfile", "/testfiletest"};
                ret = ToolRunner.run((Tool)shell, (String[])argv);
                returned = out.toString();
                Assert.assertTrue((String)"no output from rename", (returned.lastIndexOf("Renamed") == -1 ? 1 : 0) != 0);
                out.reset();
                argv[0] = "-mv";
                argv[1] = "/testfile";
                argv[2] = "/testfiletmp";
                ret = ToolRunner.run((Tool)shell, (String[])argv);
                returned = out.toString();
                Assert.assertTrue((String)" unix like output", (returned.lastIndexOf("No such file or") != -1 ? 1 : 0) != 0);
                out.reset();
                argv = new String[]{"-du"};
                srcFs.mkdirs(srcFs.getHomeDirectory());
                ret = ToolRunner.run((Tool)shell, (String[])argv);
                returned = out.toString();
                Assert.assertEquals((String)" no error ", (long)0L, (long)ret);
                Assert.assertTrue((String)"empty path specified", (returned.lastIndexOf("empty string") == -1 ? 1 : 0) != 0);
                out.reset();
                argv = new String[]{"-test", "-d", "/no/such/dir"};
                ret = ToolRunner.run((Tool)shell, (String[])argv);
                returned = out.toString();
                Assert.assertEquals((String)" -test -d wrong result ", (long)1L, (long)ret);
                Assert.assertTrue((boolean)returned.isEmpty());
                if (bak == null) break block5;
            }
            catch (Throwable throwable) {
                if (bak != null) {
                    System.setErr(bak);
                }
                if (cluster != null) {
                    cluster.shutdown();
                }
                throw throwable;
            }
            System.setErr(bak);
        }
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    public void testURIPaths() throws Exception {
        HdfsConfiguration srcConf = new HdfsConfiguration();
        HdfsConfiguration dstConf = new HdfsConfiguration();
        MiniDFSCluster srcCluster = null;
        MiniDFSCluster dstCluster = null;
        File bak = new File(PathUtils.getTestDir(this.getClass()), "dfs_tmp_uri");
        bak.mkdirs();
        try {
            srcCluster = new MiniDFSCluster.Builder((Configuration)srcConf).numDataNodes(2).build();
            dstConf.set("hdfs.minidfs.basedir", bak.getAbsolutePath());
            dstCluster = new MiniDFSCluster.Builder((Configuration)dstConf).numDataNodes(2).build();
            DistributedFileSystem srcFs = srcCluster.getFileSystem();
            DistributedFileSystem dstFs = dstCluster.getFileSystem();
            FsShell shell = new FsShell();
            shell.setConf((Configuration)srcConf);
            String[] argv = new String[]{"-ls", dstFs.getUri().toString() + "/"};
            int ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"ls works on remote uri ", (long)0L, (long)ret);
            dstFs.mkdirs(new Path("/hadoopdir"));
            argv = new String[]{"-rmr", dstFs.getUri().toString() + "/hadoopdir"};
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)("-rmr works on remote uri " + argv[1]), (long)0L, (long)ret);
            argv[0] = "-du";
            argv[1] = dstFs.getUri().toString() + "/";
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"du works on remote uri ", (long)0L, (long)ret);
            File furi = new File(TEST_ROOT_DIR, "furi");
            TestDFSShell.createLocalFile(furi);
            argv = new String[]{"-put", furi.toString(), dstFs.getUri().toString() + "/furi"};
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)" put is working ", (long)0L, (long)ret);
            argv[0] = "-cp";
            argv[1] = dstFs.getUri().toString() + "/furi";
            argv[2] = srcFs.getUri().toString() + "/furi";
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)" cp is working ", (long)0L, (long)ret);
            Assert.assertTrue((boolean)srcFs.exists(new Path("/furi")));
            argv = new String[]{"-cat", dstFs.getUri().toString() + "/furi"};
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)" cat is working ", (long)0L, (long)ret);
            dstFs.delete(new Path("/furi"), true);
            dstFs.delete(new Path("/hadoopdir"), true);
            String file = "/tmp/chownTest";
            Path path = new Path(file);
            Path parent = new Path("/tmp");
            Path root = new Path("/");
            TestDFSShell.writeFile((FileSystem)dstFs, path);
            TestDFSShell.runCmd(shell, "-chgrp", "-R", "herbivores", dstFs.getUri().toString() + "/*");
            this.confirmOwner(null, "herbivores", (FileSystem)dstFs, parent, path);
            TestDFSShell.runCmd(shell, "-chown", "-R", ":reptiles", dstFs.getUri().toString() + "/");
            this.confirmOwner(null, "reptiles", (FileSystem)dstFs, root, parent, path);
            argv[0] = "-cat";
            argv[1] = "hdfs:///furi";
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)" default works for cat", (long)0L, (long)ret);
            argv[0] = "-ls";
            argv[1] = "hdfs:///";
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"default works for ls ", (long)0L, (long)ret);
            argv[0] = "-rmr";
            argv[1] = "hdfs:///furi";
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"default works for rm/rmr", (long)0L, (long)ret);
        }
        finally {
            if (null != srcCluster) {
                srcCluster.shutdown();
            }
            if (null != dstCluster) {
                dstCluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testText() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
            DistributedFileSystem dfs = cluster.getFileSystem();
            this.textTest(new Path("/texttest").makeQualified(dfs.getUri(), dfs.getWorkingDirectory()), (Configuration)conf);
            conf.set("fs.defaultFS", dfs.getUri().toString());
            LocalFileSystem lfs = FileSystem.getLocal((Configuration)conf);
            this.textTest(new Path(TEST_ROOT_DIR, "texttest").makeQualified(lfs.getUri(), lfs.getWorkingDirectory()), (Configuration)conf);
        }
        finally {
            if (null != cluster) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void textTest(Path root, Configuration conf) throws Exception {
        PrintStream bak = null;
        try {
            FileSystem fs = root.getFileSystem(conf);
            fs.mkdirs(root);
            GZIPOutputStream zout = new GZIPOutputStream((OutputStream)fs.create(new Path(root, "file.gz")));
            Random r = new Random();
            bak = System.out;
            ByteArrayOutputStream file = new ByteArrayOutputStream();
            for (int i = 0; i < 1024; ++i) {
                char c = Character.forDigit(r.nextInt(26) + 10, 36);
                file.write(c);
                ((OutputStream)zout).write(c);
            }
            ((OutputStream)zout).close();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            System.setOut(new PrintStream(out));
            String[] argv = new String[]{"-text", new Path(root, "file.gz").toString()};
            int ret = ToolRunner.run((Tool)new FsShell(conf), (String[])argv);
            Assert.assertEquals((String)("'-text " + argv[1] + " returned " + ret), (long)0L, (long)ret);
            Assert.assertTrue((String)"Output doesn't match input", (boolean)Arrays.equals(file.toByteArray(), out.toByteArray()));
            SequenceFile.Writer writer = SequenceFile.createWriter((Configuration)conf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)new Path(root, "file.gz")), SequenceFile.Writer.keyClass(Text.class), SequenceFile.Writer.valueClass(Text.class)});
            writer.append((Writable)new Text("Foo"), (Writable)new Text("Bar"));
            writer.close();
            out = new ByteArrayOutputStream();
            System.setOut(new PrintStream(out));
            argv = new String[]{"-text", new Path(root, "file.gz").toString()};
            ret = ToolRunner.run((Tool)new FsShell(conf), (String[])argv);
            Assert.assertEquals((String)("'-text " + argv[1] + " returned " + ret), (long)0L, (long)ret);
            Assert.assertTrue((String)"Output doesn't match input", (boolean)Arrays.equals("Foo\tBar\n".getBytes(), out.toByteArray()));
            out.reset();
            DeflaterOutputStream dout = new DeflaterOutputStream((OutputStream)fs.create(new Path(root, "file.deflate")));
            byte[] outbytes = "foo".getBytes();
            ((OutputStream)dout).write(outbytes);
            ((OutputStream)dout).close();
            out = new ByteArrayOutputStream();
            System.setOut(new PrintStream(out));
            argv = new String[]{"-text", new Path(root, "file.deflate").toString()};
            ret = ToolRunner.run((Tool)new FsShell(conf), (String[])argv);
            Assert.assertEquals((String)("'-text " + argv[1] + " returned " + ret), (long)0L, (long)ret);
            Assert.assertTrue((String)"Output doesn't match input", (boolean)Arrays.equals(outbytes, out.toByteArray()));
            out.reset();
            CompressionCodec codec = (CompressionCodec)ReflectionUtils.newInstance(BZip2Codec.class, (Configuration)conf);
            String extension = codec.getDefaultExtension();
            Path p = new Path(root, "file." + extension);
            DataOutputStream fout = new DataOutputStream((OutputStream)codec.createOutputStream((OutputStream)fs.create(p, true)));
            byte[] writebytes = "foo".getBytes();
            ((OutputStream)fout).write(writebytes);
            ((OutputStream)fout).close();
            out = new ByteArrayOutputStream();
            System.setOut(new PrintStream(out));
            argv = new String[]{"-text", new Path(root, p).toString()};
            ret = ToolRunner.run((Tool)new FsShell(conf), (String[])argv);
            Assert.assertEquals((String)("'-text " + argv[1] + " returned " + ret), (long)0L, (long)ret);
            Assert.assertTrue((String)"Output doesn't match input", (boolean)Arrays.equals(writebytes, out.toByteArray()));
            out.reset();
            if (null == bak) return;
        }
        catch (Throwable throwable) {
            if (null == bak) throw throwable;
            System.setOut(bak);
            throw throwable;
        }
        System.setOut(bak);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyToLocal() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        Assert.assertTrue((String)("Not a HDFS: " + fs.getUri()), (boolean)(fs instanceof DistributedFileSystem));
        DistributedFileSystem dfs = fs;
        FsShell shell = new FsShell();
        shell.setConf((Configuration)conf);
        try {
            String root = TestDFSShell.createTree((FileSystem)dfs, "copyToLocal");
            try {
                Assert.assertEquals((long)0L, (long)TestDFSShell.runCmd(shell, "-copyToLocal", root + "*", TEST_ROOT_DIR));
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            File localroot = new File(TEST_ROOT_DIR, "copyToLocal");
            File localroot2 = new File(TEST_ROOT_DIR, "copyToLocal2");
            File f1 = new File(localroot, "f1");
            Assert.assertTrue((String)"Copying failed.", (boolean)f1.isFile());
            File f2 = new File(localroot, "f2");
            Assert.assertTrue((String)"Copying failed.", (boolean)f2.isFile());
            File sub = new File(localroot, "sub");
            Assert.assertTrue((String)"Copying failed.", (boolean)sub.isDirectory());
            File f3 = new File(sub, "f3");
            Assert.assertTrue((String)"Copying failed.", (boolean)f3.isFile());
            File f4 = new File(sub, "f4");
            Assert.assertTrue((String)"Copying failed.", (boolean)f4.isFile());
            File f5 = new File(localroot2, "f1");
            Assert.assertTrue((String)"Copying failed.", (boolean)f5.isFile());
            f1.delete();
            f2.delete();
            f3.delete();
            f4.delete();
            f5.delete();
            sub.delete();
            String[] args = new String[]{"-copyToLocal", "nosuchfile", TEST_ROOT_DIR};
            try {
                Assert.assertEquals((long)1L, (long)shell.run(args));
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            File f6 = new File(TEST_ROOT_DIR, "nosuchfile");
            Assert.assertTrue((!f6.exists() ? 1 : 0) != 0);
        }
        finally {
            try {
                dfs.close();
            }
            catch (Exception exception) {}
            cluster.shutdown();
        }
    }

    static String createTree(FileSystem fs, String name) throws IOException {
        String path = "/test/" + name;
        Path root = TestDFSShell.mkdir(fs, new Path(path));
        Path sub = TestDFSShell.mkdir(fs, new Path(root, "sub"));
        Path root2 = TestDFSShell.mkdir(fs, new Path(path + "2"));
        TestDFSShell.writeFile(fs, new Path(root, "f1"));
        TestDFSShell.writeFile(fs, new Path(root, "f2"));
        TestDFSShell.writeFile(fs, new Path(sub, "f3"));
        TestDFSShell.writeFile(fs, new Path(sub, "f4"));
        TestDFSShell.writeFile(fs, new Path(root2, "f1"));
        TestDFSShell.mkdir(fs, new Path(root2, "sub"));
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCount() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        DistributedFileSystem dfs = cluster.getFileSystem();
        FsShell shell = new FsShell();
        shell.setConf((Configuration)conf);
        try {
            String root = TestDFSShell.createTree((FileSystem)dfs, "count");
            TestDFSShell.runCount(root, 2L, 4L, shell);
            TestDFSShell.runCount(root + "2", 2L, 1L, shell);
            TestDFSShell.runCount(root + "2/f1", 0L, 1L, shell);
            TestDFSShell.runCount(root + "2/sub", 1L, 0L, shell);
            LocalFileSystem localfs = FileSystem.getLocal((Configuration)conf);
            Path localpath = new Path(TEST_ROOT_DIR, "testcount");
            localpath = localpath.makeQualified(localfs.getUri(), localfs.getWorkingDirectory());
            localfs.mkdirs(localpath);
            String localstr = localpath.toString();
            System.out.println("localstr=" + localstr);
            TestDFSShell.runCount(localstr, 1L, 0L, shell);
            Assert.assertEquals((long)0L, (long)TestDFSShell.runCmd(shell, "-count", root, localstr));
        }
        finally {
            try {
                dfs.close();
            }
            catch (Exception exception) {}
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runCount(String path, long dirs, long files, FsShell shell) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bytes);
        PrintStream oldOut = System.out;
        System.setOut(out);
        Scanner in = null;
        String results = null;
        try {
            TestDFSShell.runCmd(shell, "-count", path);
            results = bytes.toString();
            in = new Scanner(results);
            Assert.assertEquals((long)dirs, (long)in.nextLong());
            Assert.assertEquals((long)files, (long)in.nextLong());
        }
        finally {
            if (in != null) {
                in.close();
            }
            IOUtils.closeStream((Closeable)out);
            System.setOut(oldOut);
            System.out.println("results:\n" + results);
        }
    }

    private static int runCmd(FsShell shell, String ... args) throws IOException {
        StringBuilder cmdline = new StringBuilder("RUN:");
        for (String arg : args) {
            cmdline.append(" " + arg);
        }
        LOG.info((Object)cmdline.toString());
        try {
            int exitCode = shell.run(args);
            LOG.info((Object)("RUN: " + args[0] + " exit=" + exitCode));
            return exitCode;
        }
        catch (IOException e) {
            LOG.error((Object)("RUN: " + args[0] + " IOException=" + e.getMessage()));
            throw e;
        }
        catch (RuntimeException e) {
            LOG.error((Object)("RUN: " + args[0] + " RuntimeException=" + e.getMessage()));
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)("RUN: " + args[0] + " Exception=" + e.getMessage()));
            throw new IOException(StringUtils.stringifyException((Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void testChmod(Configuration conf, FileSystem fs, String chmodDir) throws IOException {
        FsShell shell = new FsShell();
        shell.setConf(conf);
        try {
            Path dir = new Path(chmodDir);
            fs.delete(dir, true);
            fs.mkdirs(dir);
            this.confirmPermissionChange("u+rwx,g=rw,o-rwx", "rwxrw----", fs, shell, dir);
            Path file = new Path(chmodDir, "file");
            TestDFSShell.writeFile(fs, file);
            this.confirmPermissionChange("644", "rw-r--r--", fs, shell, file);
            TestDFSShell.runCmd(shell, "-chmod", "-R", "a+rwX", chmodDir);
            Assert.assertEquals((Object)"rwxrwxrwx", (Object)fs.getFileStatus(dir).getPermission().toString());
            Assert.assertEquals((Object)"rw-rw-rw-", (Object)fs.getFileStatus(file).getPermission().toString());
            Path dir2 = new Path(dir, "stickybit");
            fs.mkdirs(dir2);
            LOG.info((Object)("Testing sticky bit on: " + dir2));
            LOG.info((Object)("Sticky bit directory initial mode: " + fs.getFileStatus(dir2).getPermission()));
            this.confirmPermissionChange("u=rwx,g=rx,o=rx", "rwxr-xr-x", fs, shell, dir2);
            this.confirmPermissionChange("+t", "rwxr-xr-t", fs, shell, dir2);
            this.confirmPermissionChange("-t", "rwxr-xr-x", fs, shell, dir2);
            this.confirmPermissionChange("=t", "--------T", fs, shell, dir2);
            this.confirmPermissionChange("0000", "---------", fs, shell, dir2);
            this.confirmPermissionChange("1666", "rw-rw-rwT", fs, shell, dir2);
            this.confirmPermissionChange("777", "rwxrwxrwt", fs, shell, dir2);
            fs.delete(dir2, true);
            fs.delete(dir, true);
        }
        finally {
            try {
                fs.close();
                shell.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void confirmPermissionChange(String toApply, String expected, FileSystem fs, FsShell shell, Path dir2) throws IOException {
        LOG.info((Object)("Confirming permission change of " + toApply + " to " + expected));
        TestDFSShell.runCmd(shell, "-chmod", toApply, dir2.toString());
        String result = fs.getFileStatus(dir2).getPermission().toString();
        LOG.info((Object)("Permission change result: " + result));
        Assert.assertEquals((Object)expected, (Object)result);
    }

    private void confirmOwner(String owner, String group, FileSystem fs, Path ... paths) throws IOException {
        for (Path path : paths) {
            if (owner != null) {
                Assert.assertEquals((Object)owner, (Object)fs.getFileStatus(path).getOwner());
            }
            if (group == null) continue;
            Assert.assertEquals((Object)group, (Object)fs.getFileStatus(path).getGroup());
        }
    }

    @Test
    public void testFilePermissions() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        this.testChmod((Configuration)conf, (FileSystem)fs, new File(TEST_ROOT_DIR, "chmodTest").getAbsolutePath());
        conf.set("dfs.permissions.enabled", "true");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        fs = cluster.getFileSystem();
        this.testChmod((Configuration)conf, (FileSystem)fs, "/tmp/chmodTest");
        FsShell shell = new FsShell();
        shell.setConf((Configuration)conf);
        fs = cluster.getFileSystem();
        String file = "/tmp/chownTest";
        Path path = new Path(file);
        Path parent = new Path("/tmp");
        Path root = new Path("/");
        TestDFSShell.writeFile((FileSystem)fs, path);
        TestDFSShell.runCmd(shell, "-chgrp", "-R", "herbivores", "/*", "unknownFile*");
        this.confirmOwner(null, "herbivores", (FileSystem)fs, parent, path);
        TestDFSShell.runCmd(shell, "-chgrp", "mammals", file);
        this.confirmOwner(null, "mammals", (FileSystem)fs, path);
        TestDFSShell.runCmd(shell, "-chown", "-R", ":reptiles", "/");
        this.confirmOwner(null, "reptiles", (FileSystem)fs, root, parent, path);
        TestDFSShell.runCmd(shell, "-chown", "python:", "/nonExistentFile", file);
        this.confirmOwner("python", "reptiles", (FileSystem)fs, path);
        TestDFSShell.runCmd(shell, "-chown", "-R", "hadoop:toys", "unknownFile", "/");
        this.confirmOwner("hadoop", "toys", (FileSystem)fs, root, parent, path);
        TestDFSShell.runCmd(shell, "-chown", "hdfs.user", file);
        this.confirmOwner("hdfs.user", null, (FileSystem)fs, path);
        TestDFSShell.runCmd(shell, "-chown", "_Hdfs.User-10:_hadoop.users--", file);
        this.confirmOwner("_Hdfs.User-10", "_hadoop.users--", (FileSystem)fs, path);
        TestDFSShell.runCmd(shell, "-chown", "hdfs/hadoop-core@apache.org:asf-projects", file);
        this.confirmOwner("hdfs/hadoop-core@apache.org", "asf-projects", (FileSystem)fs, path);
        TestDFSShell.runCmd(shell, "-chgrp", "hadoop-core@apache.org/100", file);
        this.confirmOwner(null, "hadoop-core@apache.org/100", (FileSystem)fs, path);
        cluster.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDFSShell() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        Assert.assertTrue((String)("Not a HDFS: " + fs.getUri()), (boolean)(fs instanceof DistributedFileSystem));
        DistributedFileSystem fileSys = fs;
        FsShell shell = new FsShell();
        shell.setConf((Configuration)conf);
        try {
            Path myPath = new Path("/test/mkdirs");
            Assert.assertTrue((boolean)fileSys.mkdirs(myPath));
            Assert.assertTrue((boolean)fileSys.exists(myPath));
            Assert.assertTrue((boolean)fileSys.mkdirs(myPath));
            Path myFile = new Path("/test/mkdirs/myFile");
            TestDFSShell.writeFile((FileSystem)fileSys, myFile);
            Assert.assertTrue((boolean)fileSys.exists(myFile));
            Path myFile2 = new Path("/test/mkdirs/myFile2");
            TestDFSShell.writeFile((FileSystem)fileSys, myFile2);
            Assert.assertTrue((boolean)fileSys.exists(myFile2));
            String[] args = new String[]{"-rm", "/test/mkdirs/myFile*"};
            int val = -1;
            try {
                val = shell.run(args);
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            Assert.assertTrue((val == 0 ? 1 : 0) != 0);
            Assert.assertFalse((boolean)fileSys.exists(myFile));
            Assert.assertFalse((boolean)fileSys.exists(myFile2));
            TestDFSShell.writeFile((FileSystem)fileSys, myFile);
            Assert.assertTrue((boolean)fileSys.exists(myFile));
            TestDFSShell.writeFile((FileSystem)fileSys, myFile2);
            Assert.assertTrue((boolean)fileSys.exists(myFile2));
            args = new String[]{"-cat", "/test/mkdirs/myFile", "/test/mkdirs/myFile2"};
            val = -1;
            try {
                val = shell.run(args);
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run: " + StringUtils.stringifyException((Throwable)e));
            }
            Assert.assertTrue((val == 0 ? 1 : 0) != 0);
            fileSys.delete(myFile2, true);
            args = new String[]{"-cat", "/test/mkdirs/myFile1"};
            val = -1;
            try {
                val = shell.run(args);
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            Assert.assertTrue((val != 0 ? 1 : 0) != 0);
            args = new String[]{"-rm", "/test/mkdirs/myFile1"};
            val = -1;
            try {
                val = shell.run(args);
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            Assert.assertTrue((val != 0 ? 1 : 0) != 0);
            args = new String[]{"-rm", "/test/mkdirs/myFile"};
            val = -1;
            try {
                val = shell.run(args);
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            Assert.assertTrue((val == 0 ? 1 : 0) != 0);
            args = new String[]{"-test", "-e", "/test/mkdirs/noFileHere"};
            val = -1;
            try {
                val = shell.run(args);
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            Assert.assertEquals((long)1L, (long)val);
            args[1] = "-z";
            val = -1;
            try {
                val = shell.run(args);
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            Assert.assertEquals((long)1L, (long)val);
            args = new String[]{"-touchz", "/test/mkdirs/isFileHere"};
            val = -1;
            try {
                val = shell.run(args);
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            Assert.assertEquals((long)0L, (long)val);
            args = new String[]{"-touchz", "/test/mkdirs/thisDirNotExists/isFileHere"};
            val = -1;
            try {
                val = shell.run(args);
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            Assert.assertEquals((long)1L, (long)val);
            args = new String[]{"-test", "-e", "/test/mkdirs/isFileHere"};
            val = -1;
            try {
                val = shell.run(args);
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            Assert.assertEquals((long)0L, (long)val);
            args[1] = "-d";
            val = -1;
            try {
                val = shell.run(args);
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            Assert.assertEquals((long)1L, (long)val);
            args[1] = "-z";
            val = -1;
            try {
                val = shell.run(args);
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            Assert.assertEquals((long)0L, (long)val);
            args = new String[]{"-mkdir", "/test/dir1"};
            val = -1;
            try {
                val = shell.run(args);
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            Assert.assertEquals((long)0L, (long)val);
            String[] args1 = new String[]{"-cp", "/test/dir1", "/test/dir1/dir2"};
            val = 0;
            try {
                val = shell.run(args1);
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            Assert.assertEquals((long)1L, (long)val);
            args1[0] = "-cp";
            args1[1] = "/test/dir1";
            args1[2] = "/test/dir1foo";
            val = -1;
            try {
                val = shell.run(args1);
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            Assert.assertEquals((long)0L, (long)val);
            args = new String[]{"-test", "-f", "/test/mkdirs/noFileHere"};
            val = -1;
            try {
                val = shell.run(args);
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            Assert.assertEquals((long)1L, (long)val);
            args = new String[]{"-test", "-f", "/test/mkdirs"};
            val = -1;
            try {
                val = shell.run(args);
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            Assert.assertEquals((long)1L, (long)val);
            TestDFSShell.writeFile((FileSystem)fileSys, myFile);
            Assert.assertTrue((boolean)fileSys.exists(myFile));
            args = new String[]{"-test", "-f", myFile.toString()};
            val = -1;
            try {
                val = shell.run(args);
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            Assert.assertEquals((long)0L, (long)val);
            args = new String[]{"-test", "-s", "/test/mkdirs/noFileHere"};
            val = -1;
            try {
                val = shell.run(args);
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            Assert.assertEquals((long)1L, (long)val);
            args = new String[]{"-test", "-s", "/test/mkdirs/isFileHere"};
            val = -1;
            try {
                val = shell.run(args);
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            Assert.assertEquals((long)1L, (long)val);
            args = new String[]{"-test", "-s", myFile.toString()};
            val = -1;
            try {
                val = shell.run(args);
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            Assert.assertEquals((long)0L, (long)val);
        }
        finally {
            try {
                fileSys.close();
            }
            catch (Exception exception) {}
            cluster.shutdown();
        }
    }

    static List<File> getBlockFiles(MiniDFSCluster cluster) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        ArrayList<DataNode> datanodes = cluster.getDataNodes();
        String poolId = cluster.getNamesystem().getBlockPoolId();
        List<Map<DatanodeStorage, BlockReport>> blocks = cluster.getAllBlockReports(poolId);
        for (int i = 0; i < blocks.size(); ++i) {
            DataNode dn = (DataNode)datanodes.get(i);
            Map<DatanodeStorage, BlockReport> map = blocks.get(i);
            for (Map.Entry<DatanodeStorage, BlockReport> e : map.entrySet()) {
                for (Block b : e.getValue()) {
                    files.add(DataNodeTestUtils.getFile(dn, poolId, b.getBlockId()));
                }
            }
        }
        return files;
    }

    static void corrupt(List<File> files) throws IOException {
        for (File f : files) {
            StringBuilder content = new StringBuilder(DFSTestUtil.readFile(f));
            char c = content.charAt(0);
            c = (char)(c + '\u0001');
            content.setCharAt(0, c);
            PrintWriter out = new PrintWriter(f);
            out.print(content);
            out.flush();
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoteException() throws Exception {
        MiniDFSCluster dfs;
        block5: {
            UserGroupInformation tmpUGI = UserGroupInformation.createUserForTesting((String)"tmpname", (String[])new String[]{"mygroup"});
            dfs = null;
            PrintStream bak = null;
            try {
                HdfsConfiguration conf = new HdfsConfiguration();
                dfs = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
                DistributedFileSystem fs = dfs.getFileSystem();
                Path p = new Path("/foo");
                fs.mkdirs(p);
                fs.setPermission(p, new FsPermission(448));
                bak = System.err;
                tmpUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>((Configuration)conf){
                    final /* synthetic */ Configuration val$conf;
                    {
                        this.val$conf = configuration;
                    }

                    @Override
                    public Object run() throws Exception {
                        FsShell fshell = new FsShell(this.val$conf);
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        PrintStream tmp = new PrintStream(out);
                        System.setErr(tmp);
                        String[] args = new String[]{"-ls", "/foo"};
                        int ret = ToolRunner.run((Tool)fshell, (String[])args);
                        Assert.assertEquals((String)"returned should be 1", (long)1L, (long)ret);
                        String str = out.toString();
                        Assert.assertTrue((String)"permission denied printed", (str.indexOf("Permission denied") != -1 ? 1 : 0) != 0);
                        out.reset();
                        return null;
                    }
                });
                if (bak == null) break block5;
            }
            catch (Throwable throwable) {
                if (bak != null) {
                    System.setErr(bak);
                }
                if (dfs != null) {
                    dfs.shutdown();
                }
                throw throwable;
            }
            System.setErr(bak);
        }
        if (dfs != null) {
            dfs.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testGet() throws IOException {
        DFSTestUtil.setLogLevel2All(FSInputChecker.LOG);
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.client.retry.window.base", 10);
        conf.setInt("dfs.datanode.scan.period.hours", -1);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        DistributedFileSystem dfs = cluster.getFileSystem();
        try {
            String fname = "testGet.txt";
            File localf = TestDFSShell.createLocalFile(new File(TEST_ROOT_DIR, "testGet.txt"));
            String localfcontent = DFSTestUtil.readFile(localf);
            Path root = TestDFSShell.mkdir((FileSystem)dfs, new Path("/test/get"));
            final Path remotef = new Path(root, "testGet.txt");
            dfs.copyFromLocalFile(false, false, new Path(localf.getPath()), remotef);
            final FsShell shell = new FsShell();
            shell.setConf((Configuration)conf);
            TestGetRunner runner = new TestGetRunner(){
                private int count = 0;

                @Override
                public String run(int exitcode, String ... options) throws IOException {
                    String dst = new File(TEST_ROOT_DIR, "testGet.txt" + ++this.count).getAbsolutePath();
                    String[] args = new String[options.length + 3];
                    args[0] = "-get";
                    args[args.length - 2] = remotef.toString();
                    args[args.length - 1] = dst;
                    for (int i = 0; i < options.length; ++i) {
                        args[i + 1] = options[i];
                    }
                    TestDFSShell.show("args=" + Arrays.asList(args));
                    try {
                        Assert.assertEquals((long)exitcode, (long)shell.run(args));
                    }
                    catch (Exception e) {
                        Assert.assertTrue((String)StringUtils.stringifyException((Throwable)e), (boolean)false);
                    }
                    return exitcode == 0 ? DFSTestUtil.readFile(new File(dst)) : null;
                }
            };
            Assert.assertEquals((Object)localfcontent, (Object)runner.run(0, new String[0]));
            Assert.assertEquals((Object)localfcontent, (Object)runner.run(0, "-ignoreCrc"));
            List<File> files = TestDFSShell.getBlockFiles(cluster);
            TestDFSShell.show("files=" + files);
            TestDFSShell.corrupt(files);
            Assert.assertEquals(null, (Object)runner.run(1, new String[0]));
            String corruptedcontent = runner.run(0, "-ignoreCrc");
            Assert.assertEquals((Object)localfcontent.substring(1), (Object)corruptedcontent.substring(1));
            Assert.assertEquals((long)(localfcontent.charAt(0) + '\u0001'), (long)corruptedcontent.charAt(0));
            localf.delete();
        }
        finally {
            try {
                dfs.close();
            }
            catch (Exception exception) {}
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLsr() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        DistributedFileSystem dfs = cluster.getFileSystem();
        try {
            String root = TestDFSShell.createTree((FileSystem)dfs, "lsr");
            dfs.mkdirs(new Path(root, "zzz"));
            TestDFSShell.runLsr(new FsShell((Configuration)conf), root, 0);
            Path sub = new Path(root, "sub");
            dfs.setPermission(sub, new FsPermission(0));
            UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
            String tmpusername = ugi.getShortUserName() + "1";
            UserGroupInformation tmpUGI = UserGroupInformation.createUserForTesting((String)tmpusername, (String[])new String[]{tmpusername});
            String results = (String)tmpUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>((Configuration)conf, root){
                final /* synthetic */ Configuration val$conf;
                final /* synthetic */ String val$root;
                {
                    this.val$conf = configuration;
                    this.val$root = string;
                }

                @Override
                public String run() throws Exception {
                    return TestDFSShell.runLsr(new FsShell(this.val$conf), this.val$root, 1);
                }
            });
            Assert.assertTrue((boolean)results.contains("zzz"));
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String runLsr(FsShell shell, String root, int returnvalue) throws Exception {
        String results;
        System.out.println("root=" + root + ", returnvalue=" + returnvalue);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bytes);
        PrintStream oldOut = System.out;
        PrintStream oldErr = System.err;
        System.setOut(out);
        System.setErr(out);
        try {
            Assert.assertEquals((long)returnvalue, (long)shell.run(new String[]{"-lsr", root}));
            results = bytes.toString();
        }
        finally {
            IOUtils.closeStream((Closeable)out);
            System.setOut(oldOut);
            System.setErr(oldErr);
        }
        System.out.println("results:\n" + results);
        return results;
    }

    @Test
    public void testInvalidShell() throws Exception {
        Configuration conf = new Configuration();
        DFSAdmin admin = new DFSAdmin();
        admin.setConf(conf);
        int res = admin.run(new String[]{"-refreshNodes"});
        Assert.assertEquals((String)"expected to fail -1", (long)res, (long)-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testCopyCommandsWithPreserveOption() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.namenode.xattrs.enabled", true);
        conf.setBoolean("dfs.namenode.acls.enabled", true);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).format(true).build();
        FsShell shell = null;
        DistributedFileSystem fs = null;
        String testdir = "/tmp/TestDFSShell-testCopyCommandsWithPreserveOption-" + counter.getAndIncrement();
        Path hdfsTestDir = new Path(testdir);
        try {
            fs = cluster.getFileSystem();
            fs.mkdirs(hdfsTestDir);
            Path src = new Path(hdfsTestDir, "srcfile");
            fs.create(src).close();
            fs.setAcl(src, (List)Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "bar", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.EXECUTE)}));
            FileStatus status = fs.getFileStatus(src);
            long mtime = status.getModificationTime();
            long atime = status.getAccessTime();
            String owner = status.getOwner();
            String group = status.getGroup();
            FsPermission perm = status.getPermission();
            fs.setXAttr(src, USER_A1, USER_A1_VALUE);
            fs.setXAttr(src, TRUSTED_A1, TRUSTED_A1_VALUE);
            shell = new FsShell(conf);
            Path target1 = new Path(hdfsTestDir, "targetfile1");
            String[] argv = new String[]{"-cp", "-p", src.toUri().toString(), target1.toUri().toString()};
            int ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"cp -p is not working", (long)0L, (long)ret);
            FileStatus targetStatus = fs.getFileStatus(target1);
            Assert.assertEquals((long)mtime, (long)targetStatus.getModificationTime());
            Assert.assertEquals((long)atime, (long)targetStatus.getAccessTime());
            Assert.assertEquals((Object)owner, (Object)targetStatus.getOwner());
            Assert.assertEquals((Object)group, (Object)targetStatus.getGroup());
            FsPermission targetPerm = targetStatus.getPermission();
            Assert.assertTrue((boolean)perm.equals((Object)targetPerm));
            Map xattrs = fs.getXAttrs(target1);
            Assert.assertTrue((boolean)xattrs.isEmpty());
            List acls = fs.getAclStatus(target1).getEntries();
            Assert.assertTrue((boolean)acls.isEmpty());
            Assert.assertFalse((boolean)targetPerm.getAclBit());
            Path target2 = new Path(hdfsTestDir, "targetfile2");
            argv = new String[]{"-cp", "-ptop", src.toUri().toString(), target2.toUri().toString()};
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"cp -ptop is not working", (long)0L, (long)ret);
            targetStatus = fs.getFileStatus(target2);
            Assert.assertEquals((long)mtime, (long)targetStatus.getModificationTime());
            Assert.assertEquals((long)atime, (long)targetStatus.getAccessTime());
            Assert.assertEquals((Object)owner, (Object)targetStatus.getOwner());
            Assert.assertEquals((Object)group, (Object)targetStatus.getGroup());
            targetPerm = targetStatus.getPermission();
            Assert.assertTrue((boolean)perm.equals((Object)targetPerm));
            xattrs = fs.getXAttrs(target2);
            Assert.assertTrue((boolean)xattrs.isEmpty());
            acls = fs.getAclStatus(target2).getEntries();
            Assert.assertTrue((boolean)acls.isEmpty());
            Assert.assertFalse((boolean)targetPerm.getAclBit());
            Path target3 = new Path(hdfsTestDir, "targetfile3");
            argv = new String[]{"-cp", "-ptopx", src.toUri().toString(), target3.toUri().toString()};
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"cp -ptopx is not working", (long)0L, (long)ret);
            targetStatus = fs.getFileStatus(target3);
            Assert.assertEquals((long)mtime, (long)targetStatus.getModificationTime());
            Assert.assertEquals((long)atime, (long)targetStatus.getAccessTime());
            Assert.assertEquals((Object)owner, (Object)targetStatus.getOwner());
            Assert.assertEquals((Object)group, (Object)targetStatus.getGroup());
            targetPerm = targetStatus.getPermission();
            Assert.assertTrue((boolean)perm.equals((Object)targetPerm));
            xattrs = fs.getXAttrs(target3);
            Assert.assertEquals((long)xattrs.size(), (long)2L);
            Assert.assertArrayEquals((byte[])USER_A1_VALUE, (byte[])((byte[])xattrs.get(USER_A1)));
            Assert.assertArrayEquals((byte[])TRUSTED_A1_VALUE, (byte[])((byte[])xattrs.get(TRUSTED_A1)));
            acls = fs.getAclStatus(target3).getEntries();
            Assert.assertTrue((boolean)acls.isEmpty());
            Assert.assertFalse((boolean)targetPerm.getAclBit());
            Path target4 = new Path(hdfsTestDir, "targetfile4");
            argv = new String[]{"-cp", "-ptopa", src.toUri().toString(), target4.toUri().toString()};
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"cp -ptopa is not working", (long)0L, (long)ret);
            targetStatus = fs.getFileStatus(target4);
            Assert.assertEquals((long)mtime, (long)targetStatus.getModificationTime());
            Assert.assertEquals((long)atime, (long)targetStatus.getAccessTime());
            Assert.assertEquals((Object)owner, (Object)targetStatus.getOwner());
            Assert.assertEquals((Object)group, (Object)targetStatus.getGroup());
            targetPerm = targetStatus.getPermission();
            Assert.assertTrue((boolean)perm.equals((Object)targetPerm));
            xattrs = fs.getXAttrs(target4);
            Assert.assertTrue((boolean)xattrs.isEmpty());
            acls = fs.getAclStatus(target4).getEntries();
            Assert.assertFalse((boolean)acls.isEmpty());
            Assert.assertTrue((boolean)targetPerm.getAclBit());
            Assert.assertEquals((Object)fs.getAclStatus(src), (Object)fs.getAclStatus(target4));
            Path target5 = new Path(hdfsTestDir, "targetfile5");
            argv = new String[]{"-cp", "-ptoa", src.toUri().toString(), target5.toUri().toString()};
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"cp -ptoa is not working", (long)0L, (long)ret);
            targetStatus = fs.getFileStatus(target5);
            Assert.assertEquals((long)mtime, (long)targetStatus.getModificationTime());
            Assert.assertEquals((long)atime, (long)targetStatus.getAccessTime());
            Assert.assertEquals((Object)owner, (Object)targetStatus.getOwner());
            Assert.assertEquals((Object)group, (Object)targetStatus.getGroup());
            targetPerm = targetStatus.getPermission();
            Assert.assertTrue((boolean)perm.equals((Object)targetPerm));
            xattrs = fs.getXAttrs(target5);
            Assert.assertTrue((boolean)xattrs.isEmpty());
            acls = fs.getAclStatus(target5).getEntries();
            Assert.assertFalse((boolean)acls.isEmpty());
            Assert.assertTrue((boolean)targetPerm.getAclBit());
            Assert.assertEquals((Object)fs.getAclStatus(src), (Object)fs.getAclStatus(target5));
        }
        finally {
            if (null != shell) {
                shell.close();
            }
            if (null != fs) {
                fs.delete(hdfsTestDir, true);
                fs.close();
            }
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testCopyCommandsWithRawXAttrs() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.namenode.xattrs.enabled", true);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).format(true).build();
        FsShell shell = null;
        DistributedFileSystem fs = null;
        String testdir = "/tmp/TestDFSShell-testCopyCommandsWithRawXAttrs-" + counter.getAndIncrement();
        Path hdfsTestDir = new Path(testdir);
        Path rawHdfsTestDir = new Path("/.reserved/raw" + testdir);
        try {
            fs = cluster.getFileSystem();
            fs.mkdirs(hdfsTestDir);
            Path src = new Path(hdfsTestDir, "srcfile");
            String rawSrcBase = "/.reserved/raw" + testdir;
            Path rawSrc = new Path(rawSrcBase, "srcfile");
            fs.create(src).close();
            Path srcDir = new Path(hdfsTestDir, "srcdir");
            Path rawSrcDir = new Path("/.reserved/raw" + testdir, "srcdir");
            fs.mkdirs(srcDir);
            Path srcDirFile = new Path(srcDir, "srcfile");
            Path rawSrcDirFile = new Path("/.reserved/raw" + srcDirFile);
            fs.create(srcDirFile).close();
            Path[] paths = new Path[]{rawSrc, rawSrcDir, rawSrcDirFile};
            String[] xattrNames = new String[]{USER_A1, RAW_A1};
            byte[][] xattrVals = new byte[][]{USER_A1_VALUE, RAW_A1_VALUE};
            for (int i = 0; i < paths.length; ++i) {
                for (int j = 0; j < xattrNames.length; ++j) {
                    fs.setXAttr(paths[i], xattrNames[j], xattrVals[j]);
                }
            }
            shell = new FsShell(conf);
            this.doTestCopyCommandsWithRawXAttrs(shell, (FileSystem)fs, src, hdfsTestDir, false);
            this.doTestCopyCommandsWithRawXAttrs(shell, (FileSystem)fs, rawSrc, hdfsTestDir, false);
            this.doTestCopyCommandsWithRawXAttrs(shell, (FileSystem)fs, src, rawHdfsTestDir, false);
            this.doTestCopyCommandsWithRawXAttrs(shell, (FileSystem)fs, rawSrc, rawHdfsTestDir, true);
            Path savedWd = fs.getWorkingDirectory();
            try {
                fs.setWorkingDirectory(new Path(rawSrcBase));
                Path relRawSrc = new Path("../srcfile");
                Path relRawHdfsTestDir = new Path("..");
                this.doTestCopyCommandsWithRawXAttrs(shell, (FileSystem)fs, relRawSrc, relRawHdfsTestDir, true);
            }
            finally {
                fs.setWorkingDirectory(savedWd);
            }
            this.doTestCopyCommandsWithRawXAttrs(shell, (FileSystem)fs, srcDir, hdfsTestDir, false);
            this.doTestCopyCommandsWithRawXAttrs(shell, (FileSystem)fs, rawSrcDir, hdfsTestDir, false);
            this.doTestCopyCommandsWithRawXAttrs(shell, (FileSystem)fs, srcDir, rawHdfsTestDir, false);
            this.doTestCopyCommandsWithRawXAttrs(shell, (FileSystem)fs, rawSrcDir, rawHdfsTestDir, true);
            String relRawSrcDir = "./.reserved/../.reserved/raw/../raw" + testdir + "/srcdir";
            String relRawDstDir = "./.reserved/../.reserved/raw/../raw" + testdir;
            this.doTestCopyCommandsWithRawXAttrs(shell, (FileSystem)fs, new Path(relRawSrcDir), new Path(relRawDstDir), true);
        }
        finally {
            if (null != shell) {
                shell.close();
            }
            if (null != fs) {
                fs.delete(hdfsTestDir, true);
                fs.close();
            }
            cluster.shutdown();
        }
    }

    private void doTestCopyCommandsWithRawXAttrs(FsShell shell, FileSystem fs, Path src, Path hdfsTestDir, boolean expectRaw) throws Exception {
        Path target;
        boolean destIsRaw;
        boolean srcIsRaw = src.isAbsolute() ? src.toString().contains("/.reserved/raw") : new Path(fs.getWorkingDirectory(), src).toString().contains("/.reserved/raw");
        boolean srcDestMismatch = srcIsRaw ^ (destIsRaw = hdfsTestDir.toString().contains("/.reserved/raw"));
        if (srcDestMismatch) {
            this.doCopyAndTest(shell, hdfsTestDir, src, "-p", 1);
        } else {
            target = this.doCopyAndTest(shell, hdfsTestDir, src, "-p", 0);
            this.checkXAttrs(fs, target, expectRaw, false);
        }
        if (srcDestMismatch) {
            this.doCopyAndTest(shell, hdfsTestDir, src, "-px", 1);
        } else {
            target = this.doCopyAndTest(shell, hdfsTestDir, src, "-px", 0);
            this.checkXAttrs(fs, target, expectRaw, true);
        }
        if (srcDestMismatch) {
            this.doCopyAndTest(shell, hdfsTestDir, src, null, 1);
        } else {
            target = this.doCopyAndTest(shell, hdfsTestDir, src, null, 0);
            this.checkXAttrs(fs, target, expectRaw, false);
        }
    }

    private Path doCopyAndTest(FsShell shell, Path dest, Path src, String cpArgs, int expectedExitCode) throws Exception {
        String[] stringArray;
        Path target = new Path(dest, "targetfile" + counter.getAndIncrement());
        if (cpArgs == null) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "-cp";
            stringArray2[1] = src.toUri().toString();
            stringArray = stringArray2;
            stringArray2[2] = target.toUri().toString();
        } else {
            String[] stringArray3 = new String[4];
            stringArray3[0] = "-cp";
            stringArray3[1] = cpArgs;
            stringArray3[2] = src.toUri().toString();
            stringArray = stringArray3;
            stringArray3[3] = target.toUri().toString();
        }
        String[] argv = stringArray;
        int ret = ToolRunner.run((Tool)shell, (String[])argv);
        Assert.assertEquals((String)"cp -p is not working", (long)expectedExitCode, (long)ret);
        return target;
    }

    private void checkXAttrs(FileSystem fs, Path target, boolean expectRaw, boolean expectVanillaXAttrs) throws Exception {
        Map xattrs = fs.getXAttrs(target);
        int expectedCount = 0;
        if (expectRaw) {
            Assert.assertArrayEquals((String)"raw.a1 has incorrect value", (byte[])RAW_A1_VALUE, (byte[])((byte[])xattrs.get(RAW_A1)));
            ++expectedCount;
        }
        if (expectVanillaXAttrs) {
            Assert.assertArrayEquals((String)"user.a1 has incorrect value", (byte[])USER_A1_VALUE, (byte[])((byte[])xattrs.get(USER_A1)));
            ++expectedCount;
        }
        Assert.assertEquals((String)"xattrs size mismatch", (long)expectedCount, (long)xattrs.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testCopyCommandsToDirectoryWithPreserveOption() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.namenode.xattrs.enabled", true);
        conf.setBoolean("dfs.namenode.acls.enabled", true);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).format(true).build();
        FsShell shell = null;
        DistributedFileSystem fs = null;
        String testdir = "/tmp/TestDFSShell-testCopyCommandsToDirectoryWithPreserveOption-" + counter.getAndIncrement();
        Path hdfsTestDir = new Path(testdir);
        try {
            fs = cluster.getFileSystem();
            fs.mkdirs(hdfsTestDir);
            Path srcDir = new Path(hdfsTestDir, "srcDir");
            fs.mkdirs(srcDir);
            fs.setAcl(srcDir, (List)Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, "bar", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.EXECUTE)}));
            fs.setPermission(srcDir, new FsPermission(FsAction.ALL, FsAction.READ_EXECUTE, FsAction.EXECUTE, true));
            Path srcFile = new Path(srcDir, "srcFile");
            fs.create(srcFile).close();
            FileStatus status = fs.getFileStatus(srcDir);
            long mtime = status.getModificationTime();
            long atime = status.getAccessTime();
            String owner = status.getOwner();
            String group = status.getGroup();
            FsPermission perm = status.getPermission();
            fs.setXAttr(srcDir, USER_A1, USER_A1_VALUE);
            fs.setXAttr(srcDir, TRUSTED_A1, TRUSTED_A1_VALUE);
            shell = new FsShell(conf);
            Path targetDir1 = new Path(hdfsTestDir, "targetDir1");
            String[] argv = new String[]{"-cp", "-p", srcDir.toUri().toString(), targetDir1.toUri().toString()};
            int ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"cp -p is not working", (long)0L, (long)ret);
            FileStatus targetStatus = fs.getFileStatus(targetDir1);
            Assert.assertEquals((long)mtime, (long)targetStatus.getModificationTime());
            Assert.assertEquals((long)atime, (long)targetStatus.getAccessTime());
            Assert.assertEquals((Object)owner, (Object)targetStatus.getOwner());
            Assert.assertEquals((Object)group, (Object)targetStatus.getGroup());
            FsPermission targetPerm = targetStatus.getPermission();
            Assert.assertTrue((boolean)perm.equals((Object)targetPerm));
            Map xattrs = fs.getXAttrs(targetDir1);
            Assert.assertTrue((boolean)xattrs.isEmpty());
            List acls = fs.getAclStatus(targetDir1).getEntries();
            Assert.assertTrue((boolean)acls.isEmpty());
            Assert.assertFalse((boolean)targetPerm.getAclBit());
            Path targetDir2 = new Path(hdfsTestDir, "targetDir2");
            argv = new String[]{"-cp", "-ptop", srcDir.toUri().toString(), targetDir2.toUri().toString()};
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"cp -ptop is not working", (long)0L, (long)ret);
            targetStatus = fs.getFileStatus(targetDir2);
            Assert.assertEquals((long)mtime, (long)targetStatus.getModificationTime());
            Assert.assertEquals((long)atime, (long)targetStatus.getAccessTime());
            Assert.assertEquals((Object)owner, (Object)targetStatus.getOwner());
            Assert.assertEquals((Object)group, (Object)targetStatus.getGroup());
            targetPerm = targetStatus.getPermission();
            Assert.assertTrue((boolean)perm.equals((Object)targetPerm));
            xattrs = fs.getXAttrs(targetDir2);
            Assert.assertTrue((boolean)xattrs.isEmpty());
            acls = fs.getAclStatus(targetDir2).getEntries();
            Assert.assertTrue((boolean)acls.isEmpty());
            Assert.assertFalse((boolean)targetPerm.getAclBit());
            Path targetDir3 = new Path(hdfsTestDir, "targetDir3");
            argv = new String[]{"-cp", "-ptopx", srcDir.toUri().toString(), targetDir3.toUri().toString()};
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"cp -ptopx is not working", (long)0L, (long)ret);
            targetStatus = fs.getFileStatus(targetDir3);
            Assert.assertEquals((long)mtime, (long)targetStatus.getModificationTime());
            Assert.assertEquals((long)atime, (long)targetStatus.getAccessTime());
            Assert.assertEquals((Object)owner, (Object)targetStatus.getOwner());
            Assert.assertEquals((Object)group, (Object)targetStatus.getGroup());
            targetPerm = targetStatus.getPermission();
            Assert.assertTrue((boolean)perm.equals((Object)targetPerm));
            xattrs = fs.getXAttrs(targetDir3);
            Assert.assertEquals((long)xattrs.size(), (long)2L);
            Assert.assertArrayEquals((byte[])USER_A1_VALUE, (byte[])((byte[])xattrs.get(USER_A1)));
            Assert.assertArrayEquals((byte[])TRUSTED_A1_VALUE, (byte[])((byte[])xattrs.get(TRUSTED_A1)));
            acls = fs.getAclStatus(targetDir3).getEntries();
            Assert.assertTrue((boolean)acls.isEmpty());
            Assert.assertFalse((boolean)targetPerm.getAclBit());
            Path targetDir4 = new Path(hdfsTestDir, "targetDir4");
            argv = new String[]{"-cp", "-ptopa", srcDir.toUri().toString(), targetDir4.toUri().toString()};
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"cp -ptopa is not working", (long)0L, (long)ret);
            targetStatus = fs.getFileStatus(targetDir4);
            Assert.assertEquals((long)mtime, (long)targetStatus.getModificationTime());
            Assert.assertEquals((long)atime, (long)targetStatus.getAccessTime());
            Assert.assertEquals((Object)owner, (Object)targetStatus.getOwner());
            Assert.assertEquals((Object)group, (Object)targetStatus.getGroup());
            targetPerm = targetStatus.getPermission();
            Assert.assertTrue((boolean)perm.equals((Object)targetPerm));
            xattrs = fs.getXAttrs(targetDir4);
            Assert.assertTrue((boolean)xattrs.isEmpty());
            acls = fs.getAclStatus(targetDir4).getEntries();
            Assert.assertFalse((boolean)acls.isEmpty());
            Assert.assertTrue((boolean)targetPerm.getAclBit());
            Assert.assertEquals((Object)fs.getAclStatus(srcDir), (Object)fs.getAclStatus(targetDir4));
            Path targetDir5 = new Path(hdfsTestDir, "targetDir5");
            argv = new String[]{"-cp", "-ptoa", srcDir.toUri().toString(), targetDir5.toUri().toString()};
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"cp -ptoa is not working", (long)0L, (long)ret);
            targetStatus = fs.getFileStatus(targetDir5);
            Assert.assertEquals((long)mtime, (long)targetStatus.getModificationTime());
            Assert.assertEquals((long)atime, (long)targetStatus.getAccessTime());
            Assert.assertEquals((Object)owner, (Object)targetStatus.getOwner());
            Assert.assertEquals((Object)group, (Object)targetStatus.getGroup());
            targetPerm = targetStatus.getPermission();
            Assert.assertTrue((boolean)perm.equals((Object)targetPerm));
            xattrs = fs.getXAttrs(targetDir5);
            Assert.assertTrue((boolean)xattrs.isEmpty());
            acls = fs.getAclStatus(targetDir5).getEntries();
            Assert.assertFalse((boolean)acls.isEmpty());
            Assert.assertTrue((boolean)targetPerm.getAclBit());
            Assert.assertEquals((Object)fs.getAclStatus(srcDir), (Object)fs.getAclStatus(targetDir5));
        }
        finally {
            if (shell != null) {
                shell.close();
            }
            if (fs != null) {
                fs.delete(hdfsTestDir, true);
                fs.close();
            }
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testCopyCommandsPreserveAclAndStickyBit() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.namenode.acls.enabled", true);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).format(true).build();
        FsShell shell = null;
        DistributedFileSystem fs = null;
        String testdir = "/tmp/TestDFSShell-testCopyCommandsPreserveAclAndStickyBit-" + counter.getAndIncrement();
        Path hdfsTestDir = new Path(testdir);
        try {
            fs = cluster.getFileSystem();
            fs.mkdirs(hdfsTestDir);
            Path src = new Path(hdfsTestDir, "srcfile");
            fs.create(src).close();
            fs.setAcl(src, (List)Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "bar", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.EXECUTE)}));
            fs.setPermission(src, new FsPermission(FsAction.ALL, FsAction.READ_EXECUTE, FsAction.EXECUTE, true));
            FileStatus status = fs.getFileStatus(src);
            long mtime = status.getModificationTime();
            long atime = status.getAccessTime();
            String owner = status.getOwner();
            String group = status.getGroup();
            FsPermission perm = status.getPermission();
            shell = new FsShell(conf);
            Path target1 = new Path(hdfsTestDir, "targetfile1");
            String[] argv = new String[]{"-cp", "-p", src.toUri().toString(), target1.toUri().toString()};
            int ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"cp is not working", (long)0L, (long)ret);
            FileStatus targetStatus = fs.getFileStatus(target1);
            Assert.assertEquals((long)mtime, (long)targetStatus.getModificationTime());
            Assert.assertEquals((long)atime, (long)targetStatus.getAccessTime());
            Assert.assertEquals((Object)owner, (Object)targetStatus.getOwner());
            Assert.assertEquals((Object)group, (Object)targetStatus.getGroup());
            FsPermission targetPerm = targetStatus.getPermission();
            Assert.assertTrue((boolean)perm.equals((Object)targetPerm));
            List acls = fs.getAclStatus(target1).getEntries();
            Assert.assertTrue((boolean)acls.isEmpty());
            Assert.assertFalse((boolean)targetPerm.getAclBit());
            Path target2 = new Path(hdfsTestDir, "targetfile2");
            argv = new String[]{"-cp", "-ptopa", src.toUri().toString(), target2.toUri().toString()};
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"cp -ptopa is not working", (long)0L, (long)ret);
            targetStatus = fs.getFileStatus(target2);
            Assert.assertEquals((long)mtime, (long)targetStatus.getModificationTime());
            Assert.assertEquals((long)atime, (long)targetStatus.getAccessTime());
            Assert.assertEquals((Object)owner, (Object)targetStatus.getOwner());
            Assert.assertEquals((Object)group, (Object)targetStatus.getGroup());
            targetPerm = targetStatus.getPermission();
            Assert.assertTrue((boolean)perm.equals((Object)targetPerm));
            acls = fs.getAclStatus(target2).getEntries();
            Assert.assertFalse((boolean)acls.isEmpty());
            Assert.assertTrue((boolean)targetPerm.getAclBit());
            Assert.assertEquals((Object)fs.getAclStatus(src), (Object)fs.getAclStatus(target2));
        }
        finally {
            if (null != shell) {
                shell.close();
            }
            if (null != fs) {
                fs.delete(hdfsTestDir, true);
                fs.close();
            }
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyCommandsWithForceOption() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).format(true).build();
        FsShell shell = null;
        DistributedFileSystem fs = null;
        File localFile = new File(TEST_ROOT_DIR, "testFileForPut");
        String localfilepath = localFile.getAbsolutePath();
        String testdir = TEST_ROOT_DIR + "/ForceTestDir";
        Path hdfsTestDir = new Path(testdir);
        try {
            fs = cluster.getFileSystem();
            fs.mkdirs(hdfsTestDir);
            localFile.createNewFile();
            TestDFSShell.writeFile((FileSystem)fs, new Path(TEST_ROOT_DIR, "testFileForPut"));
            shell = new FsShell();
            String[] argv = new String[]{"-put", "-f", localfilepath, testdir};
            int res = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"put -f is not working", (long)0L, (long)res);
            argv = new String[]{"-put", localfilepath, testdir};
            res = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"put command itself is able to overwrite the file", (long)1L, (long)res);
            argv = new String[]{"-copyFromLocal", "-f", localfilepath, testdir};
            res = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"copyFromLocal -f is not working", (long)0L, (long)res);
            argv = new String[]{"-copyFromLocal", localfilepath, testdir};
            res = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"copyFromLocal command itself is able to overwrite the file", (long)1L, (long)res);
            argv = new String[]{"-cp", "-f", localfilepath, testdir};
            res = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"cp -f is not working", (long)0L, (long)res);
            argv = new String[]{"-cp", localfilepath, testdir};
            res = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"cp command itself is able to overwrite the file", (long)1L, (long)res);
        }
        finally {
            if (null != shell) {
                shell.close();
            }
            if (localFile.exists()) {
                localFile.delete();
            }
            if (null != fs) {
                fs.delete(hdfsTestDir, true);
                fs.close();
            }
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testSetrep() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).format(true).build();
        FsShell shell = null;
        DistributedFileSystem fs = null;
        String testdir1 = "/tmp/TestDFSShell-testSetrep-" + counter.getAndIncrement();
        String testdir2 = testdir1 + "/nestedDir";
        Path hdfsFile1 = new Path(testdir1, "testFileForSetrep");
        Path hdfsFile2 = new Path(testdir2, "testFileForSetrep");
        Short oldRepFactor = new Short(1);
        Short newRepFactor = new Short(3);
        try {
            cluster.waitActive();
            fs = cluster.getFileSystem();
            Assert.assertThat((Object)fs.mkdirs(new Path(testdir2)), (Matcher)CoreMatchers.is((Object)true));
            shell = new FsShell(conf);
            fs.create(hdfsFile1, true).close();
            fs.create(hdfsFile2, true).close();
            String[] argv = new String[]{"-setrep", newRepFactor.toString(), hdfsFile1.toString()};
            Assert.assertThat((Object)shell.run(argv), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)fs.getFileStatus(hdfsFile1).getReplication(), (Matcher)CoreMatchers.is((Object)newRepFactor));
            Assert.assertThat((Object)fs.getFileStatus(hdfsFile2).getReplication(), (Matcher)CoreMatchers.is((Object)oldRepFactor));
            argv = new String[]{"-setrep", newRepFactor.toString(), testdir1};
            Assert.assertThat((Object)shell.run(argv), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)fs.getFileStatus(hdfsFile1).getReplication(), (Matcher)CoreMatchers.is((Object)newRepFactor));
            Assert.assertThat((Object)fs.getFileStatus(hdfsFile2).getReplication(), (Matcher)CoreMatchers.is((Object)newRepFactor));
        }
        finally {
            if (shell != null) {
                shell.close();
            }
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteFileUsingTrash(boolean serverTrash, boolean clientTrash) throws Exception {
        HdfsConfiguration serverConf = new HdfsConfiguration();
        if (serverTrash) {
            serverConf.setLong("fs.trash.interval", 1L);
        }
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)serverConf).numDataNodes(1).format(true).build();
        Configuration clientConf = new Configuration((Configuration)serverConf);
        if (clientTrash) {
            clientConf.setLong("fs.trash.interval", 1L);
        } else {
            clientConf.setLong("fs.trash.interval", 0L);
        }
        FsShell shell = new FsShell(clientConf);
        DistributedFileSystem fs = null;
        try {
            fs = cluster.getFileSystem();
            TestDFSShell.writeFile((FileSystem)fs, new Path(TEST_ROOT_DIR, "foo"));
            String testFile = TEST_ROOT_DIR + "/foo";
            String trashFile = shell.getCurrentTrashDir() + "/" + testFile;
            String[] argv = new String[]{"-rm", testFile};
            int res = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"rm failed", (long)0L, (long)res);
            if (serverTrash) {
                Assert.assertTrue((String)"File not in trash", (boolean)fs.exists(new Path(trashFile)));
            } else if (clientTrash) {
                Assert.assertTrue((String)"File not in trashed", (boolean)fs.exists(new Path(trashFile)));
            } else {
                Assert.assertFalse((String)"File was not removed", (boolean)fs.exists(new Path(testFile)));
                Assert.assertFalse((String)"File was trashed", (boolean)fs.exists(new Path(trashFile)));
            }
        }
        finally {
            if (fs != null) {
                fs.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testAppendToFile() throws Exception {
        int inputFileLength = 0x100000;
        File testRoot = new File(TEST_ROOT_DIR, "testAppendtoFileDir");
        testRoot.mkdirs();
        File file1 = new File(testRoot, "file1");
        File file2 = new File(testRoot, "file2");
        TestDFSShell.createLocalFileWithRandomData(0x100000, file1);
        TestDFSShell.createLocalFileWithRandomData(0x100000, file2);
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        cluster.waitActive();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Assert.assertTrue((String)("Not a HDFS: " + dfs.getUri()), (boolean)(dfs instanceof DistributedFileSystem));
            Path remoteFile = new Path("/remoteFile");
            FsShell shell = new FsShell();
            shell.setConf((Configuration)conf);
            String[] argv = new String[]{"-appendToFile", file1.toString(), file2.toString(), remoteFile.toString()};
            int res = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertThat((Object)res, (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)dfs.getFileStatus(remoteFile).getLen(), (Matcher)CoreMatchers.is((Object)0x200000L));
            res = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertThat((Object)res, (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)dfs.getFileStatus(remoteFile).getLen(), (Matcher)CoreMatchers.is((Object)0x400000L));
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testAppendToFileBadArgs() throws Exception {
        int inputFileLength = 0x100000;
        File testRoot = new File(TEST_ROOT_DIR, "testAppendToFileBadArgsDir");
        testRoot.mkdirs();
        File file1 = new File(testRoot, "file1");
        TestDFSShell.createLocalFileWithRandomData(0x100000, file1);
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        cluster.waitActive();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Assert.assertTrue((String)("Not a HDFS: " + dfs.getUri()), (boolean)(dfs instanceof DistributedFileSystem));
            FsShell shell = new FsShell();
            shell.setConf((Configuration)conf);
            String[] argv = new String[]{"-appendToFile", file1.toString()};
            int res = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertThat((Object)res, (Matcher)CoreMatchers.not((Object)0));
            Path remoteFile = new Path("/remoteFile");
            argv = new String[]{"-appendToFile", file1.toString(), "-", remoteFile.toString()};
            res = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertThat((Object)res, (Matcher)CoreMatchers.not((Object)0));
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testSetXAttrPermission() throws Exception {
        MiniDFSCluster cluster;
        block5: {
            UserGroupInformation user = UserGroupInformation.createUserForTesting((String)"user", (String[])new String[]{"mygroup"});
            cluster = null;
            PrintStream bak = null;
            try {
                HdfsConfiguration conf = new HdfsConfiguration();
                cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
                cluster.waitActive();
                DistributedFileSystem fs = cluster.getFileSystem();
                Path p = new Path("/foo");
                fs.mkdirs(p);
                bak = System.err;
                final FsShell fshell = new FsShell((Configuration)conf);
                final ByteArrayOutputStream out = new ByteArrayOutputStream();
                System.setErr(new PrintStream(out));
                fs.setPermission(p, new FsPermission(448));
                user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        int ret = ToolRunner.run((Tool)fshell, (String[])new String[]{"-setfattr", "-n", TestDFSShell.USER_A1, "-v", "1234", "/foo"});
                        Assert.assertEquals((String)"Returned should be 1", (long)1L, (long)ret);
                        String str = out.toString();
                        Assert.assertTrue((String)"Permission denied printed", (str.indexOf("Permission denied") != -1 ? 1 : 0) != 0);
                        out.reset();
                        return null;
                    }
                });
                int ret = ToolRunner.run((Tool)fshell, (String[])new String[]{"-setfattr", "-n", USER_A1, "-v", "1234", "/foo"});
                Assert.assertEquals((String)"Returned should be 0", (long)0L, (long)ret);
                out.reset();
                fs.setPermission(p, new FsPermission(488));
                user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        int ret = ToolRunner.run((Tool)fshell, (String[])new String[]{"-getfattr", "-n", TestDFSShell.USER_A1, "/foo"});
                        Assert.assertEquals((String)"Returned should be 1", (long)1L, (long)ret);
                        String str = out.toString();
                        Assert.assertTrue((String)"Permission denied printed", (str.indexOf("Permission denied") != -1 ? 1 : 0) != 0);
                        out.reset();
                        ret = ToolRunner.run((Tool)fshell, (String[])new String[]{"-setfattr", "-x", TestDFSShell.USER_A1, "/foo"});
                        Assert.assertEquals((String)"Returned should be 1", (long)1L, (long)ret);
                        str = out.toString();
                        Assert.assertTrue((String)"Permission denied printed", (str.indexOf("Permission denied") != -1 ? 1 : 0) != 0);
                        out.reset();
                        return null;
                    }
                });
                if (bak == null) break block5;
            }
            catch (Throwable throwable) {
                if (bak != null) {
                    System.setErr(bak);
                }
                if (cluster != null) {
                    cluster.shutdown();
                }
                throw throwable;
            }
            System.setErr(bak);
        }
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testSetXAttrPermissionAsDifferentOwner() throws Exception {
        MiniDFSCluster cluster;
        block5: {
            String USER1 = "user1";
            String GROUP1 = "supergroup";
            UserGroupInformation user1 = UserGroupInformation.createUserForTesting((String)"user1", (String[])new String[]{"supergroup"});
            UserGroupInformation user2 = UserGroupInformation.createUserForTesting((String)"user2", (String[])new String[]{"mygroup2"});
            UserGroupInformation SUPERUSER = UserGroupInformation.getCurrentUser();
            cluster = null;
            PrintStream bak = null;
            try {
                HdfsConfiguration conf = new HdfsConfiguration();
                cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
                cluster.waitActive();
                DistributedFileSystem fs = cluster.getFileSystem();
                fs.setOwner(new Path("/"), "user1", "supergroup");
                bak = System.err;
                final FsShell fshell = new FsShell((Configuration)conf);
                final ByteArrayOutputStream out = new ByteArrayOutputStream();
                System.setErr(new PrintStream(out));
                user1.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        int ret = ToolRunner.run((Tool)fshell, (String[])new String[]{"-mkdir", "/foo"});
                        Assert.assertEquals((String)"Return should be 0", (long)0L, (long)ret);
                        out.reset();
                        return null;
                    }
                });
                user1.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        int ret = ToolRunner.run((Tool)fshell, (String[])new String[]{"-chmod", "707", "/foo"});
                        Assert.assertEquals((String)"Return should be 0", (long)0L, (long)ret);
                        out.reset();
                        return null;
                    }
                });
                user2.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        int ret = ToolRunner.run((Tool)fshell, (String[])new String[]{"-setfattr", "-n", TestDFSShell.USER_A1, "-v", "1234", "/foo"});
                        Assert.assertEquals((String)"Returned should be 0", (long)0L, (long)ret);
                        out.reset();
                        return null;
                    }
                });
                user1.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        int ret = ToolRunner.run((Tool)fshell, (String[])new String[]{"-setfattr", "-n", TestDFSShell.USER_A1, "-v", "1234", "/foo"});
                        Assert.assertEquals((String)"Returned should be 0", (long)0L, (long)ret);
                        out.reset();
                        return null;
                    }
                });
                user2.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        int ret = ToolRunner.run((Tool)fshell, (String[])new String[]{"-getfattr", "-n", TestDFSShell.USER_A1, "/foo"});
                        Assert.assertEquals((String)"Returned should be 0", (long)0L, (long)ret);
                        out.reset();
                        ret = ToolRunner.run((Tool)fshell, (String[])new String[]{"-setfattr", "-x", TestDFSShell.USER_A1, "/foo"});
                        Assert.assertEquals((String)"Returned should be 0", (long)0L, (long)ret);
                        out.reset();
                        return null;
                    }
                });
                user1.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        return null;
                    }
                });
                user1.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        int ret = ToolRunner.run((Tool)fshell, (String[])new String[]{"-chmod", "700", "/foo"});
                        Assert.assertEquals((String)"Return should be 0", (long)0L, (long)ret);
                        out.reset();
                        return null;
                    }
                });
                user2.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        int ret = ToolRunner.run((Tool)fshell, (String[])new String[]{"-setfattr", "-n", "user.a2", "/foo"});
                        Assert.assertEquals((String)"Returned should be 1", (long)1L, (long)ret);
                        String str = out.toString();
                        Assert.assertTrue((String)"Permission denied printed", (str.indexOf("Permission denied") != -1 ? 1 : 0) != 0);
                        out.reset();
                        return null;
                    }
                });
                user2.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        int ret = ToolRunner.run((Tool)fshell, (String[])new String[]{"-setfattr", "-x", "user.a2", "/foo"});
                        Assert.assertEquals((String)"Returned should be 1", (long)1L, (long)ret);
                        String str = out.toString();
                        Assert.assertTrue((String)"Permission denied printed", (str.indexOf("Permission denied") != -1 ? 1 : 0) != 0);
                        out.reset();
                        return null;
                    }
                });
                SUPERUSER.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        int ret = ToolRunner.run((Tool)fshell, (String[])new String[]{"-setfattr", "-n", "trusted.a3", "/foo"});
                        Assert.assertEquals((String)"Returned should be 0", (long)0L, (long)ret);
                        out.reset();
                        return null;
                    }
                });
                if (bak == null) break block5;
            }
            catch (Throwable throwable) {
                if (bak != null) {
                    System.setErr(bak);
                }
                if (cluster != null) {
                    cluster.shutdown();
                }
                throw throwable;
            }
            System.setErr(bak);
        }
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testSetXAttrCaseSensitivity() throws Exception {
        MiniDFSCluster cluster;
        block5: {
            UserGroupInformation user = UserGroupInformation.createUserForTesting((String)"user", (String[])new String[]{"mygroup"});
            cluster = null;
            PrintStream bak = null;
            try {
                HdfsConfiguration conf = new HdfsConfiguration();
                cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
                cluster.waitActive();
                DistributedFileSystem fs = cluster.getFileSystem();
                Path p = new Path("/mydir");
                fs.mkdirs(p);
                bak = System.err;
                FsShell fshell = new FsShell((Configuration)conf);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                System.setOut(new PrintStream(out));
                this.doSetXattr(out, fshell, new String[]{"-setfattr", "-n", "User.Foo", "/mydir"}, new String[]{"-getfattr", "-d", "/mydir"}, new String[]{"user.Foo"}, new String[0]);
                this.doSetXattr(out, fshell, new String[]{"-setfattr", "-n", "user.FOO", "/mydir"}, new String[]{"-getfattr", "-d", "/mydir"}, new String[]{"user.Foo", "user.FOO"}, new String[0]);
                this.doSetXattr(out, fshell, new String[]{"-setfattr", "-n", "USER.foo", "/mydir"}, new String[]{"-getfattr", "-d", "/mydir"}, new String[]{"user.Foo", "user.FOO", "user.foo"}, new String[0]);
                this.doSetXattr(out, fshell, new String[]{"-setfattr", "-n", "USER.fOo", "-v", "myval", "/mydir"}, new String[]{"-getfattr", "-d", "/mydir"}, new String[]{"user.Foo", "user.FOO", "user.foo", "user.fOo=\"myval\""}, new String[]{"user.Foo=", "user.FOO=", "user.foo="});
                this.doSetXattr(out, fshell, new String[]{"-setfattr", "-x", "useR.foo", "/mydir"}, new String[]{"-getfattr", "-d", "/mydir"}, new String[]{"user.Foo", "user.FOO"}, new String[]{"foo"});
                this.doSetXattr(out, fshell, new String[]{"-setfattr", "-x", "USER.FOO", "/mydir"}, new String[]{"-getfattr", "-d", "/mydir"}, new String[]{"user.Foo"}, new String[]{"FOO"});
                this.doSetXattr(out, fshell, new String[]{"-setfattr", "-x", "useR.Foo", "/mydir"}, new String[]{"-getfattr", "-n", "User.Foo", "/mydir"}, new String[0], new String[]{"Foo"});
                if (bak == null) break block5;
            }
            catch (Throwable throwable) {
                if (bak != null) {
                    System.setOut(bak);
                }
                if (cluster != null) {
                    cluster.shutdown();
                }
                throw throwable;
            }
            System.setOut(bak);
        }
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    private void doSetXattr(ByteArrayOutputStream out, FsShell fshell, String[] setOp, String[] getOp, String[] expectArr, String[] dontExpectArr) throws Exception {
        StringBuilder sb;
        int i;
        int ret = ToolRunner.run((Tool)fshell, (String[])setOp);
        out.reset();
        ret = ToolRunner.run((Tool)fshell, (String[])getOp);
        String str = out.toString();
        for (i = 0; i < expectArr.length; ++i) {
            String expect = expectArr[i];
            sb = new StringBuilder("Incorrect results from getfattr. Expected: ");
            sb.append(expect).append(" Full Result: ");
            sb.append(str);
            Assert.assertTrue((String)sb.toString(), (str.indexOf(expect) != -1 ? 1 : 0) != 0);
        }
        for (i = 0; i < dontExpectArr.length; ++i) {
            String dontExpect = dontExpectArr[i];
            sb = new StringBuilder("Incorrect results from getfattr. Didn't Expect: ");
            sb.append(dontExpect).append(" Full Result: ");
            sb.append(str);
            Assert.assertTrue((String)sb.toString(), (str.indexOf(dontExpect) == -1 ? 1 : 0) != 0);
        }
        out.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testGetFAttrErrors() throws Exception {
        MiniDFSCluster cluster;
        block5: {
            UserGroupInformation user = UserGroupInformation.createUserForTesting((String)"user", (String[])new String[]{"mygroup"});
            cluster = null;
            PrintStream bakErr = null;
            try {
                HdfsConfiguration conf = new HdfsConfiguration();
                cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
                cluster.waitActive();
                DistributedFileSystem fs = cluster.getFileSystem();
                Path p = new Path("/foo");
                fs.mkdirs(p);
                bakErr = System.err;
                final FsShell fshell = new FsShell((Configuration)conf);
                final ByteArrayOutputStream out = new ByteArrayOutputStream();
                System.setErr(new PrintStream(out));
                fs.setPermission(p, new FsPermission(448));
                int ret = ToolRunner.run((Tool)fshell, (String[])new String[]{"-setfattr", "-n", USER_A1, "-v", "1234", "/foo"});
                Assert.assertEquals((String)"Returned should be 0", (long)0L, (long)ret);
                out.reset();
                user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        int ret = ToolRunner.run((Tool)fshell, (String[])new String[]{"-getfattr", "-n", TestDFSShell.USER_A1, "/foo"});
                        String str = out.toString();
                        Assert.assertTrue((String)"xattr value was incorrectly returned", (str.indexOf("1234") == -1 ? 1 : 0) != 0);
                        out.reset();
                        return null;
                    }
                });
                ret = ToolRunner.run((Tool)fshell, (String[])new String[]{"-getfattr", "-n", "user.nonexistent", "/foo"});
                String str = out.toString();
                Assert.assertTrue((String)"xattr value was incorrectly returned", (str.indexOf("getfattr: At least one of the attributes provided was not found") >= 0 ? 1 : 0) != 0);
                out.reset();
                if (bakErr == null) break block5;
            }
            catch (Throwable throwable) {
                if (bakErr != null) {
                    System.setErr(bakErr);
                }
                if (cluster != null) {
                    cluster.shutdown();
                }
                throw throwable;
            }
            System.setErr(bakErr);
        }
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Test
    public void testServerConfigRespected() throws Exception {
        this.deleteFileUsingTrash(true, false);
    }

    @Test
    public void testServerConfigRespectedWithClient() throws Exception {
        this.deleteFileUsingTrash(true, true);
    }

    @Test
    public void testClientConfigRespected() throws Exception {
        this.deleteFileUsingTrash(false, true);
    }

    @Test
    public void testNoTrashConfig() throws Exception {
        this.deleteFileUsingTrash(false, false);
    }

    static interface TestGetRunner {
        public String run(int var1, String ... var2) throws IOException;
    }
}

