/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import io.hops.metadata.HdfsStorageFactory;
import io.hops.security.UsersGroups;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.HopsFilesTestHelper;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.util.ExitUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;

public class TestSmallFilesCreation {
    private static final Log LOG = LogFactory.getLog(TestSmallFilesCreation.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestSimpleReadAndWrite() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 0x100000;
            conf.setInt("dfs.blocksize", 0x100000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(true).build();
            cluster.waitActive();
            int ONDISK_SMALL_BUCKET_SIZE = FSNamesystem.getDBOnDiskSmallBucketSize();
            int ONDISK_MEDIUM_BUCKET_SIZE = FSNamesystem.getDBOnDiskMediumBucketSize();
            int MAX_SMALL_FILE_SIZE = FSNamesystem.getMaxSmallFileSize();
            int INMEMORY_BUCKET_SIZE = FSNamesystem.getDBInMemBucketSize();
            String FILE_NAME1 = "/dir/TEST-FLIE1";
            String FILE_NAME2 = "/dir/TEST-FLIE2";
            String FILE_NAME3 = "/dir/TEST-FLIE3";
            String FILE_NAME4 = "/dir/TEST-FLIE4";
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.mkdirs(new Path("/dir"));
            dfs.setStoragePolicy(new Path("/dir"), "DB");
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE1", INMEMORY_BUCKET_SIZE);
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE1", INMEMORY_BUCKET_SIZE);
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE2", ONDISK_SMALL_BUCKET_SIZE);
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE2", ONDISK_SMALL_BUCKET_SIZE);
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE3", ONDISK_MEDIUM_BUCKET_SIZE);
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE3", ONDISK_MEDIUM_BUCKET_SIZE);
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE4", MAX_SMALL_FILE_SIZE);
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE4", MAX_SMALL_FILE_SIZE);
            Assert.assertTrue((String)("Expecting 1 in-memory file. Got: " + HopsFilesTestHelper.countInMemoryDBFiles()), (HopsFilesTestHelper.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 3 on-disk file(s). Got:" + HopsFilesTestHelper.countAllOnDiskDBFiles()), (HopsFilesTestHelper.countAllOnDiskDBFiles() == 3 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskSmallDBFiles()), (HopsFilesTestHelper.countOnDiskSmallDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskMediumDBFiles()), (HopsFilesTestHelper.countOnDiskMediumDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskLargeDBFiles()), (HopsFilesTestHelper.countOnDiskLargeDBFiles() == 1 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestWriteLargeFile() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 0x100000;
            conf.setInt("dfs.blocksize", 0x100000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(true).build();
            cluster.waitActive();
            int MAX_SMALL_FILE_SIZE = FSNamesystem.getMaxSmallFileSize();
            int FILE_SIZE = MAX_SMALL_FILE_SIZE + 1;
            String FILE_NAME = "/dir/TEST-FLIE";
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.mkdirs(new Path("/dir"));
            dfs.setStoragePolicy(new Path("/dir"), "DB");
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE", FILE_SIZE);
            FSDataInputStream dfsIs = dfs.open(new Path("/dir/TEST-FLIE"));
            LocatedBlocks lblks = dfs.getClient().getLocatedBlocks("/dir/TEST-FLIE", 0L, Long.MAX_VALUE);
            Assert.assertFalse((String)"The should not have been stored in the database", (boolean)lblks.hasPhantomBlock());
            Assert.assertTrue((String)("Expecting 0 DB files. Got:" + HopsFilesTestHelper.countDBFiles()), (HopsFilesTestHelper.countDBFiles() == 0 ? 1 : 0) != 0);
            dfsIs.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestSmallFileHflush() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 0x100000;
            conf.setInt("dfs.blocksize", 0x100000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(true).build();
            cluster.waitActive();
            int INMEMORY_BUCKET_SIZE = FSNamesystem.getDBInMemBucketSize();
            String FILE_NAME = "/dir/TEST-FLIE";
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.mkdirs(new Path("/dir"));
            dfs.setStoragePolicy(new Path("/dir"), "DB");
            FSDataOutputStream out = dfs.create(new Path("/dir/TEST-FLIE"), (short)3);
            HopsFilesTestHelper.writeData(out, 0, INMEMORY_BUCKET_SIZE);
            out.flush();
            out.hflush();
            out.close();
            FSDataInputStream dfsIs = dfs.open(new Path("/dir/TEST-FLIE"));
            LocatedBlocks lblks = dfs.getClient().getLocatedBlocks("/dir/TEST-FLIE", 0L, Long.MAX_VALUE);
            Assert.assertFalse((String)"The should not have been stored in the database", (boolean)lblks.hasPhantomBlock());
            Assert.assertTrue((String)("Expecting 0 DB files. Got:" + HopsFilesTestHelper.countDBFiles()), (HopsFilesTestHelper.countDBFiles() == 0 ? 1 : 0) != 0);
            dfsIs.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestSmallFileHsync() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 0x100000;
            conf.setInt("dfs.blocksize", 0x100000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(true).build();
            cluster.waitActive();
            int INMEMORY_BUCKET_SIZE = FSNamesystem.getDBInMemBucketSize();
            String FILE_NAME = "/dir/TEST-FLIE";
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.mkdirs(new Path("/dir"));
            dfs.setStoragePolicy(new Path("/dir"), "DB");
            FSDataOutputStream out = dfs.create(new Path("/dir/TEST-FLIE"), (short)3);
            HopsFilesTestHelper.writeData(out, 0, INMEMORY_BUCKET_SIZE);
            out.hsync();
            out.close();
            FSDataInputStream dfsIs = dfs.open(new Path("/dir/TEST-FLIE"));
            LocatedBlocks lblks = dfs.getClient().getLocatedBlocks("/dir/TEST-FLIE", 0L, Long.MAX_VALUE);
            Assert.assertFalse((String)"The should not have been stored in the database", (boolean)lblks.hasPhantomBlock());
            Assert.assertTrue((String)("Expecting 0 DB files. Got:" + HopsFilesTestHelper.countDBFiles()), (HopsFilesTestHelper.countDBFiles() == 0 ? 1 : 0) != 0);
            dfsIs.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestDeleteSmallFile() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 0x100000;
            conf.setInt("dfs.blocksize", 0x100000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(true).build();
            cluster.waitActive();
            int ONDISK_SMALL_BUCKET_SIZE = FSNamesystem.getDBOnDiskSmallBucketSize();
            int ONDISK_MEDIUM_BUCKET_SIZE = FSNamesystem.getDBOnDiskMediumBucketSize();
            int MAX_SMALL_FILE_SIZE = FSNamesystem.getMaxSmallFileSize();
            int INMEMORY_BUCKET_SIZE = FSNamesystem.getDBInMemBucketSize();
            String FILE_NAME1 = "/dir/TEST-FLIE1";
            String FILE_NAME2 = "/dir/TEST-FLIE2";
            String FILE_NAME3 = "/dir/TEST-FLIE3";
            String FILE_NAME4 = "/dir/TEST-FLIE4";
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.mkdirs(new Path("/dir"));
            dfs.setStoragePolicy(new Path("/dir"), "DB");
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE1", INMEMORY_BUCKET_SIZE);
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE2", ONDISK_SMALL_BUCKET_SIZE);
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE3", ONDISK_MEDIUM_BUCKET_SIZE);
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE4", MAX_SMALL_FILE_SIZE);
            Assert.assertTrue((String)("Expecting 1 in-memory file(s). Got: " + HopsFilesTestHelper.countInMemoryDBFiles()), (HopsFilesTestHelper.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 3 on-disk file(s). Got:" + HopsFilesTestHelper.countAllOnDiskDBFiles()), (HopsFilesTestHelper.countAllOnDiskDBFiles() == 3 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskSmallDBFiles()), (HopsFilesTestHelper.countOnDiskSmallDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskMediumDBFiles()), (HopsFilesTestHelper.countOnDiskMediumDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskLargeDBFiles()), (HopsFilesTestHelper.countOnDiskLargeDBFiles() == 1 ? 1 : 0) != 0);
            dfs.delete(new Path("/dir/TEST-FLIE1"));
            dfs.delete(new Path("/dir/TEST-FLIE2"));
            dfs.delete(new Path("/dir/TEST-FLIE3"));
            dfs.delete(new Path("/dir/TEST-FLIE4"));
            Assert.assertTrue((String)("Expecting 0 in-memory file(s). Got: " + HopsFilesTestHelper.countInMemoryDBFiles()), (HopsFilesTestHelper.countInMemoryDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countAllOnDiskDBFiles()), (HopsFilesTestHelper.countAllOnDiskDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskSmallDBFiles()), (HopsFilesTestHelper.countOnDiskSmallDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskMediumDBFiles()), (HopsFilesTestHelper.countOnDiskMediumDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskLargeDBFiles()), (HopsFilesTestHelper.countOnDiskLargeDBFiles() == 0 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestRenameSmallFile() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 0x100000;
            conf.setInt("dfs.blocksize", 0x100000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(true).build();
            cluster.waitActive();
            int ONDISK_SMALL_BUCKET_SIZE = FSNamesystem.getDBOnDiskSmallBucketSize();
            int ONDISK_MEDIUM_BUCKET_SIZE = FSNamesystem.getDBOnDiskMediumBucketSize();
            int MAX_SMALL_FILE_SIZE = FSNamesystem.getMaxSmallFileSize();
            int INMEMORY_BUCKET_SIZE = FSNamesystem.getDBInMemBucketSize();
            String FILE_NAME1 = "/dir/TEST-FLIE1";
            String FILE_NAME2 = "/dir/TEST-FLIE2";
            String FILE_NAME3 = "/dir/TEST-FLIE3";
            String FILE_NAME4 = "/dir/TEST-FLIE4";
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.mkdirs(new Path("/dir"));
            dfs.setStoragePolicy(new Path("/dir"), "DB");
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE1", INMEMORY_BUCKET_SIZE);
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE2", ONDISK_SMALL_BUCKET_SIZE);
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE3", ONDISK_MEDIUM_BUCKET_SIZE);
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE4", MAX_SMALL_FILE_SIZE);
            Assert.assertTrue((String)("Expecting 1 in-memory file(s). Got: " + HopsFilesTestHelper.countInMemoryDBFiles()), (HopsFilesTestHelper.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 3 on-disk file(s). Got:" + HopsFilesTestHelper.countAllOnDiskDBFiles()), (HopsFilesTestHelper.countAllOnDiskDBFiles() == 3 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskSmallDBFiles()), (HopsFilesTestHelper.countOnDiskSmallDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskMediumDBFiles()), (HopsFilesTestHelper.countOnDiskMediumDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskLargeDBFiles()), (HopsFilesTestHelper.countOnDiskLargeDBFiles() == 1 ? 1 : 0) != 0);
            dfs.rename(new Path("/dir/TEST-FLIE1"), new Path("/dir/TEST-FLIE11"));
            dfs.rename(new Path("/dir/TEST-FLIE2"), new Path("/dir/TEST-FLIE21"));
            dfs.rename(new Path("/dir/TEST-FLIE3"), new Path("/dir/TEST-FLIE31"));
            dfs.rename(new Path("/dir/TEST-FLIE4"), new Path("/dir/TEST-FLIE41"));
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE11", INMEMORY_BUCKET_SIZE);
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE21", ONDISK_SMALL_BUCKET_SIZE);
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE31", ONDISK_MEDIUM_BUCKET_SIZE);
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE41", MAX_SMALL_FILE_SIZE);
            Assert.assertTrue((String)("Expecting 1 in-memory file(s). Got: " + HopsFilesTestHelper.countInMemoryDBFiles()), (HopsFilesTestHelper.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 3 on-disk file(s). Got:" + HopsFilesTestHelper.countAllOnDiskDBFiles()), (HopsFilesTestHelper.countAllOnDiskDBFiles() == 3 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskSmallDBFiles()), (HopsFilesTestHelper.countOnDiskSmallDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskMediumDBFiles()), (HopsFilesTestHelper.countOnDiskMediumDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskLargeDBFiles()), (HopsFilesTestHelper.countOnDiskLargeDBFiles() == 1 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestRenameSmallFiles2() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 0x100000;
            conf.setInt("dfs.blocksize", 0x100000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(true).build();
            cluster.waitActive();
            int ONDISK_SMALL_BUCKET_SIZE = FSNamesystem.getDBOnDiskSmallBucketSize();
            int ONDISK_MEDIUM_BUCKET_SIZE = FSNamesystem.getDBOnDiskMediumBucketSize();
            int MAX_SMALL_FILE_SIZE = FSNamesystem.getMaxSmallFileSize();
            int INMEMORY_BUCKET_SIZE = FSNamesystem.getDBInMemBucketSize();
            String FILE_NAME1 = "/dir/TEST-FLIE1";
            String FILE_NAME2 = "/dir/TEST-FLIE2";
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.mkdirs(new Path("/dir"));
            dfs.setStoragePolicy(new Path("/dir"), "DB");
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE1", INMEMORY_BUCKET_SIZE);
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE2", INMEMORY_BUCKET_SIZE);
            Assert.assertTrue((String)"Count of db file should be 2", (HopsFilesTestHelper.countInMemoryDBFiles() == 2 ? 1 : 0) != 0);
            dfs.rename(new Path("/dir/TEST-FLIE1"), new Path("/dir/TEST-FLIE2"), new Options.Rename[]{Options.Rename.OVERWRITE});
            Assert.assertTrue((String)"Count of db file should be 1", (HopsFilesTestHelper.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE2", INMEMORY_BUCKET_SIZE);
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE1", ONDISK_SMALL_BUCKET_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (HopsFilesTestHelper.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Count of db file should be 1", (HopsFilesTestHelper.countAllOnDiskDBFiles() == 1 ? 1 : 0) != 0);
            dfs.rename(new Path("/dir/TEST-FLIE1"), new Path("/dir/TEST-FLIE2"), new Options.Rename[]{Options.Rename.OVERWRITE});
            Assert.assertTrue((String)"Count of db file should be 0", (HopsFilesTestHelper.countInMemoryDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Count of db file should be 1", (HopsFilesTestHelper.countAllOnDiskDBFiles() == 1 ? 1 : 0) != 0);
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE2", ONDISK_SMALL_BUCKET_SIZE);
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE1", MAX_SMALL_FILE_SIZE);
            Assert.assertTrue((String)"Count of db file should be 0", (HopsFilesTestHelper.countInMemoryDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Count of db file should be 2", (HopsFilesTestHelper.countAllOnDiskDBFiles() == 2 ? 1 : 0) != 0);
            dfs.rename(new Path("/dir/TEST-FLIE1"), new Path("/dir/TEST-FLIE2"), new Options.Rename[]{Options.Rename.OVERWRITE});
            Assert.assertTrue((String)"Count of db file should be 0", (HopsFilesTestHelper.countInMemoryDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Count of db file should be 1", (HopsFilesTestHelper.countAllOnDiskDBFiles() == 1 ? 1 : 0) != 0);
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE2", MAX_SMALL_FILE_SIZE);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestRenameSmallFiles3() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 0x100000;
            conf.setInt("dfs.blocksize", 0x100000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(true).build();
            cluster.waitActive();
            int MAX_SMALL_FILE_SIZE = FSNamesystem.getMaxSmallFileSize();
            int INMEMORY_BUCKET_SIZE = FSNamesystem.getDBInMemBucketSize();
            String FILE_NAME1 = "/dir/TEST-FLIE1";
            String FILE_NAME2 = "/dir/TEST-FLIE2";
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.mkdirs(new Path("/dir"));
            dfs.setStoragePolicy(new Path("/dir"), "DB");
            FSNamesystem namesystem = cluster.getNamesystem();
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE1", INMEMORY_BUCKET_SIZE);
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE2", MAX_SMALL_FILE_SIZE + 1);
            Assert.assertTrue((String)"Count of db file should be 1", (HopsFilesTestHelper.countDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 block but found: " + namesystem.getTotalBlocks()), (namesystem.getTotalBlocks() == 1L ? 1 : 0) != 0);
            dfs.rename(new Path("/dir/TEST-FLIE1"), new Path("/dir/TEST-FLIE2"), new Options.Rename[]{Options.Rename.OVERWRITE});
            Assert.assertTrue((String)"Count of db file should be 1", (HopsFilesTestHelper.countDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 0 block but foudn " + namesystem.getTotalBlocks()), (namesystem.getTotalBlocks() == 0L ? 1 : 0) != 0);
            dfs.delete(new Path("/dir/TEST-FLIE2"));
            Assert.assertTrue((String)"Count of db file should be 0", (HopsFilesTestHelper.countDBFiles() == 0 ? 1 : 0) != 0);
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE1", INMEMORY_BUCKET_SIZE);
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE2", MAX_SMALL_FILE_SIZE + 1);
            Assert.assertTrue((String)"Count of db file should be 1", (HopsFilesTestHelper.countDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 block but found: " + namesystem.getTotalBlocks()), (namesystem.getTotalBlocks() == 1L ? 1 : 0) != 0);
            dfs.rename(new Path("/dir/TEST-FLIE2"), new Path("/dir/TEST-FLIE1"), new Options.Rename[]{Options.Rename.OVERWRITE});
            Assert.assertTrue((String)"Count of db file should be 0", (HopsFilesTestHelper.countDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 block but foudn " + namesystem.getTotalBlocks()), (namesystem.getTotalBlocks() == 1L ? 1 : 0) != 0);
            dfs.delete(new Path("/dir/TEST-FLIE1"));
            Assert.assertTrue((String)"Count of db file should be 0", (HopsFilesTestHelper.countDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 0 block but foudn " + namesystem.getTotalBlocks()), (namesystem.getTotalBlocks() == 0L ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestDelete1() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            int i;
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 0x100000;
            conf.setInt("dfs.blocksize", 0x100000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(true).build();
            cluster.waitActive();
            int ONDISK_SMALL_BUCKET_SIZE = FSNamesystem.getDBOnDiskSmallBucketSize();
            int ONDISK_MEDIUM_BUCKET_SIZE = FSNamesystem.getDBOnDiskMediumBucketSize();
            int MAX_SMALL_FILE_SIZE = FSNamesystem.getMaxSmallFileSize();
            int INMEMORY_BUCKET_SIZE = FSNamesystem.getDBInMemBucketSize();
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.mkdirs(new Path("/dir"));
            dfs.setStoragePolicy(new Path("/dir"), "DB");
            for (i = 0; i < 5; ++i) {
                HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/file-db-file" + i, INMEMORY_BUCKET_SIZE);
            }
            for (i = 5; i < 10; ++i) {
                HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/file-db-file" + i, ONDISK_SMALL_BUCKET_SIZE);
            }
            for (i = 10; i < 15; ++i) {
                HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/file-db-file" + i, ONDISK_MEDIUM_BUCKET_SIZE);
            }
            for (i = 15; i < 20; ++i) {
                HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/file-db-file" + i, MAX_SMALL_FILE_SIZE);
            }
            for (i = 20; i < 25; ++i) {
                HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/file2" + i, MAX_SMALL_FILE_SIZE + 1);
            }
            Assert.assertTrue((String)"Count of db file should be 10", (HopsFilesTestHelper.countDBFiles() == 20 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 5 block but found " + cluster.getNamesystem().getTotalBlocks()), (cluster.getNamesystem().getTotalBlocks() == 5L ? 1 : 0) != 0);
            dfs.delete(new Path("/dir"), true);
            Assert.assertTrue((String)"Count of db file should be 0", (HopsFilesTestHelper.countDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 0 block but foudn " + cluster.getNamesystem().getTotalBlocks()), (cluster.getNamesystem().getTotalBlocks() == 0L ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestAppendMigrateToDataNodes() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 0x100000;
            conf.setInt("dfs.blocksize", 0x100000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(true).build();
            cluster.waitActive();
            int ONDISK_SMALL_BUCKET_SIZE = FSNamesystem.getDBOnDiskSmallBucketSize();
            int ONDISK_MEDIUM_BUCKET_SIZE = FSNamesystem.getDBOnDiskMediumBucketSize();
            int MAX_SMALL_FILE_SIZE = FSNamesystem.getMaxSmallFileSize();
            int INMEMORY_BUCKET_SIZE = FSNamesystem.getDBInMemBucketSize();
            String FILE_NAME1 = "/dir/TEST-FLIE1";
            String FILE_NAME2 = "/dir/TEST-FLIE2";
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.mkdirs(new Path("/dir"));
            dfs.setStoragePolicy(new Path("/dir"), "DB");
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE1", INMEMORY_BUCKET_SIZE);
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE1", INMEMORY_BUCKET_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (HopsFilesTestHelper.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
            FSDataOutputStream out = dfs.append(new Path("/dir/TEST-FLIE1"));
            HopsFilesTestHelper.writeData(out, INMEMORY_BUCKET_SIZE, ONDISK_SMALL_BUCKET_SIZE - INMEMORY_BUCKET_SIZE);
            out.close();
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE1", ONDISK_SMALL_BUCKET_SIZE);
            Assert.assertTrue((String)"Count of db file should be 0", (HopsFilesTestHelper.countInMemoryDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Count of db file should be 1", (HopsFilesTestHelper.countOnDiskSmallDBFiles() == 1 ? 1 : 0) != 0);
            out = dfs.append(new Path("/dir/TEST-FLIE1"));
            HopsFilesTestHelper.writeData(out, ONDISK_SMALL_BUCKET_SIZE, ONDISK_MEDIUM_BUCKET_SIZE - ONDISK_SMALL_BUCKET_SIZE);
            out.close();
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE1", ONDISK_MEDIUM_BUCKET_SIZE);
            Assert.assertTrue((String)"Count of db file should be 0", (HopsFilesTestHelper.countInMemoryDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Count of db file should be 0", (HopsFilesTestHelper.countOnDiskSmallDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Count of db file should be 1", (HopsFilesTestHelper.countOnDiskMediumDBFiles() == 1 ? 1 : 0) != 0);
            out = dfs.append(new Path("/dir/TEST-FLIE1"));
            HopsFilesTestHelper.writeData(out, ONDISK_MEDIUM_BUCKET_SIZE, MAX_SMALL_FILE_SIZE - ONDISK_MEDIUM_BUCKET_SIZE);
            out.close();
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE1", MAX_SMALL_FILE_SIZE);
            Assert.assertTrue((String)"Count of db file should be 0", (HopsFilesTestHelper.countInMemoryDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Count of db file should be 0", (HopsFilesTestHelper.countOnDiskSmallDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Count of db file should be 0", (HopsFilesTestHelper.countOnDiskMediumDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Count of db file should be 1", (HopsFilesTestHelper.countOnDiskLargeDBFiles() == 1 ? 1 : 0) != 0);
            out = dfs.append(new Path("/dir/TEST-FLIE1"));
            HopsFilesTestHelper.writeData(out, MAX_SMALL_FILE_SIZE, 1);
            out.close();
            Assert.assertTrue((String)"Count of db file should be 0", (HopsFilesTestHelper.countDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 block but foudn " + cluster.getNamesystem().getTotalBlocks()), (cluster.getNamesystem().getTotalBlocks() == 1L ? 1 : 0) != 0);
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE1", MAX_SMALL_FILE_SIZE + 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestAppendSync() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 0x100000;
            conf.setInt("dfs.blocksize", 0x100000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(true).build();
            cluster.waitActive();
            int INMEMORY_BUCKET_SIZE = FSNamesystem.getDBInMemBucketSize();
            String FILE_NAME1 = "/dir/TEST-FLIE1";
            String FILE_NAME2 = "/dir/TEST-FLIE2";
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.mkdirs(new Path("/dir"));
            dfs.setStoragePolicy(new Path("/dir"), "DB");
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE1", INMEMORY_BUCKET_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (HopsFilesTestHelper.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
            FSDataOutputStream out = dfs.append(new Path("/dir/TEST-FLIE1"));
            HopsFilesTestHelper.writeData(out, INMEMORY_BUCKET_SIZE, 1);
            out.hflush();
            HopsFilesTestHelper.writeData(out, INMEMORY_BUCKET_SIZE + 1, 1);
            out.close();
            Assert.assertTrue((String)"Count of db file should be 0", (HopsFilesTestHelper.countDBFiles() == 0 ? 1 : 0) != 0);
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE1", INMEMORY_BUCKET_SIZE + 2);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestAppend() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 0x100000;
            conf.setInt("dfs.blocksize", 0x100000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(true).build();
            cluster.waitActive();
            int MAX_SMALL_FILE_SIZE = FSNamesystem.getMaxSmallFileSize();
            String FILE_NAME1 = "/dir/TEST-FLIE1";
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.mkdirs(new Path("/dir"));
            dfs.setStoragePolicy(new Path("/dir"), "DB");
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE1", MAX_SMALL_FILE_SIZE);
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE1", MAX_SMALL_FILE_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (HopsFilesTestHelper.countDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Count of db file should be 0", (HopsFilesTestHelper.countInMemoryDBFiles() == 0 ? 1 : 0) != 0);
            FSDataOutputStream out = dfs.append(new Path("/dir/TEST-FLIE1"));
            HopsFilesTestHelper.writeData(out, MAX_SMALL_FILE_SIZE, 1024);
            out.close();
            Assert.assertTrue((String)"Count of db file should be 0", (HopsFilesTestHelper.countDBFiles() == 0 ? 1 : 0) != 0);
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE1", MAX_SMALL_FILE_SIZE + 1024);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestOverwrite() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 0x100000;
            conf.setInt("dfs.blocksize", 0x100000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(true).build();
            cluster.waitActive();
            int ONDISK_SMALL_BUCKET_SIZE = FSNamesystem.getDBOnDiskSmallBucketSize();
            int ONDISK_MEDIUM_BUCKET_SIZE = FSNamesystem.getDBOnDiskMediumBucketSize();
            int MAX_SMALL_FILE_SIZE = FSNamesystem.getMaxSmallFileSize();
            int INMEMORY_BUCKET_SIZE = FSNamesystem.getDBInMemBucketSize();
            String FILE_NAME1 = "/dir/TEST-FLIE1";
            String FILE_NAME2 = "/dir/TEST-FLIE2";
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.mkdirs(new Path("/dir"));
            dfs.setStoragePolicy(new Path("/dir"), "DB");
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE1", INMEMORY_BUCKET_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (HopsFilesTestHelper.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE1", INMEMORY_BUCKET_SIZE);
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE1", INMEMORY_BUCKET_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (HopsFilesTestHelper.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
            dfs.delete(new Path("/dir/TEST-FLIE1"));
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE2", MAX_SMALL_FILE_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (HopsFilesTestHelper.countOnDiskLargeDBFiles() == 1 ? 1 : 0) != 0);
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE2", MAX_SMALL_FILE_SIZE);
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE2", MAX_SMALL_FILE_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (HopsFilesTestHelper.countOnDiskLargeDBFiles() == 1 ? 1 : 0) != 0);
            dfs.delete(new Path("/dir/TEST-FLIE2"));
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE2", ONDISK_MEDIUM_BUCKET_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (HopsFilesTestHelper.countOnDiskMediumDBFiles() == 1 ? 1 : 0) != 0);
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE2", ONDISK_MEDIUM_BUCKET_SIZE);
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE2", ONDISK_MEDIUM_BUCKET_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (HopsFilesTestHelper.countOnDiskMediumDBFiles() == 1 ? 1 : 0) != 0);
            dfs.delete(new Path("/dir/TEST-FLIE2"));
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE2", MAX_SMALL_FILE_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (HopsFilesTestHelper.countOnDiskLargeDBFiles() == 1 ? 1 : 0) != 0);
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE2", MAX_SMALL_FILE_SIZE);
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE2", MAX_SMALL_FILE_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (HopsFilesTestHelper.countOnDiskLargeDBFiles() == 1 ? 1 : 0) != 0);
            dfs.delete(new Path("/dir/TEST-FLIE2"));
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE1", INMEMORY_BUCKET_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (HopsFilesTestHelper.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE1", ONDISK_SMALL_BUCKET_SIZE);
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE1", ONDISK_SMALL_BUCKET_SIZE);
            Assert.assertTrue((String)"Count of db file should be 0", (HopsFilesTestHelper.countInMemoryDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Count of db file should be 1", (HopsFilesTestHelper.countOnDiskSmallDBFiles() == 1 ? 1 : 0) != 0);
            dfs.delete(new Path("/dir/TEST-FLIE1"));
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE1", INMEMORY_BUCKET_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (HopsFilesTestHelper.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE1", ONDISK_MEDIUM_BUCKET_SIZE);
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE1", ONDISK_MEDIUM_BUCKET_SIZE);
            Assert.assertTrue((String)"Count of db file should be 0", (HopsFilesTestHelper.countInMemoryDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Count of db file should be 1", (HopsFilesTestHelper.countOnDiskMediumDBFiles() == 1 ? 1 : 0) != 0);
            dfs.delete(new Path("/dir/TEST-FLIE1"));
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE1", INMEMORY_BUCKET_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (HopsFilesTestHelper.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE1", MAX_SMALL_FILE_SIZE);
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE1", MAX_SMALL_FILE_SIZE);
            Assert.assertTrue((String)"Count of db file should be 0", (HopsFilesTestHelper.countInMemoryDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Count of db file should be 1", (HopsFilesTestHelper.countOnDiskLargeDBFiles() == 1 ? 1 : 0) != 0);
            dfs.delete(new Path("/dir/TEST-FLIE1"));
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE2", MAX_SMALL_FILE_SIZE);
            Assert.assertTrue((String)"Count of db file should be 2", (HopsFilesTestHelper.countAllOnDiskDBFiles() == 1 ? 1 : 0) != 0);
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE2", ONDISK_SMALL_BUCKET_SIZE);
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE2", ONDISK_SMALL_BUCKET_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (HopsFilesTestHelper.countInMemoryDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Count of db file should be 0", (HopsFilesTestHelper.countOnDiskSmallDBFiles() == 1 ? 1 : 0) != 0);
            dfs.delete(new Path("/dir/TEST-FLIE2"));
            Assert.assertTrue((String)"Count of db file should be 0", (HopsFilesTestHelper.countDBFiles() == 0 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestOverwrite2() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 0x100000;
            conf.setInt("dfs.blocksize", 0x100000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).format(true).numDataNodes(1).format(true).build();
            cluster.waitActive();
            int MAX_SMALL_FILE_SIZE = FSNamesystem.getMaxSmallFileSize();
            int INMEMORY_BUCKET_SIZE = FSNamesystem.getDBInMemBucketSize();
            String FILE_NAME1 = "/dir/TEST-FLIE1";
            String FILE_NAME2 = "/dir/TEST-FLIE2";
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.mkdirs(new Path("/dir"));
            dfs.setStoragePolicy(new Path("/dir"), "DB");
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE1", INMEMORY_BUCKET_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (HopsFilesTestHelper.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE1", MAX_SMALL_FILE_SIZE + 1);
            Assert.assertTrue((String)("Expecting 1 block but found " + cluster.getNamesystem().getTotalBlocks()), (cluster.getNamesystem().getTotalBlocks() == 1L ? 1 : 0) != 0);
            Assert.assertTrue((String)"Count of db file should be 0", (HopsFilesTestHelper.countDBFiles() == 0 ? 1 : 0) != 0);
            dfs.delete(new Path("/dir/TEST-FLIE1"));
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE1", MAX_SMALL_FILE_SIZE + 1);
            Assert.assertTrue((String)("Expecting 1 block but found " + cluster.getNamesystem().getTotalBlocks()), (cluster.getNamesystem().getTotalBlocks() == 1L ? 1 : 0) != 0);
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE1", INMEMORY_BUCKET_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (HopsFilesTestHelper.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 0 block but found " + cluster.getNamesystem().getTotalBlocks()), (cluster.getNamesystem().getTotalBlocks() == 0L ? 1 : 0) != 0);
            dfs.delete(new Path("/dir/TEST-FLIE1"));
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE1", MAX_SMALL_FILE_SIZE + 1);
            Assert.assertTrue((String)("Expecting 1 block but found " + cluster.getNamesystem().getTotalBlocks()), (cluster.getNamesystem().getTotalBlocks() == 1L ? 1 : 0) != 0);
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE1", MAX_SMALL_FILE_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (HopsFilesTestHelper.countOnDiskLargeDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 0 block but found " + cluster.getNamesystem().getTotalBlocks()), (cluster.getNamesystem().getTotalBlocks() == 0L ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestHdfsCompatibility1() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 0x100000;
            conf.setInt("dfs.blocksize", 0x100000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).format(true).numDataNodes(1).format(true).build();
            cluster.waitActive();
            int INMEMORY_BUCKET_SIZE = FSNamesystem.getDBInMemBucketSize();
            String FILE_NAME1 = "/dir/TEST-FLIE1";
            String FILE_NAME2 = "/dir/TEST-FLIE2";
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.mkdirs(new Path("/dir"));
            dfs.setStoragePolicy(new Path("/dir"), "DB");
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE1", INMEMORY_BUCKET_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (HopsFilesTestHelper.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
            conf.setBoolean("dfs.force.client.to.write.small.files.to.disk.key", true);
            FileSystem hdfsClient = FileSystem.newInstance((Configuration)conf);
            HopsFilesTestHelper.writeFile(hdfsClient, "/dir/TEST-FLIE2", INMEMORY_BUCKET_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (HopsFilesTestHelper.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 block but found " + cluster.getNamesystem().getTotalBlocks()), (cluster.getNamesystem().getTotalBlocks() == 1L ? 1 : 0) != 0);
            HopsFilesTestHelper.verifyFile(hdfsClient, "/dir/TEST-FLIE1", INMEMORY_BUCKET_SIZE);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestHdfsCompatibility2() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 0x100000;
            conf.setInt("dfs.blocksize", 0x100000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).format(true).numDataNodes(1).format(true).build();
            cluster.waitActive();
            int ONDISK_SMALL_BUCKET_SIZE = FSNamesystem.getDBOnDiskSmallBucketSize();
            int INMEMORY_BUCKET_SIZE = FSNamesystem.getDBInMemBucketSize();
            String FILE_NAME1 = "/dir/TEST-FLIE1";
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.mkdirs(new Path("/dir"));
            dfs.setStoragePolicy(new Path("/dir"), "DB");
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE1", INMEMORY_BUCKET_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (HopsFilesTestHelper.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
            conf.setBoolean("dfs.force.client.to.write.small.files.to.disk.key", true);
            FileSystem hdfsClient = FileSystem.newInstance((Configuration)conf);
            FSDataOutputStream out = hdfsClient.append(new Path("/dir/TEST-FLIE1"));
            HopsFilesTestHelper.writeData(out, INMEMORY_BUCKET_SIZE, ONDISK_SMALL_BUCKET_SIZE - INMEMORY_BUCKET_SIZE);
            out.close();
            Assert.assertTrue((String)"Count of db file should be 0", (HopsFilesTestHelper.countInMemoryDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 block but found " + cluster.getNamesystem().getTotalBlocks()), (cluster.getNamesystem().getTotalBlocks() == 1L ? 1 : 0) != 0);
            HopsFilesTestHelper.verifyFile(hdfsClient, "/dir/TEST-FLIE1", ONDISK_SMALL_BUCKET_SIZE);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestSmallFilesWithNoDataNodes() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 0x100000;
            conf.setInt("dfs.blocksize", 0x100000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).format(true).numDataNodes(0).format(true).build();
            cluster.waitActive();
            int INMEMORY_BUCKET_SIZE = FSNamesystem.getDBInMemBucketSize();
            String FILE_NAME1 = "/dir/TEST-FLIE1";
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.mkdirs(new Path("/dir"));
            dfs.setStoragePolicy(new Path("/dir"), "DB");
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE1", INMEMORY_BUCKET_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (HopsFilesTestHelper.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE1", INMEMORY_BUCKET_SIZE);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestSmallFilesReplication() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 0x100000;
            conf.setInt("dfs.blocksize", 0x100000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).format(true).numDataNodes(0).format(true).build();
            cluster.waitActive();
            int INMEMORY_BUCKET_SIZE = FSNamesystem.getDBInMemBucketSize();
            String FILE_NAME1 = "/dir/TEST-FLIE1";
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.mkdirs(new Path("/dir"));
            dfs.setStoragePolicy(new Path("/dir"), "DB");
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE1", INMEMORY_BUCKET_SIZE);
            Assert.assertTrue((String)"Count of db file should be 1", (HopsFilesTestHelper.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE1", INMEMORY_BUCKET_SIZE);
            dfs.setReplication(new Path("/dir/TEST-FLIE1"), (short)10);
            if (dfs.getFileStatus(new Path("/dir/TEST-FLIE1")).getReplication() != 10) {
                Assert.fail((String)"Unable to set replication for a small file");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestSmallFileByteBufferReader() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 0x100000;
            conf.setInt("dfs.blocksize", 0x100000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).format(true).numDataNodes(0).format(true).build();
            cluster.waitActive();
            int MAX_SMALL_FILE_SIZE = FSNamesystem.getMaxSmallFileSize();
            String FILE_NAME1 = "/dir/TEST-FLIE1";
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.mkdirs(new Path("/dir"));
            dfs.setStoragePolicy(new Path("/dir"), "DB");
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE1", MAX_SMALL_FILE_SIZE);
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE1", MAX_SMALL_FILE_SIZE);
            FSDataInputStream read = dfs.open(new Path("/dir/TEST-FLIE1"));
            ByteBuffer buf = ByteBuffer.allocate(MAX_SMALL_FILE_SIZE);
            while (buf.hasRemaining()) {
                int readCount = read.read(buf);
                if (readCount != -1) continue;
                throw new EOFException("Reached the end of stream. Still have: " + buf.remaining() + " bytes left");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestSmallFileListing() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 0x100000;
            conf.setInt("dfs.blocksize", 0x100000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).format(true).numDataNodes(1).format(true).build();
            cluster.waitActive();
            int ONDISK_SMALL_BUCKET_SIZE = FSNamesystem.getDBOnDiskSmallBucketSize();
            int ONDISK_MEDIUM_BUCKET_SIZE = FSNamesystem.getDBOnDiskMediumBucketSize();
            int MAX_SMALL_FILE_SIZE = FSNamesystem.getMaxSmallFileSize();
            String BASE_DIR = "/dir";
            String FILE_NAME1 = "/dir/TEST-FLIE1";
            String FILE_NAME2 = "/dir/TEST-FLIE2";
            String FILE_NAME3 = "/dir/TEST-FLIE3";
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.mkdirs(new Path("/dir"));
            dfs.setStoragePolicy(new Path("/dir"), "DB");
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE1", ONDISK_SMALL_BUCKET_SIZE);
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE2", ONDISK_MEDIUM_BUCKET_SIZE);
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE3", MAX_SMALL_FILE_SIZE);
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE3", MAX_SMALL_FILE_SIZE);
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE2", ONDISK_MEDIUM_BUCKET_SIZE);
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE1", ONDISK_SMALL_BUCKET_SIZE);
            BlockLocation[] loc = dfs.getFileBlockLocations(new Path("/dir/TEST-FLIE1"), 0L, Long.MAX_VALUE);
            loc = dfs.getFileBlockLocations(new Path("/dir/TEST-FLIE2"), 0L, Long.MAX_VALUE);
            loc = dfs.getFileBlockLocations(new Path("/dir/TEST-FLIE3"), 0L, Long.MAX_VALUE);
            LocatedFileStatus fs = null;
            RemoteIterator itr = null;
            Assert.assertTrue((String)"Expecting 3 files", (dfs.listStatus(new Path("/dir")).length == 3 ? 1 : 0) != 0);
            FileStatus[] fss = dfs.listStatus(new Path("/dir/TEST-FLIE1"));
            Assert.assertTrue((String)("Small file size did not match. Expecting " + ONDISK_SMALL_BUCKET_SIZE + " Got " + fss[0].getLen()), (fss[0].getLen() == (long)ONDISK_SMALL_BUCKET_SIZE ? 1 : 0) != 0);
            fss = dfs.listStatus(new Path("/dir/TEST-FLIE2"));
            Assert.assertTrue((String)("Small file size did not match. Expecting " + ONDISK_MEDIUM_BUCKET_SIZE + " Got " + fss[0].getLen()), (fss[0].getLen() == (long)ONDISK_MEDIUM_BUCKET_SIZE ? 1 : 0) != 0);
            fss = dfs.listStatus(new Path("/dir/TEST-FLIE3"));
            Assert.assertTrue((String)("Small file size did not match. Expecting " + MAX_SMALL_FILE_SIZE + " Got " + fss[0].getLen()), (fss[0].getLen() == (long)MAX_SMALL_FILE_SIZE ? 1 : 0) != 0);
            itr = dfs.listFiles(new Path("/dir"), true);
            while (itr.hasNext()) {
                fs = (LocatedFileStatus)itr.next();
                System.out.println("File: " + fs.getPath() + ", Size: " + fs.getLen() + ", Loc: " + Arrays.toString(fs.getBlockLocations()));
            }
            itr = dfs.listFiles(new Path("/dir/TEST-FLIE1"), true);
            fs = (LocatedFileStatus)itr.next();
            Assert.assertTrue((String)("Small file size did not match. Expecting " + ONDISK_SMALL_BUCKET_SIZE + " Got " + fs.getLen()), (fs.getLen() == (long)ONDISK_SMALL_BUCKET_SIZE ? 1 : 0) != 0);
            itr = dfs.listFiles(new Path("/dir/TEST-FLIE2"), true);
            fs = (LocatedFileStatus)itr.next();
            Assert.assertTrue((String)("Small file size did not match. Expecting " + ONDISK_MEDIUM_BUCKET_SIZE + " Got " + fs.getLen()), (fs.getLen() == (long)ONDISK_MEDIUM_BUCKET_SIZE ? 1 : 0) != 0);
            itr = dfs.listFiles(new Path("/dir/TEST-FLIE3"), true);
            fs = (LocatedFileStatus)itr.next();
            Assert.assertTrue((String)("Small file size did not match. Expecting " + MAX_SMALL_FILE_SIZE + " Got " + fs.getLen()), (fs.getLen() == (long)MAX_SMALL_FILE_SIZE ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Test
    public void TestReconfiguration1() throws IOException {
        int BLOCK_SIZE;
        HdfsConfiguration conf;
        MiniDFSCluster cluster;
        int INMEMORY_BUCKET_SIZE;
        block41: {
            INMEMORY_BUCKET_SIZE = 0;
            String FILE_NAME0 = "/dir/TEST-FLIE0";
            String FILE_NAME1 = "/dir/TEST-FLIE1";
            String FILE_NAME2 = "/dir/TEST-FLIE2";
            String FILE_NAME3 = "/dir/TEST-FLIE3";
            int firstConfig = 65536;
            int secondConfig = 131072;
            int thirdConfig = 32768;
            cluster = null;
            conf = new HdfsConfiguration();
            BLOCK_SIZE = 0x100000;
            conf.setInt("dfs.blocksize", 0x100000);
            conf.setInt("dfs.db.file.max.size", 65536);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(true).build();
            cluster.waitActive();
            INMEMORY_BUCKET_SIZE = FSNamesystem.getDBInMemBucketSize();
            int maxSmallFile = FSNamesystem.getMaxSmallFileSize();
            Assert.assertTrue((maxSmallFile == 65536 ? 1 : 0) != 0);
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.mkdirs(new Path("/dir"));
            dfs.setStoragePolicy(new Path("/dir"), "DB");
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE0", INMEMORY_BUCKET_SIZE);
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE0", INMEMORY_BUCKET_SIZE);
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE1", maxSmallFile);
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE1", maxSmallFile);
            Assert.assertTrue((String)("Expecting 1 in-memory file. Got: " + HopsFilesTestHelper.countInMemoryDBFiles()), (HopsFilesTestHelper.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 on-disk file(s). Got:" + HopsFilesTestHelper.countAllOnDiskDBFiles()), (HopsFilesTestHelper.countAllOnDiskDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskSmallDBFiles()), (HopsFilesTestHelper.countOnDiskSmallDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskMediumDBFiles()), (HopsFilesTestHelper.countOnDiskMediumDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskLargeDBFiles()), (HopsFilesTestHelper.countOnDiskLargeDBFiles() == 1 ? 1 : 0) != 0);
            if (cluster == null) break block41;
            cluster.shutdown();
        }
        try {
            conf = new HdfsConfiguration();
            BLOCK_SIZE = 0x100000;
            conf.setInt("dfs.blocksize", 0x100000);
            conf.setInt("dfs.db.file.max.size", 131072);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(false).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE1", 65536);
            int maxSmallFile = FSNamesystem.getMaxSmallFileSize();
            Assert.assertTrue((maxSmallFile == 131072 ? 1 : 0) != 0);
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE2", 131072);
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE2", 131072);
            Assert.assertTrue((String)("Expecting 1 in-memory file. Got: " + HopsFilesTestHelper.countInMemoryDBFiles()), (HopsFilesTestHelper.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 2 on-disk file(s). Got:" + HopsFilesTestHelper.countAllOnDiskDBFiles()), (HopsFilesTestHelper.countAllOnDiskDBFiles() == 2 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskSmallDBFiles()), (HopsFilesTestHelper.countOnDiskSmallDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskMediumDBFiles()), (HopsFilesTestHelper.countOnDiskMediumDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 2 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskLargeDBFiles()), (HopsFilesTestHelper.countOnDiskLargeDBFiles() == 2 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
        try {
            conf = new HdfsConfiguration();
            BLOCK_SIZE = 0x100000;
            conf.setInt("dfs.blocksize", 0x100000);
            conf.setInt("dfs.db.file.max.size", 32768);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(false).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE1", 65536);
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE2", 131072);
            int maxSmallFile = FSNamesystem.getMaxSmallFileSize();
            Assert.assertTrue((maxSmallFile == 32768 ? 1 : 0) != 0);
            HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE3", 32768);
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE3", 32768);
            Assert.assertTrue((String)("Expecting 1 in-memory file. Got: " + HopsFilesTestHelper.countInMemoryDBFiles()), (HopsFilesTestHelper.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 3 on-disk file(s). Got:" + HopsFilesTestHelper.countAllOnDiskDBFiles()), (HopsFilesTestHelper.countAllOnDiskDBFiles() == 3 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskSmallDBFiles()), (HopsFilesTestHelper.countOnDiskSmallDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskMediumDBFiles()), (HopsFilesTestHelper.countOnDiskMediumDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 3 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskLargeDBFiles()), (HopsFilesTestHelper.countOnDiskLargeDBFiles() == 3 ? 1 : 0) != 0);
            this.append(dfs, "/dir/TEST-FLIE0", INMEMORY_BUCKET_SIZE, 1);
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE0", INMEMORY_BUCKET_SIZE + 1);
            this.append(dfs, "/dir/TEST-FLIE1", 65536, 1);
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE1", 65537);
            this.append(dfs, "/dir/TEST-FLIE2", 131072, 1);
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE2", 131073);
            this.append(dfs, "/dir/TEST-FLIE3", 32768, 1);
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE3", 32769);
            Assert.assertTrue((String)("Expecting 0 in-memory file. Got: " + HopsFilesTestHelper.countInMemoryDBFiles()), (HopsFilesTestHelper.countInMemoryDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 on-disk file(s). Got:" + HopsFilesTestHelper.countAllOnDiskDBFiles()), (HopsFilesTestHelper.countAllOnDiskDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskSmallDBFiles()), (HopsFilesTestHelper.countOnDiskSmallDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskMediumDBFiles()), (HopsFilesTestHelper.countOnDiskMediumDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskLargeDBFiles()), (HopsFilesTestHelper.countOnDiskLargeDBFiles() == 0 ? 1 : 0) != 0);
            dfs.delete(new Path("/dir/TEST-FLIE0"));
            dfs.delete(new Path("/dir/TEST-FLIE1"));
            dfs.delete(new Path("/dir/TEST-FLIE2"));
            dfs.delete(new Path("/dir/TEST-FLIE3"));
            Assert.assertTrue((String)("Expecting 0 in-memory file. Got: " + HopsFilesTestHelper.countInMemoryDBFiles()), (HopsFilesTestHelper.countInMemoryDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countAllOnDiskDBFiles()), (HopsFilesTestHelper.countAllOnDiskDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskSmallDBFiles()), (HopsFilesTestHelper.countOnDiskSmallDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskMediumDBFiles()), (HopsFilesTestHelper.countOnDiskMediumDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskLargeDBFiles()), (HopsFilesTestHelper.countOnDiskLargeDBFiles() == 0 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
        catch (Exception e) {
            int maxSmallFile;
            DistributedFileSystem dfs;
            int BLOCK_SIZE2;
            HdfsConfiguration conf2;
            block43: {
                try {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                    if (cluster == null) break block43;
                    cluster.shutdown();
                }
                catch (Throwable throwable) {
                    int maxSmallFile2;
                    DistributedFileSystem dfs2;
                    int BLOCK_SIZE3;
                    HdfsConfiguration conf3;
                    if (cluster != null) {
                        cluster.shutdown();
                    }
                    try {
                        conf3 = new HdfsConfiguration();
                        BLOCK_SIZE3 = 0x100000;
                        conf3.setInt("dfs.blocksize", 0x100000);
                        conf3.setInt("dfs.db.file.max.size", 131072);
                        cluster = new MiniDFSCluster.Builder((Configuration)conf3).numDataNodes(1).format(false).build();
                        cluster.waitActive();
                        dfs2 = cluster.getFileSystem();
                        HopsFilesTestHelper.verifyFile((FileSystem)dfs2, "/dir/TEST-FLIE1", 65536);
                        maxSmallFile2 = FSNamesystem.getMaxSmallFileSize();
                        Assert.assertTrue((maxSmallFile2 == 131072 ? 1 : 0) != 0);
                        HopsFilesTestHelper.writeFile((FileSystem)dfs2, "/dir/TEST-FLIE2", 131072);
                        HopsFilesTestHelper.verifyFile((FileSystem)dfs2, "/dir/TEST-FLIE2", 131072);
                        Assert.assertTrue((String)("Expecting 1 in-memory file. Got: " + HopsFilesTestHelper.countInMemoryDBFiles()), (HopsFilesTestHelper.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
                        Assert.assertTrue((String)("Expecting 2 on-disk file(s). Got:" + HopsFilesTestHelper.countAllOnDiskDBFiles()), (HopsFilesTestHelper.countAllOnDiskDBFiles() == 2 ? 1 : 0) != 0);
                        Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskSmallDBFiles()), (HopsFilesTestHelper.countOnDiskSmallDBFiles() == 0 ? 1 : 0) != 0);
                        Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskMediumDBFiles()), (HopsFilesTestHelper.countOnDiskMediumDBFiles() == 0 ? 1 : 0) != 0);
                        Assert.assertTrue((String)("Expecting 2 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskLargeDBFiles()), (HopsFilesTestHelper.countOnDiskLargeDBFiles() == 2 ? 1 : 0) != 0);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                        Assert.fail((String)e2.getMessage());
                    }
                    finally {
                        if (cluster != null) {
                            cluster.shutdown();
                        }
                    }
                    try {
                        conf3 = new HdfsConfiguration();
                        BLOCK_SIZE3 = 0x100000;
                        conf3.setInt("dfs.blocksize", 0x100000);
                        conf3.setInt("dfs.db.file.max.size", 32768);
                        cluster = new MiniDFSCluster.Builder((Configuration)conf3).numDataNodes(1).format(false).build();
                        cluster.waitActive();
                        dfs2 = cluster.getFileSystem();
                        HopsFilesTestHelper.verifyFile((FileSystem)dfs2, "/dir/TEST-FLIE1", 65536);
                        HopsFilesTestHelper.verifyFile((FileSystem)dfs2, "/dir/TEST-FLIE2", 131072);
                        maxSmallFile2 = FSNamesystem.getMaxSmallFileSize();
                        Assert.assertTrue((maxSmallFile2 == 32768 ? 1 : 0) != 0);
                        HopsFilesTestHelper.writeFile((FileSystem)dfs2, "/dir/TEST-FLIE3", 32768);
                        HopsFilesTestHelper.verifyFile((FileSystem)dfs2, "/dir/TEST-FLIE3", 32768);
                        Assert.assertTrue((String)("Expecting 1 in-memory file. Got: " + HopsFilesTestHelper.countInMemoryDBFiles()), (HopsFilesTestHelper.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
                        Assert.assertTrue((String)("Expecting 3 on-disk file(s). Got:" + HopsFilesTestHelper.countAllOnDiskDBFiles()), (HopsFilesTestHelper.countAllOnDiskDBFiles() == 3 ? 1 : 0) != 0);
                        Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskSmallDBFiles()), (HopsFilesTestHelper.countOnDiskSmallDBFiles() == 0 ? 1 : 0) != 0);
                        Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskMediumDBFiles()), (HopsFilesTestHelper.countOnDiskMediumDBFiles() == 0 ? 1 : 0) != 0);
                        Assert.assertTrue((String)("Expecting 3 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskLargeDBFiles()), (HopsFilesTestHelper.countOnDiskLargeDBFiles() == 3 ? 1 : 0) != 0);
                        this.append(dfs2, "/dir/TEST-FLIE0", INMEMORY_BUCKET_SIZE, 1);
                        HopsFilesTestHelper.verifyFile((FileSystem)dfs2, "/dir/TEST-FLIE0", INMEMORY_BUCKET_SIZE + 1);
                        this.append(dfs2, "/dir/TEST-FLIE1", 65536, 1);
                        HopsFilesTestHelper.verifyFile((FileSystem)dfs2, "/dir/TEST-FLIE1", 65537);
                        this.append(dfs2, "/dir/TEST-FLIE2", 131072, 1);
                        HopsFilesTestHelper.verifyFile((FileSystem)dfs2, "/dir/TEST-FLIE2", 131073);
                        this.append(dfs2, "/dir/TEST-FLIE3", 32768, 1);
                        HopsFilesTestHelper.verifyFile((FileSystem)dfs2, "/dir/TEST-FLIE3", 32769);
                        Assert.assertTrue((String)("Expecting 0 in-memory file. Got: " + HopsFilesTestHelper.countInMemoryDBFiles()), (HopsFilesTestHelper.countInMemoryDBFiles() == 0 ? 1 : 0) != 0);
                        Assert.assertTrue((String)("Expecting 1 on-disk file(s). Got:" + HopsFilesTestHelper.countAllOnDiskDBFiles()), (HopsFilesTestHelper.countAllOnDiskDBFiles() == 1 ? 1 : 0) != 0);
                        Assert.assertTrue((String)("Expecting 1 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskSmallDBFiles()), (HopsFilesTestHelper.countOnDiskSmallDBFiles() == 1 ? 1 : 0) != 0);
                        Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskMediumDBFiles()), (HopsFilesTestHelper.countOnDiskMediumDBFiles() == 0 ? 1 : 0) != 0);
                        Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskLargeDBFiles()), (HopsFilesTestHelper.countOnDiskLargeDBFiles() == 0 ? 1 : 0) != 0);
                        dfs2.delete(new Path("/dir/TEST-FLIE0"));
                        dfs2.delete(new Path("/dir/TEST-FLIE1"));
                        dfs2.delete(new Path("/dir/TEST-FLIE2"));
                        dfs2.delete(new Path("/dir/TEST-FLIE3"));
                        Assert.assertTrue((String)("Expecting 0 in-memory file. Got: " + HopsFilesTestHelper.countInMemoryDBFiles()), (HopsFilesTestHelper.countInMemoryDBFiles() == 0 ? 1 : 0) != 0);
                        Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countAllOnDiskDBFiles()), (HopsFilesTestHelper.countAllOnDiskDBFiles() == 0 ? 1 : 0) != 0);
                        Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskSmallDBFiles()), (HopsFilesTestHelper.countOnDiskSmallDBFiles() == 0 ? 1 : 0) != 0);
                        Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskMediumDBFiles()), (HopsFilesTestHelper.countOnDiskMediumDBFiles() == 0 ? 1 : 0) != 0);
                        Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskLargeDBFiles()), (HopsFilesTestHelper.countOnDiskLargeDBFiles() == 0 ? 1 : 0) != 0);
                    }
                    catch (Exception e3) {
                        e3.printStackTrace();
                        Assert.fail((String)e3.getMessage());
                    }
                    finally {
                        if (cluster != null) {
                            cluster.shutdown();
                        }
                    }
                    throw throwable;
                }
            }
            try {
                conf2 = new HdfsConfiguration();
                BLOCK_SIZE2 = 0x100000;
                conf2.setInt("dfs.blocksize", 0x100000);
                conf2.setInt("dfs.db.file.max.size", 131072);
                cluster = new MiniDFSCluster.Builder((Configuration)conf2).numDataNodes(1).format(false).build();
                cluster.waitActive();
                dfs = cluster.getFileSystem();
                HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE1", 65536);
                maxSmallFile = FSNamesystem.getMaxSmallFileSize();
                Assert.assertTrue((maxSmallFile == 131072 ? 1 : 0) != 0);
                HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE2", 131072);
                HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE2", 131072);
                Assert.assertTrue((String)("Expecting 1 in-memory file. Got: " + HopsFilesTestHelper.countInMemoryDBFiles()), (HopsFilesTestHelper.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
                Assert.assertTrue((String)("Expecting 2 on-disk file(s). Got:" + HopsFilesTestHelper.countAllOnDiskDBFiles()), (HopsFilesTestHelper.countAllOnDiskDBFiles() == 2 ? 1 : 0) != 0);
                Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskSmallDBFiles()), (HopsFilesTestHelper.countOnDiskSmallDBFiles() == 0 ? 1 : 0) != 0);
                Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskMediumDBFiles()), (HopsFilesTestHelper.countOnDiskMediumDBFiles() == 0 ? 1 : 0) != 0);
                Assert.assertTrue((String)("Expecting 2 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskLargeDBFiles()), (HopsFilesTestHelper.countOnDiskLargeDBFiles() == 2 ? 1 : 0) != 0);
            }
            catch (Exception e4) {
                e4.printStackTrace();
                Assert.fail((String)e4.getMessage());
            }
            finally {
                if (cluster != null) {
                    cluster.shutdown();
                }
            }
            try {
                conf2 = new HdfsConfiguration();
                BLOCK_SIZE2 = 0x100000;
                conf2.setInt("dfs.blocksize", 0x100000);
                conf2.setInt("dfs.db.file.max.size", 32768);
                cluster = new MiniDFSCluster.Builder((Configuration)conf2).numDataNodes(1).format(false).build();
                cluster.waitActive();
                dfs = cluster.getFileSystem();
                HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE1", 65536);
                HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE2", 131072);
                maxSmallFile = FSNamesystem.getMaxSmallFileSize();
                Assert.assertTrue((maxSmallFile == 32768 ? 1 : 0) != 0);
                HopsFilesTestHelper.writeFile((FileSystem)dfs, "/dir/TEST-FLIE3", 32768);
                HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE3", 32768);
                Assert.assertTrue((String)("Expecting 1 in-memory file. Got: " + HopsFilesTestHelper.countInMemoryDBFiles()), (HopsFilesTestHelper.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
                Assert.assertTrue((String)("Expecting 3 on-disk file(s). Got:" + HopsFilesTestHelper.countAllOnDiskDBFiles()), (HopsFilesTestHelper.countAllOnDiskDBFiles() == 3 ? 1 : 0) != 0);
                Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskSmallDBFiles()), (HopsFilesTestHelper.countOnDiskSmallDBFiles() == 0 ? 1 : 0) != 0);
                Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskMediumDBFiles()), (HopsFilesTestHelper.countOnDiskMediumDBFiles() == 0 ? 1 : 0) != 0);
                Assert.assertTrue((String)("Expecting 3 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskLargeDBFiles()), (HopsFilesTestHelper.countOnDiskLargeDBFiles() == 3 ? 1 : 0) != 0);
                this.append(dfs, "/dir/TEST-FLIE0", INMEMORY_BUCKET_SIZE, 1);
                HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE0", INMEMORY_BUCKET_SIZE + 1);
                this.append(dfs, "/dir/TEST-FLIE1", 65536, 1);
                HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE1", 65537);
                this.append(dfs, "/dir/TEST-FLIE2", 131072, 1);
                HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE2", 131073);
                this.append(dfs, "/dir/TEST-FLIE3", 32768, 1);
                HopsFilesTestHelper.verifyFile((FileSystem)dfs, "/dir/TEST-FLIE3", 32769);
                Assert.assertTrue((String)("Expecting 0 in-memory file. Got: " + HopsFilesTestHelper.countInMemoryDBFiles()), (HopsFilesTestHelper.countInMemoryDBFiles() == 0 ? 1 : 0) != 0);
                Assert.assertTrue((String)("Expecting 1 on-disk file(s). Got:" + HopsFilesTestHelper.countAllOnDiskDBFiles()), (HopsFilesTestHelper.countAllOnDiskDBFiles() == 1 ? 1 : 0) != 0);
                Assert.assertTrue((String)("Expecting 1 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskSmallDBFiles()), (HopsFilesTestHelper.countOnDiskSmallDBFiles() == 1 ? 1 : 0) != 0);
                Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskMediumDBFiles()), (HopsFilesTestHelper.countOnDiskMediumDBFiles() == 0 ? 1 : 0) != 0);
                Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskLargeDBFiles()), (HopsFilesTestHelper.countOnDiskLargeDBFiles() == 0 ? 1 : 0) != 0);
                dfs.delete(new Path("/dir/TEST-FLIE0"));
                dfs.delete(new Path("/dir/TEST-FLIE1"));
                dfs.delete(new Path("/dir/TEST-FLIE2"));
                dfs.delete(new Path("/dir/TEST-FLIE3"));
                Assert.assertTrue((String)("Expecting 0 in-memory file. Got: " + HopsFilesTestHelper.countInMemoryDBFiles()), (HopsFilesTestHelper.countInMemoryDBFiles() == 0 ? 1 : 0) != 0);
                Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countAllOnDiskDBFiles()), (HopsFilesTestHelper.countAllOnDiskDBFiles() == 0 ? 1 : 0) != 0);
                Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskSmallDBFiles()), (HopsFilesTestHelper.countOnDiskSmallDBFiles() == 0 ? 1 : 0) != 0);
                Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskMediumDBFiles()), (HopsFilesTestHelper.countOnDiskMediumDBFiles() == 0 ? 1 : 0) != 0);
                Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskLargeDBFiles()), (HopsFilesTestHelper.countOnDiskLargeDBFiles() == 0 ? 1 : 0) != 0);
            }
            catch (Exception e5) {
                e5.printStackTrace();
                Assert.fail((String)e5.getMessage());
            }
            finally {
                if (cluster != null) {
                    cluster.shutdown();
                }
            }
        }
    }

    void append(DistributedFileSystem dfs, String name, int existingSize, int newSize) throws IOException {
        FSDataOutputStream out = dfs.append(new Path(name));
        HopsFilesTestHelper.writeData(out, existingSize, newSize);
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestConcat() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 0x100000;
            conf.setInt("dfs.blocksize", 0x100000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(true).build();
            cluster.waitActive();
            int ONDISK_SMALL_BUCKET_SIZE = FSNamesystem.getDBOnDiskSmallBucketSize();
            int ONDISK_MEDIUM_BUCKET_SIZE = FSNamesystem.getDBOnDiskMediumBucketSize();
            int MAX_SMALL_FILE_SIZE = FSNamesystem.getMaxSmallFileSize();
            int INMEMORY_BUCKET_SIZE = FSNamesystem.getDBInMemBucketSize();
            Path[] paths = new Path[4];
            for (int i = 0; i < 4; ++i) {
                paths[i] = new Path("/dir/TEST-FLIE" + i);
            }
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.mkdirs(new Path("/dir"));
            dfs.setStoragePolicy(new Path("/dir"), "DB");
            HopsFilesTestHelper.writeFile((FileSystem)dfs, paths[0].toString(), INMEMORY_BUCKET_SIZE);
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, paths[0].toString(), INMEMORY_BUCKET_SIZE);
            HopsFilesTestHelper.writeFile((FileSystem)dfs, paths[1].toString(), ONDISK_SMALL_BUCKET_SIZE);
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, paths[1].toString(), ONDISK_SMALL_BUCKET_SIZE);
            HopsFilesTestHelper.writeFile((FileSystem)dfs, paths[2].toString(), ONDISK_MEDIUM_BUCKET_SIZE);
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, paths[2].toString(), ONDISK_MEDIUM_BUCKET_SIZE);
            HopsFilesTestHelper.writeFile((FileSystem)dfs, paths[3].toString(), MAX_SMALL_FILE_SIZE);
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, paths[3].toString(), MAX_SMALL_FILE_SIZE);
            Assert.assertTrue((String)("Expecting 1 in-memory file. Got: " + HopsFilesTestHelper.countInMemoryDBFiles()), (HopsFilesTestHelper.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 3 on-disk file(s). Got:" + HopsFilesTestHelper.countAllOnDiskDBFiles()), (HopsFilesTestHelper.countAllOnDiskDBFiles() == 3 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskSmallDBFiles()), (HopsFilesTestHelper.countOnDiskSmallDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskMediumDBFiles()), (HopsFilesTestHelper.countOnDiskMediumDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskLargeDBFiles()), (HopsFilesTestHelper.countOnDiskLargeDBFiles() == 1 ? 1 : 0) != 0);
            Path merged = new Path("/dir/merged");
            HopsFilesTestHelper.writeFile((FileSystem)dfs, merged.toString(), 0);
            try {
                dfs.concat(merged, paths);
            }
            catch (IOException e) {
                if (!e.getMessage().contains("stored in DB")) {
                    throw e;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestTruncate() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 0x100000;
            conf.setInt("dfs.blocksize", 0x100000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(true).build();
            cluster.waitActive();
            int ONDISK_SMALL_BUCKET_SIZE = FSNamesystem.getDBOnDiskSmallBucketSize();
            int ONDISK_MEDIUM_BUCKET_SIZE = FSNamesystem.getDBOnDiskMediumBucketSize();
            int MAX_SMALL_FILE_SIZE = FSNamesystem.getMaxSmallFileSize();
            int INMEMORY_BUCKET_SIZE = FSNamesystem.getDBInMemBucketSize();
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.mkdirs(new Path("/dir"));
            dfs.setStoragePolicy(new Path("/dir"), "DB");
            Path file = new Path("/dir/file");
            HopsFilesTestHelper.writeFile((FileSystem)dfs, file.toString(), MAX_SMALL_FILE_SIZE);
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, file.toString(), MAX_SMALL_FILE_SIZE);
            Assert.assertTrue((String)("Expecting 0 in-memory file. Got: " + HopsFilesTestHelper.countInMemoryDBFiles()), (HopsFilesTestHelper.countInMemoryDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 on-disk file(s). Got:" + HopsFilesTestHelper.countAllOnDiskDBFiles()), (HopsFilesTestHelper.countAllOnDiskDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskSmallDBFiles()), (HopsFilesTestHelper.countOnDiskSmallDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskMediumDBFiles()), (HopsFilesTestHelper.countOnDiskMediumDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskLargeDBFiles()), (HopsFilesTestHelper.countOnDiskLargeDBFiles() == 1 ? 1 : 0) != 0);
            assert (dfs.truncate(file, (long)ONDISK_MEDIUM_BUCKET_SIZE));
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, file.toString(), ONDISK_MEDIUM_BUCKET_SIZE);
            Assert.assertTrue((String)("Expecting 0 in-memory file. Got: " + HopsFilesTestHelper.countInMemoryDBFiles()), (HopsFilesTestHelper.countInMemoryDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 on-disk file(s). Got:" + HopsFilesTestHelper.countAllOnDiskDBFiles()), (HopsFilesTestHelper.countAllOnDiskDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskSmallDBFiles()), (HopsFilesTestHelper.countOnDiskSmallDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskMediumDBFiles()), (HopsFilesTestHelper.countOnDiskMediumDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskLargeDBFiles()), (HopsFilesTestHelper.countOnDiskLargeDBFiles() == 0 ? 1 : 0) != 0);
            assert (dfs.truncate(file, (long)ONDISK_SMALL_BUCKET_SIZE));
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, file.toString(), ONDISK_SMALL_BUCKET_SIZE);
            Assert.assertTrue((String)("Expecting 0 in-memory file. Got: " + HopsFilesTestHelper.countInMemoryDBFiles()), (HopsFilesTestHelper.countInMemoryDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 on-disk file(s). Got:" + HopsFilesTestHelper.countAllOnDiskDBFiles()), (HopsFilesTestHelper.countAllOnDiskDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 1 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskSmallDBFiles()), (HopsFilesTestHelper.countOnDiskSmallDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskMediumDBFiles()), (HopsFilesTestHelper.countOnDiskMediumDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskLargeDBFiles()), (HopsFilesTestHelper.countOnDiskLargeDBFiles() == 0 ? 1 : 0) != 0);
            assert (dfs.truncate(file, (long)INMEMORY_BUCKET_SIZE));
            HopsFilesTestHelper.verifyFile((FileSystem)dfs, file.toString(), INMEMORY_BUCKET_SIZE);
            Thread.sleep(1000L);
            Assert.assertTrue((String)("Expecting 1 in-memory file. Got: " + HopsFilesTestHelper.countInMemoryDBFiles()), (HopsFilesTestHelper.countInMemoryDBFiles() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countAllOnDiskDBFiles()), (HopsFilesTestHelper.countAllOnDiskDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskSmallDBFiles()), (HopsFilesTestHelper.countOnDiskSmallDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskMediumDBFiles()), (HopsFilesTestHelper.countOnDiskMediumDBFiles() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting 0 on-disk file(s). Got:" + HopsFilesTestHelper.countOnDiskLargeDBFiles()), (HopsFilesTestHelper.countOnDiskLargeDBFiles() == 0 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @AfterClass
    public static void TestZLastTestCleanUp() throws IOException {
        String[] argv = new String[]{"-format", "-force"};
        ExitUtil.disableSystemExit();
        HdfsConfiguration conf = new HdfsConfiguration();
        HdfsStorageFactory.reset();
        HdfsStorageFactory.setConfiguration((Configuration)conf);
        UsersGroups.createSyncRow();
        try {
            NameNode.createNameNode((String[])argv, (Configuration)conf);
            Assert.fail((String)"createNameNode() did not call System.exit()");
        }
        catch (ExitUtil.ExitException exitException) {
            // empty catch block
        }
    }
}

