/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestAclLocksAcquired
extends TestCase {
    private MiniDFSCluster cluster;
    private static final Configuration conf;
    private DistributedFileSystem dfs;
    private static String dirOwner;
    private static String dirGroup;
    private UserGroupInformation robin;
    private UserGroupInformation superuser;
    private UserGroupInformation dir1admin;

    @Before
    public void setUp() throws IOException, InterruptedException {
        this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        TestAclLocksAcquired.assertNotNull((String)"Failed Cluster Creation", (Object)this.cluster);
        this.cluster.waitClusterUp();
        this.dfs = this.cluster.getFileSystem();
        TestAclLocksAcquired.assertNotNull((String)"Failed to get FileSystem", (Object)this.dfs);
        this.superuser = UserGroupInformation.createUserForTesting((String)dirOwner, (String[])new String[]{dirGroup});
        this.robin = UserGroupInformation.createUserForTesting((String)"robin", (String[])new String[]{"robin", "dir1"});
        this.dir1admin = UserGroupInformation.createUserForTesting((String)"dir1", (String[])new String[]{"dir1", "supergroup"});
        Path dir1 = new Path("/dir1");
        this.cluster.getFileSystem().mkdir(dir1, new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.NONE));
        this.cluster.getFileSystem().setOwner(dir1, "dir1", "dir1");
        ArrayList<AclEntry> acl = new ArrayList<AclEntry>();
        acl.add(new AclEntry.Builder().setScope(AclEntryScope.DEFAULT).setType(AclEntryType.USER).setName("robin").setPermission(FsAction.NONE).build());
        this.setAclAs("/dir1", this.superuser, acl);
        this.mkdirAs("/dir1/dir2", this.dir1admin, new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.NONE));
    }

    private void mkdirAs(final String path, UserGroupInformation ugi, final FsPermission permission) throws IOException, InterruptedException {
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                TestAclLocksAcquired.this.cluster.getFileSystem().mkdir(new Path(path), permission);
                TestAclLocksAcquired.this.cluster.getFileSystem().close();
                return null;
            }
        });
    }

    private void setAclAs(final String path, UserGroupInformation ugi, final List<AclEntry> acl) throws IOException, InterruptedException {
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                TestAclLocksAcquired.this.cluster.getFileSystem().setAcl(new Path(path), acl);
                TestAclLocksAcquired.this.cluster.getFileSystem().close();
                return null;
            }
        });
    }

    private void createFileAs(final String path, UserGroupInformation ugi) throws IOException, InterruptedException {
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                FSDataOutputStream fsDataOutputStream = TestAclLocksAcquired.this.cluster.getFileSystem().create(new Path(path), false);
                fsDataOutputStream.writeInt(0);
                fsDataOutputStream.close();
                return null;
            }
        });
    }

    private FileStatus getFileInfoAs(final String path, UserGroupInformation ugi) throws IOException, InterruptedException {
        return (FileStatus)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileStatus>(){

            @Override
            public FileStatus run() throws Exception {
                return TestAclLocksAcquired.this.cluster.getFileSystem().getFileStatus(new Path(path));
            }
        });
    }

    @After
    public void tearDown() throws IOException {
        if (this.dfs != null) {
            this.dfs.close();
        }
        if (this.cluster != null) {
            this.cluster.shutdownDataNodes();
            this.cluster.shutdown();
        }
    }

    @Test
    public void testCreateFile() throws IOException, InterruptedException {
        block2: {
            try {
                this.createFileAs("/dir1/dir2/file1", this.robin);
                TestAclLocksAcquired.fail((String)"Should throw exception");
            }
            catch (IOException e) {
                if (e instanceof AccessControlException) break block2;
                TestAclLocksAcquired.fail((String)"Should throw access control exception.");
            }
        }
    }

    @Test
    public void testGetFileInfo() throws IOException, InterruptedException {
        block2: {
            this.createFileAs("/dir1/dir2/file1", this.dir1admin);
            try {
                FileStatus status = this.getFileInfoAs("/dir1/dir2/file1", this.robin);
                TestAclLocksAcquired.fail((String)"Should throw exception.");
            }
            catch (IOException e) {
                if (e instanceof AccessControlException) break block2;
                TestAclLocksAcquired.fail((String)"Should throw access control exception.");
            }
        }
    }

    static {
        dirOwner = "superuser";
        dirGroup = "supergroup";
        conf = new HdfsConfiguration();
        conf.setBoolean("dfs.namenode.acls.enabled", true);
    }
}

