/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.exception.LockUpgradeException;
import io.hops.transaction.lock.TransactionLockTypes;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.junit.Assert;
import org.junit.Test;

public class TestLockUpgradeInFileRead {
    public static void writeFile(FSDataOutputStream stm, int size) throws IOException {
        byte[] buffer = AppendTestUtil.randomBytes(0L, size);
        stm.write(buffer, 0, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestFileReadLockUpgrade() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 1024;
            conf.setInt("dfs.blocksize", 1024);
            conf.setLong("dfs.namenode.accesstime.precision", 10000L);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path file = new Path("/file.txt");
            FSDataOutputStream out = dfs.create(file, (short)3);
            TestLockUpgradeInFileRead.writeFile(out, 1024);
            out.close();
            FSNamesystem ns = cluster.getNamesystem();
            try {
                Thread.sleep(10000L);
                ns.getBlockLocationsWithLock("client", file.toString(), 0L, 1024L, TransactionLockTypes.INodeLockType.READ);
                Assert.fail((String)"The operation was expected to fail");
            }
            catch (LockUpgradeException | InterruptedException throwable) {
                // empty catch block
            }
            try {
                ns.getBlockLocationsWithLock("client", file.toString(), 0L, 1024L, TransactionLockTypes.INodeLockType.WRITE);
            }
            catch (Exception e) {
                Assert.fail((String)("No exception was expected. Got " + e));
                e.printStackTrace();
            }
            try {
                ns.getBlockLocationsWithLock("client", file.toString(), 0L, 1024L, TransactionLockTypes.INodeLockType.READ);
            }
            catch (Exception e) {
                Assert.fail((String)("No exception was expected. Got " + e));
                e.printStackTrace();
            }
            try {
                Thread.sleep(10000L);
                FSDataInputStream in = dfs.open(file);
                in.read();
                in.close();
            }
            catch (Exception e) {
                Assert.fail((String)("No exception was expected. Got " + e));
                e.printStackTrace();
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

