/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.collect.Lists;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.hdfs.entity.StoredXAttr;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.XAttrHelper;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.XAttrPermissionFilter;
import org.apache.hadoop.hdfs.server.namenode.XAttrStorage;
import org.apache.hadoop.security.AccessControlException;

class FSDirXAttrOp {
    private static final XAttr UNREADABLE_BY_SUPERUSER_XATTR = XAttrHelper.buildXAttr("security.hdfs.unreadable.by.superuser", null);
    public static final XAttr XATTR_ENCRYPTION_ZONE = XAttrHelper.buildXAttr("raw.hdfs.crypto.encryption.zone", null);
    public static final XAttr XATTR_FILE_ENCRYPTION_INFO = XAttrHelper.buildXAttr("raw.hdfs.crypto.file.encryption.info", null);

    FSDirXAttrOp() {
    }

    static HdfsFileStatus setXAttr(FSDirectory fsd, String srcArg, String src, XAttr xAttr, EnumSet<XAttrSetFlag> flag, boolean logRetryCache) throws IOException {
        FSDirXAttrOp.checkXAttrsConfigFlag(fsd);
        FSDirXAttrOp.checkXAttrSize(fsd, xAttr);
        FSPermissionChecker pc = fsd.getPermissionChecker();
        XAttrPermissionFilter.checkPermissionForApi(pc, xAttr, FSDirectory.isReservedRawName(srcArg));
        INodesInPath iip = fsd.getINodesInPath4Write(src);
        FSDirXAttrOp.checkXAttrChangeAccess(fsd, iip, xAttr, pc);
        ArrayList xAttrs = Lists.newArrayListWithCapacity((int)1);
        xAttrs.add(xAttr);
        FSDirXAttrOp.unprotectedSetXAttrs(fsd, src, xAttrs, flag);
        return fsd.getAuditFileInfo(fsd.getINodesInPath(src, false));
    }

    static List<XAttr> getXAttrs(FSDirectory fsd, String srcArg, String src, List<XAttr> xAttrs) throws IOException {
        boolean getAll;
        boolean isRawPath = FSDirectory.isReservedRawName(srcArg);
        FSDirXAttrOp.checkXAttrsConfigFlag(fsd);
        FSPermissionChecker pc = fsd.getPermissionChecker();
        boolean bl = getAll = xAttrs == null || xAttrs.isEmpty();
        if (!getAll) {
            XAttrPermissionFilter.checkPermissionForApi(pc, xAttrs, isRawPath);
        }
        INodesInPath iip = fsd.getINodesInPath(src, true);
        if (fsd.isPermissionEnabled()) {
            fsd.checkPathAccess(pc, iip, FsAction.READ);
        }
        List<XAttr> all = FSDirXAttrOp.getXAttrsInt(fsd, src, xAttrs);
        List<XAttr> filteredAll = XAttrPermissionFilter.filterXAttrsForApi(pc, all, isRawPath);
        if (getAll) {
            return filteredAll;
        }
        if (filteredAll == null || !iip.getLastINode().hasXAttrs()) {
            return null;
        }
        ArrayList toGet = Lists.newArrayListWithCapacity((int)xAttrs.size());
        for (XAttr xAttr : xAttrs) {
            boolean foundIt = false;
            for (XAttr a : filteredAll) {
                if (xAttr.getNameSpace() != a.getNameSpace() || !xAttr.getName().equals(a.getName())) continue;
                toGet.add(a);
                foundIt = true;
                break;
            }
            if (foundIt) continue;
            throw new IOException("At least one of the attributes provided was not found.");
        }
        return toGet;
    }

    static List<XAttr> listXAttrs(FSDirectory fsd, String srcArg, String src) throws IOException {
        FSDirXAttrOp.checkXAttrsConfigFlag(fsd);
        FSPermissionChecker pc = fsd.getPermissionChecker();
        INodesInPath iip = fsd.getINodesInPath(src, true);
        if (fsd.isPermissionEnabled()) {
            fsd.checkParentAccess(pc, iip, FsAction.EXECUTE);
        }
        List<XAttr> all = FSDirXAttrOp.getXAttrsInt(fsd, src);
        List<XAttr> filteredAll = XAttrPermissionFilter.filterXAttrsForApi(pc, all, FSDirectory.isReservedRawName(srcArg));
        return filteredAll;
    }

    static HdfsFileStatus removeXAttr(FSDirectory fsd, String srcArg, String src, XAttr xAttr, boolean logRetryCache) throws IOException {
        FSDirXAttrOp.checkXAttrsConfigFlag(fsd);
        FSPermissionChecker pc = fsd.getPermissionChecker();
        XAttrPermissionFilter.checkPermissionForApi(pc, xAttr, FSDirectory.isReservedRawName(srcArg));
        INodesInPath iip = fsd.getINodesInPath4Write(src);
        FSDirXAttrOp.checkXAttrChangeAccess(fsd, iip, xAttr, pc);
        ArrayList xAttrs = Lists.newArrayListWithCapacity((int)1);
        xAttrs.add(xAttr);
        List<XAttr> removedXAttrs = FSDirXAttrOp.unprotectedRemoveXAttrs(fsd, src, xAttrs);
        if (removedXAttrs == null || removedXAttrs.isEmpty()) {
            throw new IOException("No matching attributes found for remove operation");
        }
        return fsd.getAuditFileInfo(fsd.getINodesInPath(src, false));
    }

    static XAttr unprotectedGetXAttrByName(INode inode, String xAttrName) throws IOException {
        List<XAttr> xAttrs = FSDirXAttrOp.unprotectedGetXAttrs(inode);
        if (xAttrs == null) {
            return null;
        }
        for (XAttr x : xAttrs) {
            if (!XAttrHelper.getPrefixName(x).equals(xAttrName)) continue;
            return x;
        }
        return null;
    }

    private static void checkXAttrsConfigFlag(FSDirectory fsd) throws IOException {
        if (!fsd.isXattrsEnabled()) {
            throw new IOException(String.format("The XAttr operation has been rejected.  Support for XAttrs has been disabled by setting %s to false.", "dfs.namenode.xattrs.enabled"));
        }
    }

    private static void checkXAttrChangeAccess(FSDirectory fsd, INodesInPath iip, XAttr xAttr, FSPermissionChecker pc) throws IOException {
        if (fsd.isPermissionEnabled() && xAttr.getNameSpace() == XAttr.NameSpace.USER) {
            INode inode = iip.getLastINode();
            if (inode != null && inode.isDirectory() && inode.getFsPermission().getStickyBit()) {
                if (!pc.isSuperUser()) {
                    fsd.checkOwner(pc, iip);
                }
            } else {
                fsd.checkPathAccess(pc, iip, FsAction.WRITE);
            }
        }
    }

    public static void checkXAttrSize(FSDirectory fsd, XAttr xAttr) {
        int nameSize = StoredXAttr.getXAttrBytes((String)xAttr.getName()).length;
        int valueSize = 0;
        if (xAttr.getValue() != null) {
            valueSize = xAttr.getValue().length;
        }
        if (nameSize > 255) {
            throw new HadoopIllegalArgumentException("The XAttr name is too big. The maximum  size of the name is 255, but the name size is " + nameSize);
        }
        if (valueSize > 13500) {
            throw new HadoopIllegalArgumentException("The XAttr value is too big. The maximum  size of the value is 13500, but the value size is " + valueSize);
        }
        int size = nameSize + valueSize;
        if (size > fsd.getXattrMaxSize()) {
            throw new HadoopIllegalArgumentException("The XAttr is too big. The maximum combined size of the name and value is " + fsd.getXattrMaxSize() + ", but the total size is " + size);
        }
    }

    static void unprotectedSetXAttrs(FSDirectory fsd, String src, List<XAttr> xAttrs, EnumSet<XAttrSetFlag> flag) throws IOException {
        INodesInPath iip = fsd.getINodesInPath4Write(FSDirectory.normalizePath(src), true);
        INode inode = FSDirectory.resolveLastINode(iip);
        FSDirXAttrOp.setINodeXAttrs(fsd, inode, xAttrs, flag);
    }

    static void setINodeXAttrs(FSDirectory fsd, INode inode, List<XAttr> toSet, EnumSet<XAttrSetFlag> flag) throws IOException {
        for (int i = 0; i < toSet.size(); ++i) {
            for (int j = i + 1; j < toSet.size(); ++j) {
                if (!toSet.get(i).equalsIgnoreValue((Object)toSet.get(j))) continue;
                throw new IOException("Cannot specify the same XAttr to be set more than once");
            }
        }
        for (XAttr xAttr : toSet) {
            boolean exists = XAttrStorage.readINodeXAttr(inode, xAttr) != null;
            XAttrSetFlag.validate((String)xAttr.getName(), (boolean)exists, flag);
            FSDirXAttrOp.incrementXAttrs(fsd, inode, xAttr, exists);
            String xaName = XAttrHelper.getPrefixName(xAttr);
            if ("raw.hdfs.crypto.encryption.zone".equals(xaName)) {
                HdfsProtos.ZoneEncryptionInfoProto ezProto = HdfsProtos.ZoneEncryptionInfoProto.parseFrom(xAttr.getValue());
                fsd.ezManager.addEncryptionZone(inode.getId(), PBHelper.convert(ezProto.getSuite()), PBHelper.convert(ezProto.getCryptoProtocolVersion()), ezProto.getKeyName());
            }
            if (!inode.isFile() && "security.hdfs.unreadable.by.superuser".equals(xaName)) {
                throw new IOException("Can only set 'security.hdfs.unreadable.by.superuser' on a file.");
            }
            XAttrStorage.updateINodeXAttr(inode, xAttr, exists, fsd.getFSNamesystem().getNamenodeId());
        }
    }

    private static void incrementXAttrs(FSDirectory fsd, INode inode, XAttr xAttr, boolean xAttrExists) throws IOException {
        if (xAttrExists) {
            return;
        }
        boolean limitsExceeded = false;
        String message = "Cannot add additional %sXAttr to inode, would exceed limit of %d";
        if (FSDirXAttrOp.isUserVisible(xAttr)) {
            if (inode.getNumUserXAttrs() == XAttrStorage.getMaxNumberOfUserXAttrPerInode()) {
                limitsExceeded = true;
            } else {
                inode.incrementUserXAttrs();
                limitsExceeded = inode.getNumUserXAttrs() > fsd.getInodeXAttrsLimit();
            }
            message = String.format(message, "", fsd.getInodeXAttrsLimit());
        } else if (inode.getNumSysXAttrs() == XAttrStorage.getMaxNumberOfSysXAttrPerInode()) {
            limitsExceeded = true;
            message = String.format(message, "System ", XAttrStorage.getMaxNumberOfSysXAttrPerInode());
        } else {
            inode.incrementSysXAttrs();
        }
        if (limitsExceeded) {
            throw new IOException(message);
        }
    }

    private static boolean isUserVisible(XAttr xAttr) {
        return xAttr.getNameSpace() == XAttr.NameSpace.USER || xAttr.getNameSpace() == XAttr.NameSpace.TRUSTED || xAttr.getNameSpace() == XAttr.NameSpace.PROVENANCE;
    }

    static List<XAttr> getXAttrs(INode inode) throws IOException {
        return FSDirXAttrOp.unprotectedGetXAttrs(inode, Collections.emptyList());
    }

    private static List<XAttr> getXAttrsInt(FSDirectory fsd, String src) throws IOException {
        return FSDirXAttrOp.getXAttrsInt(fsd, src, Collections.emptyList());
    }

    private static List<XAttr> getXAttrsInt(FSDirectory fsd, String src, List<XAttr> xAttrs) throws IOException {
        String srcs = FSDirectory.normalizePath(src);
        INodesInPath iip = fsd.getINodesInPath(srcs, true);
        INode inode = FSDirectory.resolveLastINode(iip);
        return FSDirXAttrOp.unprotectedGetXAttrs(inode, xAttrs);
    }

    private static List<XAttr> unprotectedGetXAttrs(INode inode) throws IOException {
        return XAttrStorage.readINodeXAttrs(inode, Collections.emptyList());
    }

    private static List<XAttr> unprotectedGetXAttrs(INode inode, List<XAttr> xAttrs) throws IOException {
        return XAttrStorage.readINodeXAttrs(inode, xAttrs);
    }

    static List<XAttr> unprotectedRemoveXAttrs(FSDirectory fsd, String src, List<XAttr> toRemove) throws IOException {
        INodesInPath iip = fsd.getINodesInPath4Write(FSDirectory.normalizePath(src), true);
        INode inode = FSDirectory.resolveLastINode(iip);
        List<XAttr> storedXAttrs = XAttrStorage.readINodeXAttrs(inode, toRemove);
        for (XAttr xAttr : toRemove) {
            if (!UNREADABLE_BY_SUPERUSER_XATTR.equalsIgnoreValue((Object)xAttr)) continue;
            throw new AccessControlException("The xattr 'security.hdfs.unreadable.by.superuser' can not be deleted.");
        }
        for (XAttr xAttr : storedXAttrs) {
            XAttrStorage.removeINodeXAttr(inode, xAttr, fsd.getFSNamesystem().getNamenodeId());
            FSDirXAttrOp.decrementXAttrs(inode, xAttr);
        }
        if (!storedXAttrs.isEmpty()) {
            return storedXAttrs;
        }
        return null;
    }

    private static void decrementXAttrs(INode inode, XAttr xAttr) throws TransactionContextException, StorageException {
        if (FSDirXAttrOp.isUserVisible(xAttr)) {
            inode.decrementUserXAttrs();
        } else {
            inode.decrementSysXAttrs();
        }
    }
}

