/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.common.Pair;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.hdfs.entity.FileProvXAttrBufferEntry;
import io.hops.metadata.hdfs.entity.FileProvenanceEntry;
import io.hops.security.UsersGroups;
import io.hops.transaction.EntityManager;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Optional;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileProvenance {
    static final Logger LOG = LoggerFactory.getLogger((String)FileProvenance.class.getName());
    static final String PROV_PROJECTS = "Projects";
    static final String[] PROV_HIVE = new String[]{"apps", "hive", "warehouse", "_featurestore.db"};
    static final int PROV_PROJ_RETAINED_DIRS = ProvParents.PROJECT.ordinal() + 2;
    static final int PROV_HIVE_RETAINED_DIRS = 6;
    static final int PROV_RETAINED_DIRS = Math.max(PROV_PROJ_RETAINED_DIRS, 6);

    public static void log(long namenodeId, INode inode, FileProvenanceEntry.Operation op) throws IOException {
        Pair<TrackedProv, INodeDirectory[]> parents = FileProvenance.provenanceDirs(inode);
        switch (parents.getL()) {
            case DATASET: 
            case HIVE: {
                block3 : switch (parents.getR()[ProvParents.DATASET.ordinal()].getMetaStatus()) {
                    case FULL_PROV_ENABLED: {
                        break;
                    }
                    case MIN_PROV_ENABLED: {
                        switch (op) {
                            case CREATE: 
                            case DELETE: {
                                break block3;
                            }
                            case XATTR_ADD: 
                            case XATTR_UPDATE: 
                            case XATTR_DELETE: {
                                return;
                            }
                        }
                        return;
                    }
                    default: {
                        return;
                    }
                }
                Optional<XAttr> xattr = Optional.empty();
                FileProvenance.log(namenodeId, inode, parents.getL(), parents.getR(), op, xattr);
                break;
            }
            default: {
                return;
            }
        }
    }

    public static void log(long namenodeId, INode inode, FileProvenanceEntry.Operation op, XAttr xattr) throws IOException {
        if (XAttr.NameSpace.PROVENANCE.equals((Object)xattr.getNameSpace())) {
            Pair<TrackedProv, INodeDirectory[]> parents = FileProvenance.provenanceDirs(inode);
            switch (parents.getL()) {
                case DATASET: 
                case HIVE: {
                    switch (parents.getR()[ProvParents.DATASET.ordinal()].getMetaStatus()) {
                        case FULL_PROV_ENABLED: 
                        case MIN_PROV_ENABLED: {
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    FileProvenance.log(namenodeId, inode, parents.getL(), parents.getR(), op, Optional.of(xattr));
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    private static void log(long namenodeId, INode inode, TrackedProv type, INodeDirectory[] parents, FileProvenanceEntry.Operation op, Optional<XAttr> xattr) throws IOException {
        String remoteUserName;
        int remoteUserId;
        UserGroupInformation ugi;
        String projectName;
        Long projectIId;
        String tieBreaker = namenodeId + "_" + Thread.currentThread().getId();
        switch (type) {
            case DATASET: {
                projectIId = parents[ProvParents.PROJECT.ordinal()].getId();
                projectName = parents[ProvParents.PROJECT.ordinal()].getLocalName();
                break;
            }
            case HIVE: {
                projectIId = -1L;
                projectName = FileProvenance.projectNameFromHiveDB(parents[ProvParents.DATASET.ordinal()].getLocalName());
                break;
            }
            default: {
                return;
            }
        }
        try {
            ugi = NameNode.getRemoteUser();
            remoteUserId = UsersGroups.getUserID((String)ugi.getUserName());
            remoteUserName = ugi.getUserName();
        }
        catch (IOException ex) {
            String msg = "provenance - error getting user - issuer of operation for inode:" + inode.getLocalName();
            LOG.error(msg, (Throwable)ex);
            throw ex;
        }
        String appId = ugi.getApplicationId();
        if (appId == null) {
            appId = "none";
        }
        long timestamp = System.currentTimeMillis();
        String p1Name = parents[ProvParents.PARENT_P1.ordinal()] != null ? parents[ProvParents.PARENT_P1.ordinal()].getLocalName() : "";
        String p2Name = parents[ProvParents.PARENT_P2.ordinal()] != null ? parents[ProvParents.PARENT_P2.ordinal()].getLocalName() : "";
        String xattrName = xattr.isPresent() ? xattr.get().getName() : "";
        FileProvenanceEntry ple = new FileProvenanceEntry(inode.getId(), op, inode.getLogicalTime(), timestamp, appId, remoteUserId, tieBreaker, inode.getPartitionId().longValue(), projectIId.longValue(), parents[ProvParents.DATASET.ordinal()].getId(), parents[ProvParents.PARENT_DIRECT.ordinal()].getId(), inode.getLocalName(), projectName, parents[ProvParents.DATASET.ordinal()].getLocalName(), p1Name, p2Name, parents[ProvParents.PARENT_DIRECT.ordinal()].getLocalName(), remoteUserName, xattrName, inode.getLogicalTime(), timestamp, parents[ProvParents.DATASET.ordinal()].getLogicalTime());
        try {
            if (xattr.isPresent()) {
                byte xattrNamespace = xattr.get().getNameSpace().getId();
                byte[] xattrValue = xattr.get().getValue();
                FileProvXAttrBufferEntry xattrEntry = new FileProvXAttrBufferEntry(inode.getId(), xattrNamespace, xattrName, inode.getLogicalTime(), xattrValue);
                EntityManager.add((Object)xattrEntry);
            }
            EntityManager.add((Object)ple);
        }
        catch (StorageException | TransactionContextException ex) {
            String msg = "provenance - error persisting in ndb for inode:" + inode.getLocalName();
            LOG.error(msg, ex);
            throw ex;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Pair<TrackedProv, INodeDirectory[]> provenanceDirs(INode inode) throws TransactionContextException, StorageException {
        INodeDirectory[] provDirs = new INodeDirectory[]{null, null, null, null, null, null};
        LinkedList<INodeDirectory> aux = new LinkedList<INodeDirectory>();
        if (inode.isRoot()) {
            return new Pair<TrackedProv, INodeDirectory[]>(TrackedProv.OTHER, provDirs);
        }
        try {
            INodeDirectory current;
            provDirs[ProvParents.PARENT_DIRECT.ordinal()] = current = inode.getParent();
            if (current.isRoot()) {
                return new Pair<TrackedProv, INodeDirectory[]>(TrackedProv.OTHER, provDirs);
            }
            aux.add(current);
            while (!current.isRoot()) {
                current = current.getParent();
                aux.add(current);
                if (aux.size() <= PROV_RETAINED_DIRS) continue;
                aux.removeFirst();
            }
        }
        catch (StorageException | TransactionContextException ex) {
            String msg = "provenance - error getting inode parents:" + inode.getLocalName();
            LOG.error(msg, ex);
            throw ex;
        }
        aux.removeLast();
        if (aux.isEmpty()) {
            return new Pair<TrackedProv, INodeDirectory[]>(TrackedProv.OTHER, provDirs);
        }
        if (PROV_PROJECTS.equals(((INodeDirectory)aux.getLast()).getLocalName())) {
            aux.removeLast();
            if (aux.isEmpty()) {
                if (!(inode instanceof INodeDirectory)) return new Pair<TrackedProv, INodeDirectory[]>(TrackedProv.OTHER, provDirs);
                provDirs[ProvParents.PROJECT.ordinal()] = (INodeDirectory)inode;
                return new Pair<TrackedProv, INodeDirectory[]>(TrackedProv.PROJECT, provDirs);
            }
            provDirs[ProvParents.PROJECT.ordinal()] = aux.removeLast();
            if (aux.isEmpty()) {
                if (!(inode instanceof INodeDirectory)) return new Pair<TrackedProv, INodeDirectory[]>(TrackedProv.OTHER, provDirs);
                provDirs[ProvParents.DATASET.ordinal()] = (INodeDirectory)inode;
                return new Pair<TrackedProv, INodeDirectory[]>(TrackedProv.DATASET, provDirs);
            }
            provDirs[ProvParents.DATASET.ordinal()] = aux.removeLast();
            provDirs[ProvParents.PARENT_P1.ordinal()] = aux.isEmpty() ? null : aux.removeLast();
            provDirs[ProvParents.PARENT_P2.ordinal()] = aux.isEmpty() ? null : aux.removeLast();
            return new Pair<TrackedProv, INodeDirectory[]>(TrackedProv.DATASET, provDirs);
        }
        if (!FileProvenance.isHive(aux)) return new Pair<TrackedProv, INodeDirectory[]>(TrackedProv.OTHER, provDirs);
        aux.removeLast();
        aux.removeLast();
        aux.removeLast();
        provDirs[ProvParents.PROJECT.ordinal()] = null;
        if (aux.isEmpty()) {
            if (!(inode instanceof INodeDirectory)) return new Pair<TrackedProv, INodeDirectory[]>(TrackedProv.OTHER, provDirs);
            provDirs[ProvParents.DATASET.ordinal()] = (INodeDirectory)inode;
        } else {
            provDirs[ProvParents.DATASET.ordinal()] = aux.removeLast();
        }
        provDirs[ProvParents.PARENT_P1.ordinal()] = aux.isEmpty() ? null : aux.removeLast();
        provDirs[ProvParents.PARENT_P2.ordinal()] = aux.isEmpty() ? null : aux.removeLast();
        return new Pair<TrackedProv, INodeDirectory[]>(TrackedProv.HIVE, provDirs);
    }

    static boolean isHive(LinkedList<INodeDirectory> parents) {
        return parents.size() >= 3 && PROV_HIVE[0].equals(parents.get(parents.size() - 1).getLocalName()) && PROV_HIVE[1].equals(parents.get(parents.size() - 2).getLocalName()) && PROV_HIVE[2].equals(parents.get(parents.size() - 3).getLocalName());
    }

    static String projectNameFromHiveDB(String hiveDBName) {
        int idx = hiveDBName.indexOf(PROV_HIVE[3]);
        idx = idx == -1 ? hiveDBName.indexOf(".db") : idx;
        idx = idx == -1 ? hiveDBName.length() : idx;
        return hiveDBName.substring(0, idx);
    }

    private static enum ProvParents {
        PARENT_DIRECT,
        PARENT_P2,
        PARENT_P1,
        DATASET,
        PROJECT;

    }

    private static enum TrackedProv {
        PROJECT,
        DATASET,
        HIVE,
        OTHER;

    }
}

