/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.CounterType;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.entity.LeasePath;
import io.hops.transaction.EntityManager;
import java.util.Collection;
import java.util.TreeSet;
import org.apache.hadoop.hdfs.protocol.Block;

public class Lease
implements Comparable<Lease> {
    private final String holder;
    private long lastUpdate;
    private Collection<LeasePath> paths = null;
    private int holderID;

    public Lease(String holder, int holderID, long lastUpd) {
        this.holder = holder;
        this.holderID = holderID;
        this.lastUpdate = lastUpd;
    }

    public void setLastUpdate(long lastUpd) {
        this.lastUpdate = lastUpd;
    }

    public void setPaths(TreeSet<LeasePath> paths) {
        this.paths = paths;
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public void setHolderID(int holderID) {
        this.holderID = holderID;
    }

    public int getHolderID() {
        return this.holderID;
    }

    public boolean removePath(LeasePath lPath) throws StorageException, TransactionContextException {
        return this.getPaths().remove(lPath);
    }

    public void addPath(LeasePath lPath) throws StorageException, TransactionContextException {
        this.getPaths().add(lPath);
    }

    public void addFirstPath(LeasePath lPath) {
        this.paths = new TreeSet<LeasePath>();
        this.paths.add(lPath);
    }

    boolean hasPath() throws StorageException, TransactionContextException {
        return !this.getPaths().isEmpty();
    }

    public String toString() {
        int size = 0;
        if (this.paths != null) {
            size = this.paths.size();
        }
        return "[Lease.  Holder: " + this.holder + ", pendingcreates: " + size + "]";
    }

    @Override
    public int compareTo(Lease o) {
        Lease l1 = this;
        Lease l2 = o;
        long lu1 = l1.lastUpdate;
        long lu2 = l2.lastUpdate;
        if (lu1 < lu2) {
            return -1;
        }
        if (lu1 > lu2) {
            return 1;
        }
        return l1.holder.compareTo(l2.holder);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Lease)) {
            return false;
        }
        Lease obj = (Lease)o;
        return this.lastUpdate == obj.lastUpdate && this.holder.equals(obj.holder);
    }

    public int hashCode() {
        return this.holder.hashCode();
    }

    public Collection<LeasePath> getPaths() throws StorageException, TransactionContextException {
        if (this.paths == null) {
            this.paths = EntityManager.findList((FinderType)LeasePath.Finder.ByHolderId, (Object[])new Object[]{this.holderID});
        }
        return this.paths;
    }

    public String getHolder() {
        return this.holder;
    }

    public static int getHolderId(String holder) {
        return holder.hashCode();
    }

    public void updateLastTwoBlocksInLeasePath(String path, Block lastBlock, Block penultimateBlock) throws TransactionContextException, StorageException {
        this.updateLastTwoBlocksInLeasePath(path, lastBlock == null ? -1L : lastBlock.getBlockId(), penultimateBlock == null ? -1L : penultimateBlock.getBlockId());
    }

    private void updateLastTwoBlocksInLeasePath(String path, long lastBlockId, long penultimateBlockId) throws TransactionContextException, StorageException {
        Collection<LeasePath> lps = this.getPaths();
        for (LeasePath lp : lps) {
            if (!lp.getPath().equals(path)) continue;
            lp.setLastBlockId(lastBlockId);
            lp.setPenultimateBlockId(penultimateBlockId);
            EntityManager.update((Object)lp);
            break;
        }
    }

    public LeasePath getLeasePath(String path) throws TransactionContextException, StorageException {
        Collection<LeasePath> lps = this.getPaths();
        for (LeasePath lp : lps) {
            if (!lp.getPath().equals(path)) continue;
            return lp;
        }
        return null;
    }

    public static enum Finder implements FinderType<Lease>
    {
        ByHolder,
        ByHolderId,
        All;


        public Class getType() {
            return Lease.class;
        }

        public FinderType.Annotation getAnnotated() {
            switch (this) {
                case ByHolder: {
                    return FinderType.Annotation.PrimaryKey;
                }
                case ByHolderId: {
                    return FinderType.Annotation.PrunedIndexScan;
                }
                case All: {
                    return FinderType.Annotation.FullTable;
                }
            }
            throw new IllegalStateException();
        }
    }

    public static enum Counter implements CounterType<Lease>
    {
        All;


        public Class getType() {
            return Lease.class;
        }
    }
}

