/*
 * Decompiled with CFR 0.152.
 */
package io.hops.merge;

import io.hops.merge.HttpConfig2;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.client.ConnectionConfigurator;
import org.apache.hadoop.security.ssl.SSLFactory;

public class SecurityUtil2
extends SecurityUtil {
    private static SSLFactory sslFactory;

    public static URLConnection openSecureHttpConnection(URL url) throws IOException {
        if (!HttpConfig2.isSecure() && !UserGroupInformation.isSecurityEnabled()) {
            return url.openConnection();
        }
        AuthenticatedURL.Token token = new AuthenticatedURL.Token();
        try {
            return new AuthenticatedURL(null, (ConnectionConfigurator)sslFactory).openConnection(url, token);
        }
        catch (AuthenticationException e) {
            throw new IOException("Exception trying to open authenticated connection to " + url, e);
        }
    }

    static {
        Configuration conf = new Configuration();
        if (HttpConfig2.isSecure()) {
            sslFactory = new SSLFactory(SSLFactory.Mode.CLIENT, conf);
            try {
                sslFactory.init();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

