/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.adaptor;

import io.hops.exception.StorageException;
import io.hops.metadata.DalAdaptor;
import io.hops.metadata.hdfs.dal.INodeDataAccess;
import io.hops.metadata.hdfs.entity.INode;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.metadata.hdfs.entity.INodeMetadataLogEntry;
import io.hops.metadata.hdfs.entity.ProjectedINode;
import io.hops.security.GroupNotFoundException;
import io.hops.security.UserNotFoundException;
import io.hops.security.UsersGroups;
import io.hops.transaction.context.EntityContext;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.server.namenode.DirectoryWithQuotaFeature;
import org.apache.hadoop.hdfs.server.namenode.FileUnderConstructionFeature;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeSymlink;
import org.apache.hadoop.hdfs.server.namenode.INodeWithAdditionalFields;
import org.apache.hadoop.hdfs.server.namenode.XAttrFeature;

public class INodeDALAdaptor
extends DalAdaptor<org.apache.hadoop.hdfs.server.namenode.INode, INode>
implements INodeDataAccess<org.apache.hadoop.hdfs.server.namenode.INode> {
    private INodeDataAccess<INode> dataAccess;

    public INodeDALAdaptor(INodeDataAccess<INode> dataAccess) {
        this.dataAccess = dataAccess;
    }

    public org.apache.hadoop.hdfs.server.namenode.INode findInodeByIdFTIS(long inodeId) throws StorageException {
        return this.convertDALtoHDFS((INode)this.dataAccess.findInodeByIdFTIS(inodeId));
    }

    public Collection<org.apache.hadoop.hdfs.server.namenode.INode> findInodesByIdsFTIS(long[] inodeId) throws StorageException {
        return this.convertDALtoHDFS(this.dataAccess.findInodesByIdsFTIS(inodeId));
    }

    public List<org.apache.hadoop.hdfs.server.namenode.INode> findInodesByParentIdFTIS(long parentId) throws StorageException {
        List list = (List)this.convertDALtoHDFS(this.dataAccess.findInodesByParentIdFTIS(parentId));
        Collections.sort(list, INode.Order.ByName);
        return list;
    }

    public List<org.apache.hadoop.hdfs.server.namenode.INode> findInodesByParentIdAndPartitionIdPPIS(long parentId, long partitionId) throws StorageException {
        List list = (List)this.convertDALtoHDFS(this.dataAccess.findInodesByParentIdAndPartitionIdPPIS(parentId, partitionId));
        Collections.sort(list, INode.Order.ByName);
        return list;
    }

    public List<ProjectedINode> findInodesPPISTx(long parentId, long partitionId, EntityContext.LockMode lock) throws StorageException {
        List list = this.dataAccess.findInodesPPISTx(parentId, partitionId, lock);
        Collections.sort(list);
        return list;
    }

    public List<ProjectedINode> findInodesFTISTx(long parentId, EntityContext.LockMode lock) throws StorageException {
        List list = this.dataAccess.findInodesFTISTx(parentId, lock);
        Collections.sort(list);
        return list;
    }

    public List<org.apache.hadoop.hdfs.server.namenode.INode> lockInodesUsingPkBatchTx(String[] names, long[] parentIds, long[] partitionIds, EntityContext.LockMode lock) throws StorageException {
        return (List)this.convertDALtoHDFS(this.dataAccess.lockInodesUsingPkBatchTx(names, parentIds, partitionIds, lock));
    }

    public org.apache.hadoop.hdfs.server.namenode.INode findInodeByNameParentIdAndPartitionIdPK(String name, long parentId, long partitionId) throws StorageException {
        return this.convertDALtoHDFS((INode)this.dataAccess.findInodeByNameParentIdAndPartitionIdPK(name, parentId, partitionId));
    }

    public List<org.apache.hadoop.hdfs.server.namenode.INode> getINodesPkBatched(String[] names, long[] parentIds, long[] partitionIds) throws StorageException {
        return (List)this.convertDALtoHDFS(this.dataAccess.getINodesPkBatched(names, parentIds, partitionIds));
    }

    public void prepare(Collection<org.apache.hadoop.hdfs.server.namenode.INode> removed, Collection<org.apache.hadoop.hdfs.server.namenode.INode> newed, Collection<org.apache.hadoop.hdfs.server.namenode.INode> modified) throws StorageException {
        this.dataAccess.prepare(this.convertHDFStoDAL(removed), this.convertHDFStoDAL(newed), this.convertHDFStoDAL(modified));
    }

    public int countAll() throws StorageException {
        return this.dataAccess.countAll();
    }

    public List<INodeIdentifier> getAllINodeFiles(long startId, long endId) throws StorageException {
        return this.dataAccess.getAllINodeFiles(startId, endId);
    }

    public boolean haveFilesWithIdsGreaterThan(long id) throws StorageException {
        return this.dataAccess.haveFilesWithIdsGreaterThan(id);
    }

    public boolean haveFilesWithIdsBetween(long startId, long endId) throws StorageException {
        return this.dataAccess.haveFilesWithIdsBetween(startId, endId);
    }

    public long getMinFileId() throws StorageException {
        return this.dataAccess.getMinFileId();
    }

    public long getMaxFileId() throws StorageException {
        return this.dataAccess.getMaxFileId();
    }

    public int countAllFiles() throws StorageException {
        return this.dataAccess.countAllFiles();
    }

    public boolean hasChildren(long parentId, boolean areChildrenRandomlyPartitioned) throws StorageException {
        return this.dataAccess.hasChildren(parentId, areChildrenRandomlyPartitioned);
    }

    public List<org.apache.hadoop.hdfs.server.namenode.INode> allINodes() throws StorageException {
        return (List)this.convertDALtoHDFS(this.dataAccess.allINodes());
    }

    public void deleteInode(String name) throws StorageException {
        this.dataAccess.deleteInode(name);
    }

    public void updateLogicalTime(Collection<INodeMetadataLogEntry> logEntries) throws StorageException {
        this.dataAccess.updateLogicalTime(logEntries);
    }

    public int countSubtreeLockedInodes() throws StorageException {
        return this.dataAccess.countSubtreeLockedInodes();
    }

    public INode convertHDFStoDAL(org.apache.hadoop.hdfs.server.namenode.INode inode) throws StorageException {
        INode hopINode = null;
        if (inode != null) {
            hopINode = new INode();
            hopINode.setAccessTime(inode.getAccessTime());
            hopINode.setGroupID(inode.getGroupID());
            hopINode.setId(inode.getId());
            hopINode.setIsDir(inode.isDirectory());
            hopINode.setPartitionId(inode.getPartitionId().longValue());
            hopINode.setLogicalTime(inode.getLogicalTime());
            hopINode.setModificationTime(inode.getModificationTime());
            hopINode.setName(inode.getLocalName());
            hopINode.setParentId(inode.getParentId());
            hopINode.setPermission(inode.getFsPermission().toShort());
            if (!inode.isSymlink()) {
                hopINode.setStoragePolicyID(inode.getLocalStoragePolicyID());
            }
            hopINode.setSubtreeLocked(inode.isSTOLocked());
            hopINode.setSubtreeLockOwner(inode.getSTOLockOwner());
            hopINode.setUserID(inode.getUserID());
            if (inode.isDirectory()) {
                hopINode.setUnderConstruction(false);
                hopINode.setDirWithQuota(((INodeDirectory)inode).isWithQuota());
                hopINode.setMetaStatus(((INodeDirectory)inode).getMetaStatus());
                hopINode.setChildrenNum(((INodeDirectory)inode).getChildrenNum());
            }
            if (inode instanceof INodeFile) {
                if (inode.isUnderConstruction()) {
                    hopINode.setClientName(((INodeFile)inode).getFileUnderConstructionFeature().getClientName());
                    hopINode.setClientMachine(((INodeFile)inode).getFileUnderConstructionFeature().getClientMachine());
                }
                hopINode.setUnderConstruction(inode.isUnderConstruction());
                hopINode.setDirWithQuota(false);
                hopINode.setHeader(((INodeFile)inode).getHeader());
                hopINode.setGenerationStamp(((INodeFile)inode).getGenerationStamp());
                hopINode.setFileSize(((INodeFile)inode).getSize());
                hopINode.setFileStoredInDB(((INodeFile)inode).isFileStoredInDB());
            }
            if (inode instanceof INodeSymlink) {
                hopINode.setUnderConstruction(false);
                hopINode.setDirWithQuota(false);
                String linkValue = DFSUtil.bytes2String(((INodeSymlink)inode).getSymlink());
                hopINode.setSymlink(linkValue);
            }
            hopINode.setHeader(inode.getHeader());
            hopINode.setNumAces(inode.getNumAces());
            hopINode.setNumUserXAttrs(inode.getNumUserXAttrs());
            hopINode.setNumSysXAttrs(inode.getNumSysXAttrs());
        }
        return hopINode;
    }

    public org.apache.hadoop.hdfs.server.namenode.INode convertDALtoHDFS(INode hopINode) throws StorageException {
        try {
            INodeWithAdditionalFields inode = null;
            if (hopINode != null) {
                String group = null;
                String user = null;
                try {
                    user = UsersGroups.getUser((int)hopINode.getUserID());
                }
                catch (UserNotFoundException userNotFoundException) {
                    // empty catch block
                }
                try {
                    group = UsersGroups.getGroup((int)hopINode.getGroupID());
                }
                catch (GroupNotFoundException groupNotFoundException) {
                    // empty catch block
                }
                PermissionStatus ps = new PermissionStatus(user, group, new FsPermission(hopINode.getPermission()));
                if (hopINode.isDirectory()) {
                    if (hopINode.isDirWithQuota()) {
                        inode = new INodeDirectory(hopINode.getId(), hopINode.getName(), ps, true);
                        DirectoryWithQuotaFeature quota = new DirectoryWithQuotaFeature.Builder(((org.apache.hadoop.hdfs.server.namenode.INode)inode).getId()).build();
                        inode.addFeature(quota);
                    } else {
                        String iname = hopINode.getName().length() == 0 ? "" : hopINode.getName();
                        inode = new INodeDirectory(hopINode.getId(), iname, ps, true);
                    }
                    ((org.apache.hadoop.hdfs.server.namenode.INode)inode).setAccessTimeNoPersistance(hopINode.getAccessTime());
                    ((org.apache.hadoop.hdfs.server.namenode.INode)inode).setModificationTimeNoPersistance(hopINode.getModificationTime());
                    ((INodeDirectory)inode).setMetaStatus(hopINode.getMetaStatus());
                    ((INodeDirectory)inode).setChildrenNum(hopINode.getChildrenNum());
                } else if (hopINode.getSymlink() != null) {
                    inode = new INodeSymlink(hopINode.getId(), hopINode.getSymlink(), hopINode.getModificationTime(), hopINode.getAccessTime(), ps, true);
                } else {
                    inode = new INodeFile(hopINode.getId(), ps, hopINode.getHeader(), hopINode.getModificationTime(), hopINode.getAccessTime(), hopINode.isFileStoredInDB(), hopINode.getStoragePolicyID(), true);
                    if (hopINode.isUnderConstruction()) {
                        FileUnderConstructionFeature ucf = new FileUnderConstructionFeature(hopINode.getClientName(), hopINode.getClientMachine(), inode);
                        ((INodeFile)inode).addFeature(ucf);
                    }
                    ((INodeFile)inode).setGenerationStampNoPersistence(hopINode.getGenerationStamp());
                    ((INodeFile)inode).setSizeNoPersistence(hopINode.getFileSize());
                    ((INodeFile)inode).setFileStoredInDBNoPersistence(hopINode.isFileStoredInDB());
                }
                ((org.apache.hadoop.hdfs.server.namenode.INode)inode).setLocalNameNoPersistance(hopINode.getName());
                inode.setParentIdNoPersistance(hopINode.getParentId());
                inode.setSubtreeLocked(hopINode.isSubtreeLocked());
                inode.setSubtreeLockOwner(hopINode.getSubtreeLockOwner());
                ((org.apache.hadoop.hdfs.server.namenode.INode)inode).setUserIDNoPersistence(hopINode.getUserID());
                ((org.apache.hadoop.hdfs.server.namenode.INode)inode).setGroupIDNoPersistence(hopINode.getGroupID());
                ((org.apache.hadoop.hdfs.server.namenode.INode)inode).setHeaderNoPersistance(hopINode.getHeader());
                ((org.apache.hadoop.hdfs.server.namenode.INode)inode).setPartitionIdNoPersistance(hopINode.getPartitionId());
                ((org.apache.hadoop.hdfs.server.namenode.INode)inode).setLogicalTimeNoPersistance(hopINode.getLogicalTime());
                inode.setBlockStoragePolicyIDNoPersistance(hopINode.getStoragePolicyID());
                inode.setNumAcesNoPersistence(hopINode.getNumAces());
                inode.setNumUserXAttrsNoPersistence(hopINode.getNumUserXAttrs());
                inode.setNumSysXAttrsNoPersistence(hopINode.getNumSysXAttrs());
                if (inode.hasXAttrs()) {
                    inode.addXAttrFeature(new XAttrFeature(hopINode.getId()));
                }
            }
            return inode;
        }
        catch (IOException ex) {
            throw new StorageException((Throwable)ex);
        }
    }

    public long getMaxId() throws StorageException {
        return this.dataAccess.getMaxId();
    }
}

