/*
 * Decompiled with CFR 0.152.
 */
package io.hops.resolvingcache;

import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.resolvingcache.InMemoryCache;
import io.hops.transaction.context.TransactionsStats;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.namenode.INode;

public abstract class Cache {
    private static Cache instance = null;
    protected static final Log LOG = LogFactory.getLog(Cache.class);
    private boolean isStarted;
    private boolean isEnabled;

    protected Cache() {
    }

    public static Cache getInstance(Configuration conf) throws IOException {
        if (instance == null) {
            String memType = conf.get("dfs.resolvingcache.type", "InMemory").toLowerCase();
            if (!memType.equals("inmemory")) {
                throw new IllegalArgumentException("Cache has only two Memcache implementations, Inode based and Path based: wrong parameter " + memType);
            }
            instance = new InMemoryCache();
            instance.setConfiguration(conf);
        }
        return instance;
    }

    public static Cache getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Memcache should have started first with configuration");
        }
        return instance;
    }

    protected void setConfiguration(Configuration conf) throws IOException {
        this.isEnabled = conf.getBoolean("dfs.resolvingcache.enabled", true);
        if (this.isEnabled) {
            this.start();
        }
    }

    private void start() throws IOException {
        if (!this.isStarted) {
            LOG.info((Object)("starting Resolving Cache [" + instance.getClass().getSimpleName() + "]"));
            this.startInternal();
            this.isStarted = true;
        }
    }

    private void stop() {
        if (this.isStarted) {
            LOG.info((Object)("stopping Resolving Cache [" + instance.getClass().getSimpleName() + "]"));
            this.stopInternal();
            this.isStarted = false;
        }
    }

    public void enableOrDisable(boolean forceEnable) throws IOException {
        if (forceEnable) {
            this.start();
        } else {
            this.stop();
        }
        this.isEnabled = forceEnable;
    }

    public final void set(String path, INode[] inodes) {
        this.set(path, Arrays.asList(inodes));
    }

    public final void set(String path, List<INode> inodes) {
        if (this.isStarted) {
            this.setInternal(path, inodes);
            if (TransactionsStats.getInstance().isEnabled()) {
                TransactionsStats.getInstance().pushResolvingCacheStats(new TransactionsStats.ResolvingCacheStat(TransactionsStats.ResolvingCacheStat.Op.SET, 0L, this.getRoundTrips(inodes)));
            }
        }
    }

    public final void set(INode inode) {
        if (this.isStarted) {
            this.setInternal(inode);
            if (TransactionsStats.getInstance().isEnabled()) {
                TransactionsStats.getInstance().pushResolvingCacheStats(new TransactionsStats.ResolvingCacheStat(TransactionsStats.ResolvingCacheStat.Op.SET, 0L, 1));
            }
        }
    }

    public final long[] get(String path) throws IOException {
        if (this.isStarted) {
            long startTime = System.currentTimeMillis();
            long[] result = this.getInternal(path);
            long elapsed = System.currentTimeMillis() - startTime;
            LOG.debug((Object)("GET for path (" + path + ")  got value = " + Arrays.toString(result) + " in " + elapsed + " msec"));
            if (TransactionsStats.getInstance().isEnabled()) {
                TransactionsStats.getInstance().pushResolvingCacheStats(new TransactionsStats.ResolvingCacheStat(TransactionsStats.ResolvingCacheStat.Op.GET, elapsed, this.getRoundTrips(path)));
            }
            return result;
        }
        return null;
    }

    public final INodeIdentifier get(long inodeId) throws IOException {
        if (this.isStarted) {
            long startTime = System.currentTimeMillis();
            INodeIdentifier result = this.getInternal(inodeId);
            long elapsed = System.currentTimeMillis() - startTime;
            LOG.debug((Object)("GET for inodeId (" + inodeId + ")  got value = " + result + " in " + elapsed + " msec"));
            if (TransactionsStats.getInstance().isEnabled()) {
                TransactionsStats.getInstance().pushResolvingCacheStats(new TransactionsStats.ResolvingCacheStat(TransactionsStats.ResolvingCacheStat.Op.GET, elapsed, 1));
            }
            return result;
        }
        return null;
    }

    public final void delete(String path) {
        if (this.isStarted) {
            this.deleteInternal(path);
        }
    }

    public final void delete(INode inode) {
        if (this.isStarted) {
            this.deleteInternal(inode);
        }
    }

    public final void delete(INodeIdentifier inode) {
        if (this.isStarted) {
            this.deleteInternal(inode);
        }
    }

    public final void flush() {
        if (this.isStarted) {
            this.flushInternal();
        }
    }

    protected abstract void startInternal() throws IOException;

    protected abstract void stopInternal();

    protected abstract void setInternal(String var1, List<INode> var2);

    protected abstract void setInternal(INode var1);

    protected abstract long[] getInternal(String var1) throws IOException;

    protected abstract INodeIdentifier getInternal(long var1) throws IOException;

    protected abstract void deleteInternal(String var1);

    protected abstract void deleteInternal(INode var1);

    protected abstract void deleteInternal(INodeIdentifier var1);

    protected abstract void flushInternal();

    protected abstract int getRoundTrips(String var1);

    protected abstract int getRoundTrips(List<INode> var1);
}

