/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import com.google.common.annotations.VisibleForTesting;
import io.hops.leader_election.node.ActiveNode;
import io.hops.leader_election.node.SortedActiveNodeList;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeStatus;
import org.apache.hadoop.hdfs.protocol.UnregisteredNodeException;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.server.common.IncorrectVersionException;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.DNConf;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.protocol.BlockReportContext;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.DisallowedDatanodeException;
import org.apache.hadoop.hdfs.server.protocol.HeartbeatResponse;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.StorageBlockReport;
import org.apache.hadoop.hdfs.server.protocol.StorageReceivedDeletedBlocks;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.hdfs.server.protocol.VolumeFailureSummary;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hadoop.util.VersionUtil;

@InterfaceAudience.Private
class BPServiceActor
implements Runnable {
    static final Log LOG = DataNode.LOG;
    final InetSocketAddress nnAddr;
    BPOfferService bpos;
    Thread bpThread;
    DatanodeProtocolClientSideTranslatorPB bpNamenode;
    private final Scheduler scheduler;
    private volatile RunningState runningState = RunningState.CONNECTING;
    private volatile boolean shouldServiceRun = true;
    private final DataNode dn;
    private final DNConf dnConf;
    private DatanodeRegistration bpRegistration;
    private boolean connectedToNN = false;

    BPServiceActor(InetSocketAddress nnAddr, BPOfferService bpos) {
        this.bpos = bpos;
        this.dn = bpos.getDataNode();
        this.nnAddr = nnAddr;
        this.dnConf = this.dn.getDnConf();
        this.scheduler = new Scheduler(this.dnConf.heartBeatInterval);
    }

    boolean isRunning() {
        if (!this.isAlive()) {
            return false;
        }
        return this.runningState == RunningState.RUNNING;
    }

    boolean isAlive() {
        if (!this.shouldServiceRun || !this.bpThread.isAlive()) {
            return false;
        }
        return this.runningState == RunningState.RUNNING || this.runningState == RunningState.CONNECTING;
    }

    public String toString() {
        return this.bpos.toString() + " service to " + this.nnAddr;
    }

    InetSocketAddress getNNSocketAddress() {
        return this.nnAddr;
    }

    @VisibleForTesting
    void setNameNode(DatanodeProtocolClientSideTranslatorPB dnProtocol) {
        this.bpNamenode = dnProtocol;
    }

    @VisibleForTesting
    DatanodeProtocolClientSideTranslatorPB getNameNodeProxy() {
        return this.bpNamenode;
    }

    @VisibleForTesting
    NamespaceInfo retrieveNamespaceInfo() throws IOException {
        NamespaceInfo nsInfo = null;
        while (this.shouldRun()) {
            try {
                nsInfo = this.bpNamenode.versionRequest();
                LOG.debug((Object)(this + " received versionRequest response: " + nsInfo));
                break;
            }
            catch (SocketTimeoutException e) {
                LOG.warn((Object)("Problem connecting to server: " + this.nnAddr));
            }
            catch (IOException e) {
                LOG.warn((Object)("Problem connecting to server: " + this.nnAddr));
            }
            this.sleepAndLogInterrupts(5000, "requesting version info from NN");
        }
        if (nsInfo == null) {
            throw new IOException("DN shut down before block pool connected");
        }
        this.checkNNVersion(nsInfo);
        return nsInfo;
    }

    private void checkNNVersion(NamespaceInfo nsInfo) throws IncorrectVersionException {
        String minimumNameNodeVersion;
        String nnVersion = nsInfo.getSoftwareVersion();
        if (VersionUtil.compareVersions((String)nnVersion, (String)(minimumNameNodeVersion = this.dnConf.getMinimumNameNodeVersion())) < 0) {
            IncorrectVersionException ive = new IncorrectVersionException(minimumNameNodeVersion, nnVersion, "NameNode", "DataNode");
            LOG.warn((Object)ive.getMessage());
            throw ive;
        }
        String dnVersion = VersionInfo.getVersion();
        if (!nnVersion.equals(dnVersion)) {
            LOG.info((Object)("Reported NameNode version '" + nnVersion + "' does not match DataNode version '" + dnVersion + "' but is within acceptable limits. Note: This is normal during a rolling upgrade."));
        }
    }

    private void connectToNNAndHandshake() throws IOException {
        this.bpNamenode = this.dn.connectToNN(this.nnAddr);
        NamespaceInfo nsInfo = this.retrieveNamespaceInfo();
        this.bpos.verifyAndSetNamespaceInfo(nsInfo);
        this.register(nsInfo);
    }

    void reportBadBlocks(ExtendedBlock block, String storageUuid, StorageType storageType) throws IOException {
        if (this.bpRegistration == null) {
            return;
        }
        DatanodeInfo[] dnArr = new DatanodeInfo[]{new DatanodeInfo((DatanodeID)this.bpRegistration)};
        String[] uuids = new String[]{storageUuid};
        StorageType[] types = new StorageType[]{storageType};
        LocatedBlock[] blocks = new LocatedBlock[]{new LocatedBlock(block, dnArr, uuids, types)};
        try {
            this.bpNamenode.reportBadBlocks(blocks);
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed to report bad block " + block + " to namenode :  Exception"), (Throwable)e);
            throw e;
        }
    }

    @VisibleForTesting
    synchronized void triggerHeartbeatForTests() {
        long nextHeartbeatTime = this.scheduler.scheduleHeartbeat();
        this.notifyAll();
        while (nextHeartbeatTime - this.scheduler.nextHeartbeatTime >= 0L) {
            try {
                this.wait(100L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    HeartbeatResponse sendHeartBeat() throws IOException {
        VolumeFailureSummary volumeFailureSummary;
        StorageReport[] reports = this.dn.getFSDataset().getStorageReports(this.bpos.getBlockPoolId());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Sending heartbeat with " + reports.length + " storage reports from service actor: " + this));
        }
        int numFailedVolumes = (volumeFailureSummary = this.dn.getFSDataset().getVolumeFailureSummary()) != null ? volumeFailureSummary.getFailedStorageLocations().length : 0;
        return this.bpNamenode.sendHeartbeat(this.bpRegistration, reports, this.dn.getFSDataset().getCacheCapacity(), this.dn.getFSDataset().getCacheUsed(), this.dn.getXmitsInProgress(), this.dn.getXceiverCount(), numFailedVolumes, volumeFailureSummary);
    }

    void start() {
        if (this.bpThread != null && this.bpThread.isAlive()) {
            return;
        }
        this.bpThread = new Thread((Runnable)this, this.formatThreadName());
        this.bpThread.setDaemon(true);
        this.bpThread.start();
    }

    private String formatThreadName() {
        List<StorageLocation> dataDirs = DataNode.getStorageLocations(this.dn.getConf());
        return "DataNode: [" + dataDirs.toString() + "]  heartbeating to " + this.nnAddr;
    }

    void stop() {
        this.shouldServiceRun = false;
        if (this.bpThread != null) {
            this.bpThread.interrupt();
        }
    }

    void join() {
        try {
            if (this.bpThread != null) {
                this.bpThread.join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private synchronized void cleanUp() {
        this.shouldServiceRun = false;
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.bpNamenode});
        this.bpos.shutdownActor(this);
    }

    private void handleRollingUpgradeStatus(HeartbeatResponse resp) throws IOException {
        RollingUpgradeStatus rollingUpgradeStatus = resp.getRollingUpdateStatus();
        if (rollingUpgradeStatus != null && rollingUpgradeStatus.getBlockPoolId().compareTo(this.bpos.getBlockPoolId()) != 0) {
            LOG.error((Object)("Invalid BlockPoolId " + rollingUpgradeStatus.getBlockPoolId() + " in HeartbeatResponse. Expected " + this.bpos.getBlockPoolId()));
        } else {
            this.bpos.signalRollingUpgrade(rollingUpgradeStatus != null);
        }
    }

    private void offerService() throws Exception {
        LOG.info((Object)("For namenode " + this.nnAddr + " using BLOCKREPORT_INTERVAL of " + this.dnConf.blockReportInterval + "msec CACHEREPORT_INTERVAL of " + this.dnConf.cacheReportInterval + "msec Initial delay: " + this.dnConf.initialBlockReportDelay + "msec; heartBeatInterval=" + this.dnConf.heartBeatInterval));
        this.bpos.startWhirlingSufiThread();
        while (this.shouldRun()) {
            try {
                long waitTime;
                long startTime = this.scheduler.monotonicNow();
                boolean sendHeartbeat = this.scheduler.isHeartbeatDue(startTime);
                if (sendHeartbeat) {
                    this.refreshNNConnections();
                    this.scheduler.scheduleNextHeartbeat();
                    if (!this.dn.areHeartbeatsDisabledForTests()) {
                        HeartbeatResponse resp = this.sendHeartBeat();
                        assert (resp != null);
                        this.connectedToNN = true;
                        this.dn.getMetrics().addHeartbeat(this.scheduler.monotonicNow() - startTime);
                        this.handleRollingUpgradeStatus(resp);
                        long startProcessCommands = Time.monotonicNow();
                        if (!this.processCommand(resp.getCommands())) continue;
                        long endProcessCommands = Time.monotonicNow();
                        if (endProcessCommands - startProcessCommands > 2000L) {
                            LOG.info((Object)("Took " + (endProcessCommands - startProcessCommands) + "ms to process " + resp.getCommands().length + " commands from NN"));
                        }
                    }
                }
                if ((waitTime = this.scheduler.getHeartbeatWaitTime()) <= 0L) {
                    waitTime = 1L;
                }
                Thread.sleep(waitTime);
            }
            catch (RemoteException re) {
                String reClass = re.getClassName();
                if (UnregisteredNodeException.class.getName().equals(reClass) || DisallowedDatanodeException.class.getName().equals(reClass) || IncorrectVersionException.class.getName().equals(reClass)) {
                    LOG.warn((Object)(this + " is shutting down"), (Throwable)re);
                    this.shouldServiceRun = false;
                    return;
                }
                LOG.warn((Object)"RemoteException in offerService", (Throwable)re);
                try {
                    long sleepTime = Math.min(1000L, this.dnConf.heartBeatInterval);
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
            catch (InterruptedException e) {
                LOG.warn((Object)"OfferService interrupted", (Throwable)e);
            }
            catch (IOException e) {
                LOG.warn((Object)"IOException in offerService", (Throwable)e);
                this.connectedToNN = false;
            }
        }
    }

    void register(NamespaceInfo nsInfo) throws IOException {
        this.bpRegistration = this.bpos.createRegistration();
        while (this.shouldRun()) {
            try {
                this.bpRegistration = this.bpNamenode.registerDatanode(this.bpRegistration);
                this.bpRegistration.setNamespaceInfo(nsInfo);
                break;
            }
            catch (EOFException e) {
                LOG.info((Object)("Problem connecting to server: " + this.nnAddr + " :" + e.getLocalizedMessage()));
                this.sleepAndLogInterrupts(1000, "connecting to server");
            }
            catch (SocketTimeoutException e) {
                LOG.info((Object)("Problem connecting to server: " + this.nnAddr));
                this.sleepAndLogInterrupts(1000, "connecting to server");
            }
        }
        LOG.info((Object)("Block pool " + this + " successfully registered with NN"));
        this.bpos.registrationSucceeded(this, this.bpRegistration);
        this.refreshNNConnections();
        if (!this.bpos.otherActorsConnectedToNNs(this) && this.bpos.firstActor(this)) {
            this.bpos.scheduleBlockReport(this.dnConf.initialBlockReportDelay);
        } else {
            LOG.info((Object)"Block Report skipped as other BPServiceActors are connected to the namenodes ");
        }
    }

    private void sleepAndLogInterrupts(int millis, String stateString) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ie) {
            LOG.info((Object)("BPOfferService " + this + " interrupted while " + stateString));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        LOG.info((Object)(this + " starting to offer service"));
        try {
            while (true) {
                try {
                    this.connectToNNAndHandshake();
                }
                catch (IOException ioe) {
                    this.runningState = RunningState.INIT_FAILED;
                    if (!this.shouldRetryInit()) {
                        this.runningState = RunningState.FAILED;
                        LOG.fatal((Object)("Initialization failed for " + this + ". Exiting. "), (Throwable)ioe);
                        this.cleanUp();
                        LOG.warn((Object)("Ending block pool service for: " + this));
                        this.cleanUp();
                        return;
                    }
                    LOG.error((Object)("Initialization failed for " + this + " " + ioe.getLocalizedMessage()));
                    this.sleepAndLogInterrupts(5000, "initializing");
                    continue;
                }
                break;
            }
            this.runningState = RunningState.RUNNING;
        }
        catch (Throwable ex) {
            LOG.warn((Object)("Unexpected exception in block pool " + this), ex);
            this.runningState = RunningState.FAILED;
            return;
        }
        finally {
            LOG.warn((Object)("Ending block pool service for: " + this));
            this.cleanUp();
        }
        while (true) {
            if (!this.shouldRun()) {
                this.runningState = RunningState.EXITED;
                return;
            }
            try {
                this.offerService();
            }
            catch (Exception ex) {
                LOG.error((Object)("Exception in BPOfferService for " + this), (Throwable)ex);
                this.cleanUp();
                continue;
            }
            break;
        }
    }

    private boolean shouldRetryInit() {
        return this.shouldRun() && this.bpos.shouldRetryInit();
    }

    private boolean shouldRun() {
        return this.shouldServiceRun && this.dn.shouldRun();
    }

    boolean processCommand(DatanodeCommand[] cmds) {
        if (cmds != null) {
            for (DatanodeCommand cmd : cmds) {
                try {
                    if (!this.bpos.processCommandFromActor(cmd, this)) {
                        return false;
                    }
                }
                catch (IOException ioe) {
                    LOG.warn((Object)"Error processing datanode Command", (Throwable)ioe);
                }
            }
        }
        return true;
    }

    void trySendErrorReport(int errCode, String errMsg) {
        try {
            this.bpNamenode.errorReport(this.bpRegistration, errCode, errMsg);
        }
        catch (IOException e) {
            LOG.warn((Object)("Error reporting an error to NameNode " + this.nnAddr), (Throwable)e);
        }
    }

    void reportRemoteBadBlock(DatanodeInfo dnInfo, ExtendedBlock block) throws IOException {
        LocatedBlock lb = new LocatedBlock(block, new DatanodeInfo[]{dnInfo});
        this.bpNamenode.reportBadBlocks(new LocatedBlock[]{lb});
    }

    void reRegister() throws IOException {
        if (this.shouldRun()) {
            NamespaceInfo nsInfo = this.retrieveNamespaceInfo();
            this.register(nsInfo);
            this.scheduler.scheduleHeartbeat();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof BPServiceActor)) {
            return false;
        }
        BPServiceActor that = (BPServiceActor)obj;
        return this.getNNSocketAddress().equals(that.getNNSocketAddress());
    }

    private void refreshNNConnections() throws IOException {
        if (!this.bpos.canUpdateNNList()) {
            return;
        }
        SortedActiveNodeList list = this.bpNamenode.getActiveNamenodes();
        this.bpos.updateNNList(list);
        this.bpos.setLastNNListUpdateTime();
    }

    public void blockReceivedAndDeleted(DatanodeRegistration registration, String poolId, StorageReceivedDeletedBlocks[] receivedAndDeletedBlocks) throws IOException {
        if (this.bpNamenode != null) {
            this.bpNamenode.blockReceivedAndDeleted(registration, poolId, receivedAndDeletedBlocks);
        }
    }

    public DatanodeCommand reportHashes(DatanodeRegistration registration, String poolId, StorageBlockReport[] reports) throws IOException {
        return this.bpNamenode.reportHashes(registration, poolId, reports);
    }

    public DatanodeCommand blockReport(DatanodeRegistration registration, String poolId, StorageBlockReport[] reports, BlockReportContext context) throws IOException {
        return this.bpNamenode.blockReport(registration, poolId, reports, context);
    }

    public void blockReportCompleted(DatanodeRegistration registration, DatanodeStorage[] storages, boolean success) throws IOException {
        this.bpNamenode.blockReportCompleted(registration, storages, success);
    }

    public DatanodeCommand cacheReport(DatanodeRegistration bpRegistration, String bpid, List<Long> blockIds) throws IOException {
        return this.bpNamenode.cacheReport(bpRegistration, bpid, blockIds, this.dn.getFSDataset().getCacheCapacity(), this.dn.getFSDataset().getCacheUsed());
    }

    public ActiveNode nextNNForBlkReport(long noOfBlks, DatanodeRegistration nodeReg) throws IOException {
        if (this.bpNamenode != null) {
            return this.bpNamenode.getNextNamenodeToSendBlockReport(noOfBlks, nodeReg);
        }
        return null;
    }

    public byte[] getSmallFileDataFromNN(int id) throws IOException {
        if (this.bpNamenode != null) {
            return this.bpNamenode.getSmallFileData(id);
        }
        return null;
    }

    public boolean connectedToNN() {
        return this.connectedToNN;
    }

    static class Scheduler {
        @VisibleForTesting
        volatile long nextHeartbeatTime = this.monotonicNow();
        private final long heartbeatIntervalMs;

        Scheduler(long heartbeatIntervalMs) {
            this.heartbeatIntervalMs = heartbeatIntervalMs;
        }

        long scheduleHeartbeat() {
            this.nextHeartbeatTime = this.monotonicNow();
            return this.nextHeartbeatTime;
        }

        long scheduleNextHeartbeat() {
            this.nextHeartbeatTime += this.heartbeatIntervalMs;
            return this.nextHeartbeatTime;
        }

        boolean isHeartbeatDue(long startTime) {
            return this.nextHeartbeatTime - startTime <= 0L;
        }

        long getHeartbeatWaitTime() {
            return this.nextHeartbeatTime - this.monotonicNow();
        }

        @VisibleForTesting
        public long monotonicNow() {
            return Time.monotonicNow();
        }
    }

    static enum RunningState {
        CONNECTING,
        INIT_FAILED,
        RUNNING,
        EXITED,
        FAILED;

    }
}

