/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.base.Charsets;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import io.hops.TestUtil;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.hdfs.dal.MetadataLogDataAccess;
import io.hops.metadata.hdfs.dal.XAttrDataAccess;
import io.hops.metadata.hdfs.entity.INodeMetadataLogEntry;
import io.hops.metadata.hdfs.entity.MetaStatus;
import io.hops.metadata.hdfs.entity.MetadataLogEntry;
import io.hops.metadata.hdfs.entity.XAttrMetadataLogEntry;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.handler.RequestHandler;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.annotation.Nullable;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.TestFileCreation;
import org.apache.hadoop.hdfs.XAttrHelper;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.junit.Test;

public class TestMetadataLog
extends TestCase {
    private static final int ANY_DATASET = -1;
    private static final String ANY_NAME = "-1";
    private static Comparator<MetadataLogEntry> LOGICAL_TIME_COMPARATOR = new Comparator<MetadataLogEntry>(){

        @Override
        public int compare(MetadataLogEntry o1, MetadataLogEntry o2) {
            return Integer.compare(o1.getLogicalTime(), o2.getLogicalTime());
        }
    };

    private boolean checkLog(long inodeId, INodeMetadataLogEntry.Operation operation) throws IOException {
        return this.checkLog(-1L, inodeId, (MetadataLogEntry.OperationBase)operation);
    }

    private boolean checkLog(long datasetId, long inodeId, MetadataLogEntry.OperationBase operation) throws IOException {
        return this.checkLog(datasetId, inodeId, ANY_NAME, operation);
    }

    private boolean checkLog(long datasetId, long inodeId, String inodeNameOrXAttrName, MetadataLogEntry.OperationBase operation) throws IOException {
        Collection<MetadataLogEntry> logEntries = this.getMetadataLogEntries(inodeId);
        for (MetadataLogEntry logEntry : logEntries) {
            if (logEntry.getOperationId() != operation.getId() || datasetId != -1L && datasetId != logEntry.getDatasetId() || !inodeNameOrXAttrName.equals(ANY_NAME) && !inodeNameOrXAttrName.equals(logEntry.getPk3())) continue;
            return true;
        }
        return false;
    }

    private Collection<MetadataLogEntry> getMetadataLogEntries(final long inodeId) throws IOException {
        return (Collection)new LightWeightRequestHandler((RequestHandler.OperationType)HDFSOperationType.GET_METADATA_LOG_ENTRIES){

            public Object performTask() throws IOException {
                MetadataLogDataAccess da = (MetadataLogDataAccess)HdfsStorageFactory.getDataAccess(MetadataLogDataAccess.class);
                return da.find(inodeId);
            }
        }.handle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonLoggingFolder() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path projects = new Path("/projects");
            Path project = new Path(projects, "project");
            Path dataset = new Path(project, "dataset");
            Path subdir = new Path(dataset, "subdir");
            Path file = new Path(dataset, "file");
            dfs.mkdirs(dataset, FsPermission.getDefault());
            dfs.mkdirs(subdir);
            TestMetadataLog.assertFalse((boolean)this.checkLog(TestUtil.getINodeId(cluster.getNameNode(), dataset), INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertFalse((boolean)this.checkLog(TestUtil.getINodeId(cluster.getNameNode(), subdir), INodeMetadataLogEntry.Operation.Add));
            HdfsDataOutputStream out = TestFileCreation.create(dfs, file, 1);
            out.close();
            TestMetadataLog.assertFalse((boolean)this.checkLog(TestUtil.getINodeId(cluster.getNameNode(), file), INodeMetadataLogEntry.Operation.Add));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreate() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path projects = new Path("/projects");
            Path project = new Path(projects, "project");
            Path dataset = new Path(project, "dataset");
            Path subdir = new Path(dataset, "subdir");
            Path file = new Path(subdir, "file");
            dfs.mkdirs(dataset, FsPermission.getDefault());
            dfs.setMetaStatus(dataset, MetaStatus.META_ENABLED);
            dfs.mkdirs(subdir);
            TestMetadataLog.assertTrue((boolean)this.checkLog(TestUtil.getINodeId(cluster.getNameNode(), dataset), INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(TestUtil.getINodeId(cluster.getNameNode(), subdir), INodeMetadataLogEntry.Operation.Add));
            HdfsDataOutputStream out = TestFileCreation.create(dfs, file, 1);
            out.close();
            TestMetadataLog.assertTrue((boolean)this.checkLog(TestUtil.getINodeId(cluster.getNameNode(), file), INodeMetadataLogEntry.Operation.Add));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset, subdir, file}, new int[]{1, 1, 1});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppend() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path projects = new Path("/projects");
            Path project = new Path(projects, "project");
            Path dataset = new Path(project, "dataset");
            Path subdir = new Path(dataset, "subdir");
            Path file = new Path(subdir, "file");
            dfs.mkdirs(dataset, FsPermission.getDefault());
            dfs.setMetaStatus(dataset, MetaStatus.META_ENABLED);
            dfs.mkdirs(subdir);
            TestMetadataLog.assertTrue((boolean)this.checkLog(TestUtil.getINodeId(cluster.getNameNode(), dataset), INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(TestUtil.getINodeId(cluster.getNameNode(), subdir), INodeMetadataLogEntry.Operation.Add));
            HdfsDataOutputStream out = TestFileCreation.create(dfs, file, 1);
            out.close();
            long inodeId = TestUtil.getINodeId(cluster.getNameNode(), file);
            TestMetadataLog.assertTrue((boolean)this.checkLog(inodeId, INodeMetadataLogEntry.Operation.Add));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset, subdir, file}, new int[]{1, 1, 1});
            dfs.append(file).close();
            dfs.append(file).close();
            ArrayList<MetadataLogEntry> inodeLogEntries = new ArrayList<MetadataLogEntry>(this.getMetadataLogEntries(inodeId));
            Collections.sort(inodeLogEntries, LOGICAL_TIME_COMPARATOR);
            TestMetadataLog.assertTrue((inodeLogEntries.size() == 3 ? 1 : 0) != 0);
            for (int i = 0; i < 3; ++i) {
                TestMetadataLog.assertEquals((int)(i + 1), (int)((MetadataLogEntry)inodeLogEntries.get(i)).getLogicalTime());
                TestMetadataLog.assertTrue((((INodeMetadataLogEntry)inodeLogEntries.get(i)).getOperation() == INodeMetadataLogEntry.Operation.Add ? 1 : 0) != 0);
            }
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset, subdir, file}, new int[]{1, 1, 3});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoLogEntryBeforeClosing() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path projects = new Path("/projects");
            Path project = new Path(projects, "project");
            Path dataset = new Path(project, "dataset");
            Path file = new Path(dataset, "file");
            dfs.mkdirs(dataset, FsPermission.getDefault());
            dfs.setMetaStatus(dataset, MetaStatus.META_ENABLED);
            HdfsDataOutputStream out = TestFileCreation.create(dfs, file, 1);
            TestMetadataLog.assertTrue((boolean)this.checkLog(TestUtil.getINodeId(cluster.getNameNode(), dataset), INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertFalse((boolean)this.checkLog(TestUtil.getINodeId(cluster.getNameNode(), file), INodeMetadataLogEntry.Operation.Add));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset, file}, new int[]{1, 0});
            out.close();
            TestMetadataLog.assertTrue((boolean)this.checkLog(TestUtil.getINodeId(cluster.getNameNode(), file), INodeMetadataLogEntry.Operation.Add));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset, file}, new int[]{1, 1});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDelete() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path projects = new Path("/projects");
            Path project = new Path(projects, "project");
            Path dataset = new Path(project, "dataset");
            Path folder = new Path(dataset, "folder");
            Path file = new Path(folder, "file");
            dfs.mkdirs(folder, FsPermission.getDefault());
            dfs.setMetaStatus(dataset, MetaStatus.META_ENABLED);
            HdfsDataOutputStream out = TestFileCreation.create(dfs, file, 1);
            out.close();
            long inodeId = TestUtil.getINodeId(cluster.getNameNode(), file);
            long folderId = TestUtil.getINodeId(cluster.getNameNode(), folder);
            long datasetId = TestUtil.getINodeId(cluster.getNameNode(), dataset);
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(folderId, INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(inodeId, INodeMetadataLogEntry.Operation.Add));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset, folder, file}, new int[]{1, 1, 1});
            dfs.delete(folder, true);
            TestMetadataLog.assertTrue((boolean)this.checkLog(folderId, INodeMetadataLogEntry.Operation.Delete));
            TestMetadataLog.assertTrue((boolean)this.checkLog(inodeId, INodeMetadataLogEntry.Operation.Delete));
            this.checkLogicalTimeDeleteAfterAdd(new long[]{folderId, inodeId});
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset}, new int[]{1});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testOldRename() throws Exception {
        this.testRename(true);
    }

    @Test
    public void testRename() throws Exception {
        this.testRename(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRename(boolean oldRename) throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path projects = new Path("/projects");
            Path project = new Path(projects, "project");
            Path dataset0 = new Path(project, "dataset0");
            Path dataset1 = new Path(project, "dataset1");
            Path file0 = new Path(dataset0, "file");
            Path file1 = new Path(dataset1, "file");
            dfs.mkdirs(dataset0, FsPermission.getDefault());
            dfs.mkdirs(dataset1, FsPermission.getDefault());
            dfs.setMetaStatus(dataset0, MetaStatus.META_ENABLED);
            dfs.setMetaStatus(dataset1, MetaStatus.META_ENABLED);
            HdfsDataOutputStream out = TestFileCreation.create(dfs, file0, 1);
            out.close();
            long inodeId = TestUtil.getINodeId(cluster.getNameNode(), file0);
            long dataset0Id = TestUtil.getINodeId(cluster.getNameNode(), dataset0);
            long dataset1Id = TestUtil.getINodeId(cluster.getNameNode(), dataset1);
            TestMetadataLog.assertTrue((boolean)this.checkLog(dataset0Id, INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(dataset1Id, INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(inodeId, INodeMetadataLogEntry.Operation.Add));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset0, dataset1, file0}, new int[]{1, 1, 1});
            if (oldRename) {
                TestMetadataLog.assertTrue((boolean)dfs.rename(file0, file1));
            } else {
                dfs.rename(file0, file1, new Options.Rename[]{Options.Rename.NONE});
            }
            TestMetadataLog.assertTrue((boolean)this.checkLog(dataset1Id, inodeId, (MetadataLogEntry.OperationBase)INodeMetadataLogEntry.Operation.Rename));
            TestMetadataLog.assertEquals((int)2, (int)this.getMetadataLogEntries(inodeId).size());
            this.checkLogicalTimeAddRename(inodeId);
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset0, dataset1, file1}, new int[]{1, 1, 2});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testDeepOldRename() throws Exception {
        this.testDeepRename(true);
    }

    @Test
    public void testDeepRename() throws Exception {
        this.testDeepRename(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDeepRename(boolean oldRename) throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path projects = new Path("/projects");
            Path project = new Path(projects, "project");
            Path dataset0 = new Path(project, "dataset0");
            Path folder0 = new Path(dataset0, "folder0");
            Path dataset1 = new Path(project, "dataset1");
            Path folder1 = new Path(dataset1, "folder1");
            Path file0 = new Path(folder0, "file");
            dfs.mkdirs(folder0, FsPermission.getDefault());
            dfs.mkdirs(dataset1, FsPermission.getDefault());
            dfs.setMetaStatus(dataset0, MetaStatus.META_ENABLED);
            dfs.setMetaStatus(dataset1, MetaStatus.META_ENABLED);
            HdfsDataOutputStream out = TestFileCreation.create(dfs, file0, 1);
            out.close();
            long inodeId = TestUtil.getINodeId(cluster.getNameNode(), file0);
            long folder0Id = TestUtil.getINodeId(cluster.getNameNode(), folder0);
            long dataset0Id = TestUtil.getINodeId(cluster.getNameNode(), dataset0);
            long dataset1Id = TestUtil.getINodeId(cluster.getNameNode(), dataset1);
            TestMetadataLog.assertTrue((boolean)this.checkLog(dataset0Id, dataset0Id, (MetadataLogEntry.OperationBase)INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(dataset0Id, folder0Id, (MetadataLogEntry.OperationBase)INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(dataset0Id, inodeId, (MetadataLogEntry.OperationBase)INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(dataset1Id, dataset1Id, (MetadataLogEntry.OperationBase)INodeMetadataLogEntry.Operation.Add));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset0, dataset1, folder0, file0}, new int[]{1, 1, 1, 1});
            if (oldRename) {
                dfs.rename(folder0, folder1);
            } else {
                dfs.rename(folder0, folder1, new Options.Rename[]{Options.Rename.NONE});
            }
            long folder1Id = TestUtil.getINodeId(cluster.getNameNode(), folder1);
            TestMetadataLog.assertEquals((long)folder0Id, (long)folder1Id);
            TestMetadataLog.assertTrue((boolean)this.checkLog(dataset1Id, folder0Id, (MetadataLogEntry.OperationBase)INodeMetadataLogEntry.Operation.Rename));
            TestMetadataLog.assertTrue((boolean)this.checkLog(dataset1Id, inodeId, (MetadataLogEntry.OperationBase)INodeMetadataLogEntry.Operation.ChangeDataset));
            this.checkLogicalTimeAddRename(folder0Id);
            this.checkLogicalTimeAddRChangeDataset(inodeId);
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset0, dataset1, folder1, new Path(folder1, file0.getName())}, new int[]{1, 1, 2, 2});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEnableLogForExistingDirectory() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path projects = new Path("/projects");
            Path project = new Path(projects, "project");
            Path dataset = new Path(project, "dataset");
            Path folder = new Path(dataset, "folder");
            Path file = new Path(folder, "file");
            dfs.mkdirs(folder, FsPermission.getDefault());
            HdfsDataOutputStream out = TestFileCreation.create(dfs, file, 1);
            out.close();
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{projects, project, dataset, folder, file}, new int[]{0, 0, 0, 0, 0});
            dfs.setMetaStatus(dataset, MetaStatus.META_ENABLED);
            long inodeId = TestUtil.getINodeId(cluster.getNameNode(), file);
            long folderId = TestUtil.getINodeId(cluster.getNameNode(), folder);
            long datasetId = TestUtil.getINodeId(cluster.getNameNode(), dataset);
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(folderId, INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(inodeId, INodeMetadataLogEntry.Operation.Add));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{projects, project, dataset, folder, file}, new int[]{0, 0, 1, 1, 1});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteFileWhileOpen() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        boolean BYTES_PER_CHECKSUM = true;
        boolean PACKET_SIZE = true;
        boolean BLOCK_SIZE = true;
        conf.setInt("dfs.bytes-per-checksum", 1);
        conf.setLong("dfs.blocksize", 1L);
        conf.setInt("dfs.client-write-packet-size", 1);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            DistributedFileSystem dfs = (DistributedFileSystem)FileSystem.newInstance((URI)fs.getUri(), (Configuration)fs.getConf());
            Path projects = new Path("/projects");
            Path project = new Path(projects, "project");
            Path dataset = new Path(project, "dataset");
            Path folder = new Path(dataset, "folder");
            Path file = new Path(folder, "file");
            dfs.mkdirs(folder, FsPermission.getDefault());
            dfs.setMetaStatus(dataset, MetaStatus.META_ENABLED);
            FSDataOutputStream out = dfs.create(file);
            out.writeByte(0);
            long inodeId = TestUtil.getINodeId(cluster.getNameNode(), file);
            long folderId = TestUtil.getINodeId(cluster.getNameNode(), folder);
            long datasetId = TestUtil.getINodeId(cluster.getNameNode(), dataset);
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(folderId, INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertFalse((boolean)this.checkLog(inodeId, INodeMetadataLogEntry.Operation.Add));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset, folder, file}, new int[]{1, 1, 0});
            DistributedFileSystem dfs2 = (DistributedFileSystem)FileSystem.newInstance((URI)fs.getUri(), (Configuration)fs.getConf());
            try {
                dfs2.delete(file, false);
            }
            catch (Exception ex) {
                TestMetadataLog.fail((String)("we shouldn't have any exception: " + ex.getMessage()));
            }
            TestMetadataLog.assertFalse((boolean)this.checkLog(inodeId, INodeMetadataLogEntry.Operation.Delete));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{folder}, new int[]{1});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testDeepOldRenameInTheSameDataset() throws Exception {
        this.testDeepRenameInTheSameDataset(true);
    }

    @Test
    public void testDeepRenameInTheSameDataset() throws Exception {
        this.testDeepRenameInTheSameDataset(false);
    }

    @Test
    public void testOldDeepRenameToNonMetaEnabledDir() throws Exception {
        this.testDeepRenameToNonMetaEnabledDir(true);
    }

    @Test
    public void testDeepRenameToNonMetaEnabledDir() throws Exception {
        this.testDeepRenameToNonMetaEnabledDir(false);
    }

    @Test
    public void testDeleteDatasetAfterOldRename() throws Exception {
        this.testDeleteDatasetAfterRename(true);
    }

    @Test
    public void testDeleteDatasetAfterRename() throws Exception {
        this.testDeleteDatasetAfterRename(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDeepRenameInTheSameDataset(boolean oldRename) throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path projects = new Path("/projects");
            Path project = new Path(projects, "project");
            Path dataset = new Path(project, "dataset");
            Path folder0 = new Path(dataset, "folder0");
            Path folder1 = new Path(folder0, "folder1");
            Path file = new Path(folder1, "file");
            Path newFolder = new Path(dataset, "newFolder");
            dfs.mkdirs(folder1, FsPermission.getDefault());
            dfs.setMetaStatus(dataset, MetaStatus.META_ENABLED);
            HdfsDataOutputStream out = TestFileCreation.create(dfs, file, 1);
            out.close();
            long inodeId = TestUtil.getINodeId(cluster.getNameNode(), file);
            long folder0Id = TestUtil.getINodeId(cluster.getNameNode(), folder0);
            long folder1Id = TestUtil.getINodeId(cluster.getNameNode(), folder1);
            long datasetId = TestUtil.getINodeId(cluster.getNameNode(), dataset);
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, datasetId, (MetadataLogEntry.OperationBase)INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder0Id, (MetadataLogEntry.OperationBase)INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder1Id, (MetadataLogEntry.OperationBase)INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(inodeId, INodeMetadataLogEntry.Operation.Add));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset, folder0, folder1, file}, new int[]{1, 1, 1, 1});
            if (oldRename) {
                dfs.rename(folder0, newFolder);
            } else {
                dfs.rename(folder0, newFolder, new Options.Rename[]{Options.Rename.NONE});
            }
            long newFolderId = TestUtil.getINodeId(cluster.getNameNode(), newFolder);
            TestMetadataLog.assertEquals((long)folder0Id, (long)newFolderId);
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder0Id, newFolder.getName(), (MetadataLogEntry.OperationBase)INodeMetadataLogEntry.Operation.Rename));
            TestMetadataLog.assertEquals((String)"Subfolders and files shouldn't be logged during a rename in the same dataset", (int)1, (int)this.getMetadataLogEntries(folder1Id).size());
            TestMetadataLog.assertEquals((String)"Subfolders and files shouldn't be logged during a rename in the same dataset", (int)1, (int)this.getMetadataLogEntries(inodeId).size());
            this.checkLogicalTimeAddRename(folder0Id);
            Path newFolder1 = new Path(newFolder, folder1.getName());
            Path newFile = new Path(newFolder1, file.getName());
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset, newFolder, newFolder1, newFile}, new int[]{1, 2, 1, 1});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDeepRenameToNonMetaEnabledDir(boolean oldRename) throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path projects = new Path("/projects");
            Path project = new Path(projects, "project");
            Path dataset = new Path(project, "dataset");
            Path folder0 = new Path(dataset, "folder0");
            Path folder1 = new Path(folder0, "folder1");
            Path file = new Path(folder1, "file");
            Path newFolder = new Path(project, "newFolder");
            dfs.mkdirs(folder1, FsPermission.getDefault());
            dfs.setMetaStatus(dataset, MetaStatus.META_ENABLED);
            HdfsDataOutputStream out = TestFileCreation.create(dfs, file, 1);
            out.close();
            long inodeId = TestUtil.getINodeId(cluster.getNameNode(), file);
            long folder0Id = TestUtil.getINodeId(cluster.getNameNode(), folder0);
            long folder1Id = TestUtil.getINodeId(cluster.getNameNode(), folder1);
            long datasetId = TestUtil.getINodeId(cluster.getNameNode(), dataset);
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, datasetId, (MetadataLogEntry.OperationBase)INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder0Id, (MetadataLogEntry.OperationBase)INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder1Id, (MetadataLogEntry.OperationBase)INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(inodeId, INodeMetadataLogEntry.Operation.Add));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset, folder0, folder1, file}, new int[]{1, 1, 1, 1});
            if (oldRename) {
                dfs.rename(folder0, newFolder);
            } else {
                dfs.rename(folder0, newFolder, new Options.Rename[]{Options.Rename.NONE});
            }
            long newFolderId = TestUtil.getINodeId(cluster.getNameNode(), newFolder);
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder0Id, (MetadataLogEntry.OperationBase)INodeMetadataLogEntry.Operation.Delete));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder1Id, (MetadataLogEntry.OperationBase)INodeMetadataLogEntry.Operation.Delete));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, inodeId, (MetadataLogEntry.OperationBase)INodeMetadataLogEntry.Operation.Delete));
            TestMetadataLog.assertFalse((boolean)this.checkLog(datasetId, newFolderId, newFolder.getName(), (MetadataLogEntry.OperationBase)INodeMetadataLogEntry.Operation.Delete));
            TestMetadataLog.assertEquals((String)"Subfolders and files shouldn't be logged for addition during a move to a non MetaEnabled directoy", (int)2, (int)this.getMetadataLogEntries(folder1Id).size());
            TestMetadataLog.assertEquals((String)"Subfolders and files shouldn't be logged for addition during a move to a non MetaEnabled directoy", (int)2, (int)this.getMetadataLogEntries(inodeId).size());
            this.checkLogicalTimeDeleteAfterAdd(new long[]{folder0Id, folder1Id, inodeId});
            Path newFolder1 = new Path(newFolder, folder1.getName());
            Path newFile = new Path(newFolder1, file.getName());
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset, newFolder, newFolder1, newFile}, new int[]{1, 2, 2, 2});
            if (oldRename) {
                dfs.rename(newFolder, folder0);
            } else {
                dfs.rename(newFolder, folder0, new Options.Rename[]{Options.Rename.NONE});
            }
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder0Id, (MetadataLogEntry.OperationBase)INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder1Id, (MetadataLogEntry.OperationBase)INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(inodeId, INodeMetadataLogEntry.Operation.Add));
            this.checkLogicalTimeAddDeleteAdd(folder0Id);
            this.checkLogicalTimeAddDeleteAdd(folder1Id);
            this.checkLogicalTimeAddDeleteAdd(inodeId);
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset, folder0, folder1, file}, new int[]{1, 3, 3, 3});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDeleteDatasetAfterRename(boolean oldRename) throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path dataset = new Path("/dataset");
            Path folder1 = new Path(dataset, "folder1");
            Path folder2 = new Path(folder1, "folder2");
            Path folder3 = new Path(folder2, "folder3");
            dfs.mkdirs(folder3, FsPermission.getDefault());
            dfs.setMetaStatus(dataset, MetaStatus.META_ENABLED);
            long datasetId = TestUtil.getINodeId(cluster.getNameNode(), dataset);
            long folder1Id = TestUtil.getINodeId(cluster.getNameNode(), folder1);
            long folder2Id = TestUtil.getINodeId(cluster.getNameNode(), folder2);
            long folder3Id = TestUtil.getINodeId(cluster.getNameNode(), folder3);
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, datasetId, (MetadataLogEntry.OperationBase)INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder1Id, (MetadataLogEntry.OperationBase)INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder2Id, (MetadataLogEntry.OperationBase)INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder3Id, (MetadataLogEntry.OperationBase)INodeMetadataLogEntry.Operation.Add));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset, folder1, folder2, folder3}, new int[]{1, 1, 1, 1});
            Path file1 = new Path(folder3, "file1");
            TestFileCreation.create(dfs, file1, 1).close();
            Path file2 = new Path(folder3, "file2");
            TestFileCreation.create(dfs, file2, 1).close();
            long file1Id = TestUtil.getINodeId(cluster.getNameNode(), file1);
            long file2Id = TestUtil.getINodeId(cluster.getNameNode(), file2);
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, file1Id, (MetadataLogEntry.OperationBase)INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, file2Id, (MetadataLogEntry.OperationBase)INodeMetadataLogEntry.Operation.Add));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset, folder1, folder2, folder3, file1, file2}, new int[]{1, 1, 1, 1, 1, 1});
            Path newDataset = new Path("/newDataset");
            if (oldRename) {
                dfs.rename(dataset, newDataset);
            } else {
                dfs.rename(dataset, newDataset, new Options.Rename[]{Options.Rename.NONE});
            }
            long newDatasetId = TestUtil.getINodeId(cluster.getNameNode(), newDataset);
            TestMetadataLog.assertTrue((newDatasetId == datasetId ? 1 : 0) != 0);
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, datasetId, newDataset.getName(), (MetadataLogEntry.OperationBase)INodeMetadataLogEntry.Operation.Rename));
            TestMetadataLog.assertFalse((boolean)this.checkLog(datasetId, folder1Id, (MetadataLogEntry.OperationBase)INodeMetadataLogEntry.Operation.Delete));
            TestMetadataLog.assertFalse((boolean)this.checkLog(datasetId, folder2Id, (MetadataLogEntry.OperationBase)INodeMetadataLogEntry.Operation.Delete));
            TestMetadataLog.assertFalse((boolean)this.checkLog(datasetId, folder3Id, (MetadataLogEntry.OperationBase)INodeMetadataLogEntry.Operation.Delete));
            TestMetadataLog.assertFalse((boolean)this.checkLog(datasetId, file1Id, (MetadataLogEntry.OperationBase)INodeMetadataLogEntry.Operation.Delete));
            TestMetadataLog.assertFalse((boolean)this.checkLog(datasetId, file2Id, (MetadataLogEntry.OperationBase)INodeMetadataLogEntry.Operation.Delete));
            Path newFolder1 = new Path(newDataset, folder1.getName());
            Path newFolder2 = new Path(newFolder1, folder2.getName());
            Path newFolder3 = new Path(newFolder2, folder3.getName());
            Path newFile1 = new Path(newFolder3, file1.getName());
            Path newFile2 = new Path(newFolder3, file2.getName());
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{newDataset, newFolder1, newFolder2, newFolder3, newFile1, newFile2}, new int[]{2, 1, 1, 1, 1, 1});
            TestMetadataLog.assertTrue((boolean)dfs.delete(newDataset, true));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, datasetId, newDataset.getName(), (MetadataLogEntry.OperationBase)INodeMetadataLogEntry.Operation.Delete));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder1Id, (MetadataLogEntry.OperationBase)INodeMetadataLogEntry.Operation.Delete));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder2Id, (MetadataLogEntry.OperationBase)INodeMetadataLogEntry.Operation.Delete));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder3Id, (MetadataLogEntry.OperationBase)INodeMetadataLogEntry.Operation.Delete));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, file1Id, (MetadataLogEntry.OperationBase)INodeMetadataLogEntry.Operation.Delete));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, file2Id, (MetadataLogEntry.OperationBase)INodeMetadataLogEntry.Operation.Delete));
            this.checkLogicalTimeDeleteAfterAdd(new long[]{folder1Id, folder2Id, folder3Id, file1Id, file2Id});
            this.checkLogicalTimeAddRenameDelete(datasetId);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSettingAndUnsettingMetaEnabled() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path projects = new Path("/projects");
            Path project = new Path(projects, "project");
            Path dataset = new Path(project, "dataset");
            Path folder = new Path(dataset, "folder");
            Path file = new Path(folder, "file");
            dfs.mkdirs(folder, FsPermission.getDefault());
            HdfsDataOutputStream out = TestFileCreation.create(dfs, file, 1);
            out.close();
            dfs.setMetaStatus(dataset, MetaStatus.META_ENABLED);
            long inodeId = TestUtil.getINodeId(cluster.getNameNode(), file);
            long folderId = TestUtil.getINodeId(cluster.getNameNode(), folder);
            long datasetId = TestUtil.getINodeId(cluster.getNameNode(), dataset);
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(folderId, INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(inodeId, INodeMetadataLogEntry.Operation.Add));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset, folder, file}, new int[]{1, 1, 1});
            dfs.setMetaStatus(dataset, MetaStatus.DISABLED);
            TestMetadataLog.assertEquals((int)1, (int)this.getMetadataLogEntries(inodeId).size());
            TestMetadataLog.assertEquals((int)1, (int)this.getMetadataLogEntries(folderId).size());
            TestMetadataLog.assertEquals((int)1, (int)this.getMetadataLogEntries(datasetId).size());
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset, folder, file}, new int[]{1, 1, 1});
            dfs.setMetaStatus(dataset, MetaStatus.META_ENABLED);
            TestMetadataLog.assertEquals((int)2, (int)this.getMetadataLogEntries(inodeId).size());
            TestMetadataLog.assertEquals((int)2, (int)this.getMetadataLogEntries(folderId).size());
            TestMetadataLog.assertEquals((int)2, (int)this.getMetadataLogEntries(datasetId).size());
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{dataset, folder, file}, new int[]{2, 2, 2});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private void checkLogicalTimeDeleteAfterAdd(long[] inodesIds) throws IOException {
        for (long inodeId : inodesIds) {
            ArrayList<MetadataLogEntry> inodeLogEntries = new ArrayList<MetadataLogEntry>(this.getMetadataLogEntries(inodeId));
            Collections.sort(inodeLogEntries, LOGICAL_TIME_COMPARATOR);
            TestMetadataLog.assertTrue((inodeLogEntries.size() == 2 ? 1 : 0) != 0);
            TestMetadataLog.assertTrue((((MetadataLogEntry)inodeLogEntries.get(0)).getOperationId() == INodeMetadataLogEntry.Operation.Add.getId() ? 1 : 0) != 0);
            TestMetadataLog.assertTrue((((MetadataLogEntry)inodeLogEntries.get(1)).getOperationId() == INodeMetadataLogEntry.Operation.Delete.getId() ? 1 : 0) != 0);
        }
    }

    private void checkLogicalTimeAddDeleteAdd(long inodeId) throws IOException {
        ArrayList<MetadataLogEntry> inodeLogEntries = new ArrayList<MetadataLogEntry>(this.getMetadataLogEntries(inodeId));
        Collections.sort(inodeLogEntries, LOGICAL_TIME_COMPARATOR);
        TestMetadataLog.assertTrue((inodeLogEntries.size() == 3 ? 1 : 0) != 0);
        TestMetadataLog.assertTrue((((MetadataLogEntry)inodeLogEntries.get(0)).getOperationId() == INodeMetadataLogEntry.Operation.Add.getId() ? 1 : 0) != 0);
        TestMetadataLog.assertTrue((((MetadataLogEntry)inodeLogEntries.get(1)).getOperationId() == INodeMetadataLogEntry.Operation.Delete.getId() ? 1 : 0) != 0);
        TestMetadataLog.assertTrue((((MetadataLogEntry)inodeLogEntries.get(2)).getOperationId() == INodeMetadataLogEntry.Operation.Add.getId() ? 1 : 0) != 0);
    }

    private void checkLogicalTimeAddRenameDelete(long inodeId) throws IOException {
        ArrayList<MetadataLogEntry> inodeLogEntries = new ArrayList<MetadataLogEntry>(this.getMetadataLogEntries(inodeId));
        Collections.sort(inodeLogEntries, LOGICAL_TIME_COMPARATOR);
        TestMetadataLog.assertTrue((inodeLogEntries.size() == 3 ? 1 : 0) != 0);
        TestMetadataLog.assertTrue((((MetadataLogEntry)inodeLogEntries.get(0)).getOperationId() == INodeMetadataLogEntry.Operation.Add.getId() ? 1 : 0) != 0);
        TestMetadataLog.assertTrue((((MetadataLogEntry)inodeLogEntries.get(1)).getOperationId() == INodeMetadataLogEntry.Operation.Rename.getId() ? 1 : 0) != 0);
        TestMetadataLog.assertTrue((((MetadataLogEntry)inodeLogEntries.get(2)).getOperationId() == INodeMetadataLogEntry.Operation.Delete.getId() ? 1 : 0) != 0);
    }

    private void checkLogicalTimeAddRename(long inodeId) throws IOException {
        ArrayList<MetadataLogEntry> inodeLogEntries = new ArrayList<MetadataLogEntry>(this.getMetadataLogEntries(inodeId));
        Collections.sort(inodeLogEntries, LOGICAL_TIME_COMPARATOR);
        TestMetadataLog.assertTrue((inodeLogEntries.size() == 2 ? 1 : 0) != 0);
        TestMetadataLog.assertTrue((((MetadataLogEntry)inodeLogEntries.get(0)).getOperationId() == INodeMetadataLogEntry.Operation.Add.getId() ? 1 : 0) != 0);
        TestMetadataLog.assertTrue((((MetadataLogEntry)inodeLogEntries.get(1)).getOperationId() == INodeMetadataLogEntry.Operation.Rename.getId() ? 1 : 0) != 0);
    }

    private void checkLogicalTimeAddRChangeDataset(long inodeId) throws IOException {
        ArrayList<MetadataLogEntry> inodeLogEntries = new ArrayList<MetadataLogEntry>(this.getMetadataLogEntries(inodeId));
        Collections.sort(inodeLogEntries, LOGICAL_TIME_COMPARATOR);
        TestMetadataLog.assertTrue((inodeLogEntries.size() == 2 ? 1 : 0) != 0);
        TestMetadataLog.assertTrue((((MetadataLogEntry)inodeLogEntries.get(0)).getOperationId() == INodeMetadataLogEntry.Operation.Add.getId() ? 1 : 0) != 0);
        TestMetadataLog.assertTrue((((MetadataLogEntry)inodeLogEntries.get(1)).getOperationId() == INodeMetadataLogEntry.Operation.ChangeDataset.getId() ? 1 : 0) != 0);
    }

    private void checkLogicalTimeForINodes(NameNode nameNode, Path[] inodesPaths, int[] logicalTimes) throws IOException {
        int i = 0;
        for (Path path : inodesPaths) {
            TestMetadataLog.assertEquals((int)logicalTimes[i], (int)TestUtil.getINode(nameNode, path).getLogicalTime());
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testXAttrNonLogginFolder() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.namenode.xattrs.enabled", true);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        String name1 = "user.metadata";
        byte[] value1 = "this file metadata".getBytes(Charsets.UTF_8);
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path dir = new Path("/dir");
            dfs.mkdirs(dir);
            Path file = new Path(dir, "file");
            DFSTestUtil.createFile((FileSystem)dfs, file, 0L, (short)1, 0L);
            long inodeId = TestUtil.getINodeId(cluster.getNameNode(), file);
            long datasetId = TestUtil.getINodeId(cluster.getNameNode(), dir);
            TestMetadataLog.assertTrue((boolean)this.getMetadataLogEntries(inodeId).isEmpty());
            dfs.setXAttr(file, "user.metadata", value1);
            TestMetadataLog.assertTrue((boolean)this.getMetadataLogEntries(inodeId).isEmpty());
            dfs.setMetaStatus(dir, MetaStatus.META_ENABLED);
            TestMetadataLog.assertEquals((int)2, (int)this.getMetadataLogEntries(inodeId).size());
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, inodeId, (MetadataLogEntry.OperationBase)XAttrMetadataLogEntry.Operation.AddAll));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, inodeId, (MetadataLogEntry.OperationBase)INodeMetadataLogEntry.Operation.Add));
            dfs.delete(file, true);
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, inodeId, (MetadataLogEntry.OperationBase)INodeMetadataLogEntry.Operation.Delete));
            this.checkIfNoXAttrsForINode(inodeId);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testXAttrOnMetaEnabledDir() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.namenode.xattrs.enabled", true);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        String name1 = "user.metadata";
        byte[] value1 = "this file metadata".getBytes(Charsets.UTF_8);
        String name2 = "user.path";
        byte[] value2 = "/this/is/my/test/path/".getBytes(Charsets.UTF_8);
        byte[] value3 = "/replace/the/old/path".getBytes(Charsets.UTF_8);
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path dir = new Path("/dir");
            dfs.mkdirs(dir);
            dfs.setMetaStatus(dir, MetaStatus.META_ENABLED);
            Path file = new Path(dir, "file");
            DFSTestUtil.createFile((FileSystem)dfs, file, 0L, (short)1, 0L);
            long inodeId = TestUtil.getINodeId(cluster.getNameNode(), file);
            long datasetId = TestUtil.getINodeId(cluster.getNameNode(), dir);
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{file, dir}, new int[]{1, 1});
            dfs.setXAttr(file, "user.metadata", value1);
            TestMetadataLog.assertTrue((boolean)Arrays.equals(value1, dfs.getXAttr(file, "user.metadata")));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, inodeId, XAttrHelper.buildXAttr((String)"user.metadata").getName(), (MetadataLogEntry.OperationBase)XAttrMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertEquals((int)2, (int)this.getMetadataLogEntries(inodeId).size());
            dfs.setXAttr(file, "user.path", value2);
            TestMetadataLog.assertTrue((boolean)Arrays.equals(value2, dfs.getXAttr(file, "user.path")));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, inodeId, XAttrHelper.buildXAttr((String)"user.path").getName(), (MetadataLogEntry.OperationBase)XAttrMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertEquals((int)3, (int)this.getMetadataLogEntries(inodeId).size());
            TestMetadataLog.assertEquals((int)3, (int)TestUtil.getINode(cluster.getNameNode(), file).getLogicalTime());
            dfs.removeXAttr(file, "user.metadata");
            this.checkXAttrLogicalTimeAddDelete(inodeId, XAttrHelper.buildXAttr((String)"user.metadata").getName());
            TestMetadataLog.assertEquals((int)4, (int)TestUtil.getINode(cluster.getNameNode(), file).getLogicalTime());
            dfs.setXAttr(file, "user.path", value3);
            TestMetadataLog.assertTrue((boolean)Arrays.equals(value3, dfs.getXAttr(file, "user.path")));
            TestMetadataLog.assertEquals((int)5, (int)TestUtil.getINode(cluster.getNameNode(), file).getLogicalTime());
            dfs.removeXAttr(file, "user.path");
            this.checkXAttrLogicalTimeAddUpdateDelete(inodeId, XAttrHelper.buildXAttr((String)"user.path").getName());
            TestMetadataLog.assertEquals((int)6, (int)TestUtil.getINode(cluster.getNameNode(), file).getLogicalTime());
            dfs.setXAttr(dir, "user.metadata", value1);
            TestMetadataLog.assertTrue((boolean)Arrays.equals(value1, dfs.getXAttr(dir, "user.metadata")));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{file, dir}, new int[]{6, 2});
            dfs.setXAttr(dir, "user.metadata", value2);
            TestMetadataLog.assertTrue((boolean)Arrays.equals(value2, dfs.getXAttr(dir, "user.metadata")));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{file, dir}, new int[]{6, 3});
            dfs.setXAttr(dir, "user.path", value3);
            TestMetadataLog.assertTrue((boolean)Arrays.equals(value3, dfs.getXAttr(dir, "user.path")));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{file, dir}, new int[]{6, 4});
            dfs.removeXAttr(dir, "user.metadata");
            this.checkXAttrLogicalTimeAddUpdateDelete(datasetId, XAttrHelper.buildXAttr((String)"user.metadata").getName());
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{file, dir}, new int[]{6, 5});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private void checkXAttrLogicalTimeAddDelete(long inodeId, final String name) throws IOException {
        ArrayList<MetadataLogEntry> allEntries = new ArrayList<MetadataLogEntry>(this.getMetadataLogEntries(inodeId));
        Collection filtered = Collections2.filter(allEntries, (Predicate)new Predicate<MetadataLogEntry>(){

            public boolean apply(@Nullable MetadataLogEntry logEntry) {
                if (logEntry instanceof XAttrMetadataLogEntry) {
                    return ((XAttrMetadataLogEntry)logEntry).getName().equals(name);
                }
                return false;
            }
        });
        ArrayList xAttrLogEntries = new ArrayList(filtered);
        Collections.sort(xAttrLogEntries, LOGICAL_TIME_COMPARATOR);
        TestMetadataLog.assertTrue((xAttrLogEntries.size() == 2 ? 1 : 0) != 0);
        TestMetadataLog.assertTrue((((MetadataLogEntry)xAttrLogEntries.get(0)).getOperationId() == XAttrMetadataLogEntry.Operation.Add.getId() ? 1 : 0) != 0);
        TestMetadataLog.assertTrue((((MetadataLogEntry)xAttrLogEntries.get(1)).getOperationId() == XAttrMetadataLogEntry.Operation.Delete.getId() ? 1 : 0) != 0);
    }

    private void checkXAttrLogicalTimeAddUpdateDelete(long inodeId, final String name) throws IOException {
        ArrayList<MetadataLogEntry> allEntries = new ArrayList<MetadataLogEntry>(this.getMetadataLogEntries(inodeId));
        Collection filtered = Collections2.filter(allEntries, (Predicate)new Predicate<MetadataLogEntry>(){

            public boolean apply(@Nullable MetadataLogEntry logEntry) {
                if (logEntry instanceof XAttrMetadataLogEntry) {
                    return ((XAttrMetadataLogEntry)logEntry).getName().equals(name);
                }
                return false;
            }
        });
        ArrayList xAttrLogEntries = new ArrayList(filtered);
        Collections.sort(xAttrLogEntries, LOGICAL_TIME_COMPARATOR);
        TestMetadataLog.assertTrue((xAttrLogEntries.size() == 3 ? 1 : 0) != 0);
        TestMetadataLog.assertTrue((((MetadataLogEntry)xAttrLogEntries.get(0)).getOperationId() == XAttrMetadataLogEntry.Operation.Add.getId() ? 1 : 0) != 0);
        TestMetadataLog.assertTrue((((MetadataLogEntry)xAttrLogEntries.get(1)).getOperationId() == XAttrMetadataLogEntry.Operation.Update.getId() ? 1 : 0) != 0);
        TestMetadataLog.assertTrue((((MetadataLogEntry)xAttrLogEntries.get(2)).getOperationId() == XAttrMetadataLogEntry.Operation.Delete.getId() ? 1 : 0) != 0);
    }

    private boolean checkIfNoXAttrsForINode(final long inodeId) throws IOException {
        return (Boolean)new LightWeightRequestHandler((RequestHandler.OperationType)HDFSOperationType.TEST){

            public Object performTask() throws IOException {
                XAttrDataAccess da = (XAttrDataAccess)HdfsStorageFactory.getDataAccess(XAttrDataAccess.class);
                return da.getXAttrsByInodeId(inodeId) == null;
            }
        }.handle();
    }

    @Test
    public void testRenameDataset() throws Exception {
        this.testRenameDataset(false);
    }

    @Test
    public void testOldRenameDataset() throws Exception {
        this.testRenameDataset(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testRenameDataset(boolean oldRename) throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path projects = new Path("/projects");
            Path project = new Path(projects, "project");
            Path dataset = new Path(project, "dataset");
            Path folder0 = new Path(dataset, "folder0");
            Path folder1 = new Path(folder0, "folder1");
            Path file = new Path(folder1, "file");
            Path newDataset = new Path(project, "newDataset");
            dfs.mkdirs(folder1, FsPermission.getDefault());
            dfs.setMetaStatus(dataset, MetaStatus.META_ENABLED);
            HdfsDataOutputStream out = TestFileCreation.create(dfs, file, 1);
            out.close();
            long inodeId = TestUtil.getINodeId(cluster.getNameNode(), file);
            long folder0Id = TestUtil.getINodeId(cluster.getNameNode(), folder0);
            long folder1Id = TestUtil.getINodeId(cluster.getNameNode(), folder1);
            long datasetId = TestUtil.getINodeId(cluster.getNameNode(), dataset);
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder0Id, (MetadataLogEntry.OperationBase)INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, folder1Id, (MetadataLogEntry.OperationBase)INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertTrue((boolean)this.checkLog(inodeId, INodeMetadataLogEntry.Operation.Add));
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{projects, project, dataset, folder0, folder1, file}, new int[]{0, 0, 1, 1, 1, 1});
            if (oldRename) {
                dfs.rename(dataset, newDataset);
            } else {
                dfs.rename(dataset, newDataset, new Options.Rename[]{Options.Rename.NONE});
            }
            long newDatasetId = TestUtil.getINodeId(cluster.getNameNode(), newDataset);
            TestMetadataLog.assertEquals((long)datasetId, (long)newDatasetId);
            TestMetadataLog.assertTrue((boolean)this.checkLog(datasetId, datasetId, newDataset.getName(), (MetadataLogEntry.OperationBase)INodeMetadataLogEntry.Operation.Rename));
            TestMetadataLog.assertEquals((String)"Subfolders and files shouldn't be logged during a rename in the same dataset", (int)1, (int)this.getMetadataLogEntries(folder1Id).size());
            TestMetadataLog.assertEquals((String)"Subfolders and files shouldn't be logged during a rename in the same dataset", (int)1, (int)this.getMetadataLogEntries(folder0Id).size());
            TestMetadataLog.assertEquals((String)"Subfolders and files shouldn't be logged during a rename in the same dataset", (int)1, (int)this.getMetadataLogEntries(inodeId).size());
            Path newFolder0 = new Path(newDataset, folder0.getName());
            Path newFolder1 = new Path(newFolder0, folder1.getName());
            Path newFile = new Path(newFolder1, file.getName());
            this.checkLogicalTimeForINodes(cluster.getNameNode(), new Path[]{newDataset, newFolder0, newFolder1, newFile}, new int[]{2, 1, 1, 1});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetMetaEnabledOnNonExistingDirectory() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path root = new Path("/");
            Path dir = new Path(root, "dir");
            try {
                dfs.setMetaStatus(dir, MetaStatus.META_ENABLED);
                TestMetadataLog.fail((String)"should fail to set metaEnabled on non existing directory");
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            dfs.mkdirs(dir, FsPermission.getDefault());
            TestMetadataLog.assertFalse((boolean)this.checkLog(TestUtil.getINodeId(cluster.getNameNode(), dir), INodeMetadataLogEntry.Operation.Add));
            dfs.setMetaStatus(dir, MetaStatus.META_ENABLED);
            TestMetadataLog.assertTrue((boolean)this.checkLog(TestUtil.getINodeId(cluster.getNameNode(), dir), INodeMetadataLogEntry.Operation.Add));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetMetaEnabledOnRoot() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path root = new Path("/");
            Path dir = new Path(root, "dir");
            dfs.mkdirs(dir, FsPermission.getDefault());
            try {
                dfs.setMetaStatus(root, MetaStatus.META_ENABLED);
                TestMetadataLog.fail((String)"should fail to set metaEnabled on the root since subtree locks are disabled for the root");
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            TestMetadataLog.assertFalse((boolean)this.checkLog(TestUtil.getINodeId(cluster.getNameNode(), dir), INodeMetadataLogEntry.Operation.Add));
            TestMetadataLog.assertFalse((boolean)this.checkLog(TestUtil.getINodeId(cluster.getNameNode(), root), INodeMetadataLogEntry.Operation.Add));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

