/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.INodeLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.EnumSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.io.EnumSetWritable;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class TestAddBlockRetry {
    public static final Log LOG = LogFactory.getLog(TestAddBlockRetry.class);
    private static final short REPLICATION = 3;
    private Configuration conf;
    private MiniDFSCluster cluster;

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).build();
        this.cluster.waitActive();
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Ignore
    public void testRetryAddBlockWhileInChooseTarget() throws Exception {
        String src = "/testRetryAddBlockWhileInChooseTarget";
        final FSNamesystem ns = this.cluster.getNamesystem();
        final NamenodeProtocols nn = this.cluster.getNameNodeRpc();
        nn.create("/testRetryAddBlockWhileInChooseTarget", FsPermission.getFileDefault(), "clientName", new EnumSetWritable(EnumSet.of(CreateFlag.CREATE)), true, (short)3, 1024L, null);
        LOG.info((Object)"Starting first addBlock for /testRetryAddBlockWhileInChooseTarget");
        final LocatedBlock[] onRetryBlock = new LocatedBlock[1];
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath((String)"/testRetryAddBlockWhileInChooseTarget");
        new HopsTransactionalRequestHandler(HDFSOperationType.GET_ADDITIONAL_BLOCK, "/testRetryAddBlockWhileInChooseTarget"){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, new String[]{"/testRetryAddBlockWhileInChooseTarget"});
                locks.add((Lock)il).add(lf.getLastTwoBlocksLock("/testRetryAddBlockWhileInChooseTarget"));
                locks.add(lf.getLeaseLock(TransactionLockTypes.LockType.READ, "clientName")).add(lf.getLeasePathLock(TransactionLockTypes.LockType.READ_COMMITTED)).add(lf.getBlockRelated(new LockFactory.BLK[]{LockFactory.BLK.RE, LockFactory.BLK.CR, LockFactory.BLK.ER, LockFactory.BLK.UC}));
            }

            public Object performTask() throws IOException {
                DatanodeStorageInfo[] targets = ns.getNewBlockTargets("/testRetryAddBlockWhileInChooseTarget", 0L, "clientName", null, null, null, onRetryBlock);
                Assert.assertNotNull((String)"Targets must be generated", (Object)targets);
                LOG.info((Object)"Starting second addBlock for /testRetryAddBlockWhileInChooseTarget");
                nn.addBlock("/testRetryAddBlockWhileInChooseTarget", "clientName", null, null, 0L, null);
                Assert.assertTrue((String)"Penultimate block must be complete", (boolean)TestAddBlockRetry.this.checkFileProgress("/testRetryAddBlockWhileInChooseTarget", false));
                LocatedBlocks lbs = nn.getBlockLocations("/testRetryAddBlockWhileInChooseTarget", 0L, Long.MAX_VALUE);
                Assert.assertEquals((String)"Must be one block", (long)1L, (long)lbs.getLocatedBlocks().size());
                LocatedBlock lb2 = lbs.get(0);
                Assert.assertEquals((String)"Wrong replication", (long)3L, (long)lb2.getLocations().length);
                LocatedBlock newBlock = ns.storeAllocatedBlock("/testRetryAddBlockWhileInChooseTarget", 0L, "clientName", null, targets);
                Assert.assertEquals((String)"Blocks are not equal", (Object)lb2.getBlock(), (Object)newBlock.getBlock());
                lbs = nn.getBlockLocations("/testRetryAddBlockWhileInChooseTarget", 0L, Long.MAX_VALUE);
                Assert.assertEquals((String)"Must be one block", (long)1L, (long)lbs.getLocatedBlocks().size());
                LocatedBlock lb1 = lbs.get(0);
                Assert.assertEquals((String)"Wrong replication", (long)3L, (long)lb1.getLocations().length);
                Assert.assertEquals((String)"Blocks are not equal", (Object)lb1.getBlock(), (Object)lb2.getBlock());
                return null;
            }
        }.handle();
    }

    boolean checkFileProgress(String src, boolean checkall) throws IOException {
        FSNamesystem ns = this.cluster.getNamesystem();
        return ns.checkFileProgress(src, ns.dir.getINode(src).asFile(), checkall);
    }

    @Test
    public void testAddBlockRetryShouldReturnBlockWithLocations() throws Exception {
        String src = "/testAddBlockRetryShouldReturnBlockWithLocations";
        NamenodeProtocols nameNodeRpc = this.cluster.getNameNodeRpc();
        nameNodeRpc.create("/testAddBlockRetryShouldReturnBlockWithLocations", FsPermission.getFileDefault(), "clientName", new EnumSetWritable(EnumSet.of(CreateFlag.CREATE)), true, (short)3, 1024L, null);
        LOG.info((Object)"Starting first addBlock for /testAddBlockRetryShouldReturnBlockWithLocations");
        LocatedBlock lb1 = nameNodeRpc.addBlock("/testAddBlockRetryShouldReturnBlockWithLocations", "clientName", null, null, 0L, null);
        Assert.assertTrue((String)"Block locations should be present", (lb1.getLocations().length > 0 ? 1 : 0) != 0);
        this.cluster.restartNameNode(new String[0]);
        nameNodeRpc = this.cluster.getNameNodeRpc();
        LocatedBlock lb2 = nameNodeRpc.addBlock("/testAddBlockRetryShouldReturnBlockWithLocations", "clientName", null, null, 0L, null);
        Assert.assertEquals((String)"Blocks are not equal", (Object)lb1.getBlock(), (Object)lb2.getBlock());
        Assert.assertTrue((String)"Wrong locations with retry", (lb2.getLocations().length > 0 ? 1 : 0) != 0);
    }
}

