/*
 * Decompiled with CFR 0.152.
 */
package io.hops.erasure_coding;

import io.hops.DalDriver;
import io.hops.DalStorageFactory;
import io.hops.exception.StorageException;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.common.CounterType;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.dal.EncodingStatusDataAccess;
import io.hops.metadata.hdfs.entity.EncodingPolicy;
import io.hops.metadata.hdfs.entity.EncodingStatus;
import io.hops.transaction.EntityManager;
import io.hops.transaction.handler.EncodingStatusOperationType;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.handler.RequestHandler;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.junit.Test;

public class TestEncodingStatus
extends TestCase {
    @Test
    public void testAddAndFindEncodingStatus() throws IOException {
        EncodingPolicy policy = new EncodingPolicy("codec", 1);
        final EncodingStatus statusToAdd = new EncodingStatus(Integer.valueOf(1), EncodingStatus.Status.ENCODING_REQUESTED, policy, Long.valueOf(1L));
        HopsTransactionalRequestHandler addReq = new HopsTransactionalRequestHandler(HDFSOperationType.ADD_ENCODING_STATUS){

            public void acquireLock(TransactionLocks locks) throws IOException {
            }

            public Object performTask() throws StorageException, IOException {
                EntityManager.add((Object)statusToAdd);
                return null;
            }
        };
        addReq.handle();
        HopsTransactionalRequestHandler findReq = new HopsTransactionalRequestHandler(HDFSOperationType.FIND_ENCODING_STATUS){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                Integer id = (Integer)this.getParams()[0];
                locks.add(lf.getIndivdualEncodingStatusLock(TransactionLockTypes.LockType.READ_COMMITTED, id.intValue()));
            }

            public Object performTask() throws StorageException, IOException {
                Integer id = (Integer)this.getParams()[0];
                return EntityManager.find((FinderType)EncodingStatus.Finder.ByInodeId, (Object[])new Object[]{id});
            }
        };
        findReq.setParams(new Object[]{statusToAdd.getInodeId()});
        EncodingStatus foundStatus = (EncodingStatus)findReq.handle();
        TestEncodingStatus.assertNotNull((Object)foundStatus);
        TestEncodingStatus.assertEquals((Object)statusToAdd.getInodeId(), (Object)foundStatus.getInodeId());
        TestEncodingStatus.assertEquals((Object)statusToAdd.getStatus(), (Object)foundStatus.getStatus());
        TestEncodingStatus.assertEquals((Object)statusToAdd.getEncodingPolicy(), (Object)foundStatus.getEncodingPolicy());
        TestEncodingStatus.assertEquals((Object)statusToAdd.getStatusModificationTime(), (Object)foundStatus.getStatusModificationTime());
        HopsTransactionalRequestHandler delReq = new HopsTransactionalRequestHandler(HDFSOperationType.DELETE_ENCODING_STATUS){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndivdualEncodingStatusLock(TransactionLockTypes.LockType.WRITE, statusToAdd.getInodeId().intValue()));
            }

            public Object performTask() throws StorageException, IOException {
                EntityManager.remove((Object)statusToAdd);
                return null;
            }
        };
        delReq.handle();
        findReq.setParams(new Object[]{statusToAdd.getInodeId()});
        TestEncodingStatus.assertNull((Object)findReq.handle());
    }

    @Test
    public void testUpdateEncodingStatus() throws IOException {
        EncodingPolicy policy = new EncodingPolicy("codec", 1);
        final EncodingStatus statusToAdd = new EncodingStatus(Integer.valueOf(1), EncodingStatus.Status.ENCODING_REQUESTED, policy, Long.valueOf(1L));
        HopsTransactionalRequestHandler addReq = new HopsTransactionalRequestHandler(HDFSOperationType.ADD_ENCODING_STATUS){

            public void acquireLock(TransactionLocks locks) throws IOException {
            }

            public Object performTask() throws StorageException, IOException {
                EntityManager.add((Object)statusToAdd);
                return null;
            }
        };
        addReq.handle();
        EncodingPolicy policy1 = new EncodingPolicy("codec2", 2);
        final EncodingStatus updatedStatus = new EncodingStatus(Integer.valueOf(1), EncodingStatus.Status.ENCODING_ACTIVE, policy1, Long.valueOf(2L));
        HopsTransactionalRequestHandler updateReq = new HopsTransactionalRequestHandler(HDFSOperationType.UPDATE_ENCODING_STATUS){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                Integer id = (Integer)this.getParams()[0];
                locks.add(lf.getIndivdualEncodingStatusLock(TransactionLockTypes.LockType.WRITE, id.intValue()));
            }

            public Object performTask() throws StorageException, IOException {
                Integer id = (Integer)this.getParams()[0];
                EntityManager.update((Object)updatedStatus);
                return null;
            }
        };
        updateReq.setParams(new Object[]{updatedStatus.getInodeId()});
        updateReq.handle();
        HopsTransactionalRequestHandler findReq = new HopsTransactionalRequestHandler(HDFSOperationType.FIND_ENCODING_STATUS){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                Integer id = (Integer)this.getParams()[0];
                locks.add(lf.getIndivdualEncodingStatusLock(TransactionLockTypes.LockType.READ_COMMITTED, id.intValue()));
            }

            public Object performTask() throws StorageException, IOException {
                Integer id = (Integer)this.getParams()[0];
                return EntityManager.find((FinderType)EncodingStatus.Finder.ByInodeId, (Object[])new Object[]{id});
            }
        };
        findReq.setParams(new Object[]{statusToAdd.getInodeId()});
        EncodingStatus foundStatus = (EncodingStatus)findReq.handle();
        TestEncodingStatus.assertNotNull((Object)foundStatus);
        TestEncodingStatus.assertEquals((Object)updatedStatus.getInodeId(), (Object)foundStatus.getInodeId());
        TestEncodingStatus.assertEquals((Object)updatedStatus.getStatus(), (Object)foundStatus.getStatus());
        TestEncodingStatus.assertEquals((Object)updatedStatus.getEncodingPolicy(), (Object)foundStatus.getEncodingPolicy());
        TestEncodingStatus.assertEquals((Object)updatedStatus.getStatusModificationTime(), (Object)foundStatus.getStatusModificationTime());
        HopsTransactionalRequestHandler delReq = new HopsTransactionalRequestHandler(HDFSOperationType.DELETE_ENCODING_STATUS){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndivdualEncodingStatusLock(TransactionLockTypes.LockType.WRITE, statusToAdd.getInodeId().intValue()));
            }

            public Object performTask() throws StorageException, IOException {
                EntityManager.remove((Object)statusToAdd);
                return null;
            }
        };
        delReq.handle();
        findReq.setParams(new Object[]{statusToAdd.getInodeId()});
        TestEncodingStatus.assertNull((Object)findReq.handle());
    }

    @Test
    public void testCountEncodingRequested() throws IOException {
        EncodingPolicy policy = new EncodingPolicy("codec", 1);
        final ArrayList<EncodingStatus> statusToAdd = new ArrayList<EncodingStatus>();
        statusToAdd.add(new EncodingStatus(Integer.valueOf(1), EncodingStatus.Status.ENCODING_REQUESTED, policy, Long.valueOf(1L)));
        statusToAdd.add(new EncodingStatus(Integer.valueOf(2), EncodingStatus.Status.ENCODED, policy, Long.valueOf(1L)));
        statusToAdd.add(new EncodingStatus(Integer.valueOf(3), EncodingStatus.Status.REPAIR_ACTIVE, policy, Long.valueOf(1L)));
        statusToAdd.add(new EncodingStatus(Integer.valueOf(4), EncodingStatus.Status.REPAIR_ACTIVE, policy, Long.valueOf(1L)));
        statusToAdd.add(new EncodingStatus(Integer.valueOf(5), EncodingStatus.Status.ENCODING_REQUESTED, policy, Long.valueOf(1L)));
        HopsTransactionalRequestHandler addReq = new HopsTransactionalRequestHandler(HDFSOperationType.ADD_ENCODING_STATUS){

            public void acquireLock(TransactionLocks locks) throws IOException {
            }

            public Object performTask() throws StorageException, IOException {
                for (EncodingStatus status : statusToAdd) {
                    EntityManager.add((Object)status);
                }
                return null;
            }
        };
        addReq.handle();
        HopsTransactionalRequestHandler countReq = new HopsTransactionalRequestHandler(HDFSOperationType.COUNT_REQUESTED_ENCODINGS){

            public void acquireLock(TransactionLocks locks) throws IOException {
            }

            public Object performTask() throws StorageException, IOException {
                return EntityManager.count((CounterType)EncodingStatus.Counter.RequestedEncodings, (Object[])new Object[0]);
            }
        };
        TestEncodingStatus.assertEquals((int)this.count(statusToAdd, EncodingStatus.Status.ENCODING_REQUESTED), (int)((Integer)countReq.handle()));
        HopsTransactionalRequestHandler delReq = new HopsTransactionalRequestHandler(HDFSOperationType.DELETE_ENCODING_STATUS){

            public void acquireLock(TransactionLocks locks) throws IOException {
            }

            public Object performTask() throws StorageException, IOException {
                for (EncodingStatus status : statusToAdd) {
                    EntityManager.remove((Object)status);
                }
                return null;
            }
        };
        delReq.handle();
    }

    @Test
    public void testFindEncodingRequested() throws IOException {
        EncodingPolicy policy = new EncodingPolicy("codec", 1);
        final ArrayList<EncodingStatus> statusToAdd = new ArrayList<EncodingStatus>();
        statusToAdd.add(new EncodingStatus(Integer.valueOf(1), EncodingStatus.Status.ENCODING_REQUESTED, policy, Long.valueOf(1L)));
        statusToAdd.add(new EncodingStatus(Integer.valueOf(2), EncodingStatus.Status.ENCODED, policy, Long.valueOf(1L)));
        statusToAdd.add(new EncodingStatus(Integer.valueOf(3), EncodingStatus.Status.REPAIR_ACTIVE, policy, Long.valueOf(1L)));
        statusToAdd.add(new EncodingStatus(Integer.valueOf(4), EncodingStatus.Status.REPAIR_ACTIVE, policy, Long.valueOf(1L)));
        statusToAdd.add(new EncodingStatus(Integer.valueOf(5), EncodingStatus.Status.ENCODING_REQUESTED, policy, Long.valueOf(1L)));
        HopsTransactionalRequestHandler addReq = new HopsTransactionalRequestHandler(HDFSOperationType.ADD_ENCODING_STATUS){

            public void acquireLock(TransactionLocks locks) throws IOException {
            }

            public Object performTask() throws StorageException, IOException {
                for (EncodingStatus status : statusToAdd) {
                    EntityManager.add((Object)status);
                }
                return null;
            }
        };
        addReq.handle();
        LightWeightRequestHandler findReq = new LightWeightRequestHandler((RequestHandler.OperationType)EncodingStatusOperationType.FIND_BY_INODE_ID){

            public Object performTask() throws StorageException, IOException {
                EncodingStatusDataAccess dataAccess = (EncodingStatusDataAccess)HdfsStorageFactory.getDataAccess(EncodingStatusDataAccess.class);
                Integer limit = (Integer)this.getParams()[0];
                return dataAccess.findRequestedEncodings(limit.intValue());
            }
        };
        findReq.setParams(new Object[]{100});
        Collection foundStatus = (Collection)findReq.handle();
        TestEncodingStatus.assertEquals((int)this.count(statusToAdd, EncodingStatus.Status.ENCODING_REQUESTED), (int)this.count(foundStatus, EncodingStatus.Status.ENCODING_REQUESTED));
        int limit = 1;
        findReq.setParams(new Object[]{limit});
        foundStatus = (Collection)findReq.handle();
        TestEncodingStatus.assertEquals((int)this.count(foundStatus, EncodingStatus.Status.ENCODING_REQUESTED), (int)limit);
        HopsTransactionalRequestHandler delReq = new HopsTransactionalRequestHandler(HDFSOperationType.DELETE_ENCODING_STATUS){

            public void acquireLock(TransactionLocks locks) throws IOException {
            }

            public Object performTask() throws StorageException, IOException {
                for (EncodingStatus status : statusToAdd) {
                    EntityManager.remove((Object)status);
                }
                return null;
            }
        };
        delReq.handle();
    }

    private int count(Collection<EncodingStatus> collection, EncodingStatus.Status status) {
        int count = 0;
        for (EncodingStatus encodingStatus : collection) {
            if (!encodingStatus.getStatus().equals((Object)status)) continue;
            ++count;
        }
        return count;
    }

    static {
        try {
            DalStorageFactory sf = DalDriver.load((String)"io.hops.metadata.ndb.NdbStorageFactory");
            Properties conf = new Properties();
            conf.load(ClassLoader.getSystemResourceAsStream("ndb-config.properties"));
            sf.setConfiguration(conf);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            HdfsStorageFactory.setConfiguration((Configuration)new Configuration());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

