/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata;

import com.google.common.collect.Lists;
import io.hops.common.CountersQueue;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.HdfsVariables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class TestHdfsVariables {
    private static final int NUM_CONCURRENT_THREADS = 100;

    @Test
    public void testIncrementINodeIdCounter() throws Exception {
        this.testIncrementCounter(CounterType.INodeId, 100);
    }

    @Test
    public void testIncrementBlockIdCounter() throws Exception {
        this.testIncrementCounter(CounterType.BlockId, 100);
    }

    @Test
    public void testIncrementQuotaIdCounter() throws Exception {
        this.testIncrementCounter(CounterType.QuotaId, 100);
    }

    @Test
    public void testIncrementalCounterOverflow() throws Exception {
        block2: {
            try {
                this.testIncrementCounter(CounterType.INodeId, 0x19999999);
                Assert.fail((String)"overflow exception was expected");
            }
            catch (ExecutionException ex) {
                if (ex.getCause().getMessage().equals("overflow")) break block2;
                throw ex;
            }
        }
    }

    void testIncrementCounter(CounterType counterType, int increment) throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        HdfsStorageFactory.setConfiguration((Configuration)conf);
        HdfsStorageFactory.formatStorage();
        ExecutorService executor = Executors.newFixedThreadPool(100);
        ArrayList tasks = Lists.newArrayListWithExpectedSize((int)100);
        for (int i = 0; i < 100; ++i) {
            tasks.add(new CounterIncrementer(counterType, increment));
        }
        List results = executor.invokeAll(tasks);
        executor.shutdown();
        executor.awaitTermination(30L, TimeUnit.SECONDS);
        ArrayList counters = Lists.newArrayListWithExpectedSize((int)results.size());
        for (Future e : results) {
            CountersQueue.Counter counter = (CountersQueue.Counter)e.get();
            Assert.assertTrue((String)"incrementCounter shouldn't return null at any time", (counter != null ? 1 : 0) != 0);
            counters.add(counter);
        }
        Collections.sort(counters, new Comparator<CountersQueue.Counter>(){

            @Override
            public int compare(CountersQueue.Counter o1, CountersQueue.Counter o2) {
                int compare = Long.compare(o1.getStart(), o2.getStart());
                Assert.assertTrue((String)"Counter ranges shouldn't have the same start", (compare != 0 ? 1 : 0) != 0);
                return compare;
            }
        });
        for (int i = 0; i < counters.size() - 1; ++i) {
            CountersQueue.Counter c1 = (CountersQueue.Counter)counters.get(i);
            CountersQueue.Counter c2 = (CountersQueue.Counter)counters.get(i + 1);
            System.out.println(c1);
            Assert.assertEquals((String)"Counters have a range", (long)(c1.getStart() + (long)increment), (long)c1.getEnd());
            long currentVal = 0L;
            while (c1.hasNext()) {
                currentVal = c1.next();
            }
            Assert.assertEquals((String)"Counter increment should be exclude the last element", (long)(c1.getEnd() - 1L), (long)currentVal);
            Assert.assertEquals((String)"Counters should be sequential", (long)c2.getStart(), (long)c1.getEnd());
            Assert.assertEquals((String)"Counters should be incremental", (long)(c1.getStart() + (long)increment), (long)c2.getStart());
        }
    }

    @Test
    public void testCountersQueue() {
        boolean start = false;
        int end = 100000;
        int inc = 1000;
        int incGabs = 3000;
        CountersQueue queue = new CountersQueue();
        int size = 0;
        for (int i = 0; i < 100000; i += 3000) {
            CountersQueue.Counter counter = new CountersQueue.Counter((long)i, (long)(i + 1000));
            System.out.println("add " + counter);
            queue.addCounter(counter);
            size += 1000;
        }
        Assert.assertTrue((String)("CountersQueue should have " + size + " Elements"), (queue.has(size) && !queue.has(size + 1) ? 1 : 0) != 0);
        int index = 1;
        long current = 0L;
        while (queue.has(size) && size != 0) {
            long e = queue.next();
            System.out.println("got " + e);
            Assert.assertEquals((long)current, (long)e);
            if (index == 1000) {
                index = 1;
                current += 2000L;
            } else {
                ++index;
            }
            ++current;
            --size;
        }
        Assert.assertFalse((String)"CountersQueue shouldn't have 0 elements", (boolean)queue.has(size));
        try {
            queue.next();
            Assert.fail((String)"CountersQueue should have failed with empty exception");
        }
        catch (CountersQueue.EmptyCountersQueueException emptyCountersQueueException) {
            // empty catch block
        }
    }

    private static class CounterIncrementer
    implements Callable<CountersQueue.Counter> {
        private final CounterType counterType;
        private final int increment;

        public CounterIncrementer(CounterType counterType, int increment) {
            this.counterType = counterType;
            this.increment = increment;
        }

        @Override
        public CountersQueue.Counter call() throws Exception {
            switch (this.counterType) {
                case INodeId: {
                    return HdfsVariables.incrementINodeIdCounter((int)this.increment);
                }
                case BlockId: {
                    return HdfsVariables.incrementBlockIdCounter((int)this.increment);
                }
                case QuotaId: {
                    return HdfsVariables.incrementQuotaUpdateIdCounter((int)this.increment);
                }
            }
            return null;
        }
    }

    private static enum CounterType {
        INodeId,
        BlockId,
        QuotaId;

    }
}

